package com.b2lmobitech.fieldcloudplus.task.adapters;

import android.content.Context;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.listener.ActivityDeletedListener;

import java.util.ArrayList;

/**
 * Created by home on 11/6/2017.
 */

public class AddedListAdapter extends RecyclerView.Adapter<AddedListAdapter.viewHolder> {

    private ArrayList<String> arrayList;
    private Context context;
    private ActivityDeletedListener activityDeletedListener;

    public AddedListAdapter(Context context,ArrayList<String> arrayList,ActivityDeletedListener activityDeletedListener)
    {
     this.arrayList=arrayList;
     this.context=context;
     this.activityDeletedListener=activityDeletedListener;
    }


    @Override
    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.list_added_activity, parent, false);
        return new viewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(final viewHolder holder, final int position) {
        holder.activityName.setText(arrayList.get(position));
        holder.delete.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                activityDeletedListener.activityDeleted(holder.getAdapterPosition());
            }
        });

    }

    @Override
    public int getItemCount() {
        return arrayList.size();
    }

    public class viewHolder extends RecyclerView.ViewHolder{
        TextView activityName;
        ImageView delete;

        public viewHolder(View itemView) {
            super(itemView);
            activityName=itemView.findViewById(R.id.activity_name);
            delete=itemView.findViewById(R.id.delete_image);
        }
    }
}
