package com.b2lmobitech.fieldcloudplus.task.adapters;

import android.content.Context;
import android.content.Intent;
import androidx.cardview.widget.CardView;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.activities.RejectForm;
import com.b2lmobitech.fieldcloudplus.task.activities.TaskInfoActivity;
import com.b2lmobitech.fieldcloudplus.task.listener.AcceptTaskListener;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.AssignTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.TaskTable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.ParseException;

/**
 * Created by home on 10/30/2017.
 */

public class AllTasksAdapter extends RecyclerView.Adapter<AllTasksAdapter.viewHolder> {

    Context context;
    JSONArray jsonArray;
    private String currentList;
    private AcceptTaskListener acceptTaskListener;
    private String emailid;
    private boolean isResponsible;

    public AllTasksAdapter(Context context, JSONArray jsonArray) {
        this.context = context;
        this.jsonArray = jsonArray;
    }

    public AllTasksAdapter(Context context, JSONArray jsonArray, String currentList,boolean isResponsible) {
        this.context = context;
        if(currentList.equalsIgnoreCase("new")) {
            acceptTaskListener = (AcceptTaskListener) context;
        }
        this.jsonArray = jsonArray;
        this.currentList = currentList;
        emailid=Preference.getInstance(context).getEmailId();
        this.isResponsible=isResponsible;
    }

    @Override
    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.list_task_active, parent, false);
        return new viewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(viewHolder holder, int position) {
        try {
            JSONObject jsonObject=jsonArray.getJSONObject(position);
            holder.taskname.setText(jsonObject.getString(TaskTable.NAME));
            holder.progress.setText(jsonObject.getString(TaskTable.PROGRESS));
            holder.circularProgressbar.setProgress(jsonObject.getInt(TaskTable.PROGRESS));
            final String taskId=jsonObject.getString(TaskTable.TASKID);
            final String assignId=jsonObject.getString(AssignTable.ASSIGNID);

            if(currentList.equalsIgnoreCase("today") || currentList.equalsIgnoreCase("late") || currentList.equalsIgnoreCase("active")){
                holder.progresslayout.setVisibility(View.VISIBLE);
                holder.arLayout.setVisibility(View.GONE);
                String date=jsonObject.getString(TaskTable.ENDDATE);
                if(currentList.equalsIgnoreCase("late")){
                    holder.remaining_days.setText(DateUtils.getLateDateString(date));
                }else if(currentList.equalsIgnoreCase("today") || currentList.equalsIgnoreCase("active")){
                    holder.remaining_days.setText(DateUtils.getDueDateString(date));
                }
            }else if(currentList.equalsIgnoreCase("new")){
                holder.progresslayout.setVisibility(View.GONE);
                if(jsonObject.getString(AssignTable.EMPLYOEEID).equalsIgnoreCase(emailid) || isResponsible) {
                    holder.arLayout.setVisibility(View.VISIBLE);

                    holder.accept.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View v) {
                            ((AcceptTaskListener) context).acceptTask(assignId);
                        }
                    });
                    holder.reject.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View v) {
                            Intent intent = new Intent(context, RejectForm.class);
                            intent.putExtra("request", "reject");
                            intent.putExtra("id", assignId);
                            context.startActivity(intent);
                        }
                    });
                }else{
                    holder.arLayout.setVisibility(View.GONE);
                }
                holder.remaining_days.setText(String.format("%s to %s", jsonObject.getString(TaskTable.STARTDATE), jsonObject.getString(TaskTable.ENDDATE)));
            }else if(currentList.equalsIgnoreCase("completed") || currentList.equalsIgnoreCase("upcoming")){
                holder.progresslayout.setVisibility(View.GONE);
                holder.arLayout.setVisibility(View.GONE);

                if(currentList.equalsIgnoreCase("upcoming")){
                    holder.remaining_days.setText(DateUtils.getUpcomingDateString(jsonObject.getString(TaskTable.STARTDATE)));
                }else if(currentList.equalsIgnoreCase("completed")){
                    holder.remaining_days.setText(DateUtils.getCompletedDateString(jsonObject.getString(TaskTable.COMPLETEDDATETIME)));
                }
            }



            holder.cardView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    Intent intent=new Intent(context, TaskInfoActivity.class);
                    intent.putExtra("id",taskId);
                    context.startActivity(intent);
                }
            });

        } catch (JSONException e) {
            e.printStackTrace();
        }catch (ParseException e) {
            e.printStackTrace();
        }



      /*  final ArrayList<TaskEncap> parcellist=new ArrayList<>();
        parcellist.add(taskEncap);

        holder.cardView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent intent=new Intent(context, TaskDetails.class);
                intent.putExtra("taskid",taskEncap.getTaskid());
                context.startActivity(intent);
            }
        });*/


    }

    @Override
    public int getItemCount() {
        return jsonArray.length();
    }

    public class viewHolder extends RecyclerView.ViewHolder{

        TextView taskname,progress,remaining_days;
        ProgressBar circularProgressbar;
        CardView cardView;
        LinearLayout arLayout;
        RelativeLayout progresslayout;
        Button accept,reject;

        public viewHolder(View itemView) {
            super(itemView);
            taskname=itemView.findViewById(R.id.task_name);
            progress=itemView.findViewById(R.id.progress_text);
            remaining_days=itemView.findViewById(R.id.due_date);
            cardView=itemView.findViewById(R.id.cardView);
            circularProgressbar=itemView.findViewById(R.id.circularProgressbar);
            arLayout=itemView.findViewById(R.id.arLayout);
            accept=itemView.findViewById(R.id.task_accept);
            reject=itemView.findViewById(R.id.task_reject);
            progresslayout=itemView.findViewById(R.id.progresslayout);
        }
    }


}
