package com.b2lmobitech.fieldcloudplus.task.adapters;

import android.content.Context;
import android.content.Intent;
import androidx.cardview.widget.CardView;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.activities.MilestoneInfoActivity;
import com.b2lmobitech.fieldcloudplus.task.encap.TaskEncap;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.EmployeeTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.MilestoneTable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.ParseException;
import java.util.ArrayList;

/**
 * Created by home on 10/31/2017.
 */

public class MilestoneAdapter extends  RecyclerView.Adapter<MilestoneAdapter.viewHolder>{

    Context context;
    private JSONArray jsonArray;
    Database database;


    public MilestoneAdapter(Context context, JSONArray jsonArray) {
        this.context = context;
        this.jsonArray = jsonArray;
        database=Database.getInstance(context);
    }

    @Override
    public void onBindViewHolder(viewHolder holder, int position) {

        try {
            JSONObject jsonObject=jsonArray.getJSONObject(position);
            holder.milestoneName.setText(jsonObject.getString(MilestoneTable.NAME));
            holder.responsiblePerson.setText(jsonObject.getString(EmployeeTable.NAME));
            holder.monthName.setText(DateUtils.monthNameFromDate(jsonObject.getString(MilestoneTable.ENDDATE)));
            holder.date.setText(DateUtils.dateNumberFromDate(jsonObject.getString(MilestoneTable.ENDDATE)));
            int daysbetween= DateUtils.compareToday(jsonObject.getString(MilestoneTable.ENDDATE));
            final String id=jsonObject.getString(MilestoneTable.MILESTONEID);
            final  String projectId=jsonObject.getString(MilestoneTable.PROJECTID);
            if(daysbetween==0){
                holder.dueDays.setText(R.string.today);
            }else if(daysbetween<0){
                daysbetween=daysbetween*-1;
                if(daysbetween==1){
                    holder.dueDays.setText(String.format(context.getString(R.string.dayAgo), daysbetween));
                }else{
                    holder.dueDays.setText(String.format(context.getString(R.string.daysAgo), daysbetween));
                }
            }else if(daysbetween==1){
                holder.dueDays.setText(R.string.tomorrow);
            }else {
                holder.dueDays.setText(String.format(context.getString(R.string.daysToGo), daysbetween));
            }

            if(database.isMilestoneCompleted(jsonObject.getString(MilestoneTable.MILESTONEID))){
                holder.monthName.setBackgroundColor(context.getResources().getColor(R.color.milestone));
            }else{
                holder.monthName.setBackgroundColor(context.getResources().getColor(R.color.milestoneLate));
            }

            holder.cardView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    ArrayList<TaskEncap> arrayList=new ArrayList<>();
                    Intent intent=new Intent(context, MilestoneInfoActivity.class);
                   // context.getSharedPreferences("projectid", MODE_PRIVATE).edit().putString("projectid", ).apply();
                    intent.putExtra("id",id);
                    intent.putExtra("projectId",projectId);
                    context.startActivity(intent);
                }
            });
        } catch (JSONException e) {
            e.printStackTrace();
        } catch (ParseException e) {
            e.printStackTrace();
        }

    }

    @Override
    public int getItemCount() {
        return jsonArray.length();
    }

    @Override
    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.list_task_milestone, parent, false);
        return new viewHolder(itemView);
    }

    public class viewHolder extends RecyclerView.ViewHolder{
        TextView milestoneName,responsiblePerson,dueDays,monthName,date;
        CardView cardView;
        public viewHolder(View itemView) {
            super(itemView);
            milestoneName=itemView.findViewById(R.id.milestoneName);
            responsiblePerson=itemView.findViewById(R.id.responsiblePerson);
            dueDays=itemView.findViewById(R.id.dueDays);
            cardView=itemView.findViewById(R.id.cardView);
            monthName=itemView.findViewById(R.id.monthName);
            date=itemView.findViewById(R.id.date);
        }
    }




}
