package com.b2lmobitech.fieldcloudplus.task.adapters;

import android.content.Context;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.TASKURL;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.ProgressTable;
import com.bumptech.glide.Glide;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by home on 11/13/2017.
 */

public class ProgressListAdapter extends RecyclerView.Adapter<ProgressListAdapter.viewHolder>{
    Context context;
    private JSONArray jsonArray;
    private Preference preference;
    private Database database;

    public ProgressListAdapter(Context context,JSONArray jsonArray) {
        this.context=context;
        this.jsonArray=jsonArray;
        preference=Preference.getInstance(context);
        database=Database.getInstance(context);
    }

    @Override
    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.list_task_progress, parent, false);
        return new viewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(final viewHolder holder, int position) {
        try {
            JSONObject jsonObject=jsonArray.getJSONObject(position);
            holder.progressLog.setText(String.format("%s%%",jsonObject.getString(ProgressTable.PROGRESS)));
            holder.datelog.setText(jsonObject.getString(ProgressTable.DATE));
            holder.completedLog.setText(jsonObject.getString(ProgressTable.ACTIVITIES).replace("@#",","));
            if(jsonObject.getString(ProgressTable.BYTYPE).equalsIgnoreCase("user")){
                if(jsonObject.getString(ProgressTable.EMPLOYEE).equalsIgnoreCase(preference.getEmailId())){
                    holder.bylog.setText(context.getString(R.string.responsible));
                }else{
                    holder.bylog.setText(database.getEmployeeName(jsonObject.getString(ProgressTable.EMPLOYEE)));
                }
            }else{
                if(jsonObject.getString(ProgressTable.BY).equalsIgnoreCase(preference.getEmailId())){
                    holder.bylog.setText(context.getString(R.string.responsible));
                }else{
                    holder.bylog.setText(database.getEmployeeName(jsonObject.getString(ProgressTable.BY)));
                }
            }
            if(!jsonObject.getString(ProgressTable.IMAGE).equalsIgnoreCase("no data available")){
                Glide.with(context).load(TASKURL.IMAGE+jsonObject.getString(ProgressTable.IMAGE))
                        .into(holder.imageView);
            }


        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return jsonArray.length();
    }

    public class viewHolder extends RecyclerView.ViewHolder{

        TextView progressLog,completedLog,datelog,bylog;
        private LinearLayout hiddenLayout,visibleLayout;
        ImageView imageView,indicatiorImage;

        public viewHolder(View itemView) {
            super(itemView);
            progressLog=itemView.findViewById(R.id.percentage_log);
            completedLog=itemView.findViewById(R.id.activity_log);
            hiddenLayout=itemView.findViewById(R.id.extra_layout);
            datelog=itemView.findViewById(R.id.date_log);
            bylog=itemView.findViewById(R.id.by_log);
            visibleLayout=itemView.findViewById(R.id.visible_layout);
            imageView=itemView.findViewById(R.id.imageView);
            indicatiorImage=itemView.findViewById(R.id.indicatiorImage);
           visibleLayout.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    if(hiddenLayout.getVisibility()==View.VISIBLE) {
                        indicatiorImage.setImageDrawable(context.getResources().getDrawable(R.drawable.ic_keyboard_arrow_down));
                        hiddenLayout.setVisibility(View.GONE);
                    } else {
                        indicatiorImage.setImageDrawable(context.getResources().getDrawable(R.drawable.ic_keyboard_arrow_up));
                        hiddenLayout.setVisibility(View.VISIBLE);
                    }
                }
            });
        }
    }



}
