package com.b2lmobitech.fieldcloudplus.task.adapters;

import android.content.Context;
import androidx.cardview.widget.CardView;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.ProjectTable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by home on 10/31/2017.
 */

public class ProjectAdapter extends  RecyclerView.Adapter<ProjectAdapter.viewHolder>{

    Context context;
    private JSONArray jsonArray;
    private OnItemClickListener onItemClickListener;


    public ProjectAdapter(Context context, JSONArray jsonArray) {
        this.context = context;
        onItemClickListener= (OnItemClickListener) context;
        this.jsonArray = jsonArray;
    }

    @Override
    public void onBindViewHolder(viewHolder holder, int position) {
        try {
            final JSONObject jsonObject=jsonArray.getJSONObject(position);
            holder.project_name.setText(jsonObject.getString(ProjectTable.PROJECTNAME));
            holder.dates.setText(String.format("%s to %s", jsonObject.getString(ProjectTable.STARTDATE), jsonObject.getString(ProjectTable.ENDDATE)));
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return jsonArray.length();
    }

    @Override
    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.list_task_projects, parent, false);
        return new viewHolder(itemView);
    }

    public class viewHolder extends RecyclerView.ViewHolder{
        TextView project_name,dates,late;
        CardView cardView;
        public viewHolder(View itemView) {
            super(itemView);
            project_name=itemView.findViewById(R.id.project_name);
            dates=itemView.findViewById(R.id.dates);
            cardView=itemView.findViewById(R.id.card);
            late=itemView.findViewById(R.id.late_tasks);

            itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    onItemClickListener.itemClicked(getAdapterPosition());
                }
            });

        }
    }




}
