package com.b2lmobitech.fieldcloudplus.task.adapters;

import android.content.Context;
import androidx.cardview.widget.CardView;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.TaskTable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by home on 11/11/2017.
 */

public class RequestHisotyAdapter extends RecyclerView.Adapter<RequestHisotyAdapter.viewHolder> {

    Context context;
    JSONArray jsonArray;
    private OnItemClickListener onItemClickListener;
    private  boolean isResponsible;

    public RequestHisotyAdapter(Context context, JSONArray jsonArray,boolean isResponsible) {
        this.context=context;
        this.jsonArray=jsonArray;
        onItemClickListener= (OnItemClickListener) context;
        this.isResponsible=isResponsible;
    }

    @Override
    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.list_task_request_history, parent, false);
        return new viewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(viewHolder holder, int position) {


        try {
            JSONObject jsonObject=jsonArray.getJSONObject(holder.getAdapterPosition());
            holder.taskname.setText(jsonObject.getString(TaskTable.NAME));
            if(jsonObject.getString("r_status").equalsIgnoreCase("accepted")){
                holder.acceptedIcon.setVisibility(View.VISIBLE);
                holder.rejectedIcon.setVisibility(View.GONE);
            }else{
                holder.acceptedIcon.setVisibility(View.GONE);
                holder.rejectedIcon.setVisibility(View.VISIBLE);
            }
            if(jsonObject.getString("increasedays").equalsIgnoreCase("1")){
                holder.thirdText.setText(String.format("%s Day", jsonObject.getString("increasedays")));
            }else{
                holder.thirdText.setText(String.format("%s Days", jsonObject.getString("increasedays")));
            }
            holder.secondText.setText(jsonObject.getString("employeename"));
        } catch (JSONException e) {
            e.printStackTrace();
        }

    }

    @Override
    public int getItemCount() {
        return jsonArray.length();
    }

    public class viewHolder extends RecyclerView.ViewHolder{

        TextView taskname,secondText,thirdText;
        CardView cardView;
        LinearLayout buttonLayout;
        ImageView acceptedIcon,rejectedIcon;

        public viewHolder(View itemView) {
            super(itemView);
            taskname=itemView.findViewById(R.id.taskName);
            secondText=itemView.findViewById(R.id.secondText);
            thirdText=itemView.findViewById(R.id.thirdText);
            cardView=itemView.findViewById(R.id.cardView);
            buttonLayout=itemView.findViewById(R.id.buttonLayout);
            acceptedIcon=itemView.findViewById(R.id.acceptedIcon);
            rejectedIcon=itemView.findViewById(R.id.rejectedIcon);
            if(isResponsible){
                secondText.setVisibility(View.VISIBLE);
            }else{
                secondText.setVisibility(View.GONE);
            }
            itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    onItemClickListener.itemClicked(getAdapterPosition());
                }
            });

        }
    }


}
