package com.b2lmobitech.fieldcloudplus.task.adapters;

import android.content.Context;
import androidx.cardview.widget.CardView;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.listener.OnTaskActionSelected;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.TaskTable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by home on 11/11/2017.
 */

public class RequestListAdapter extends RecyclerView.Adapter<RequestListAdapter.viewHolder> {

    Context context;
    JSONArray jsonArray;
    private OnTaskActionSelected onTaskActionSelected;
    private boolean isResponsible;

    public RequestListAdapter(Context context, JSONArray jsonArray,boolean isResponsible) {
        this.context=context;
        this.jsonArray=jsonArray;
        onTaskActionSelected= (OnTaskActionSelected) context;
        this.isResponsible=isResponsible;
    }

    @Override
    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.list_task_request, parent, false);
        return new viewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(viewHolder holder, int position) {


        try {
            JSONObject jsonObject=jsonArray.getJSONObject(holder.getAdapterPosition());
            holder.taskname.setText(jsonObject.getString(TaskTable.NAME));
            if(jsonObject.getString("increasedays").equalsIgnoreCase("1")){
                holder.thirdText.setText(String.format("%s day", jsonObject.getString("increasedays")));
            }else{
                holder.thirdText.setText(String.format("%s days", jsonObject.getString("increasedays")));
            }
            if(jsonObject.getInt("counts")==0){
                holder.secondText.setText(jsonObject.getString("employeename"));
            }else if(jsonObject.getInt("counts")==1){
                holder.secondText.setText(jsonObject.getString("employeename")+" \u2022 "+jsonObject.getInt("counts")+" Previous Request");
            }else{
                holder.secondText.setText(jsonObject.getString("employeename")+" \u2022 "+jsonObject.getInt("counts")+" Previous Requests");
            }

        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return jsonArray.length();
    }

    public class viewHolder extends RecyclerView.ViewHolder{

        TextView taskname,secondText,thirdText;
        CardView cardView;
        LinearLayout buttonLayout;
        ImageView button1,button2;

        public viewHolder(View itemView) {
            super(itemView);
            taskname=itemView.findViewById(R.id.task_name);
            secondText=itemView.findViewById(R.id.secondText);
            thirdText=itemView.findViewById(R.id.thirdText);
            cardView=itemView.findViewById(R.id.cardView);
            buttonLayout=itemView.findViewById(R.id.buttonLayout);
            button1=itemView.findViewById(R.id.button1);
            button2=itemView.findViewById(R.id.button2);

            if(isResponsible){
                buttonLayout.setVisibility(View.VISIBLE);
                secondText.setVisibility(View.VISIBLE);
            }else{
                secondText.setVisibility(View.GONE);
                buttonLayout.setVisibility(View.GONE);
            }
            button1.setImageResource(R.drawable.accept);
            button2.setImageResource(R.drawable.decline);

            button1.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        onTaskActionSelected.taskSelected(getAdapterPosition(),"accepted"); }
            });

            button2.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        onTaskActionSelected.taskSelected(getAdapterPosition(),"rejected");
                    }
            });

            itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    onTaskActionSelected.taskSelected(getAdapterPosition(),"details");
                }
            });

        }
    }


}
