package com.b2lmobitech.fieldcloudplus.task.adapters;

import android.content.Context;
import android.content.Intent;
import androidx.cardview.widget.CardView;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.task.old.CompletedDetails;
import com.b2lmobitech.fieldcloudplus.task.old.TaskDetails;
import com.b2lmobitech.fieldcloudplus.task.old.TaskNew;
import com.b2lmobitech.fieldcloudplus.task.encap.TaskEncap;
import com.b2lmobitech.fieldcloudplus.task.enums.TaskEnum;

import java.util.ArrayList;

/**
 * Created by home on 1/3/2018.
 */

public class SearchResultAdapter extends RecyclerView.Adapter<SearchResultAdapter.viewHolder> {

        Context context;
        ArrayList<TaskEncap> arrayList;

    public SearchResultAdapter(Context context, ArrayList<TaskEncap> arrayList){
        this.context=context;
        this.arrayList=arrayList;
        }

    @Override
    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.list_task_active, parent, false);
        return new viewHolder(itemView);

        }

    @Override
    public void onBindViewHolder(viewHolder holder, int position) {
        final TaskEncap taskEncap=arrayList.get(position);
        holder.taskname.setText(taskEncap.getTaskname());
        holder.progress.setText(taskEncap.getProgress());
        holder.circularProgressbar.setProgress(taskEncap.getI_progress());



        if(taskEncap.getCategory()== TaskEnum.ACTIVE || taskEncap.getCategory()==TaskEnum.LATE || taskEncap.getCategory()==TaskEnum.UPCOMING) {
            holder.cardView.setOnClickListener(new View.OnClickListener() {

                @Override
                public void onClick(View view) {
                    Intent intent = new Intent(context, TaskDetails.class);
                    intent.putExtra("taskid", taskEncap.getTaskid());
                    context.startActivity(intent);
                }
            });

            holder.remaining_days.setText(taskEncap.getStartdate()+" to "+taskEncap.getEnddatte());


        }else if(taskEncap.getCategory()==TaskEnum.COMPLETED){
            holder.relativeLayout.setVisibility(View.GONE);
            holder.remaining_days.setText("Completed on " + Utility.getDateTime(taskEncap.getD_enddatte()));
            holder.cardView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    Intent intent=new Intent(context, CompletedDetails.class);
                    intent.putExtra("taskid",taskEncap.getTaskid());
                    context.startActivity(intent);
                }
            });
        }else if(taskEncap.getCategory()==TaskEnum.NEW){

            holder.relativeLayout.setVisibility(View.GONE);
            holder.remaining_days.setText("New task");

            holder.remaining_days.setText("Starting on "+taskEncap.getStartdate());
            holder.cardView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    Intent intent=new Intent(context, TaskNew.class);
                    intent.putExtra("taskid",taskEncap.getTaskid());
                    context.startActivity(intent);
                }
            });

        }

        }

@Override
public int getItemCount() {
        return arrayList.size();
        }

    public class viewHolder extends RecyclerView.ViewHolder{

        TextView taskname,progress,remaining_days;
        RelativeLayout relativeLayout;
        CardView cardView;
        ProgressBar circularProgressbar;


        public viewHolder(View itemView) {
            super(itemView);
            taskname=itemView.findViewById(R.id.task_name);
            progress=itemView.findViewById(R.id.progress_text);
           // remaining_days=itemView.findViewById(R.id.due_date);
            relativeLayout=itemView.findViewById(R.id.progresslayout);
           // cardView=itemView.findViewById(R.id.current_card);
            circularProgressbar=itemView.findViewById(R.id.circularProgressbar);


        }
    }


}
