package com.b2lmobitech.fieldcloudplus.task.adapters;

import android.content.Context;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.CategoryTable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by home on 11/6/2017.
 */

public class SelectCategoryAdapter extends RecyclerView.Adapter<SelectCategoryAdapter.viewHolder> {

    private JSONArray jsonArray;
    private Context context;
    OnItemClickListener onItemClickListener;

    public SelectCategoryAdapter(Context context, JSONArray jsonArray) {
     this.jsonArray=jsonArray;
     this.context=context;
     this.onItemClickListener= (OnItemClickListener) context;
    }


    @Override
    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.list_selecttag, parent, false);
        return new viewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(final viewHolder holder, final int position) {
        try {
            JSONObject jsonObject=jsonArray.getJSONObject(holder.getAdapterPosition());
            holder.tagName.setText(jsonObject.getString(CategoryTable.CATNAME));
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return jsonArray.length();
    }

    public class viewHolder extends RecyclerView.ViewHolder{
        TextView tagName;

        public viewHolder(View itemView) {
            super(itemView);
            tagName=itemView.findViewById(R.id.tagName);
            itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    onItemClickListener.itemClicked(getAdapterPosition());
                }
            });
        }
    }
}
