package com.b2lmobitech.fieldcloudplus.task.adapters;

import android.content.Context;
import androidx.cardview.widget.CardView;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.EmployeeTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.TasklistTable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by home on 10/31/2017.
 */

public class SelectTasklistAdapter extends  RecyclerView.Adapter<SelectTasklistAdapter.viewHolder>{

    Context context;
    JSONArray jsonArray;
    private OnItemClickListener onItemClickListener;
    private Database database;


    public SelectTasklistAdapter(Context context, JSONArray jsonArray) {
        this.context = context;
        this.jsonArray = jsonArray;
        this.onItemClickListener= (OnItemClickListener) context;
        database=Database.getInstance(context);
    }

    @Override
    public void onBindViewHolder(viewHolder holder, int position) {

        try {
            final JSONObject jsonObject=jsonArray.getJSONObject(position);
            holder.taskListName.setText(jsonObject.getString(TasklistTable.NAME));
            holder.responsiblePerson.setText(jsonObject.getString(EmployeeTable.NAME));
            // holder.responsiblePerson.setText(jsonObject.getString(EmployeeTable.NAME));
            if(holder.getAdapterPosition() ==0 || !jsonObject.getString(TasklistTable.MILESTONEID).equalsIgnoreCase(jsonArray.getJSONObject(position-1).getString(TasklistTable.MILESTONEID))){
                holder.milestoneName.setText(database.getMilestoneName(jsonObject.getString(TasklistTable.MILESTONEID)));
            }else{
                holder.milestoneName.setVisibility(View.GONE);
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }

    }

    @Override
    public int getItemCount() {
        return jsonArray.length();
    }

    @Override
    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.list_task_tasklist2, parent, false);
        return new viewHolder(itemView);
    }

    public class viewHolder extends RecyclerView.ViewHolder{
        TextView taskListName,responsiblePerson,milestoneName;
        CardView cardView;
        public viewHolder(View itemView) {
            super(itemView);
            taskListName=itemView.findViewById(R.id.taskListName);
            responsiblePerson=itemView.findViewById(R.id.responsiblePerson);
            cardView=itemView.findViewById(R.id.cardView);
            milestoneName=itemView.findViewById(R.id.milestoneName);

            itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    onItemClickListener.itemClicked(getAdapterPosition());
                }
            });

        }
    }

}
