package com.b2lmobitech.fieldcloudplus.task.adapters;

import android.content.Context;
import android.content.Intent;
import androidx.cardview.widget.CardView;
import androidx.recyclerview.widget.RecyclerView;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.activities.TaskInfoActivity;
import com.b2lmobitech.fieldcloudplus.task.listener.OnTaskActionSelected;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.AssignTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.TaskTable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.ParseException;

/**
 * Created by home on 10/30/2017.
 */

public class TasksManagementAdapter extends RecyclerView.Adapter<TasksManagementAdapter.viewHolder> {

    Context context;
    JSONArray jsonArray;
    private String currentList;
    private Database database;
    private  OnTaskActionSelected onTaskActionSelected;
    String bullot="\u2022";

    public TasksManagementAdapter(Context context, JSONArray jsonArray) {
        this.context = context;
        this.jsonArray = jsonArray;
    }

    public TasksManagementAdapter(Context context, JSONArray jsonArray, String currentList) {
        this.context = context;
        this.jsonArray = jsonArray;
        database=Database.getInstance(context);
        this.currentList = currentList;
        onTaskActionSelected= (OnTaskActionSelected) context;
    }

    @Override
    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.list_task_management, parent, false);
        return new viewHolder(itemView);

    }

    @Override
    public void onBindViewHolder(viewHolder holder, int position) {
        try {
            JSONObject jsonObject=jsonArray.getJSONObject(position);
            holder.taskname.setText(jsonObject.getString(TaskTable.NAME));
            final String taskId=jsonObject.getString(TaskTable.TASKID);
            if(currentList.equalsIgnoreCase("unassigned") ){
            //    holder.progresslayout.setVisibility(View.VISIBLE);
                String date=jsonObject.getString(TaskTable.ENDDATE);
                holder.secondText.setText(String.format("%s to %s", jsonObject.getString(TaskTable.STARTDATE), jsonObject.getString(TaskTable.ENDDATE)));
            }else if(currentList.equalsIgnoreCase("assigned")){
             //   holder.progresslayout.setVisibility(View.GONE);
                holder.buttonLayout.setVisibility(View.VISIBLE);
                if(jsonObject.getString(AssignTable.STATUS).equalsIgnoreCase("accepted")){
                    holder.button1.setVisibility(View.GONE);
                    holder.secondText.setText(String.format("%s \u2022 Accepted", database.getEmployeeName(jsonObject.getString(AssignTable.EMPLYOEEID))));
                }else if(jsonObject.getString(AssignTable.STATUS).equalsIgnoreCase("declined")){
                    holder.button1.setVisibility(View.VISIBLE);
                    holder.button2.setVisibility(View.VISIBLE);
                    //holder.secondText.setText(String.format("%s \u2022 Declined", database.getEmployeeName(jsonObject.getString(BrandTable.EMPLYOEEID))));
                    holder.secondText.setText(Html.fromHtml(" <font color='#ff0000'>Declined</font> \u2022 "+database.getEmployeeName(jsonObject.getString(AssignTable.EMPLYOEEID))));
                }else{
                    holder.secondText.setText(String.format("%s \u2022 Yet To Accept", database.getEmployeeName(jsonObject.getString(AssignTable.EMPLYOEEID))));
                }
            }else if(currentList.equalsIgnoreCase("completed")){
               // holder.progresslayout.setVisibility(View.GONE);
                if(jsonObject.getString(TaskTable.STATUS).equalsIgnoreCase("underprogress")){
                    holder.buttonLayout.setVisibility(View.VISIBLE);
                    holder.secondText.setText(String.format("%s", database.getEmployeeName(jsonObject.getString(AssignTable.EMPLYOEEID))));
                }else{
                    holder.buttonLayout.setVisibility(View.GONE);
                    holder.secondText.setText(String.format("%s \u2022 %s", database.getEmployeeName(jsonObject.getString(AssignTable.EMPLYOEEID)),
                            DateUtils.getCompletedDateString(jsonObject.getString(TaskTable.COMPLETEDDATETIME))));
                }
            }else if(currentList.equalsIgnoreCase("stalled")){
                holder.secondText.setText(String.format("Stalled On %s", jsonObject.getString(TaskTable.STALLEDDATETIME)));
            }else if(currentList.equalsIgnoreCase("stopped")){
                holder.secondText.setText(String.format("Stopped On %s", jsonObject.getString(TaskTable.STOPPEDDATETIME)));
            }

            holder.cardView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    Intent intent=new Intent(context, TaskInfoActivity.class);
                    intent.putExtra("id",taskId);
                    context.startActivity(intent);
                }
            });

        } catch (JSONException e) {
            e.printStackTrace();
        }catch (ParseException e) {
            e.printStackTrace();
        }



      /*  final ArrayList<TaskEncap> parcellist=new ArrayList<>();
        parcellist.add(taskEncap);

        holder.cardView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent intent=new Intent(context, TaskDetails.class);
                intent.putExtra("taskid",taskEncap.getTaskid());
                context.startActivity(intent);
            }
        });*/


    }

    @Override
    public int getItemCount() {
        return jsonArray.length();
    }

    public class viewHolder extends RecyclerView.ViewHolder{

        TextView taskname,secondText;
        CardView cardView;
        LinearLayout buttonLayout;
        ImageView button1,button2;

        public viewHolder(View itemView) {
            super(itemView);
            taskname=itemView.findViewById(R.id.task_name);
            secondText=itemView.findViewById(R.id.secondText);
            cardView=itemView.findViewById(R.id.cardView);
            buttonLayout=itemView.findViewById(R.id.buttonLayout);
            button1=itemView.findViewById(R.id.button1);
            button2=itemView.findViewById(R.id.button2);
            if(currentList.equalsIgnoreCase("unassigned")){
                button1.setImageResource(R.drawable.ic_user_assign);
                button1.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        onTaskActionSelected.taskSelected(getAdapterPosition(),"assign");
                    }
                });
            }else if(currentList.equalsIgnoreCase("completed")){
                button1.setImageResource(R.drawable.ic_task_done);
                button2.setImageResource(R.drawable.ic_task_disapprove);

                button1.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        onTaskActionSelected.taskSelected(getAdapterPosition(),"complete");
                    }
                });

                button2.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        onTaskActionSelected.taskSelected(getAdapterPosition(),"modify");
                    }
                });


            }else if(currentList.equalsIgnoreCase("assigned")){
                button1.setImageResource(R.drawable.ic_user_assign);
                button2.setImageResource(R.drawable.ic_user_unassign);

                button1.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        onTaskActionSelected.taskSelected(getAdapterPosition(),"reassign");
                    }
                });

                button2.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        onTaskActionSelected.taskSelected(getAdapterPosition(),"unassign");
                    }
                });
            }
        }
    }

}

