package com.b2lmobitech.fieldcloudplus.task.encap;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import android.util.Log;

import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.task.enums.TaskEnum;

import org.json.JSONException;
import org.json.JSONObject;

import java.text.ParseException;
import java.util.Comparator;
import java.util.Date;

/**
 * Created by Velmurugan on 10/27/2017.
 */

public class TaskEncap implements Parcelable,Comparable<TaskEncap>{


    private String taskid;
    private String taskname;
    private String projctid;
    private String assignid;
    private String projectname;
    private String projectstartdate;
    private String projectenddate;
    private String projectdescription;
    private String milestoneid;
    private String milestonename;
    private String milestoneenddate;
    private String milestonedescription;
    private String listtaskid;
    private String listtaskname;
    private String description;
    private String due_days;
    private String status;
    private String priotity;
    private String sequence;
    private String online_sync;
    private String local_sync;
    private String progress;
    private int i_progress;
    private String startdate;
    private String enddatte;
    private String updateddatetime;
    private String assigneddatetime;
    private String underprogressdatetime;
    private Date d_startdate;
    private Date d_enddatte;
    private Date d_updateddatetime;
    private Date d_assigneddatetime;
    private Date u_datetime;
    private boolean fav;
    private String assign_status;
    private String email_id;
    private TaskEnum category;




    public TaskEncap(JSONObject jsonObject) throws JSONException, ParseException {

        taskid=jsonObject.getString("task_id");
        taskname=jsonObject.getString("task_name");
        assignid=jsonObject.getString("assignid");
        projctid=jsonObject.getString("project_id");
        milestoneid=jsonObject.getString("milestone_id");
        listtaskid=jsonObject.getString("listtask_id");
        assigneddatetime=jsonObject.getString("a_datetime");
        description=jsonObject.getString("description");
        due_days=jsonObject.getString("task_id");
        status=jsonObject.getString("status");
        priotity=jsonObject.getString("priority");
        startdate= jsonObject.getString("startdate");
        enddatte= jsonObject.getString("enddate");
        updateddatetime= jsonObject.getString("updatetime");
        sequence=jsonObject.getString("sequence");
        online_sync=jsonObject.getString("sync");
        progress=jsonObject.getString("progress");
        i_progress=jsonObject.getInt("progress");
        underprogressdatetime=jsonObject.getString("under");
        d_startdate= Utility.getDateTime(jsonObject.getString("startdate"));
        d_enddatte= Utility.getDateTime(jsonObject.getString("enddate"));
        d_updateddatetime= Utility.getDateTime(jsonObject.getString("updatetime"));
        d_assigneddatetime= Utility.getDateTime(jsonObject.getString("a_datetime"));

        email_id = jsonObject.getString("emailid");
        assign_status = jsonObject.getString("assign_status");

        if(i_progress==100)
        {
            category= TaskEnum.COMPLETED;

        }else if(assign_status.trim().equalsIgnoreCase("pending")) {
            category= TaskEnum.NEW;
        }else{
            if(status.equalsIgnoreCase("underprogress") || d_startdate.before(new Date())){
                if (d_enddatte.before(new Date())){
                    category= TaskEnum.LATE;
                }else {
                    category = TaskEnum.ACTIVE;
                }
            }else  if (status.equalsIgnoreCase("accepted") && d_startdate.after(new Date())){
                category= TaskEnum.UPCOMING;
            }
        }

    }

    public TaskEncap(){

    }



    public String getAssign_status() {
        return assign_status;
    }

    public void setAssign_status(String assign_status) {
        this.assign_status = assign_status;
    }

    public String getEmail_id() {
        return email_id;
    }

    public void setEmail_id(String email_id) {
        this.email_id = email_id;
    }

    public TaskEnum getCategory() {
        return category;
    }

    public void setCategory(TaskEnum category) {
        this.category = category;
    }

    public String getProjectstartdate() {
        return projectstartdate;
    }

    public void setProjectstartdate(String projectstartdate) {
        this.projectstartdate = projectstartdate;
    }

    public String getUnderprogressdatetime() {
        return underprogressdatetime;
    }

    public void setUnderprogressdatetime(String underprogressdatetime) {
        this.underprogressdatetime = underprogressdatetime;
    }

    public String getProjectenddate() {
        return projectenddate;
    }

    public void setProjectenddate(String projectenddate) {
        this.projectenddate = projectenddate;
    }

    public String getProjectdescription() {
        return projectdescription;
    }

    public void setProjectdescription(String projectdescription) {
        this.projectdescription = projectdescription;
    }

    public String getMilestoneenddate() {
        return milestoneenddate;
    }

    public void setMilestoneenddate(String milestoneenddate) {
        this.milestoneenddate = milestoneenddate;
    }

    public String getMilestonedescription() {
        return milestonedescription;
    }

    public void setMilestonedescription(String milestonedescription) {
        this.milestonedescription = milestonedescription;
    }

    public String getTaskid() {
        return taskid;
    }

    public void setTaskid(String taskid) {
        this.taskid = taskid;
    }

    public String getTaskname() {
        return taskname;
    }

    public void setTaskname(String taskname) {
        this.taskname = taskname;
    }

    public String getProjctid() {
        return projctid;
    }

    public void setProjctid(String projctid) {
        this.projctid = projctid;
    }

    public String getAssignid() {
        return assignid;
    }

    public void setAssignid(String assignid) {
        this.assignid = assignid;
    }

    public String getProjectname() {
        return projectname;
    }

    public void setProjectname(String projectname) {
        this.projectname = projectname;
    }

    public String getMilestoneid() {
        return milestoneid;
    }

    public void setMilestoneid(String milestoneid) {
        this.milestoneid = milestoneid;
    }

    public String getMilestonename() {
        return milestonename;
    }

    public void setMilestonename(String milestonename) {
        this.milestonename = milestonename;
    }

    public String getListtaskid() {
        return listtaskid;
    }

    public void setListtaskid(String listtaskid) {
        this.listtaskid = listtaskid;
    }

    public String getListtaskname() {
        return listtaskname;
    }

    public void setListtaskname(String listtaskname) {
        this.listtaskname = listtaskname;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDue_days() {
        return due_days;
    }

    public void setDue_days(String due_days) {
        this.due_days = due_days;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getPriotity() {
        return priotity;
    }

    public void setPriotity(String priotity) {
        this.priotity = priotity;
    }

    public String getSequence() {
        return sequence;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public String getOnline_sync() {
        return online_sync;
    }

    public void setOnline_sync(String online_sync) {
        this.online_sync = online_sync;
    }

    public String getLocal_sync() {
        return local_sync;
    }

    public void setLocal_sync(String local_sync) {
        this.local_sync = local_sync;
    }

    public boolean isFav() {
        return fav;
    }

    public void setFav(boolean fav) {
        this.fav = fav;
    }

    public String getProgress() {
        return progress;
    }

    public void setProgress(String progress) {
        this.progress = progress;
        this.i_progress= Integer.parseInt(progress);
    }

    public int getI_progress() {
        return i_progress;
    }

    public void setI_progress(int i_progress) {
        this.i_progress = i_progress;
        this.progress = String.valueOf(i_progress);
    }

    public String getStartdate() {
        return startdate;
    }

    public void setStartdate(String startdate) {
        this.startdate = startdate;
    }

    public String getEnddatte() {
        return enddatte;
    }

    public void setEnddatte(String enddatte) {
        this.enddatte = enddatte;
    }

    public String getUpdateddatetime() {
        return updateddatetime;
    }

    public void setUpdateddatetime(String updateddatetime) {
        this.updateddatetime = updateddatetime;
    }

    public String getAssigneddatetime() {
        return assigneddatetime;
    }

    public void setAssigneddatetime(String assigneddatetime) {
        this.assigneddatetime = assigneddatetime;
    }

    public Date getD_startdate() {
        return d_startdate;
    }

    public void setD_startdate(Date d_startdate) {
        this.d_startdate = d_startdate;
    }

    public void setD_enddatte(Date d_enddatte) {
        this.d_enddatte = d_enddatte;
    }

    public void setD_assigneddatetime(Date d_assigneddatetime) {
        this.d_assigneddatetime = d_assigneddatetime;
    }

    public void setD_updateddatetime(Date d_updateddatetime) {
        this.d_updateddatetime = d_updateddatetime;
    }

    public Date getD_assigneddatetime() {
        return d_assigneddatetime;
    }

    public Date getD_updateddatetime() {
        return d_updateddatetime;
    }

    public Date getD_enddatte() {
        return d_enddatte;
    }



    protected TaskEncap(Parcel in) {
        taskid = in.readString();
        taskname = in.readString();
        projctid = in.readString();
        assignid = in.readString();
        projectname = in.readString();
        milestoneid = in.readString();
        milestonename = in.readString();
        listtaskid = in.readString();
        listtaskname = in.readString();
        description = in.readString();
        due_days = in.readString();
        status = in.readString();
        priotity = in.readString();
        sequence = in.readString();
        online_sync = in.readString();
        local_sync = in.readString();
        fav = in.readByte() != 0x00;
        progress = in.readString();
        i_progress = in.readInt();
        startdate = in.readString();
        enddatte = in.readString();
        updateddatetime = in.readString();
        assigneddatetime = in.readString();
        projectstartdate = in.readString();
        projectenddate = in.readString();
        projectdescription = in.readString();
        milestoneenddate = in.readString();
        milestonedescription  = in.readString();
        assign_status   = in.readString();
        email_id  = in.readString();
        underprogressdatetime = in.readString();
        long tmpD_startdate = in.readLong();
        d_startdate = tmpD_startdate != -1 ? new Date(tmpD_startdate) : null;
        long tmpD_enddatte = in.readLong();
        d_enddatte = tmpD_enddatte != -1 ? new Date(tmpD_enddatte) : null;
        long tmpD_updateddatetime = in.readLong();
        d_updateddatetime = tmpD_updateddatetime != -1 ? new Date(tmpD_updateddatetime) : null;
        long tmpD_assigneddatetime = in.readLong();
        d_assigneddatetime = tmpD_assigneddatetime != -1 ? new Date(tmpD_assigneddatetime) : null;
        category = (TaskEnum) in.readValue(TaskEnum.class.getClassLoader());

    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(taskid);
        dest.writeString(taskname);
        dest.writeString(projctid);
        dest.writeString(assignid);
        dest.writeString(projectname);
        dest.writeString(milestoneid);
        dest.writeString(milestonename);
        dest.writeString(listtaskid);
        dest.writeString(listtaskname);
        dest.writeString(description);
        dest.writeString(due_days);
        dest.writeString(status);
        dest.writeString(priotity);
        dest.writeString(sequence);
        dest.writeString(online_sync);
        dest.writeString(local_sync);
        dest.writeByte((byte) (fav ? 0x01 : 0x00));
        dest.writeString(progress);
        dest.writeInt(i_progress);
        dest.writeString(startdate);
        dest.writeString(enddatte);
        dest.writeString(updateddatetime);
        dest.writeString(assigneddatetime);
        dest.writeString(projectstartdate);
        dest.writeString(projectenddate);
        dest.writeString(projectdescription);
        dest.writeString(milestoneenddate);
        dest.writeString(milestonedescription);
        dest.writeString(assign_status);
        dest.writeString(email_id);
        dest.writeString(underprogressdatetime);
        dest.writeLong(d_startdate != null ? d_startdate.getTime() : -1L);
        dest.writeLong(d_enddatte != null ? d_enddatte.getTime() : -1L);
        dest.writeLong(d_updateddatetime != null ? d_updateddatetime.getTime() : -1L);
        dest.writeLong(d_assigneddatetime != null ? d_assigneddatetime.getTime() : -1L);
        dest.writeValue(category);
    }

    @SuppressWarnings("unused")
    public static final Parcelable.Creator<TaskEncap> CREATOR = new Parcelable.Creator<TaskEncap>() {
        @Override
        public TaskEncap createFromParcel(Parcel in) {
            return new TaskEncap(in);
        }

        @Override
        public TaskEncap[] newArray(int size) {
            return new TaskEncap[size];
        }
    };

    public static final Comparator<TaskEncap> AgeComparator = new Comparator<TaskEncap>(){

        @Override
        public int compare(TaskEncap o1, TaskEncap o2) {
            Log.e("sort",o1.getTaskname());
            if(o1.getD_enddatte().before(o2.getD_enddatte())){
                Log.e("sort","-1");
                return -1;
            }else if (o1.getD_enddatte().after(o2.getD_enddatte())){
                Log.e("sort","-1");
                return 1;
            } else {
                Log.e("sort","-1");
                return 0;
            }
        }

    };

    @Override
    public int compareTo(@NonNull TaskEncap o) {
        Log.e("called","called");
        return getD_enddatte().compareTo(o.getD_enddatte());

    }
}