package com.b2lmobitech.fieldcloudplus.task.old;

import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.material.snackbar.Snackbar;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import androidx.cardview.widget.CardView;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.GlobalVariables;
import com.b2lmobitech.fieldcloudplus.task.activities.ProgressHistroy;
import com.b2lmobitech.fieldcloudplus.task.encap.NotificationEncap;
import com.b2lmobitech.fieldcloudplus.task.encap.ProgressEncap;
import com.b2lmobitech.fieldcloudplus.task.encap.TaskEncap;
import com.b2lmobitech.fieldcloudplus.task.sql.Sqlite;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import com.b2lmobitech.fieldcloudplus.others.sql.Tables.TaskProgress;


public class CompletedDetails extends AppCompatActivity {

    TaskEncap taskEncap;
    TextView project_name,milestone_name,task_name,task_description,start_date,end_date,task_priority,compelted_on,milestone_date,listtask_name;
    String taskid;
    private Sqlite sqldatabase;
    RequestQueue requestQueue;
    ArrayList<TaskEncap> taskList=new ArrayList<>();
    ArrayList<NotificationEncap> notificationEncaps=new ArrayList<>();
    CardView cardView;
    ProgressBar progressBar;
    Snackbar snackbar;
    CoordinatorLayout coordinatorLayout;
    ArrayList<ProgressEncap> progressList=new ArrayList<>();
    MenuItem history;
    boolean menuCreated=false;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_new);

        getSupportActionBar().setTitle("Task");
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        requestQueue= Volley.newRequestQueue(this);
        sqldatabase=new Sqlite(this);
        getWidgets();

        taskid=getIntent().getStringExtra("taskid");
        notificationEncaps=getIntent().getParcelableArrayListExtra("notifcationList");

        if(notificationEncaps!=null){
            NotificationEncap notificationEncap=notificationEncaps.get(0);
            sqldatabase.updateNotificationOpened(notificationEncap);
            GlobalVariables globalVariables = (GlobalVariables) getApplication();
            globalVariables.setProjectId(notificationEncap.getProjectID());

        }
        coordinatorLayout=findViewById(R.id.coordinator);
        getProgressList();

    }

    @Override
    protected void onResume() {
        super.onResume();
        if(isNetworkAvailable()){
            getTasksOnline(taskid);
        }else{
            getTaskDetails();
        }
    }

    private void getTasksOnline(final String taskid){
        cardView.setVisibility(View.GONE);
        progressBar.setVisibility(View.VISIBLE);

        StringRequest postRequest = new StringRequest(Request.Method.POST, "http://fieldcloud.in/App/getSingleTask.php",
                new Response.Listener<String>()
                {
                    @Override
                    public void onResponse(String response) {
                        // response
                        Log.d("Response", response);
                        try {
                            JSONObject json=new JSONObject(response);

                            int success = json.getInt("success");
                            if (success == 1) {
                                JSONArray jsonArray=json.getJSONArray("tasks");
                                JSONArray projectArray=json.getJSONArray("project");
                                JSONArray milestoneArray=json.getJSONArray("milestone");
                                JSONArray listtaskArray=json.getJSONArray("listtask");
                                JSONArray progresslsitArray=json.getJSONArray("progresslist");

                                for(int i=0; i<jsonArray.length(); i++){
                                    JSONObject jsonObject=jsonArray.getJSONObject(i);
                                    taskEncap=new TaskEncap(jsonObject);
                                    sqldatabase.insert_task(taskEncap);
                                }
                                for(int i=0; i<milestoneArray.length(); i++){
                                    JSONObject jsonObject=milestoneArray.getJSONObject(i);
                                    sqldatabase.updateMilestoneDatails(jsonObject);
                                }
                                for(int i=0; i<listtaskArray.length(); i++){
                                    JSONObject jsonObject=listtaskArray.getJSONObject(i);
                                    sqldatabase.updateListtask(jsonObject);
                                }
                                for(int i=0; i<projectArray.length(); i++){
                                    JSONObject jsonObject=projectArray.getJSONObject(i);
                                    sqldatabase.updateProjectDetails(jsonObject);
                                }
                                for(int i=0; i<progresslsitArray.length(); i++){
                                    JSONObject jsonObject=progresslsitArray.getJSONObject(i);
                                    sqldatabase.insertTaskProgress(jsonObject);
                                }
                                getTaskDetails();
                                progressBar.setVisibility(View.GONE);
                            }

                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                },
                new Response.ErrorListener()
                {
                    @Override
                    public void onErrorResponse(VolleyError error) {
                        // error
                        Log.d("Error.Response", error.toString());
                        progressBar.setVisibility(View.GONE);
                        snackbar= Snackbar.make(coordinatorLayout, "Internet connectivity problem", Snackbar.LENGTH_INDEFINITE) .setAction("close", new View.OnClickListener() {
                            @Override
                            public void onClick(View view) {
                                snackbar.dismiss();
                            }
                        });
                        snackbar.show();
                    }
                }
        ) {
            @Override
            protected Map<String, String> getParams()
            {
                Map<String, String>  params = new HashMap<String, String>();
                params.put("taskid", taskid);
                return params;
            }
        };

        requestQueue.add(postRequest);

    }

    private void getWidgets(){

        project_name=findViewById(R.id.project_name);
        milestone_name=findViewById(R.id.milestone_name);
        task_name=findViewById(R.id.task_name);
        task_description=findViewById(R.id.task_description);
        start_date=findViewById(R.id.task_start_date);
        end_date=findViewById(R.id.task_end_date);
        task_priority=findViewById(R.id.task_priority);
        findViewById(R.id.completed_layout).setVisibility(View.VISIBLE);
        compelted_on=findViewById(R.id.completed_on);
        cardView=findViewById(R.id.card_view);
        progressBar=findViewById(R.id.indeterminateBar);
        milestone_date=findViewById(R.id.milestone_date);
        listtask_name=findViewById(R.id.listtask_name);
    }

    private void setValues(){
        project_name.setText(taskEncap.getProjectname());
        task_name.setText(taskEncap.getTaskname());
        milestone_name.setText(taskEncap.getMilestonename());
        task_description.setText(taskEncap.getDescription());
        start_date.setText(taskEncap.getStartdate());
        end_date.setText(taskEncap.getEnddatte());
        compelted_on.setText(taskEncap.getUpdateddatetime());
        milestone_date.setText(taskEncap.getMilestoneenddate());
        listtask_name.setText(taskEncap.getListtaskname());

    }

    private void getTaskDetails(){
        taskList=sqldatabase.getSingleTask(taskid);
        if(taskList.size()!=0){
            taskEncap=taskList.get(0);
            setValues();
            cardView.setVisibility(View.VISIBLE);
        }else{
            snackbar= Snackbar.make(coordinatorLayout, "Details not found", Snackbar.LENGTH_INDEFINITE) .setAction("Close", new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    snackbar.dismiss();
                }
            });
            snackbar.show();
        }


    }

    private void getProgressList(){
        progressList.clear();
        Cursor cursor=sqldatabase.getTaskProgress(taskid);
        if(cursor!=null) {
            cursor.moveToFirst();
            do {
                ProgressEncap progressEncap = new ProgressEncap();
                progressEncap.setTaskid(cursor.getString(cursor.getColumnIndex(TaskProgress.TASKID)));
                progressEncap.setEmployeeid(cursor.getString(cursor.getColumnIndex(TaskProgress.EMPLOYEEID)));
                progressEncap.setProgressdate(cursor.getString(cursor.getColumnIndex(TaskProgress.PROGRESSDATE)));
                progressEncap.setProgress(cursor.getString(cursor.getColumnIndex(TaskProgress.PROGRESS)));
                progressEncap.setCompleted_activities(cursor.getString(cursor.getColumnIndex(TaskProgress.COMPLETEDACTIVITIES)));
                progressEncap.setCompleted_datetime(cursor.getString(cursor.getColumnIndex(TaskProgress.COMPLETEDDATETIME)));
                progressEncap.setProgressed_by(cursor.getString(cursor.getColumnIndex(TaskProgress.PROGRESSEDBY)));
                progressEncap.setProgressed_by_type(cursor.getString(cursor.getColumnIndex(TaskProgress.PROGRESSEDBYTYPE)));
                progressList.add(progressEncap);
            } while (cursor.moveToNext());
        }
        if(menuCreated&progressList.size()==0){
            history.setVisible(false);
        }else if(menuCreated){
            history.setVisible(true);
        }

    }


    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.menu_task_current, menu);

        menu.findItem(R.id.update).setVisible(false);
        menu.findItem(R.id.start).setVisible(false);
        menu.findItem(R.id.stop).setVisible(false);
        menu.findItem(R.id.request).setVisible(false);
        menu.findItem(R.id.reminder).setVisible(false);
        history=menu.findItem(R.id.history).setVisible(false);

        if(progressList.size()==0){
            history.setVisible(false);
        }else{
            history.setVisible(true);
        }
        menuCreated=true;
        return true;
    }


    @Override
    public boolean onOptionsItemSelected(MenuItem item) {

        switch (item.getItemId()){
            case android.R.id.home:
                finish();
                break;
            case R.id.history:
                if(cardView.getVisibility()==View.VISIBLE) {
                    Intent intent1 = new Intent(this, ProgressHistroy.class);
                    intent1.putParcelableArrayListExtra("progressList", progressList);
                    startActivity(intent1);
                    break;
                }
        }
        return super.onOptionsItemSelected(item);
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) this.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();

        return networkInfo != null && networkInfo.isConnected();
    }


}
