package com.b2lmobitech.fieldcloudplus.task.old;

import android.content.Context;
import android.content.Intent;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.encap.TaskEncap;

import java.util.ArrayList;

/**
 * Created by home on 11/7/2017.
 */

public class DependentListAdapter extends RecyclerView.Adapter<DependentListAdapter.viewHolder> {

    Context context;
    ArrayList<TaskEncap> arrayList;
    String registeredemailid;

    public DependentListAdapter(Context context,ArrayList<TaskEncap> arrayList,String registeredemailid){
        this.context=context;
        this.arrayList=arrayList;
        this.registeredemailid=registeredemailid;
    }


    @Override
    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.list_task_depentent, parent, false);
        return new viewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(viewHolder holder, int position) {
            final TaskEncap taskEncap=arrayList.get(position);

            holder.textView.setText(taskEncap.getTaskname());
        final ArrayList<TaskEncap> parcellist=new ArrayList<>();
        parcellist.add(taskEncap);

            holder.textView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    Intent intent;
                    if(taskEncap.getStatus().equalsIgnoreCase("completed")){
                        intent=new Intent(context, CompletedDetails.class);
                    }else{
                        if(taskEncap.getEmail_id().equalsIgnoreCase(registeredemailid)) {
                            intent = new Intent(context, TaskDetails.class);
                        }else{
                            intent = new Intent(context, TaskDetails2.class);
                        }
                    }
                    intent.putExtra("taskid",taskEncap.getTaskid());
                    context.startActivity(intent);
                }
            });
    }

    @Override
    public int getItemCount() {
        return arrayList.size();
    }

    public class viewHolder extends RecyclerView.ViewHolder{

        TextView textView;
        public viewHolder(View itemView) {
            super(itemView);
            textView=itemView.findViewById(R.id.dependent_task);
        }
    }

}
