package com.b2lmobitech.fieldcloudplus.task.old;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import androidx.cardview.widget.CardView;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.encap.TaskEncap;
import com.b2lmobitech.fieldcloudplus.task.encap.TasklistEncap;
import com.b2lmobitech.fieldcloudplus.task.enums.TaskEnum;

import java.util.ArrayList;

import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;

import static android.content.Context.MODE_PRIVATE;

/**
 * Created by home on 1/3/2018.
 */

public class ListTaskAdapter  extends  RecyclerView.Adapter<ListTaskAdapter.viewHolder>{

    ArrayList<TasklistEncap> projectsList;
    ArrayList<TaskEncap> taskList;
    Context context;
    SharedPreferences sp;
    String emailid;
    public ListTaskAdapter(Context context, ArrayList<TasklistEncap> projectsList, ArrayList<TaskEncap> taskList){
        this.context=context;
        this.projectsList=projectsList;
        this.taskList=taskList;
        sp = context.getSharedPreferences("projectid", MODE_PRIVATE);
        emailid = context.getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0).getString(globalvariables.logout_emailid, "");

    }


    @Override
    public void onBindViewHolder(viewHolder holder, int position) {
        final TasklistEncap tasklistEncap=projectsList.get(position);
        try {
            holder.project_name.setText(tasklistEncap.getTasklsitName());
            // holder.dates.setText("Milestone End Date : "+tasklistEncap.getMilestoneEnddate());
            holder.dates.setVisibility(View.INVISIBLE);

            holder.milestoname.setText(tasklistEncap.getMilestoneName());
            holder.milestonedate.setText(tasklistEncap.getMilestoneEnddate());

            int late = 0;
            int active = 0;

            for (TaskEncap taskEncap : taskList) {
                if (taskEncap.getEmail_id().equalsIgnoreCase(emailid) && taskEncap.getListtaskname().equalsIgnoreCase(tasklistEncap.getTasklsitName())) {
                    if (taskEncap.getCategory().equals(TaskEnum.LATE)) {
                        late++;
                    }
                }
            }
            if (late > 0) {
                holder.late.setText(late + " late");
            } else {
                holder.late.setVisibility(View.GONE);
            }

            holder.cardView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {

                    Intent intent = new Intent(context, Task.class);
                    context.getSharedPreferences("projectid", MODE_PRIVATE).edit().putString("tasklistid", tasklistEncap.getTasklistID()).apply();

                    context.startActivity(intent);
                }
            });
        }catch (Exception e){
            e.printStackTrace();
        }


    }

    @Override
    public int getItemCount() {
        return projectsList.size();
    }

    @Override
    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.list_task_tasklist, parent, false);
        return new viewHolder(itemView);
    }

    public class viewHolder extends RecyclerView.ViewHolder{
        TextView project_name,dates,late,milestoname,milestonedate;
        CardView cardView;
        public viewHolder(View itemView) {
            super(itemView);
            project_name=itemView.findViewById(R.id.project_name);
            dates=itemView.findViewById(R.id.dates);
            milestoname=itemView.findViewById(R.id.milestone_name);
            milestonedate=itemView.findViewById(R.id.milestone_date);
            cardView=itemView.findViewById(R.id.card);
            late=itemView.findViewById(R.id.late_tasks);

        }
    }

    
}

