package com.b2lmobitech.fieldcloudplus.task.old;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.location.LocationManager;
import android.provider.Settings;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.material.snackbar.Snackbar;
import androidx.cardview.widget.CardView;
import androidx.recyclerview.widget.RecyclerView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;


import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.activities.RejectForm;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.task.encap.LatLang;
import com.b2lmobitech.fieldcloudplus.task.encap.TaskEncap;
import com.b2lmobitech.fieldcloudplus.task.listener.TaskAcceptedListener;
import com.b2lmobitech.fieldcloudplus.task.sql.Sqlite;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by home on 10/27/2017.
 */

public class NewTasksAdapter extends RecyclerView.Adapter<NewTasksAdapter.ViewHolder> {

    ArrayList<TaskEncap> arrayList;
    Context context;
    ProgressDialog pDialog;
    RequestQueue requestQueue;
    TaskAcceptedListener taskAcceptedListener;
    private Sqlite sqldatabase;
    CoordinatorLayout coordinatorLayout;
    Snackbar snackbar;
    public NewTasksAdapter(Context context, ArrayList<TaskEncap> arrayList, TaskAcceptedListener taskAcceptedListener, CoordinatorLayout coordinatorLayout){
        this.context=context;
        this.arrayList=arrayList;
        this.taskAcceptedListener=taskAcceptedListener;
        sqldatabase=new Sqlite(context);
        requestQueue= Volley.newRequestQueue(context);
        this.coordinatorLayout=coordinatorLayout;
    }

    @Override
    public void onBindViewHolder(ViewHolder holder, int position) {
        final TaskEncap taskEncap=arrayList.get(position);
        holder.taskname.setText(taskEncap.getTaskname());
        holder.dates.setText(taskEncap.getStartdate()+" to "+taskEncap.getEnddatte());

        final ArrayList<TaskEncap> parcellist=new ArrayList<>();
        parcellist.add(taskEncap);

        holder.cardView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent intent=new Intent(context, TaskNew.class);
                intent.putExtra("taskid",taskEncap.getTaskid());
                context.startActivity(intent);
            }
        });

        holder.reject.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if(!Utility.isNetworkAvailable(context)) {
                    snackbar= Snackbar.make(coordinatorLayout, "No Internet Connection", Snackbar.LENGTH_INDEFINITE) .setAction("Close", new View.OnClickListener() {
                        @Override
                        public void onClick(View view) {
                            snackbar.dismiss();
                        }
                    });
                    snackbar.show();
                    return;
                }
                Intent intent=new Intent(context, RejectForm.class);
                intent.putParcelableArrayListExtra("arrayList",parcellist);
                intent.putExtra("request","reject");
                context.startActivity(intent);


            }
        });

        holder.accept.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                acceptTask(taskEncap);
            }
        });

    }

    public class ViewHolder extends RecyclerView.ViewHolder{

        TextView dates,taskname;
        Button accept,reject;
        CardView cardView;

        public ViewHolder(View itemView) {
            super(itemView);
            dates=itemView.findViewById(R.id.task_dates);
            taskname=itemView.findViewById(R.id.task_name);
            accept=itemView.findViewById(R.id.task_accept);
            reject=itemView.findViewById(R.id.task_reject);
            cardView=itemView.findViewById(R.id.new_card);
        }

    }


    @Override
    public int getItemCount() {
        return arrayList.size();
    }

    @Override
    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.list_task_new, parent, false);
        return new ViewHolder(itemView);
    }

    private void acceptTask(final TaskEncap taskEncap){

        final LocationManager locationManager = (LocationManager) context.getSystemService(Context.LOCATION_SERVICE);

        boolean isGPSEnabled = locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER);
        boolean isNetworkEnabled = locationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER);
        if (!isGPSEnabled && !isNetworkEnabled) {
            //Toast.makeText(mycontext, "No network provider is enabled for location access", Toast.LENGTH_LONG).show();
            android.app.AlertDialog.Builder alertdialog = new android.app.AlertDialog.Builder(context);

            alertdialog.setTitle("Access Location");
            alertdialog.setIcon(R.drawable.ic_action_location);
            alertdialog.setMessage("No network provider is enabled for location access!!");
            alertdialog.setPositiveButton("Turn On",
                    new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int whichButton) {
                            context.startActivity(new Intent(Settings.ACTION_LOCATION_SOURCE_SETTINGS));
                        }
                    });
            alertdialog.setNegativeButton("Cancel", new DialogInterface.OnClickListener() {

                @Override
                public void onClick(DialogInterface dialog, int which) {
                    // TODO Auto-generated method stub

                }
            }).create();
            alertdialog.show();
            return;
        }
        if(!Utility.isNetworkAvailable(context)) {
            snackbar= Snackbar.make(coordinatorLayout, "No Internet Connection", Snackbar.LENGTH_INDEFINITE) .setAction("Close", new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    snackbar.dismiss();
                }
            });
            snackbar.show();
            return;
        }
        pDialog = new ProgressDialog(context);
        pDialog.setMessage("Loading...");
        pDialog.setIndeterminate(false);
        pDialog.setCancelable(false);
        pDialog.show();
        final LatLang latLang=Utility.getLocation(context);

        StringRequest postRequest = new StringRequest(Request.Method.POST, "http://fieldcloud.in/App/accept_task.php",
                new Response.Listener<String>()
                {
                    @Override
                    public void onResponse(String response) {
                        // response
                        Log.d("Response", response);
                        try {
                            JSONObject json=new JSONObject(response);

                            int success = json.getInt("success");
                            if (success == 1) {
                                sqldatabase.updateTaskAccepted(taskEncap.getTaskid());
                                taskAcceptedListener.taskAccepted();

                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                        pDialog.dismiss();
                    }
                },
                new Response.ErrorListener()
                {
                    @Override
                    public void onErrorResponse(VolleyError error) {
                        // error
                        pDialog.dismiss();
                        Log.d("Error.Response", error.toString());
                    }
                }
        ) {
            @Override
            protected Map<String, String> getParams()
            {
                Map<String, String>  params = new HashMap<String, String>();

                params.put("assign_id", taskEncap.getAssignid());
                params.put("datetime", Utility.getCurrentDateTime());
                params.put("latitude", latLang.getLatitude());
                params.put("longtitude",latLang.getLongitude());

                return params;
            }
        };

        requestQueue.add(postRequest);

    }

    private void showAlertDialog(){

        if(!Utility.isNetworkAvailable(context)) {
            snackbar= Snackbar.make(coordinatorLayout, "No Internet Connection", Snackbar.LENGTH_INDEFINITE) .setAction("Close", new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    snackbar.dismiss();
                }
            });
            snackbar.show();
            return;
        }


    }

}
