package com.b2lmobitech.fieldcloudplus.task.old;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import androidx.cardview.widget.CardView;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;


import com.b2lmobitech.fieldcloudplus.task.encap.ProjectsEncap;
import com.b2lmobitech.fieldcloudplus.task.encap.TaskEncap;
import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.enums.TaskEnum;

import java.util.ArrayList;

import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;

import static android.content.Context.MODE_PRIVATE;

/**
 * Created by home on 10/31/2017.
 */

public class ProjectListAdapter extends  RecyclerView.Adapter<ProjectListAdapter.viewHolder>{

    ArrayList<ProjectsEncap> projectsList;
    ArrayList<TaskEncap> taskList;
    Context context;
    SharedPreferences sp;
    String emailid;



    public ProjectListAdapter(Context context, ArrayList<ProjectsEncap> projectsList, ArrayList<TaskEncap> taskList){
        this.context=context;
        this.projectsList=projectsList;
        this.taskList=taskList;
        sp = context.getSharedPreferences("projectid", MODE_PRIVATE);
        emailid = context.getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0).getString(globalvariables.logout_emailid, "");
    }


    @Override
    public void onBindViewHolder(viewHolder holder, int position) {
        final ProjectsEncap projectsEncap=projectsList.get(position);
        holder.project_name.setText(projectsEncap.getProject_name());
        holder.dates.setText(projectsEncap.getStart_date()+" to "+projectsEncap.getEnd_date());
        int late = 0;
        int active = 0;

        for (TaskEncap taskEncap : taskList) {
            if(taskEncap.getEmail_id().equalsIgnoreCase(emailid) && taskEncap.getProjectname().equalsIgnoreCase(projectsEncap.getProject_name())) {
               if (taskEncap.getCategory().equals(TaskEnum.LATE)) {
                    late++;
                }
            }
        }
        if(late>0){
            holder.late.setText(late+" late");
        }else{
            holder.late.setVisibility(View.GONE);
        }

        holder.cardView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                ArrayList<TaskEncap> arrayList=new ArrayList<>();
                for(TaskEncap taskEncap:taskList){
                    if(taskEncap.getProjectname().equalsIgnoreCase(projectsEncap.getProject_name())){
                        arrayList.add(taskEncap);
                    }
                }

                Intent intent=new Intent(context, TaskList.class);
                context.getSharedPreferences("projectid", MODE_PRIVATE).edit().putString("projectid", projectsEncap.getProjectid()).apply();

                context.startActivity(intent);
            }
        });


    }

    @Override
    public int getItemCount() {
        return projectsList.size();
    }

    @Override
    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.list_task_projects, parent, false);
        return new viewHolder(itemView);
    }

    public class viewHolder extends RecyclerView.ViewHolder{
        TextView project_name,dates,late;
        CardView cardView;
        public viewHolder(View itemView) {
            super(itemView);
            project_name=itemView.findViewById(R.id.project_name);
            dates=itemView.findViewById(R.id.dates);
            cardView=itemView.findViewById(R.id.card);
            late=itemView.findViewById(R.id.late_tasks);

        }
    }




}
