package com.b2lmobitech.fieldcloudplus.task.old;

import android.app.DatePickerDialog;
import android.app.NotificationManager;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Handler;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.material.snackbar.Snackbar;
import com.google.android.material.tabs.TabLayout;
import com.google.android.material.textfield.TextInputLayout;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import androidx.appcompat.widget.SearchView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.DatePicker;
import android.widget.RadioButton;
import android.widget.Spinner;
import android.widget.Toast;


import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.task.activities.Requests;
import com.b2lmobitech.fieldcloudplus.task.activities.SearchResult;
import com.b2lmobitech.fieldcloudplus.task.adapters.SearchResultAdapter;
import com.b2lmobitech.fieldcloudplus.task.encap.RequestEncap;
import com.b2lmobitech.fieldcloudplus.task.encap.TaskEncap;
import com.b2lmobitech.fieldcloudplus.task.enums.TaskEnum;
import com.b2lmobitech.fieldcloudplus.task.listener.TaskAcceptedListener;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.Sqlite;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;

public class Task extends AppCompatActivity{

    TabLayout tabLayout;

    ArrayList<TaskEncap> taskList=new ArrayList<>();
    ArrayList<TaskEncap> activetasks=new ArrayList<>();
    ArrayList<TaskEncap> latetasks=new ArrayList<>();
    ArrayList<TaskEncap> completedtasks=new ArrayList<>();
    ArrayList<TaskEncap> newtasks=new ArrayList<>();
    ArrayList<TaskEncap> upcoming_task=new ArrayList<>();
    ArrayList<RequestEncap> arrayList=new ArrayList<>();
    ArrayList<TaskEncap> todayList=new ArrayList<>();

    RecyclerView recyclerView;
    String registeredcompany,registeredemailid;
    NewTasksAdapter newTasksAdapter;
    TaskListAdapter taskListAdapter;
    TaskListAdapter todayListAdapter;
    UpcomingListAdapter upcomingListAdapter;
    CompletedListAdapterr completedListAdapterr;
    SearchResultAdapter searchlistAdapter;
    LateListAdapter lateListAdapter;

    ProgressDialog pDialog;
    RequestQueue requestQueue;

    SwipeRefreshLayout swipeRefreshLayout;
    private Sqlite sqldatabase;

    private String projectid;

    private static final int BACK_PASSNG=0;

    Snackbar snackbar,nosnackbar;
    CoordinatorLayout coordinatorLayout;
    boolean notFirstRun=false;
    SearchView searchView;
    RecyclerView searchRecycle;
    ArrayList<TaskEncap> searchlist=new ArrayList<>();
    MenuItem filter;
    boolean menucreated=false;
    Calendar myCalendar,myCalendar1;
    Date selected1,selected2;
    String searchType;

    @Override
    protected void onCreate(Bundle savedInstanceState)  {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_task);

        getSupportActionBar().setTitle("Tasks");
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        tabLayout=findViewById(R.id.tablayout);
        sqldatabase=new Sqlite(this);

        tabLayout.addTab(tabLayout.newTab().setText("Today"),true);
        tabLayout.addTab(tabLayout.newTab().setText("Active"));
        tabLayout.addTab(tabLayout.newTab().setText("Late"));
        tabLayout.addTab(tabLayout.newTab().setText("New"));
        tabLayout.addTab(tabLayout.newTab().setText("Upcoming"));
        tabLayout.addTab(tabLayout.newTab().setText("Completed"));

        requestQueue= Volley.newRequestQueue(this);
        searchRecycle=findViewById(R.id.search_recycycle);

        coordinatorLayout=findViewById(R.id.coordinator);
        recyclerView=findViewById(R.id.task_recycleview);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        recyclerView.setHasFixedSize(true);
        searchRecycle.setLayoutManager(new LinearLayoutManager(this));
        searchRecycle.setHasFixedSize(true);

        newTasksAdapter=new NewTasksAdapter(this, newtasks, new TaskAcceptedListener() {
            @Override
            public void taskAccepted() {
                try {
                    getTasksOffline();
                } catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        },coordinatorLayout);

        upcomingListAdapter=new UpcomingListAdapter(this,upcoming_task);
        completedListAdapterr=new CompletedListAdapterr(this,completedtasks);
        lateListAdapter=new LateListAdapter(this,latetasks);
        taskListAdapter=new TaskListAdapter(this,activetasks);
        searchlistAdapter=new SearchResultAdapter(this,searchlist);
        todayListAdapter=new TaskListAdapter(this,todayList);
        searchRecycle.setAdapter(searchlistAdapter);


        recyclerView.setAdapter(todayListAdapter);
        swipeRefreshLayout=findViewById(R.id.swiperefresh);
        setListeners();
        projectid=getSharedPreferences("projectid", MODE_PRIVATE).getString("tasklistid",null);
        getRequestsOnline();
        globalvariables.Logoutsharedpreference = getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");
    }

    private void setListeners(){
        nosnackbar= Snackbar.make(coordinatorLayout, "No Tasks found", Snackbar.LENGTH_INDEFINITE) .setAction("Close", new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                nosnackbar.dismiss();
            }
        });
        swipeRefreshLayout.setOnRefreshListener(
                new SwipeRefreshLayout.OnRefreshListener() {
                    @Override
                    public void onRefresh() {
                        // This method performs the actual data-refresh operation.
                        // The method calls setRefreshing(false) when it's finished.
                        if(!Utility.isNetworkAvailable(Task.this)) {
                            snackbar= Snackbar.make(coordinatorLayout, "No Internet Connection", Snackbar.LENGTH_INDEFINITE) .setAction("Close", new View.OnClickListener() {
                                @Override
                                public void onClick(View view) {
                                    snackbar.dismiss();
                                }
                            });
                            snackbar.show();
                            swipeRefreshLayout.setRefreshing(false);
                            return;
                        }
                        getTasksOnline();
                    }
                }
        );


        tabLayout.addOnTabSelectedListener(new TabLayout.OnTabSelectedListener() {

            @Override
            public void onTabSelected(TabLayout.Tab tab) {

                refreshData();

                boolean tabEmpty=false;

                if(tab.getPosition()==0){

                    recyclerView.setAdapter(todayListAdapter);
                    if (todayList.isEmpty()){ tabEmpty=true; }

                }else if(tab.getPosition()==1){

                    recyclerView.setAdapter(taskListAdapter);
                    if (activetasks.isEmpty()){ tabEmpty=true; }

                }else if(tab.getPosition()==2){
                    recyclerView.setAdapter(lateListAdapter);
                    if (latetasks.isEmpty()){ tabEmpty=true; }

                }else if(tab.getPosition()==3){
                    if (newtasks.isEmpty()){tabEmpty=true;}
                    recyclerView.setAdapter(newTasksAdapter);

                }else if(tab.getPosition()==4){
                    recyclerView.setAdapter(upcomingListAdapter);
                    if (upcoming_task.isEmpty()){tabEmpty=true;}

                }else if(tab.getPosition()==5){
                    recyclerView.setAdapter(completedListAdapterr);
                    if (completedtasks.isEmpty()){tabEmpty=true;}

                }
                if(tabEmpty){nosnackbar.show();}
                else{nosnackbar.dismiss();}
            }

            @Override
            public void onTabUnselected(TabLayout.Tab tab) {
            }

            @Override
            public void onTabReselected(TabLayout.Tab tab) {

            }
        });
        tabLayout.getTabAt(0).select();

    }

    private void getTasksOnline(){

        swipeRefreshLayout.setRefreshing(true);
        StringRequest postRequest = new StringRequest(Request.Method.POST, "http://fieldcloud.in/App/get_tasks.php",
                new Response.Listener<String>()
                {
                    @Override
                    public void onResponse(String response) {
                        // response
                        Log.d("Response", response);
                        try {
                            JSONObject json=new JSONObject(response);

                            int success = json.getInt("success");
                            if (success == 1) {
                                JSONArray jsonArray=json.getJSONArray("tasks");
                                JSONArray projectArray=json.getJSONArray("project");
                                JSONArray milestoneArray=json.getJSONArray("milestone");
                                JSONArray listtaskArray=json.getJSONArray("listtask");
                                JSONArray progresslsitArray=json.getJSONArray("progresslist");

                                for(int i=0; i<jsonArray.length(); i++){
                                    JSONObject jsonObject=jsonArray.getJSONObject(i);
                                    TaskEncap taskEncap=new TaskEncap(jsonObject);
                                    sqldatabase.insert_task(taskEncap);
                                }
                                for(int i=0; i<milestoneArray.length(); i++){
                                    JSONObject jsonObject=milestoneArray.getJSONObject(i);
                                    sqldatabase.updateMilestoneDatails(jsonObject);

                                }
                                for(int i=0; i<listtaskArray.length(); i++){
                                    JSONObject jsonObject=listtaskArray.getJSONObject(i);
                                    sqldatabase.updateListtask(jsonObject);
                                }
                                for(int i=0; i<projectArray.length(); i++){
                                    JSONObject jsonObject=projectArray.getJSONObject(i);
                                    sqldatabase.updateProjectDetails(jsonObject);
                                }
                                for(int i=0; i<progresslsitArray.length(); i++){
                                    JSONObject jsonObject=progresslsitArray.getJSONObject(i);
                                    sqldatabase.insertTaskProgress(jsonObject);
                                }

                                getTasksOffline();
                            }

                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                        swipeRefreshLayout.setRefreshing(false);
                    }
                },
                new Response.ErrorListener()
                {
                    @Override
                    public void onErrorResponse(VolleyError error) {
                        // error
                        Log.d("Error.Response", error.toString());
                    }
                }
        ) {
            @Override
            protected Map<String, String> getParams()
            {
                Map<String, String>  params = new HashMap<String, String>();

                //params.put("username", storedusername);
                params.put("mail", registeredemailid);
                // params.put("user", storeduser);
                // params.put("datetime",datetime);
                // params.put("available",availble);
                // params.put("version",verision);


                return params;
            }
        };

        requestQueue.add(postRequest);

    }

    @Override
    protected void onResume() {
        super.onResume();
        projectid=getSharedPreferences("projectid", MODE_PRIVATE).getString("tasklistid",null);
        try {
            getTasksOffline();
        } catch (ParseException e) {
            e.printStackTrace();
        }
        ((NotificationManager)getSystemService(Context.NOTIFICATION_SERVICE)).cancelAll();
        searchlist.clear();

    }

    private void setUncompletedTasks(){

    }

    private void getTasksOffline() throws ParseException {
        taskList.clear();
        Log.e("listtask",projectid);

        JSONArray jsonArray= Database.getInstance(this).getAssignedTasks(projectid);

        taskList=sqldatabase.get_tasks_bylsit(projectid,registeredemailid.toLowerCase());
        tabLayout.setSmoothScrollingEnabled(true);
        refreshData();

        int delaytime=10;
        if(!notFirstRun) {
            notFirstRun=true;
            if(!latetasks.isEmpty()){
                new Handler().postDelayed(
                        new Runnable() {
                            @Override public void run() {
                                tabLayout.getTabAt(2).select();
                            }
                        }, delaytime);
            }else if(!todayList.isEmpty()){
                new Handler().postDelayed(
                        new Runnable() {
                            @Override public void run() {
                                tabLayout.getTabAt(0).select();
                            }
                        }, delaytime);
            }else if (!activetasks.isEmpty()) {
                new Handler().postDelayed(
                        new Runnable() {
                            @Override public void run() {
                                tabLayout.getTabAt(1).select();
                            }
                        }, delaytime);
            }else if(!upcoming_task.isEmpty()){
                new Handler().postDelayed(
                        new Runnable() {
                            @Override public void run() {
                                tabLayout.getTabAt(4).select();
                            }
                        }, delaytime);
            }else if(!newtasks.isEmpty()){
                new Handler().postDelayed(
                        new Runnable() {
                            @Override public void run() {
                                tabLayout.getTabAt(3).select();
                            }
                        }, delaytime);
            }else if(!completedtasks.isEmpty()){
                //tabLayout.getTabAt(5).select();
              //  tabLayout.setScrollX(tabLayout.getWidth());
                new Handler().postDelayed(
                        new Runnable() {
                            @Override public void run() {
                                tabLayout.getTabAt(5).select();
                            }
                        }, delaytime);
            }
            /* else if (activetasks.size() == 0) {
                if (newtasks.size() == 0) {
                    if (upcoming_task.size() == 0) {
                        if (completedtasks.size() == 0) {
                            tabLayout.getTabAt(0).select();
                        } else {
                            tabLayout.getTabAt(4).select();
                            tabLayout.computeScroll();
                        }
                    } else {
                        tabLayout.getTabAt(3).select();
                        tabLayout.scrollBy(0,4);
                    }
                } else {
                    tabLayout.getTabAt(2).select();
                    tabLayout.scrollBy(0,3);
                }
            } else {
                tabLayout.getTabAt(0).select();
                tabLayout.scrollBy(0,2);
            }*/
        }
    }

    private void refreshData(){
        activetasks.clear();
        latetasks.clear();
        completedtasks.clear();
        newtasks.clear();
        upcoming_task.clear();
        todayList.clear();
        searchlist.clear();

        JSONArray jsonArray= Database.getInstance(this).getAssignedTasks(projectid);




        for(TaskEncap taskEncap:taskList){

            switch (taskEncap.getCategory()){
                case NEW:
                    newtasks.add(taskEncap);
                    break;
                case LATE:
                    latetasks.add(taskEncap);
                    break;
                case ACTIVE:
                    activetasks.add(taskEncap);
                    break;
                case UPCOMING:
                    upcoming_task.add(taskEncap);
                    break;
                case COMPLETED:
                    completedtasks.add(taskEncap);
                    break;
            }
            int dayend=Utility.daysbetween(taskEncap.getD_enddatte());
            if(dayend==0 && !taskEncap.getCategory().equals(TaskEnum.NEW) && !taskEncap.getCategory().equals(TaskEnum.COMPLETED)){
                todayList.add(taskEncap);
            }
        }

        Collections.sort(activetasks);
        Collections.sort(latetasks, new Comparator<TaskEncap>() {
            @Override
            public int compare(TaskEncap o1, TaskEncap o2) {
                if(o1.getD_enddatte().before(o2.getD_enddatte())){
                    return -1;
                }else if (o1.getD_enddatte().after(o2.getD_enddatte())){
                    return 1;
                } else {
                    return 0;
                }
            }
        });
        newTasksAdapter.notifyDataSetChanged();
        taskListAdapter.notifyDataSetChanged();
        upcomingListAdapter.notifyDataSetChanged();
        completedListAdapterr.notifyDataSetChanged();
        lateListAdapter.notifyDataSetChanged();
        todayListAdapter.notifyDataSetChanged();
    }

    private void startTask(final TaskEncap taskEncap){

        pDialog = new ProgressDialog(this);
        pDialog.setMessage("Starting Task...");
        pDialog.setIndeterminate(false);
        pDialog.setCancelable(false);
        pDialog.show();

        StringRequest postRequest = new StringRequest(Request.Method.POST, "http://fieldcloud.in/App/start_task.php",
                new Response.Listener<String>()
                {
                    @Override
                    public void onResponse(String response) {
                        // response
                        Log.d("Response", response);
                        try {
                            JSONObject json=new JSONObject(response);

                            int success = json.getInt("success");
                            if (success == 1) {

                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                        pDialog.dismiss();
                    }
                },
                new Response.ErrorListener()
                {
                    @Override
                    public void onErrorResponse(VolleyError error) {
                        // error
                        pDialog.dismiss();
                        Log.d("Error.Response", error.toString());
                    }
                }
        ) {
            @Override
            protected Map<String, String> getParams()
            {
                Map<String, String>  params = new HashMap<String, String>();

                params.put("assign_id", taskEncap.getAssignid());
                params.put("task_id", taskEncap.getTaskid());
                params.put("datetime",Utility.getCurrentDateTime());

                return params;
            }
        };

        requestQueue.add(postRequest);

    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.menu_task, menu);
        menucreated=true;
       // MenuItem search = menu.findItem(R.id.search);
        filter=menu.findItem(R.id.filter);
        filter.setVisible(false);
        //SearchManager searchManager = (SearchManager)getSystemService(Context.SEARCH_SERVICE);
       // searchView = (SearchView) search.getActionView();
       // searchView.setSearchableInfo(searchManager.getSearchableInfo(getComponentName()));
       // searchView.setOnQueryTextListener(this);
       // searchView.setOnCloseListener(this);

        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {

        switch (item.getItemId()){
            case R.id.requests:
                Intent intent=new Intent(this,Requests.class);
                intent.putExtra("projectid",projectid);
                startActivity(intent);
                break;
            case R.id.notifications:
                //startActivity(new Intent(this,Notifications.class));
                break;
            case android.R.id.home:
                finish();
                break;
            case R.id.filter:
                showFilterDialog();
                break;
            case R.id.search:
                showSearchAlertDialouge();
                break;


        }

        return super.onOptionsItemSelected(item);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case BACK_PASSNG:
                if (resultCode == RESULT_OK) {
                    Log.e("chekck","Notification called");
                    projectid=data.getStringExtra("projectid");
                    Log.e("chekck",projectid);

                    try {
                        getTasksOffline();
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                break;
        }
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) this.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();

        return networkInfo != null && networkInfo.isConnected();
    }

    private void getRequestsOnline(){


        StringRequest postRequest = new StringRequest(Request.Method.POST, "http://fieldcloud.in/App/requestUpdates.php",
                new Response.Listener<String>()
                {
                    @Override
                    public void onResponse(String response) {
                        // response
                        Log.d("Response", response);
                        try {
                            JSONObject json=new JSONObject(response);

                            int success = json.getInt("success");
                            if (success == 1) {
                                arrayList.clear();

                                JSONArray jsonArray=json.getJSONArray("requests");

                                for(int i=0; i<jsonArray.length(); i++){
                                    JSONObject jsonObject=jsonArray.getJSONObject(i);
                                    RequestEncap requestEncap=new RequestEncap();

                                    requestEncap.setTaskName(jsonObject.getString("task_name"));
                                    requestEncap.setTaskId(jsonObject.getString("task_id"));
                                    requestEncap.setAssignid(jsonObject.getString("assign_id"));
                                    requestEncap.setEmployeeid(jsonObject.getString("employeeid"));
                                    requestEncap.setStatus(jsonObject.getString("status"));
                                    requestEncap.setReason(jsonObject.getString("reason"));
                                    requestEncap.setRequestdatetime(jsonObject.getString("r_datetime"));
                                    requestEncap.setResponse(jsonObject.getString("response"));
                                    requestEncap.setIncreasedays(jsonObject.getString("increasedays"));
                                    requestEncap.setUpdateddatetime(jsonObject.getString("updatetime"));
                                    // arrayList.add(requestEncap);
                                    sqldatabase.insertOrUpdateTaskRequest(requestEncap);
                                }
                            }else{

                            }

                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                        //getRequestsOffline();
                    }
                },
                new Response.ErrorListener()
                {
                    @Override
                    public void onErrorResponse(VolleyError error) {
                        // error
                        Log.d("Error.Response", error.toString());
                        //getRequestsOffline();
                    }
                }
        ) {
            @Override
            protected Map<String, String> getParams()
            {
                Map<String, String>  params = new HashMap<String, String>();

                params.put("project_id", projectid);
                params.put("email_id", registeredemailid);

                return params;
            }
        };

        requestQueue.add(postRequest);

    }

    private void showFilterDialog(){
        final AlertDialog.Builder dialogBuilder = new AlertDialog.Builder(this);

        // ...Irrelevant code for customizing the buttons and title

        LayoutInflater inflater = this.getLayoutInflater();

        final View dialogView= inflater.inflate(R.layout.alert_active_tasks, null);
        dialogBuilder.setView(dialogView);
        final AlertDialog alertDialog=dialogBuilder.create();
        RadioButton radioButton=dialogView.findViewById(R.id.today_only);
        RadioButton remainingDays=dialogView.findViewById(R.id.remaining_date);
        RadioButton enddate=dialogView.findViewById(R.id.end_date);

        radioButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                filterActiveToday();
                alertDialog.hide();

            }
        });

        remainingDays.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                orderByRemaining();
                alertDialog.hide();
            }
        });

        enddate.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                orderByEdnddate();
                alertDialog.hide();
            }
        });


        alertDialog.show();
    }

    private void filterActiveToday(){

        activetasks.clear();
        for(TaskEncap taskEncap:taskList){
            int dayend=Utility.daysbetween(taskEncap.getD_enddatte());
            if(dayend==0){
                activetasks.add(taskEncap);
            }
        }
        if (activetasks.size()==0){
            nosnackbar.show();
        }
        taskListAdapter.notifyDataSetChanged();

    }

    private void orderByRemaining(){
        refreshData();
        Collections.sort(activetasks, new Comparator<TaskEncap>() {
            @Override
            public int compare(TaskEncap o1, TaskEncap o2) {
                if(o1.getD_enddatte().before(o2.getD_enddatte())){
                    return 1;
                }else if (o1.getD_enddatte().after(o2.getD_enddatte())){
                    return -1;
                } else {
                    return 0;
                }
            }
        });
        taskListAdapter.notifyDataSetChanged();

    }

    private void prepareSearchList(){
        searchlist.clear();
        for(TaskEncap taskEncap:taskList){

            if((taskEncap.getD_startdate().after(selected1) && taskEncap.getD_enddatte().before(selected2))){
                searchlist.add(taskEncap);
            }
        }
    }

    private void orderByEdnddate(){
        refreshData();
        Collections.sort(activetasks, new Comparator<TaskEncap>() {
            @Override
            public int compare(TaskEncap o1, TaskEncap o2) {
                if(o1.getD_enddatte().before(o2.getD_enddatte())){
                    return -1;
                }else if (o1.getD_enddatte().after(o2.getD_enddatte())){
                    return 1;
                } else {
                    return 0;
                }
            }
        });
        taskListAdapter.notifyDataSetChanged();
    }

    private void showSearchAlertDialouge(){


        myCalendar = Calendar.getInstance();
        myCalendar1 = Calendar.getInstance();

        //EditText edittext= (EditText) findViewById(R.id.Birthday);

        final AlertDialog.Builder dialogBuilder = new AlertDialog.Builder(this);

        // ...Irrelevant code for customizing the buttons and title

        LayoutInflater inflater = this.getLayoutInflater();

        final View dialogView= inflater.inflate(R.layout.alert_search_form, null);
        dialogBuilder.setView(dialogView);
        final AlertDialog alertDialog=dialogBuilder.create();

        final TextInputLayout tlFrom=dialogView.findViewById(R.id.from_date);
        final TextInputLayout tlTo=dialogView.findViewById(R.id.to_date);

        Button cancel=dialogView.findViewById(R.id.alert_cancel);
        Button search=dialogView.findViewById(R.id.alert_search);
        final Spinner alert_spinner=dialogView.findViewById(R.id.alert_spinner);


        alert_spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                tlFrom.getEditText().getText().clear();
                tlTo.getEditText().getText().clear();
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {

            }
        });

        final DatePickerDialog.OnDateSetListener fromDate = new DatePickerDialog.OnDateSetListener() {

            @Override
            public void onDateSet(DatePicker view, int year, int monthOfYear,
                                  int dayOfMonth) {
                // TODO Auto-generated method stub
                myCalendar.set(Calendar.YEAR, year);
                myCalendar.set(Calendar.MONTH, monthOfYear);
                myCalendar.set(Calendar.DAY_OF_MONTH, dayOfMonth);
                String myFormat = "dd/MM/yyyy"; //In which you need put here
                SimpleDateFormat sdf = new SimpleDateFormat(myFormat, Locale.US);
                tlFrom.getEditText().setText(sdf.format(myCalendar.getTime()));
                try {
                    selected1=Utility.getDateOnly(myCalendar.getTime());
                } catch (ParseException e) {
                    e.printStackTrace();
                }
                tlTo.getEditText().getText().clear();
                //edittext.setText(sdf.format(myCalendar.getTime()));
            }

        };
        final DatePickerDialog.OnDateSetListener toDate = new DatePickerDialog.OnDateSetListener() {

            @Override
            public void onDateSet(DatePicker view, int year, int monthOfYear,
                                  int dayOfMonth) {
                // TODO Auto-generated method stub
                myCalendar1.set(Calendar.YEAR, year);
                myCalendar1.set(Calendar.MONTH, monthOfYear);
                myCalendar1.set(Calendar.DAY_OF_MONTH, dayOfMonth);
                String myFormat = "dd/MM/yyyy"; //In which you need put here
                SimpleDateFormat sdf = new SimpleDateFormat(myFormat, Locale.US);
                tlTo.getEditText().setText(sdf.format(myCalendar1.getTime()));
                try {
                    selected2=Utility.getDateOnly(myCalendar1.getTime());
                } catch (ParseException e) {
                    e.printStackTrace();
                }

                //edittext.setText(sdf.format(myCalendar.getTime()));
            }

        };

        tlFrom.getEditText().setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if(alert_spinner.getSelectedItemPosition()==0){
                    Toast.makeText(getApplicationContext(),"Select Type",Toast.LENGTH_SHORT).show();
                    return;
                }
              DatePickerDialog datePicker =  new DatePickerDialog(Task.this, fromDate, myCalendar
                        .get(Calendar.YEAR), myCalendar.get(Calendar.MONTH),
                        myCalendar.get(Calendar.DAY_OF_MONTH));
              if(alert_spinner.getSelectedItemPosition()==1 || alert_spinner.getSelectedItemPosition()==2){
                  datePicker.getDatePicker().setMinDate(Calendar.getInstance().getTimeInMillis());
              }else if(alert_spinner.getSelectedItemPosition()==3){
                  datePicker.getDatePicker().setMaxDate(Calendar.getInstance().getTimeInMillis());
              }
              datePicker.show();

            }
        });
        tlTo.getEditText().setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if(tlFrom.getEditText().getText().toString().isEmpty()){
                    Toast.makeText(getApplicationContext(),"Select from Date",Toast.LENGTH_SHORT).show();
                    return;
                }

                DatePickerDialog datePicker = new DatePickerDialog(Task.this, toDate, myCalendar1
                        .get(Calendar.YEAR), myCalendar1.get(Calendar.MONTH),
                        myCalendar1.get(Calendar.DAY_OF_MONTH));
                if(alert_spinner.getSelectedItemPosition()==1 || alert_spinner.getSelectedItemPosition()==2){
                    datePicker.getDatePicker().setMinDate(myCalendar.getTimeInMillis());
                }else if(alert_spinner.getSelectedItemPosition()==3){
                    datePicker.getDatePicker().setMinDate(myCalendar.getTimeInMillis());
                    datePicker.getDatePicker().setMaxDate(Calendar.getInstance().getTimeInMillis());
                }
                datePicker.show();

            }
        });

       // alert_spinner

        cancel.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                alertDialog.hide();
            }
        });


        search.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(tlFrom.getEditText().getText().toString().isEmpty()){
                    tlFrom.getEditText().setError("Select Date");
                    return;
                }
              /*  prepareSearchList();
                if(searchlist.isEmpty()){
                    Toast.makeText(getApplicationContext(),"No tasks found",Toast.LENGTH_SHORT).show();
                    return;
                }
                Log.e("size",searchlist.size()+"");
                Intent intent=new Intent(Task.this,SearchResult.class);
                intent.putExtra("full_list",taskList);
                intent.putExtra("search_list",searchlist);
                intent.putExtra("fromDate",tlFrom.getEditText().getText().toString());
                intent.putExtra("toDate",tlFrom.getEditText().getText().toString());
                startActivity(intent);*/
                searchResult(tlFrom.getEditText().getText().toString(),tlTo.getEditText().getText().toString(),selected1,selected2,alert_spinner.getSelectedItem().toString(),alertDialog);
                //alertDialog.hide();
            }
        });
        alertDialog.show();
    }

    private void searchResult(String from,String to,Date dfrom,Date dto,String type,AlertDialog alertDialog){

        try {
            if (type.equalsIgnoreCase("Active")) {
                searchlist.clear();

                if (to.isEmpty()) {
                    for (TaskEncap taskEncap : taskList) {

                       /* if ((taskEncap.getD_startdate().compareTo(selected1)<=0 && taskEncap.getD_enddatte().compareTo(selected1)>=0)) {
                            searchlist.add(taskEncap);
                        }*/
                        if( selected1.equals(taskEncap.getD_startdate()) || selected1.equals(taskEncap.getD_enddatte()) ||
                                (selected1.after(taskEncap.getD_startdate()) && selected1.before(taskEncap.getD_enddatte()))){
                            searchlist.add(taskEncap);
                        }
                    }
                } else {
                    for (TaskEncap taskEncap : taskList) {
                        if (selected1.equals(taskEncap.getD_startdate()) || selected1.equals(taskEncap.getD_enddatte()) ||
                                selected2.equals(taskEncap.getD_startdate()) || selected2.equals(taskEncap.getD_enddatte()) ||
                                (taskEncap.getD_startdate().after(selected1) && taskEncap.getD_startdate().before(selected2)) || (taskEncap.getD_enddatte().after(selected1) && taskEncap.getD_enddatte().before(selected2))) {
                            searchlist.add(taskEncap);
                        }
                    }
                }

            } else if (type.equalsIgnoreCase("Completed")) {
                searchlist.clear();
                if (to.isEmpty()) {
                    for (TaskEncap taskEncap : taskList) {

                       /* if ((taskEncap.getD_startdate().compareTo(selected1)<=0 && taskEncap.getD_enddatte().compareTo(selected1)>=0)) {
                            searchlist.add(taskEncap);
                        }*/
                        try {
                            if( selected1.equals(Utility.getDateOnly(taskEncap.getD_updateddatetime()) ) )
                                searchlist.add(taskEncap);
                        } catch (ParseException e1) {
                            e1.printStackTrace();
                        }
                    }
                } else {
                    for (TaskEncap taskEncap : taskList) {
                        if (taskEncap.getI_progress() == 100) {
                            try {
                                if (selected1.equals(Utility.getDateOnly(taskEncap.getD_updateddatetime())) ||
                                        selected2.equals(Utility.getDateOnly(taskEncap.getD_updateddatetime())) ||
                                        (Utility.getDateOnly(taskEncap.getD_updateddatetime()).after(selected1) && Utility.getDateOnly(taskEncap.getD_updateddatetime()).before(selected2)) ||
                                        (Utility.getDateOnly(taskEncap.getD_updateddatetime()).after(selected1) && Utility.getDateOnly(taskEncap.getD_updateddatetime()).before(selected2))) {
                                    searchlist.add(taskEncap);
                                }
                            } catch (ParseException e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                }
            } else if (type.equalsIgnoreCase("Deadline")) {
                if (to.isEmpty()) {
                    for (TaskEncap taskEncap : taskList) {
                        if(  selected1.equals(taskEncap.getD_enddatte())){
                            searchlist.add(taskEncap);
                        }
                    }
                } else {
                    for (TaskEncap taskEncap : taskList) {
                        if (
                                selected1.equals(taskEncap.getD_enddatte()) ||
                                selected2.equals(taskEncap.getD_enddatte()) ||
                                (taskEncap.getD_enddatte().after(selected1) && taskEncap.getD_enddatte().before(selected2))) {
                            searchlist.add(taskEncap);
                        }
                    }
                }
            }


            if (searchlist.isEmpty()) {
                Toast.makeText(getApplicationContext(), "No tasks found", Toast.LENGTH_SHORT).show();
                return;
            }
            Intent intent = new Intent(Task.this, SearchResult.class);
            intent.putExtra("full_list", taskList);
            intent.putExtra("search_list", searchlist);
            intent.putExtra("title",type);
            intent.putExtra("fromDate", from);
            intent.putExtra("toDate", to);
            startActivity(intent);

            alertDialog.hide();
        }catch (Exception e){
            e.printStackTrace();
        }
    }



}
