package com.b2lmobitech.fieldcloudplus.task.old;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.preference.PreferenceManager;
import android.provider.Settings;
import androidx.coordinatorlayout.widget.CoordinatorLayout;

import com.b2lmobitech.fieldcloudplus.hcm.others.LocationUpdate;
import com.google.android.material.snackbar.Snackbar;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import androidx.cardview.widget.CardView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.work.Constraints;
import androidx.work.NetworkType;
import androidx.work.OneTimeWorkRequest;
import androidx.work.PeriodicWorkRequest;

import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.TimePicker;

import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.task.activities.ExtendForm;
import com.b2lmobitech.fieldcloudplus.task.activities.ProgressForm;
import com.b2lmobitech.fieldcloudplus.task.activities.ProgressHistroy;
import com.b2lmobitech.fieldcloudplus.task.activities.RejectForm;
import com.b2lmobitech.fieldcloudplus.task.activities.RequestDetails;
import com.b2lmobitech.fieldcloudplus.task.encap.LatLang;
import com.b2lmobitech.fieldcloudplus.task.encap.NotificationEncap;
import com.b2lmobitech.fieldcloudplus.task.encap.ProgressEncap;
import com.b2lmobitech.fieldcloudplus.task.encap.RequestEncap;
import com.b2lmobitech.fieldcloudplus.task.encap.TaskEncap;
import com.b2lmobitech.fieldcloudplus.task.service.AlarmReceiver;
import com.b2lmobitech.fieldcloudplus.task.service.SimpleJob;
import com.b2lmobitech.fieldcloudplus.task.service.UpdateTaskService;
import com.b2lmobitech.fieldcloudplus.task.sql.Sqlite;
//import com.firebase.jobdispatcher.Constraint;
//import com.firebase.jobdispatcher.FirebaseJobDispatcher;
//import com.firebase.jobdispatcher.GooglePlayDriver;
//import com.firebase.jobdispatcher.Job;
//import com.firebase.jobdispatcher.JobTrigger;
//import com.firebase.jobdispatcher.Lifetime;
//import com.firebase.jobdispatcher.RetryStrategy;
//import com.firebase.jobdispatcher.Trigger;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import com.b2lmobitech.fieldcloudplus.others.sql.Tables.TaskProgress;
import com.b2lmobitech.fieldcloudplus.others.sql.Tables.TaskRequestTable;
import com.b2lmobitech.fieldcloudplus.others.sql.Tables.TaskTable;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;

public class TaskDetails extends AppCompatActivity {

    MenuItem stop,update,request,start,history,reminder;
    SeekBar seekBar;
    TextView completed_percentage,project_name,milestone_name,task_name,task_description,start_date,end_date,due_days,task_priority,milestone_date,listtask_name;
    ArrayList<TaskEncap> arrayList=new ArrayList<>();
    ArrayList<TaskEncap> taskList=new ArrayList<>();
    ArrayList<TaskEncap> dependentlist=new ArrayList<>();
    ArrayList<ProgressEncap> progressList=new ArrayList<>();
    RequestQueue requestQueue;
    ProgressDialog pDialog;
    private Sqlite sqldatabase;
    TaskEncap taskEncap;
    TextView requestPlaced;
    ArrayList<RequestEncap> requestList=new ArrayList<>();
    TextView moreclick,lessclick;
    LinearLayout morelayout;
    boolean alltaksCleared=true,requestPlace=false;
    HashSet<String> depened_task=new HashSet<>();
    LinearLayout dependentLayout,progressLayput,milestoneLayout;
    RecyclerView recyclerView;
    RelativeLayout percentage_layout;
    String taskid;
    boolean menucreated=false;
    String registeredcompany,registeredemailid;
    ArrayList<NotificationEncap> notificationEncaps=new ArrayList<>();
    CardView cardView;
    ProgressBar progressBar;
    Snackbar snackbar;
    CoordinatorLayout coordinatorLayout;
    int requests=0;
    AlarmManager alarmManager;
    private PendingIntent pendingIntent;
    private TimePicker alarmTimePicker;
    private TextView alarmTextView;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_task_detailss);

        getSupportActionBar().setTitle("Task");
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        requestQueue= Volley.newRequestQueue(this);
        sqldatabase=new Sqlite(this);
        taskid=getIntent().getStringExtra("taskid");
        notificationEncaps=getIntent().getParcelableArrayListExtra("notifcationList");
        if(notificationEncaps!=null){
            NotificationEncap notificationEncap=notificationEncaps.get(0);
            sqldatabase.updateNotificationOpened(notificationEncap);

        }
        getWidgets();
        setListeners();
        dependentLayout.setVisibility(View.GONE);
        globalvariables.Logoutsharedpreference = getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");
        morelayout.setVisibility(View.GONE);
        lessclick.setVisibility(View.GONE);

    }

    @Override
    protected void onResume() {
        super.onResume();
        if(isNetworkAvailable()){
            getTasksOnline(taskid);
        }else{
            getTaskDetails();
        }
    }

    private void getTaskDetails(){

        taskList=sqldatabase.getSingleTask(taskid);
        if(taskList.size()!=0) {
            taskEncap=taskList.get(0);
            getSharedPreferences("projectid", MODE_PRIVATE).edit().putString("tasklistid", taskEncap.getListtaskid()).apply();
            checkDependents();
            setValues();
            getProgressList();
            checkRequests();
            cardView.setVisibility(View.VISIBLE);
        }else{
            snackbar= Snackbar.make(coordinatorLayout, "No details found", Snackbar.LENGTH_INDEFINITE) .setAction("close", new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    snackbar.dismiss();
                }
            });
            snackbar.show();
        }

    }

    private void getTasksOnline(final String taskid){
        cardView.setVisibility(View.GONE);
        progressBar.setVisibility(View.VISIBLE);

        StringRequest postRequest = new StringRequest(Request.Method.POST, "http://fieldcloud.in/App/getSingleTask.php",
                new Response.Listener<String>()
                {
                    @Override
                    public void onResponse(String response) {
                        // response
                        Log.d("Response", response);
                        try {
                            JSONObject json=new JSONObject(response);

                            int success = json.getInt("success");
                            if (success == 1) {
                                JSONArray jsonArray=json.getJSONArray("tasks");
                                JSONArray projectArray=json.getJSONArray("project");
                                JSONArray milestoneArray=json.getJSONArray("milestone");
                                JSONArray listtaskArray=json.getJSONArray("listtask");
                                JSONArray progresslsitArray=json.getJSONArray("progresslist");

                                for(int i=0; i<jsonArray.length(); i++){
                                    JSONObject jsonObject=jsonArray.getJSONObject(i);
                                    TaskEncap taskEncap=new TaskEncap(jsonObject);
                                    sqldatabase.insert_task(taskEncap);
                                }
                                for(int i=0; i<milestoneArray.length(); i++){
                                    JSONObject jsonObject=milestoneArray.getJSONObject(i);
                                    sqldatabase.updateMilestoneDatails(jsonObject);
                                }
                                for(int i=0; i<listtaskArray.length(); i++){
                                    JSONObject jsonObject=listtaskArray.getJSONObject(i);
                                    sqldatabase.updateListtask(jsonObject);
                                }
                                for(int i=0; i<projectArray.length(); i++){
                                    JSONObject jsonObject=projectArray.getJSONObject(i);
                                    sqldatabase.updateProjectDetails(jsonObject);
                                }
                                for(int i=0; i<progresslsitArray.length(); i++){
                                    JSONObject jsonObject=progresslsitArray.getJSONObject(i);
                                    sqldatabase.insertTaskProgress(jsonObject);
                                }

                            }

                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                        getTaskDetails();
                        progressBar.setVisibility(View.GONE);
                    }
                },
                new Response.ErrorListener()
                {
                    @Override
                    public void onErrorResponse(VolleyError error) {
                        // error
                        Log.d("Error.Response", error.toString());
                        snackbar= Snackbar.make(coordinatorLayout, "Internet connectivity problem", Snackbar.LENGTH_INDEFINITE) .setAction("close", new View.OnClickListener() {
                            @Override
                            public void onClick(View view) {
                                snackbar.dismiss();
                            }
                        });
                        snackbar.show();
                        progressBar.setVisibility(View.GONE);

                    }
                }
        ) {
            @Override
            protected Map<String, String> getParams()
            {
                Map<String, String>  params = new HashMap<String, String>();
                params.put("taskid", taskid);
                return params;
            }
        };

        requestQueue.add(postRequest);

    }

    private void getWidgets(){

        seekBar=findViewById(R.id.perccentage_seekbar);
        completed_percentage=findViewById(R.id.completed_precentage);
        project_name=findViewById(R.id.project_name);
        milestone_name=findViewById(R.id.milestone_name);
        task_name=findViewById(R.id.task_name);
        task_description=findViewById(R.id.task_description);
        start_date=findViewById(R.id.task_start_date);
        end_date=findViewById(R.id.task_end_date);
        task_priority=findViewById(R.id.task_priority);
        due_days=findViewById(R.id.task_due_days);
        moreclick=findViewById(R.id.more_click);
        morelayout=findViewById(R.id.more_layout);
        lessclick=findViewById(R.id.less_click);
        dependentLayout=findViewById(R.id.dependent_layout);
        progressLayput=findViewById(R.id.progress_layout);
        recyclerView=findViewById(R.id.depentent_recycle);
        percentage_layout=findViewById(R.id.percentage_layout);
        milestoneLayout=findViewById(R.id.milestone_layout);
        requestPlaced=findViewById(R.id.requestPlaced);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        recyclerView.setHasFixedSize(true);
        cardView=findViewById(R.id.card_view);
        progressBar=findViewById(R.id.indeterminateBar);
        coordinatorLayout=findViewById(R.id.coordinator);
        milestone_date=findViewById(R.id.milestone_date);
        listtask_name=findViewById(R.id.listtask_name);
    }

    private void setValues(){
        project_name.setText(taskEncap.getProjectname());
        task_name.setText(taskEncap.getTaskname());
        if(taskEncap.getMilestonename()==null) {
            milestoneLayout.setVisibility(View.GONE);
        }else{
            milestoneLayout.setVisibility(View.VISIBLE);
            milestone_name.setText(taskEncap.getMilestonename());
        }
        task_description.setText(taskEncap.getDescription());
        start_date.setText(taskEncap.getStartdate());
        end_date.setText(taskEncap.getEnddatte());
        task_priority.setText(taskEncap.getPriotity());
        completed_percentage.setText(taskEncap.getProgress() + "%");
        milestone_date.setText(taskEncap.getMilestoneenddate());
        listtask_name.setText(taskEncap.getListtaskname());
        int daysbetween=Utility.daysbetween(taskEncap.getD_enddatte());
        if (daysbetween < 0) {
            daysbetween = daysbetween * -1;
            if (daysbetween == 1) {
                due_days.setText(daysbetween + " Day Late");
            } else {
                due_days.setText(daysbetween + " Days Late");
            }
        } else if (daysbetween == 0) {
            due_days.setText("Today");
        } else if (daysbetween >= 1) {
            due_days.setText("In " + daysbetween + " Days");
        }
            if (menucreated) {
                seekBar.setProgress(taskEncap.getI_progress());

                update.setVisible(false);
                if (taskEncap.getAssign_status().equalsIgnoreCase("accepted")) {
                    start.setVisible(true);
                    stop.setVisible(false);
                    request.setVisible(false);
                    reminder.setVisible(false);
                } else {
                    start.setVisible(false);
                    reminder.setVisible(true);
                    if(taskEncap.getI_progress()==90){
                        stop.setVisible(false);
                    }else{
                        stop.setVisible(true);
                    }

                }
            }
    }

    private void setListeners(){
        seekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {

            @Override
            public void onProgressChanged(SeekBar seekBar, int i, boolean b) {
                completed_percentage.setText(i+"%");

                if(i>taskEncap.getI_progress()) {
                    update.setVisible(true);
                }else{
                    update.setVisible(false);
                }
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {

            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {

            }
        });

        moreclick.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                morelayout.setVisibility(View.VISIBLE);
                lessclick.setVisibility(View.VISIBLE);
                moreclick.setVisibility(View.GONE);
            }
        });
        lessclick.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                morelayout.setVisibility(View.GONE);
                lessclick.setVisibility(View.GONE);
                moreclick.setVisibility(View.VISIBLE);
            }
        });

        requestPlaced.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent intent=new Intent(TaskDetails.this, RequestDetails.class);
                intent.putExtra("assignid",requestList.get(0).getAssignid());
                intent.putExtra("datetime",requestList.get(0).getAssignid());
               // startActivity(intent);
            }
        });


    }

    private void checkDependents(){
        Log.d("Sequencce",taskEncap.getSequence());
        dependentlist.clear();
        if(!taskEncap.getSequence().equalsIgnoreCase("null") || !taskEncap.getSequence().trim().isEmpty()){

            String depend[]=taskEncap.getSequence().split(",");
            for(int i=0; i<depend.length; i++){
                depened_task.add(depend[i].trim());
            }
            for(String tid:depened_task){
                Log.d("Sequencce",tid);
                Cursor cursor=sqldatabase.getTask(tid);
                if(cursor!=null) {

                    if (cursor.moveToFirst()) {
                        dependentLayout.setVisibility(View.GONE);
                    }

                    do {
                        TaskEncap taskEncap = new TaskEncap();
                        taskEncap.setProjctid(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.PROJECTID)));
                        taskEncap.setTaskid(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.TASKID)));
                        Log.d("Sequencce", taskEncap.getTaskid());
                        taskEncap.setTaskname(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.TASKANME)));
                        taskEncap.setAssignid(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.ASSIGNID)));
                        taskEncap.setProjectname(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.PROJECTNAME)));
                        taskEncap.setEmail_id(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.EMAILID)));
                        taskEncap.setMilestoneid(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.MILESTONEID)));
                        taskEncap.setMilestonename(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.MILESTONENAME)));
                        taskEncap.setListtaskid(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.LISTTASKID)));
                        taskEncap.setListtaskname(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.LISTTASKNAME)));
                        taskEncap.setAssigneddatetime(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.ASSIGNEDDATETIME)));
                        taskEncap.setDescription(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.DESCRIPTION)));
                        taskEncap.setStatus(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.T_STATUS)));
                        taskEncap.setAssign_status(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.A_STATUS)));
                        taskEncap.setPriotity(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.PRIORITY)));
                        taskEncap.setStartdate(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.STARTDATE)));
                        taskEncap.setEnddatte(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.ENDDATE)));
                        taskEncap.setUpdateddatetime(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.UPDATEDATETIME)));
                        taskEncap.setSequence(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.SEQUENCE)));
                        taskEncap.setOnline_sync(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.ONLINESYNC)));
                        taskEncap.setProgress(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.PROGRESS)));
                        taskEncap.setI_progress(Integer.parseInt(taskEncap.getProgress()));
                        if (Integer.parseInt(taskEncap.getProgress()) != 100) {
                            alltaksCleared = false;
                        }
                        try {
                            taskEncap.setD_assigneddatetime(Utility.getDateTime(taskEncap.getAssigneddatetime()));
                            taskEncap.setD_startdate(Utility.getDateTime(taskEncap.getStartdate()));
                            taskEncap.setD_enddatte(Utility.getDateTime(taskEncap.getEnddatte()));
                            taskEncap.setD_updateddatetime(Utility.getDateTime(taskEncap.getUpdateddatetime()));
                        } catch (ParseException e) {
                            e.printStackTrace();
                        }
                        taskEncap.setProjectstartdate(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.PROJECTSTARTDATE)));
                        taskEncap.setProjectenddate(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.PROJECTENDDATE)));
                        taskEncap.setProjectdescription(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.PROJECTDESCRIPTION)));
                        taskEncap.setMilestonedescription(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.MILESTONEDESCRIPTION)));
                        taskEncap.setMilestoneenddate(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.MILESTONEENDDATE)));

                        dependentlist.add(taskEncap);

                    } while (cursor.moveToNext());
                }

            }
            Log.d("Sequencce",dependentlist.size()+"");
            if(dependentlist.size()!=0){
                dependentLayout.setVisibility(View.VISIBLE);
            }
            DependentListAdapter dependentListAdapter=new DependentListAdapter(this,dependentlist,registeredemailid);
            recyclerView.setAdapter(dependentListAdapter);
        }else{
            dependentLayout.setVisibility(View.GONE);
        }

        if(alltaksCleared && !taskEncap.getAssign_status().equalsIgnoreCase("accepted")){
            progressLayput.setVisibility(View.VISIBLE);
            percentage_layout.setVisibility(View.VISIBLE);
        }else{
            progressLayput.setVisibility(View.GONE);
            percentage_layout.setVisibility(View.GONE);
        }

    }

    private void checkRequests(){
        Cursor cursor=sqldatabase.getRequestStatus(taskid);
        requestList.clear();

        if(cursor!=null){
            cursor.moveToFirst();
            RequestEncap requestEncap=new RequestEncap();
            requestEncap.setTaskName(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.TASKANME)));
            requestEncap.setTaskId(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.TASKID)));
            requestEncap.setAssignid(cursor.getString(cursor.getColumnIndexOrThrow(TaskRequestTable.ASSIGNID)));
            requestEncap.setEmployeeid(cursor.getString(cursor.getColumnIndexOrThrow(TaskRequestTable.EMPLOYEEID)));
            requestEncap.setStatus(cursor.getString(cursor.getColumnIndexOrThrow(TaskRequestTable.STATUS)));
            requestEncap.setReason(cursor.getString(cursor.getColumnIndexOrThrow(TaskRequestTable.REASON)));
            requestEncap.setRequestfor(cursor.getString(cursor.getColumnIndexOrThrow(TaskRequestTable.REQUESTFOR)));
            requestEncap.setRequestdatetime(cursor.getString(cursor.getColumnIndexOrThrow(TaskRequestTable.REQUESTDATETIME)));
            requestEncap.setResponse(cursor.getString(cursor.getColumnIndexOrThrow(TaskRequestTable.RESPONSE)));
            requestEncap.setIncreasedays(cursor.getString(cursor.getColumnIndexOrThrow(TaskRequestTable.INCREASEDAYS)));
            requestEncap.setUpdateddatetime(cursor.getString(cursor.getColumnIndexOrThrow(TaskRequestTable.UPDATEDDATETIME)));
            requestList.add(requestEncap);
            requestPlace=true;
            if(menucreated){
                request.setVisible(false);
            }
            requestPlaced.setVisibility(View.VISIBLE);
        }else{
            requestPlaced.setVisibility(View.GONE);
            if(menucreated) {
                if (taskEncap.getI_progress() == 90) {
                    request.setVisible(false);
                }
            }
        }

    }

    private void startTask(){

        if(!Utility.isNetworkAvailable(this)) {
            snackbar= Snackbar.make(coordinatorLayout, "No Internet Connection", Snackbar.LENGTH_INDEFINITE) .setAction("Close", new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    snackbar.dismiss();
                }
            });
            snackbar.show();
            return;
        }

        final LocationManager locationManager = (LocationManager) this.getSystemService(Context.LOCATION_SERVICE);

        boolean isGPSEnabled = locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER);
        boolean isNetworkEnabled = locationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER);
        if (!isGPSEnabled && !isNetworkEnabled) {
            //Toast.makeText(mycontext, "No network provider is enabled for location access", Toast.LENGTH_LONG).show();
            android.app.AlertDialog.Builder alertdialog = new android.app.AlertDialog.Builder(this);

            alertdialog.setTitle("Access Location");
            alertdialog.setIcon(R.drawable.ic_action_location);
            alertdialog.setMessage("No network provider is enabled for location access!!");
            alertdialog.setPositiveButton("Turn On",
                    new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int whichButton) {
                            startActivity(new Intent(Settings.ACTION_LOCATION_SOURCE_SETTINGS));
                        }
                    });
            alertdialog.setNegativeButton("Cancel", new DialogInterface.OnClickListener() {

                @Override
                public void onClick(DialogInterface dialog, int which) {
                    // TODO Auto-generated method stub

                }
            }).create();
            alertdialog.show();
            return;
        }

        final LatLang latLang=Utility.getLocation(this);
        pDialog = new ProgressDialog(this);
        pDialog.setMessage("Starting Task...");
        pDialog.setIndeterminate(false);
        pDialog.setCancelable(false);
        pDialog.show();
        final String datetime=Utility.getCurrentDateTime();

        StringRequest postRequest = new StringRequest(Request.Method.POST, "http://fieldcloud.in/App/start_task.php",
                new Response.Listener<String>()
                {
                    @Override
                    public void onResponse(String response) {
                        // response
                        Log.d("Response", response);
                        try {
                            JSONObject json=new JSONObject(response);

                            int success = json.getInt("success");
                            if (success == 1) {
                                taskEncap.setStatus("underprogress");
                                taskEncap.setAssign_status("underprogress");
                                taskEncap.setUpdateddatetime(datetime);
                                sqldatabase.insert_task(taskEncap);
                                getTasksOnline(taskid);
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                        pDialog.dismiss();
                    }
                },
                new Response.ErrorListener()
                {
                    @Override
                    public void onErrorResponse(VolleyError error) {
                        // error
                        pDialog.dismiss();
                        Log.d("Error.Response", error.toString());
                    }
                }
        ) {
            @Override
            protected Map<String, String> getParams()
            {
                Map<String, String>  params = new HashMap<String, String>();

                params.put("assign_id", taskEncap.getAssignid());
                params.put("task_id", taskEncap.getTaskid());
                params.put("datetime",datetime);
                params.put("latitude", latLang.getLatitude());
                params.put("longtitude",latLang.getLongitude());

                return params;
            }
        };

        requestQueue.add(postRequest);

    }

    private void syncProgress(){

        pDialog = new ProgressDialog(this);
        pDialog.setMessage("Loading...");
        pDialog.setIndeterminate(false);
        pDialog.setCancelable(false);
        pDialog.show();

        StringRequest postRequest = new StringRequest(Request.Method.POST, "http://fieldcloud.in/App/update_taskprogress.php",
                new Response.Listener<String>()
                {
                    @Override
                    public void onResponse(String response) {
                        // response
                        Log.d("Response", response);
                        try {
                            JSONObject json=new JSONObject(response);

                            int success = json.getInt("success");
                            if (success == 1) {
                                    finish();
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                        pDialog.dismiss();
                    }
                },
                new Response.ErrorListener()
                {
                    @Override
                    public void onErrorResponse(VolleyError error) {
                        // error
                        pDialog.dismiss();
                        Log.d("Error.Response", error.toString());
                    }
                }
        ) {
            @Override
            protected Map<String, String> getParams()
            {
                Map<String, String>  params = new HashMap<String, String>();

                params.put("task_id", arrayList.get(0).getTaskid());
                params.put("datetime",Utility.getCurrentDateTime());
                params.put("progress",seekBar.getProgress()+"");

                return params;
            }
        };

        requestQueue.add(postRequest);
        requestQueue.addRequestFinishedListener(new RequestQueue.RequestFinishedListener<String>() {
            @Override
            public void onRequestFinished(Request<String> request) {
                pDialog.dismiss();
            }
        });
    }

    public static void createJob(){
        Constraints constraints = new Constraints.Builder()
                // The Worker needs Network connectivity
                .setRequiredNetworkType(NetworkType.CONNECTED)
                // Needs the device to be charging
//                .setRequiresCharging(true)
                .build();
        OneTimeWorkRequest request =
                // Tell which work to execute
                new OneTimeWorkRequest.Builder(UpdateTaskService.class)
                        // Sets the input data for the ListenableWorker
                        .addTag("OneTimeJob")
                        // If you want to delay the start of work by 60 seconds
                        .setInitialDelay(60, TimeUnit.SECONDS)
                        // Set a backoff criteria to be used when retry-ing
//                        .setBackoffCriteria(BackoffCriteria.EXPONENTIAL, 30000, TimeUnit.MILLISECONDS)
                        // Set additional constraints
                        .setConstraints(constraints)
                        .build();
//        Job job = dispatcher.newJobBuilder()
//                .setLifetime(Lifetime.FOREVER)
//                .setService(UpdateTaskService.class)
//                .setTag("OneTimeJob")
//                .setRecurring(true)
//                .setTrigger(Trigger.executionWindow(0, 60))
//                .setConstraints(Constraint.ON_ANY_NETWORK)
//                .build();
//        return job;
    }

    private void repeatingJOb(){
        Constraints constraints = new Constraints.Builder()
                // The Worker needs Network connectivity
                .setRequiredNetworkType(NetworkType.CONNECTED)
                // Needs the device to be charging
//                .setRequiresCharging(true)
                .build();
        PeriodicWorkRequest request =
                // Executes MyWorker every 15 minutes
                new PeriodicWorkRequest.Builder(SimpleJob.class, 15, TimeUnit.MINUTES)
                        // Sets the input data for the ListenableWorker
                        .addTag("api_trigger")
                        // If you want to delay the start of work by 60 seconds
                        .setInitialDelay(20, TimeUnit.SECONDS)
                        // Set a backoff criteria to be used when retry-ing
//                        .setBackoffCriteria(BackoffCriteria.EXPONENTIAL, 30000, TimeUnit.MILLISECONDS)
                        // Set additional constraints
                        .setConstraints(constraints)
                        .build();
//        FirebaseJobDispatcher dispatcher = new FirebaseJobDispatcher(new GooglePlayDriver(this));
//
//        Job job = dispatcher.newJobBuilder()
//                .setService(SimpleJob.class)
//                .setTag("api_trigger")
//                .setRecurring(true)
//                .setLifetime(Lifetime.FOREVER)
//                .setTrigger(JobDispatcherUtils.periodicTrigger(20, 0)) // repeated every 20 seconds with 1 second of tollerance
//                .setReplaceCurrent(true)
//                .setRetryStrategy(RetryStrategy.DEFAULT_LINEAR)
//                .build();
//        dispatcher.schedule(job);


    }

    public void reminder() {


		    /*    	Intent intent=new Intent(RouteSequenceActivity.this,AlarmActivity.class);

		        	 intent.putExtra ("user", storeduser);
			            intent.putExtra ("remindercustomer", name[position]);
			            intent.putExtra ("reminderaddress", caddress[position]);

  		        	startActivity(intent);*/
            SharedPreferences sharedPreferences1 = PreferenceManager.getDefaultSharedPreferences(this);
            requests = sharedPreferences1.getInt("request", 0);
           requests++;

            //Log.e("request send ", String.valueOf(request));

            View alertLayout = getLayoutInflater().inflate(R.layout.dialog_alarm, null);


            alarmTimePicker = (TimePicker) alertLayout.findViewById(R.id.alarmTimePicker);
            alarmTextView = (TextView) alertLayout.findViewById(R.id.alarmText);
            alarmManager = (AlarmManager) this.getSystemService(ALARM_SERVICE);


            AlertDialog.Builder alert = new AlertDialog.Builder(this);



            alert.setView(alertLayout);

            alert.setCancelable(true);
            alert.setPositiveButton("OK",
                    new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog,
                                            int which) {
                            Calendar calendar = Calendar.getInstance();
                            calendar.set(Calendar.HOUR_OF_DAY, alarmTimePicker.getCurrentHour());
                            calendar.set(Calendar.MINUTE, alarmTimePicker.getCurrentMinute());

                            Intent myIntent = new Intent(TaskDetails.this, AlarmReceiver.class);
                            myIntent.setAction("com.example.helloandroid.alarms");
                          //  myIntent.putExtra ("remindercustomer", pg.getCustomername());
                            myIntent.putExtra ("task",taskEncap.getTaskname());
                            myIntent.putExtra ("taskid",taskEncap.getTaskid());
                        //    myIntent.putExtra ("request", request);

                            pendingIntent = PendingIntent.getBroadcast(TaskDetails.this, 0, myIntent,  PendingIntent.FLAG_UPDATE_CURRENT );
                            alarmManager.set(AlarmManager.RTC, calendar.getTimeInMillis(), pendingIntent);

                            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences(TaskDetails.this);
                            SharedPreferences.Editor editor = sharedPreferences.edit();
                            editor.putInt("request", requests);
                            editor.apply();

                        }
                    });
            alert.setNegativeButton("Cancel", null);
            alert.show();






    }

//    public static class JobDispatcherUtils {
//        public static JobTrigger periodicTrigger(int frequency, int tolerance) {
//            return Trigger.executionWindow(frequency - tolerance, frequency);
//        }
//    }

    private void goProgressForm(){
        Intent intent=new Intent(this,ProgressForm.class);
        arrayList.clear();
        arrayList.add(taskEncap);
        intent.putExtra("taskid",taskEncap.getTaskid());
        intent.putExtra("progress",seekBar.getProgress());
        intent.putExtra("arrayList",arrayList);
        startActivity(intent);
    }

    private void getProgressList(){
        progressList.clear();
        Cursor cursor=sqldatabase.getTaskProgress(taskid);
        if(cursor!=null) {
            cursor.moveToFirst();
            do {
                ProgressEncap progressEncap = new ProgressEncap();
                progressEncap.setTaskid(cursor.getString(cursor.getColumnIndexOrThrow(TaskProgress.TASKID)));
                progressEncap.setEmployeeid(cursor.getString(cursor.getColumnIndexOrThrow(TaskProgress.EMPLOYEEID)));
                progressEncap.setProgressdate(cursor.getString(cursor.getColumnIndexOrThrow(TaskProgress.PROGRESSDATE)));
                progressEncap.setProgress(cursor.getString(cursor.getColumnIndexOrThrow(TaskProgress.PROGRESS)));
                progressEncap.setCompleted_activities(cursor.getString(cursor.getColumnIndexOrThrow(TaskProgress.COMPLETEDACTIVITIES)));
                progressEncap.setCompleted_datetime(cursor.getString(cursor.getColumnIndexOrThrow(TaskProgress.COMPLETEDDATETIME)));
                progressEncap.setProgressed_by(cursor.getString(cursor.getColumnIndexOrThrow(TaskProgress.PROGRESSEDBY)));
                progressEncap.setProgressed_by_type(cursor.getString(cursor.getColumnIndexOrThrow(TaskProgress.PROGRESSEDBYTYPE)));
                progressList.add(progressEncap);
            } while (cursor.moveToNext());
        }
        if(menucreated&progressList.size()==0){
            history.setVisible(false);
        }else if(menucreated){
            history.setVisible(true);
        }

    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.menu_task_current, menu);

        update=menu.findItem(R.id.update);
        start=menu.findItem(R.id.start);
        stop=menu.findItem(R.id.stop);
        request=menu.findItem(R.id.request);
        history=menu.findItem(R.id.history);
        reminder=menu.findItem(R.id.reminder);

        update.setVisible(false);
        if(taskEncap!=null) {
            if (taskEncap.getAssign_status().equalsIgnoreCase("accepted")) {
                start.setVisible(true);
                stop.setVisible(false);
                request.setVisible(false);
                reminder.setVisible(false);
            } else {
                start.setVisible(false);
                stop.setVisible(true);
                reminder.setVisible(true);
            }
            if (requestPlace) {
                request.setVisible(false);
            }
            seekBar.setProgress(taskEncap.getI_progress());
        }
        if(progressList.size()==0){
            history.setVisible(false);
        }else{
            history.setVisible(true);
        }
        menucreated=true;
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {

        Intent intent;
        switch (item.getItemId()){
            case R.id.update:
                //updateProgress();
                goProgressForm();
                break;
            case R.id.start:
                startTask();
                break;
            case R.id.stop:
                if(cardView.getVisibility()==View.VISIBLE) {
                    intent = new Intent(this, RejectForm.class);
                    arrayList.clear();
                    arrayList.add(taskEncap);
                    intent.putParcelableArrayListExtra("arrayList", arrayList);
                    intent.putExtra("request", "stop");
                    startActivity(intent);
                    finish();
                }
                break;
            case R.id.reminder:
                reminder();
                break;
            case R.id.history:
                if(cardView.getVisibility()==View.VISIBLE) {
                    Intent intent1 = new Intent(this, ProgressHistroy.class);
                    intent1.putParcelableArrayListExtra("progressList", progressList);
                    startActivity(intent1);
                    break;
                }
            case android.R.id.home:
                finish();
                break;
            case R.id.request:
                if(cardView.getVisibility()==View.VISIBLE) {
                    arrayList.clear();
                    arrayList.add(taskEncap);
                    intent = new Intent(TaskDetails.this, ExtendForm.class);
                    intent.putExtra("arrayList", arrayList);
                    startActivity(intent);
                    break;
                }
        }
        return super.onOptionsItemSelected(item);
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) this.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();

        return networkInfo != null && networkInfo.isConnected();
    }



}
