package com.b2lmobitech.fieldcloudplus.task.old;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.work.Constraints;
import androidx.work.NetworkType;
import androidx.work.OneTimeWorkRequest;
import androidx.work.PeriodicWorkRequest;

import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;

import com.android.volley.RequestQueue;
import com.android.volley.toolbox.Volley;
import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.task.activities.ProgressHistroy;
import com.b2lmobitech.fieldcloudplus.task.encap.ProgressEncap;
import com.b2lmobitech.fieldcloudplus.task.encap.TaskEncap;
import com.b2lmobitech.fieldcloudplus.task.service.SimpleJob;
import com.b2lmobitech.fieldcloudplus.task.service.UpdateTaskService;
import com.b2lmobitech.fieldcloudplus.task.sql.Sqlite;
//import com.firebase.jobdispatcher.Constraint;
//import com.firebase.jobdispatcher.FirebaseJobDispatcher;
//import com.firebase.jobdispatcher.GooglePlayDriver;
//import com.firebase.jobdispatcher.Job;
//import com.firebase.jobdispatcher.JobTrigger;
//import com.firebase.jobdispatcher.Lifetime;
//import com.firebase.jobdispatcher.RetryStrategy;
//import com.firebase.jobdispatcher.Trigger;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;

import com.b2lmobitech.fieldcloudplus.others.sql.Tables.TaskProgress;
import com.b2lmobitech.fieldcloudplus.others.sql.Tables.TaskTable;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;

/**
 * Created by home on 11/15/2017.
 */

public class TaskDetails2 extends AppCompatActivity {
    MenuItem stop,update,reject,start;
    SeekBar seekBar;
    TextView completed_percentage,project_name,milestone_name,task_name,task_description,start_date,end_date,due_days,task_priority;
    ArrayList<TaskEncap> arrayList=new ArrayList<>();
    ArrayList<TaskEncap> dependentlist=new ArrayList<>();
    ArrayList<ProgressEncap> progressList=new ArrayList<>();
    RequestQueue requestQueue;
    ProgressDialog pDialog;
    private Sqlite sqldatabase;
    TaskEncap taskEncap;

    TextView moreclick,lessclick;
    LinearLayout morelayout;

    boolean alltaksCleared=true,sameperson=true;
    HashSet<String> depened_task=new HashSet<>();
    LinearLayout dependentLayout,progressLayput,milestoneLayout;
    RecyclerView recyclerView;
    RelativeLayout percentage_layout;
    String taskid;
    boolean menucreated=false;
    String registeredcompany,registeredemailid;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_task_detailss);

        getSupportActionBar().setTitle("Task");
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        requestQueue= Volley.newRequestQueue(this);
        sqldatabase=new Sqlite(this);
        taskid=getIntent().getStringExtra("taskid");
        getWidgets();
        seekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {

            @Override
            public void onProgressChanged(SeekBar seekBar, int i, boolean b) {
                completed_percentage.setText(i+"%");

                if(i!=taskEncap.getI_progress()) {
                    update.setVisible(true);
                }else{
                    update.setVisible(false);
                }
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {

            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {

            }
        });
        setListeners();
        dependentLayout.setVisibility(View.GONE);
        globalvariables.Logoutsharedpreference = getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");
        progressLayput.setVisibility(View.GONE);
    }

    @Override
    protected void onResume() {
        super.onResume();
        getTaskDetails();
        getProgressList();
    }


    private void getTaskDetails(){
        Cursor cursor=sqldatabase.getTask(taskid);
        if(cursor!=null){


            cursor.moveToFirst();
            taskEncap = new TaskEncap();
            taskEncap.setProjctid(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.PROJECTID)));
            taskEncap.setTaskid(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.TASKID)));
            taskEncap.setTaskname(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.TASKANME)));
            taskEncap.setAssignid(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.ASSIGNID)));
            taskEncap.setProjectname(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.PROJECTNAME)));
            taskEncap.setMilestoneid(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.MILESTONEID)));
            taskEncap.setMilestonename(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.MILESTONENAME)));
            taskEncap.setListtaskid(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.LISTTASKID)));
            taskEncap.setListtaskname(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.LISTTASKNAME)));
            taskEncap.setAssigneddatetime(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.ASSIGNEDDATETIME)));
            taskEncap.setDescription(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.DESCRIPTION)));
            taskEncap.setStatus(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.T_STATUS)));
            taskEncap.setAssign_status(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.A_STATUS)));
            taskEncap.setPriotity(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.PRIORITY)));
            taskEncap.setStartdate(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.STARTDATE)));
            taskEncap.setEnddatte(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.ENDDATE)));
            taskEncap.setEmail_id(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.EMAILID)));
            taskEncap.setUpdateddatetime(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.UPDATEDATETIME)));
            taskEncap.setSequence(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.SEQUENCE)));
            taskEncap.setOnline_sync(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.ONLINESYNC)));
            taskEncap.setProgress(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.PROGRESS)));
            taskEncap.setI_progress(Integer.parseInt(taskEncap.getProgress()));
            try {
                taskEncap.setD_assigneddatetime(Utility.getDateTime(taskEncap.getAssigneddatetime()));
                taskEncap.setD_startdate(Utility.getDateTime(taskEncap.getStartdate()));
                taskEncap.setD_enddatte(Utility.getDateTime(taskEncap.getEnddatte()));
                taskEncap.setD_updateddatetime(Utility.getDateTime(taskEncap.getUpdateddatetime()));
            } catch (ParseException e) {
                e.printStackTrace();
            }
            taskEncap.setProjectstartdate(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.PROJECTSTARTDATE)));
            taskEncap.setProjectenddate(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.PROJECTENDDATE)));
            taskEncap.setProjectdescription(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.PROJECTDESCRIPTION)));
            taskEncap.setMilestonedescription(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.MILESTONEDESCRIPTION)));
            taskEncap.setMilestoneenddate(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.MILESTONEENDDATE)));
            if (!registeredemailid.equalsIgnoreCase(taskEncap.getEmail_id())) {
                sameperson = false;
            }
            checkDependents();
            setValues();

        }
    }

    private void getWidgets(){

        seekBar=findViewById(R.id.perccentage_seekbar);
        completed_percentage=findViewById(R.id.completed_precentage);
        project_name=findViewById(R.id.project_name);
        milestone_name=findViewById(R.id.milestone_name);
        task_name=findViewById(R.id.task_name);
        task_description=findViewById(R.id.task_description);
        start_date=findViewById(R.id.task_start_date);
        end_date=findViewById(R.id.task_end_date);
        task_priority=findViewById(R.id.task_priority);
        due_days=findViewById(R.id.task_due_days);
        moreclick=findViewById(R.id.more_click);
        morelayout=findViewById(R.id.more_layout);
        lessclick=findViewById(R.id.less_click);
        dependentLayout=findViewById(R.id.dependent_layout);
        progressLayput=findViewById(R.id.progress_layout);
        recyclerView=findViewById(R.id.depentent_recycle);
        percentage_layout=findViewById(R.id.percentage_layout);
        milestoneLayout=findViewById(R.id.milestone_layout);
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        recyclerView.setHasFixedSize(true);

    }

    private void setValues(){
        project_name.setText(taskEncap.getProjectname());
        task_name.setText(taskEncap.getTaskname());
        if(taskEncap.getMilestonename()==null) {
            milestoneLayout.setVisibility(View.GONE);
        }else{
            milestoneLayout.setVisibility(View.VISIBLE);
            milestone_name.setText(taskEncap.getMilestonename());
        }
        task_description.setText(taskEncap.getDescription());
        start_date.setText(taskEncap.getStartdate());
        end_date.setText(taskEncap.getEnddatte());
        task_priority.setText(taskEncap.getPriotity());
        completed_percentage.setText(taskEncap.getProgress() + "%");
        morelayout.setVisibility(View.GONE);
        lessclick.setVisibility(View.GONE);
        int daysbetween = (int) (taskEncap.getD_enddatte().getTime() - new Date().getTime()) / (1000 * 60 * 60 * 24);
        daysbetween = daysbetween + 1;

        if (daysbetween < 0) {
            daysbetween = daysbetween * -1;
            if (daysbetween == 1) {
                due_days.setText(daysbetween + " Day Late");
            } else {
                due_days.setText(daysbetween + " Days Late");
            }
        } else if (daysbetween == 1) {
            due_days.setText("Today");
        } else if (daysbetween > 1) {
            due_days.setText("In " + daysbetween + " Days");
        }

    }

    private void setListeners(){
        moreclick.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                morelayout.setVisibility(View.VISIBLE);
                lessclick.setVisibility(View.VISIBLE);
                moreclick.setVisibility(View.GONE);
            }
        });
        lessclick.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                morelayout.setVisibility(View.GONE);
                lessclick.setVisibility(View.GONE);
                moreclick.setVisibility(View.VISIBLE);
            }
        });
    }

    private void checkDependents(){
        Log.d("Sequencce",taskEncap.getSequence());
        dependentlist.clear();
        if(!taskEncap.getSequence().equalsIgnoreCase("null") || !taskEncap.getSequence().trim().isEmpty()){

            String depend[]=taskEncap.getSequence().split(",");
            for(int i=0; i<depend.length; i++){
                depened_task.add(depend[i].trim());
            }

            for(String tid:depened_task){
                Log.d("Sequencce",tid);
                Cursor cursor=sqldatabase.getTask(tid);
                if(cursor==null){
                    return;
                }
                cursor.moveToFirst();
                do{
                    TaskEncap taskEncap=new TaskEncap();
                    taskEncap.setProjctid(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.PROJECTID)));
                    taskEncap.setTaskid(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.TASKID)));
                    taskEncap.setTaskname(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.TASKANME)));
                    taskEncap.setAssignid(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.ASSIGNID)));
                    taskEncap.setProjectname(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.PROJECTNAME)));
                    taskEncap.setMilestoneid(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.MILESTONEID)));
                    taskEncap.setMilestonename(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.MILESTONENAME)));
                    taskEncap.setEmail_id(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.EMAILID)));
                    taskEncap.setListtaskid(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.LISTTASKID)));
                    taskEncap.setListtaskname(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.LISTTASKNAME)));
                    taskEncap.setAssigneddatetime(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.ASSIGNEDDATETIME)));
                    taskEncap.setDescription(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.DESCRIPTION)));
                    taskEncap.setStatus(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.T_STATUS)));
                    taskEncap.setAssign_status(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.A_STATUS)));
                    taskEncap.setPriotity(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.PRIORITY)));
                    taskEncap.setStartdate(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.STARTDATE)));
                    taskEncap.setEnddatte(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.ENDDATE)));
                    taskEncap.setUpdateddatetime(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.UPDATEDATETIME)));
                    taskEncap.setSequence(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.SEQUENCE)));
                    taskEncap.setOnline_sync(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.ONLINESYNC)));
                    taskEncap.setProgress(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.PROGRESS)));
                    taskEncap.setI_progress(Integer.parseInt(taskEncap.getProgress()));
                    try {
                        taskEncap.setD_assigneddatetime(Utility.getDateTime(taskEncap.getAssigneddatetime()));
                        taskEncap.setD_startdate(Utility.getDateTime(taskEncap.getStartdate()));
                        taskEncap.setD_enddatte(Utility.getDateTime(taskEncap.getEnddatte()));
                        taskEncap.setD_updateddatetime(Utility.getDateTime(taskEncap.getUpdateddatetime()));
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                    taskEncap.setProjectstartdate(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.PROJECTSTARTDATE)));
                    taskEncap.setProjectenddate(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.PROJECTENDDATE)));
                    taskEncap.setProjectdescription(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.PROJECTDESCRIPTION)));
                    taskEncap.setMilestonedescription(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.MILESTONEDESCRIPTION)));
                    taskEncap.setMilestoneenddate(cursor.getString(cursor.getColumnIndexOrThrow(TaskTable.MILESTONEENDDATE)));

                    dependentlist.add(taskEncap);

                }while(cursor.moveToNext());


            }
            Log.d("Sequencce",dependentlist.size()+"");
            if(dependentlist.size()!=0){
                dependentLayout.setVisibility(View.VISIBLE);
            }
            DependentListAdapter dependentListAdapter=new DependentListAdapter(this,dependentlist,registeredemailid);
            recyclerView.setAdapter(dependentListAdapter);
        }else{
            dependentLayout.setVisibility(View.GONE);
        }
        percentage_layout.setVisibility(View.VISIBLE);


    }


    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) this.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        // if no network is available networkInfo will be null
        // otherwise check if we are connected
        if (networkInfo != null && networkInfo.isConnected()) {

            return true;
        }
        return false;
    }

    public static void createJob(){
        Constraints constraints = new Constraints.Builder()
                // The Worker needs Network connectivity
                .setRequiredNetworkType(NetworkType.CONNECTED)
                // Needs the device to be charging
//                .setRequiresCharging(true)
                .build();
        OneTimeWorkRequest request =
                // Tell which work to execute
                new OneTimeWorkRequest.Builder(UpdateTaskService.class)
                        // Sets the input data for the ListenableWorker
                        .addTag("OneTimeJob")
                        // If you want to delay the start of work by 60 seconds
                        .setInitialDelay(60, TimeUnit.SECONDS)
                        // Set a backoff criteria to be used when retry-ing
//                        .setBackoffCriteria(BackoffCriteria.EXPONENTIAL, 30000, TimeUnit.MILLISECONDS)
                        // Set additional constraints
                        .setConstraints(constraints)
                        .build();
//        Job job = dispatcher.newJobBuilder()
//                .setLifetime(Lifetime.FOREVER)
//                .setService(UpdateTaskService.class)
//                .setTag("OneTimeJob")
//                .setRecurring(true)
//                .setTrigger(Trigger.executionWindow(0, 60))
//                .setConstraints(Constraint.ON_ANY_NETWORK)
//                .build();
//        return job;
    }

    private void repeatingJOb(){
        Constraints constraints = new Constraints.Builder()
                // The Worker needs Network connectivity
                .setRequiredNetworkType(NetworkType.CONNECTED)
                // Needs the device to be charging
//                .setRequiresCharging(true)
                .build();
        PeriodicWorkRequest request =
                // Executes MyWorker every 15 minutes
                new PeriodicWorkRequest.Builder(SimpleJob.class, 15, TimeUnit.MINUTES)
                        // Sets the input data for the ListenableWorker
                        .addTag("api_trigger")
                        // If you want to delay the start of work by 60 seconds
                        .setInitialDelay(20, TimeUnit.SECONDS)
                        // Set a backoff criteria to be used when retry-ing
//                        .setBackoffCriteria(BackoffCriteria.EXPONENTIAL, 30000, TimeUnit.MILLISECONDS)
                        // Set additional constraints
                        .setConstraints(constraints)
                        .build();
//        FirebaseJobDispatcher dispatcher = new FirebaseJobDispatcher(new GooglePlayDriver(this));
//        Job job = dispatcher.newJobBuilder()
//                .setService(SimpleJob.class)
//                .setTag("api_trigger")
//                .setRecurring(true)
//                .setLifetime(Lifetime.FOREVER)
//                .setTrigger(TaskDetails.JobDispatcherUtils.periodicTrigger(20, 0)) // repeated every 20 seconds with 1 second of tollerance
//                .setReplaceCurrent(true)
//                .setRetryStrategy(RetryStrategy.DEFAULT_LINEAR)
//                .build();
//        dispatcher.schedule(job);


    }

//    public static class JobDispatcherUtils {
//        public static JobTrigger periodicTrigger(int frequency, int tolerance) {
//            return Trigger.executionWindow(frequency - tolerance, frequency);
//        }
//    }


    private void getProgressList(){
        progressList.clear();
        Cursor cursor=sqldatabase.getTaskProgress(taskid);
        if(cursor!=null) {
            cursor.moveToFirst();
            do {
                ProgressEncap progressEncap = new ProgressEncap();
                progressEncap.setTaskid(cursor.getString(cursor.getColumnIndexOrThrow(TaskProgress.TASKID)));
                progressEncap.setEmployeeid(cursor.getString(cursor.getColumnIndexOrThrow(TaskProgress.EMPLOYEEID)));
                progressEncap.setProgressdate(cursor.getString(cursor.getColumnIndexOrThrow(TaskProgress.PROGRESSDATE)));
                progressEncap.setProgress(cursor.getString(cursor.getColumnIndexOrThrow(TaskProgress.PROGRESS)));
                progressEncap.setCompleted_activities(cursor.getString(cursor.getColumnIndexOrThrow(TaskProgress.COMPLETEDACTIVITIES)));
                progressEncap.setCompleted_datetime(cursor.getString(cursor.getColumnIndexOrThrow(TaskProgress.COMPLETEDDATETIME)));
                progressList.add(progressEncap);
            } while (cursor.moveToNext());
        }

    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.menu_task_current, menu);

        update=menu.findItem(R.id.update);
        start=menu.findItem(R.id.start);
        stop=menu.findItem(R.id.stop);

        update.setVisible(false);
        start.setVisible(false);
        stop.setVisible(false);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {


        switch (item.getItemId()){
            case R.id.history:
                Intent intent1=new Intent(this,ProgressHistroy.class);
                intent1.putParcelableArrayListExtra("progressList",progressList);
                startActivity(intent1);
                break;
            case android.R.id.home:
                finish();
                break;

        }
        return super.onOptionsItemSelected(item);
    }
}
