package com.b2lmobitech.fieldcloudplus.task.old;

import android.app.DatePickerDialog;
import android.app.ProgressDialog;
import android.content.Intent;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.material.snackbar.Snackbar;
import com.google.android.material.textfield.TextInputLayout;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.DatePicker;
import android.widget.ProgressBar;
import android.widget.Spinner;
import android.widget.Toast;

import com.android.volley.RequestQueue;
import com.android.volley.toolbox.Volley;
import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.task.activities.SearchResult;
import com.b2lmobitech.fieldcloudplus.task.encap.RequestEncap;
import com.b2lmobitech.fieldcloudplus.task.encap.TaskEncap;
import com.b2lmobitech.fieldcloudplus.task.encap.TasklistEncap;
import com.b2lmobitech.fieldcloudplus.task.sql.Sqlite;

import org.json.JSONObject;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;

import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;

public class TaskList extends AppCompatActivity {

    ProgressDialog pDialog;
    RequestQueue requestQueue;
    HashSet<String> hashSet=new HashSet<>();
    ArrayList<TaskEncap> taskList=new ArrayList<>();
    ArrayList<TasklistEncap> projectslist=new ArrayList<>();
    RecyclerView recyclerView;
    ProjectListAdapter projectListAdapter;
    String registeredcompany,registeredemailid;
    private Sqlite sqldatabase;
    ProgressBar progressBar;
    Snackbar snackbar;
    CoordinatorLayout coordinatorLayout;
    ListTaskAdapter listTaskAdapter;
    ArrayList<RequestEncap> arrayList=new ArrayList<>();

    JSONObject jsonObject;
    String projectid;
    Calendar myCalendar,myCalendar1;
    Date selected1,selected2;
    ArrayList<TaskEncap> searchlist=new ArrayList<>();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_task_list);

        requestQueue= Volley.newRequestQueue(this);
        recyclerView=findViewById(R.id.recycleView);
        recyclerView.setLayoutManager( new LinearLayoutManager(this));
        progressBar=findViewById(R.id.progressBar);
        coordinatorLayout=findViewById(R.id.coordinator);
        sqldatabase=new Sqlite(this);

        getSupportActionBar().setTitle("Task List");
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        projectid=getSharedPreferences("projectid", MODE_PRIVATE).getString("projectid",null);


        globalvariables.Logoutsharedpreference = getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");
    }

    @Override
    protected void onResume() {
        super.onResume();
        getTasksOffline();
    }

    private void getTasksOffline() {
        taskList.clear();
        projectslist.clear();
        try {
        taskList=sqldatabase.get_tasks_byproject(projectid,registeredemailid.toLowerCase());

        if (!taskList.isEmpty()) {
            for(TaskEncap taskEncap:taskList){
                hashSet.add(taskEncap.getListtaskid());

            }
            for (String id : hashSet) {
                TasklistEncap tasklistEncap=new TasklistEncap();
                Log.e("id",id);
                for (TaskEncap taskEncap : taskList) {

                    if (taskEncap.getListtaskid().equals(id)) {
                        tasklistEncap.setTasklsitName(taskEncap.getListtaskname());
                        tasklistEncap.setTasklistID(taskEncap.getListtaskid());
                        tasklistEncap.setMilestoneName(taskEncap.getMilestonename());
                        tasklistEncap.setMilestoneEnddate(taskEncap.getMilestoneenddate());
                    }
                }
                projectslist.add(tasklistEncap);
            }

               listTaskAdapter = new ListTaskAdapter(TaskList.this, projectslist, taskList);
                recyclerView.setAdapter(listTaskAdapter);

        }else{
            snackbar= Snackbar.make(coordinatorLayout, "No projects found", Snackbar.LENGTH_INDEFINITE) .setAction("Close", new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    snackbar.dismiss();
                }
            });
            snackbar.show();
        }
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.menu_tasklist, menu);

        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {

        switch (item.getItemId()){
            case android.R.id.home:
                finish();
                break;
            case R.id.search:
                showSearchAlertDialouge();
                break;


        }

        return super.onOptionsItemSelected(item);
    }

    private void showSearchAlertDialouge(){


        myCalendar = Calendar.getInstance();
        myCalendar1 = Calendar.getInstance();

        //EditText edittext= (EditText) findViewById(R.id.Birthday);

        final AlertDialog.Builder dialogBuilder = new AlertDialog.Builder(this);

        // ...Irrelevant code for customizing the buttons and title

        LayoutInflater inflater = this.getLayoutInflater();

        final View dialogView= inflater.inflate(R.layout.alert_search_form, null);
        dialogBuilder.setView(dialogView);
        final AlertDialog alertDialog=dialogBuilder.create();

        final TextInputLayout tlFrom=dialogView.findViewById(R.id.from_date);
        final TextInputLayout tlTo=dialogView.findViewById(R.id.to_date);

        Button cancel=dialogView.findViewById(R.id.alert_cancel);
        Button search=dialogView.findViewById(R.id.alert_search);
        final Spinner alert_spinner=dialogView.findViewById(R.id.alert_spinner);


        alert_spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                tlFrom.getEditText().getText().clear();
                tlTo.getEditText().getText().clear();
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {

            }
        });

        final DatePickerDialog.OnDateSetListener fromDate = new DatePickerDialog.OnDateSetListener() {

            @Override
            public void onDateSet(DatePicker view, int year, int monthOfYear,
                                  int dayOfMonth) {
                // TODO Auto-generated method stub
                myCalendar.set(Calendar.YEAR, year);
                myCalendar.set(Calendar.MONTH, monthOfYear);
                myCalendar.set(Calendar.DAY_OF_MONTH, dayOfMonth);
                String myFormat = "dd/MM/yyyy"; //In which you need put here
                SimpleDateFormat sdf = new SimpleDateFormat(myFormat, Locale.US);
                tlFrom.getEditText().setText(sdf.format(myCalendar.getTime()));
                try {
                    selected1=Utility.getDateOnly(myCalendar.getTime());
                } catch (ParseException e) {
                    e.printStackTrace();
                }
                tlTo.getEditText().getText().clear();
                //edittext.setText(sdf.format(myCalendar.getTime()));
            }

        };
        final DatePickerDialog.OnDateSetListener toDate = new DatePickerDialog.OnDateSetListener() {

            @Override
            public void onDateSet(DatePicker view, int year, int monthOfYear,
                                  int dayOfMonth) {
                // TODO Auto-generated method stub
                myCalendar1.set(Calendar.YEAR, year);
                myCalendar1.set(Calendar.MONTH, monthOfYear);
                myCalendar1.set(Calendar.DAY_OF_MONTH, dayOfMonth);
                String myFormat = "dd/MM/yyyy"; //In which you need put here
                SimpleDateFormat sdf = new SimpleDateFormat(myFormat, Locale.US);
                tlTo.getEditText().setText(sdf.format(myCalendar1.getTime()));
                try {
                    selected2=Utility.getDateOnly(myCalendar1.getTime());
                } catch (ParseException e) {
                    e.printStackTrace();
                }

                //edittext.setText(sdf.format(myCalendar.getTime()));
            }

        };

        tlFrom.getEditText().setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if(alert_spinner.getSelectedItemPosition()==0){
                    Toast.makeText(getApplicationContext(),"Select Type",Toast.LENGTH_SHORT).show();
                    return;
                }
                DatePickerDialog datePicker =  new DatePickerDialog(TaskList.this, fromDate, myCalendar
                        .get(Calendar.YEAR), myCalendar.get(Calendar.MONTH),
                        myCalendar.get(Calendar.DAY_OF_MONTH));
                if(alert_spinner.getSelectedItemPosition()==1 || alert_spinner.getSelectedItemPosition()==2){
                    datePicker.getDatePicker().setMinDate(Calendar.getInstance().getTimeInMillis());
                }else if(alert_spinner.getSelectedItemPosition()==3){
                    datePicker.getDatePicker().setMaxDate(Calendar.getInstance().getTimeInMillis());
                }
                datePicker.show();

            }
        });
        tlTo.getEditText().setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if(tlFrom.getEditText().getText().toString().isEmpty()){
                    Toast.makeText(getApplicationContext(),"Select from Date",Toast.LENGTH_SHORT).show();
                    return;
                }

                DatePickerDialog datePicker = new DatePickerDialog(TaskList.this, toDate, myCalendar1
                        .get(Calendar.YEAR), myCalendar1.get(Calendar.MONTH),
                        myCalendar1.get(Calendar.DAY_OF_MONTH));
                if(alert_spinner.getSelectedItemPosition()==1 || alert_spinner.getSelectedItemPosition()==2){
                    datePicker.getDatePicker().setMinDate(myCalendar.getTimeInMillis());
                }else if(alert_spinner.getSelectedItemPosition()==3){
                    datePicker.getDatePicker().setMinDate(myCalendar.getTimeInMillis());
                    datePicker.getDatePicker().setMaxDate(Calendar.getInstance().getTimeInMillis());
                }
                datePicker.show();

            }
        });

        // alert_spinner

        cancel.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                alertDialog.hide();
            }
        });


        search.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(tlFrom.getEditText().getText().toString().isEmpty()){
                    tlFrom.getEditText().setError("Select Date");
                    return;
                }
              /*  prepareSearchList();
                if(searchlist.isEmpty()){
                    Toast.makeText(getApplicationContext(),"No tasks found",Toast.LENGTH_SHORT).show();
                    return;
                }
                Log.e("size",searchlist.size()+"");
                Intent intent=new Intent(Task.this,SearchResult.class);
                intent.putExtra("full_list",taskList);
                intent.putExtra("search_list",searchlist);
                intent.putExtra("fromDate",tlFrom.getEditText().getText().toString());
                intent.putExtra("toDate",tlFrom.getEditText().getText().toString());
                startActivity(intent);*/
                searchResult(tlFrom.getEditText().getText().toString(),tlTo.getEditText().getText().toString(),selected1,selected2,alert_spinner.getSelectedItem().toString(),alertDialog);
                //alertDialog.hide();
            }
        });
        alertDialog.show();
    }

    private void searchResult(String from,String to,Date dfrom,Date dto,String type,AlertDialog alertDialog){
        searchlist.clear();
        try {
            if (type.equalsIgnoreCase("Active")) {


                if (to.isEmpty()) {
                    for (TaskEncap taskEncap : taskList) {

                       /* if ((taskEncap.getD_startdate().compareTo(selected1)<=0 && taskEncap.getD_enddatte().compareTo(selected1)>=0)) {
                            searchlist.add(taskEncap);
                        }*/
                        if( selected1.equals(taskEncap.getD_startdate()) || selected1.equals(taskEncap.getD_enddatte()) ||
                                (selected1.after(taskEncap.getD_startdate()) && selected1.before(taskEncap.getD_enddatte()))){
                            searchlist.add(taskEncap);
                        }
                    }
                } else {
                    for (TaskEncap taskEncap : taskList) {
                        if (selected1.equals(taskEncap.getD_startdate()) || selected1.equals(taskEncap.getD_enddatte()) ||
                                selected2.equals(taskEncap.getD_startdate()) || selected2.equals(taskEncap.getD_enddatte()) ||
                                (taskEncap.getD_startdate().after(selected1) && taskEncap.getD_startdate().before(selected2)) || (taskEncap.getD_enddatte().after(selected1) && taskEncap.getD_enddatte().before(selected2))) {
                            searchlist.add(taskEncap);
                        }
                    }
                }

            } else if (type.equalsIgnoreCase("Completed")) {
                if (to.isEmpty()) {
                    for (TaskEncap taskEncap : taskList) {

                       /* if ((taskEncap.getD_startdate().compareTo(selected1)<=0 && taskEncap.getD_enddatte().compareTo(selected1)>=0)) {
                            searchlist.add(taskEncap);
                        }*/
                        try {
                            if( selected1.equals(Utility.getDateOnly(taskEncap.getD_updateddatetime()) ) )
                                searchlist.add(taskEncap);
                        } catch (ParseException e1) {
                            e1.printStackTrace();
                        }
                    }
                } else {
                    for (TaskEncap taskEncap : taskList) {
                        if (taskEncap.getI_progress() == 100) {
                            try {
                                if (selected1.equals(Utility.getDateOnly(taskEncap.getD_updateddatetime())) ||
                                        selected2.equals(Utility.getDateOnly(taskEncap.getD_updateddatetime())) ||
                                        (Utility.getDateOnly(taskEncap.getD_updateddatetime()).after(selected1) && Utility.getDateOnly(taskEncap.getD_updateddatetime()).before(selected2)) ||
                                        (Utility.getDateOnly(taskEncap.getD_updateddatetime()).after(selected1) && Utility.getDateOnly(taskEncap.getD_updateddatetime()).before(selected2))) {
                                    searchlist.add(taskEncap);
                                }
                            } catch (ParseException e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                }
            } else if (type.equalsIgnoreCase("Deadline")) {
                if (to.isEmpty()) {
                    for (TaskEncap taskEncap : taskList) {
                        if(  selected1.equals(taskEncap.getD_enddatte())){
                            searchlist.add(taskEncap);
                        }
                    }
                } else {
                    for (TaskEncap taskEncap : taskList) {
                        if (
                                selected1.equals(taskEncap.getD_enddatte()) ||
                                        selected2.equals(taskEncap.getD_enddatte()) ||
                                        (taskEncap.getD_enddatte().after(selected1) && taskEncap.getD_enddatte().before(selected2))) {
                            searchlist.add(taskEncap);
                        }
                    }
                }
            }


            if (searchlist.isEmpty()) {
                Toast.makeText(getApplicationContext(), "No tasks found", Toast.LENGTH_SHORT).show();
                return;
            }
            Intent intent = new Intent(TaskList.this, SearchResult.class);
            intent.putExtra("full_list", taskList);
            intent.putExtra("search_list", searchlist);
            intent.putExtra("title",type);
            intent.putExtra("fromDate", from);
            intent.putExtra("toDate", to);
            startActivity(intent);
            alertDialog.hide();
        }catch (Exception e){
            e.printStackTrace();
        }
    }


}
