package com.b2lmobitech.fieldcloudplus.task.old;

import android.content.Context;
import android.content.Intent;
import androidx.cardview.widget.CardView;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.task.encap.TaskEncap;

import java.util.ArrayList;

/**
 * Created by home on 10/30/2017.
 */

public class TaskListAdapter extends RecyclerView.Adapter<TaskListAdapter.viewHolder> {

    Context context;
    ArrayList<TaskEncap> arrayList;

    public TaskListAdapter(Context context, ArrayList<TaskEncap> arrayList){
        this.context=context;
        this.arrayList=arrayList;
    }

    @Override
    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.list_task_active, parent, false);
        return new viewHolder(itemView);

    }

    @Override
    public void onBindViewHolder(viewHolder holder, int position) {
        final TaskEncap taskEncap=arrayList.get(position);
        holder.taskname.setText(taskEncap.getTaskname());
        holder.progress.setText(taskEncap.getProgress());

        int daysbetween= Utility.daysbetween(taskEncap.getD_enddatte());
        if(daysbetween==0){
            holder.remaining_days.setText("Due Today");
        }else {
            holder.remaining_days.setText(daysbetween + " Days remaining");
        }
        final ArrayList<TaskEncap> parcellist=new ArrayList<>();
        parcellist.add(taskEncap);

        holder.cardView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent intent=new Intent(context, TaskDetails.class);
                intent.putExtra("taskid",taskEncap.getTaskid());
                context.startActivity(intent);
            }
        });
        holder.circularProgressbar.setProgress(taskEncap.getI_progress());

    }

    @Override
    public int getItemCount() {
        return arrayList.size();
    }

    public class viewHolder extends RecyclerView.ViewHolder{

        TextView taskname,progress,remaining_days;
        ProgressBar circularProgressbar;
        CardView cardView;

        public viewHolder(View itemView) {
            super(itemView);
            taskname=itemView.findViewById(R.id.task_name);
            progress=itemView.findViewById(R.id.progress_text);
            remaining_days=itemView.findViewById(R.id.due_date);
            cardView=itemView.findViewById(R.id.cardView);
            circularProgressbar=itemView.findViewById(R.id.circularProgressbar);
        }
    }


}
