package com.b2lmobitech.fieldcloudplus.task.old;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.provider.Settings;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.material.snackbar.Snackbar;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import androidx.cardview.widget.CardView;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.GlobalVariables;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.task.activities.RejectForm;
import com.b2lmobitech.fieldcloudplus.task.encap.LatLang;
import com.b2lmobitech.fieldcloudplus.task.encap.NotificationEncap;
import com.b2lmobitech.fieldcloudplus.task.encap.TaskEncap;
import com.b2lmobitech.fieldcloudplus.task.sql.Sqlite;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;


public class TaskNew extends AppCompatActivity {

    TextView project_name,milestone_name,task_name,task_description,start_date,end_date,task_priority,milestone_date,listtask_name;
    RequestQueue requestQueue;
    TaskEncap taskEncap;
    ProgressDialog pDialog;
    private Sqlite sqldatabase;
    String taskid;
    ArrayList<TaskEncap> taskList=new ArrayList<>();
    private static final int BACK_PASSNG=0;
    ArrayList<NotificationEncap> notificationEncaps=new ArrayList<>();
    CardView cardView;
    ProgressBar progressBar;
    CoordinatorLayout coordinatorLayout;
    Snackbar snackbar;
    MenuItem start,stop;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_new);

        requestQueue= Volley.newRequestQueue(this);
        sqldatabase=new Sqlite(this);

        getWidgets();
        getSupportActionBar().setTitle("Task");

        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        taskid=getIntent().getStringExtra("taskid");
        notificationEncaps=getIntent().getParcelableArrayListExtra("notifcationList");
        if(notificationEncaps!=null){
            NotificationEncap notificationEncap=notificationEncaps.get(0);
            sqldatabase.updateNotificationOpened(notificationEncap);

        }

    }

    @Override
    protected void onResume() {
        super.onResume();
        if(isNetworkAvailable()){
            getTasksOnline(taskid);
        }else{
            getTaskDetails();
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.menu_task_new, menu);
        start=menu.findItem(R.id.accept);
        stop=menu.findItem(R.id.reject);
        return true;
    }

    private void getWidgets(){

        project_name=findViewById(R.id.project_name);
        milestone_name=findViewById(R.id.milestone_name);
        task_name=findViewById(R.id.task_name);
        task_description=findViewById(R.id.task_description);
        start_date=findViewById(R.id.task_start_date);
        end_date=findViewById(R.id.task_end_date);
        task_priority=findViewById(R.id.task_priority);
        findViewById(R.id.completed_layout).setVisibility(View.GONE);
        cardView=findViewById(R.id.card_view);
        progressBar=findViewById(R.id.indeterminateBar);
        coordinatorLayout=findViewById(R.id.coordinator);
        milestone_date=findViewById(R.id.milestone_date);
        listtask_name=findViewById(R.id.listtask_name);
    }

    private void setValues(){
        project_name.setText(taskEncap.getProjectname());
        task_name.setText(taskEncap.getTaskname());
        milestone_name.setText(taskEncap.getMilestonename());
        task_description.setText(taskEncap.getDescription());
        start_date.setText(taskEncap.getStartdate());
        end_date.setText(taskEncap.getEnddatte());
        task_priority.setText(taskEncap.getPriotity());
        GlobalVariables globalVariables = (GlobalVariables) getApplication();
        globalVariables.setProjectId(taskEncap.getProjctid());
        milestone_date.setText(taskEncap.getMilestoneenddate());
        listtask_name.setText(taskEncap.getListtaskname());
    }

    private void acceptTask(){

        if(!Utility.isNetworkAvailable(this)) {
            snackbar= Snackbar.make(coordinatorLayout, "No Internet Connection", Snackbar.LENGTH_INDEFINITE) .setAction("Close", new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    snackbar.dismiss();
                }
            });
            snackbar.show();
            return;
        }
        final LocationManager locationManager = (LocationManager) this.getSystemService(Context.LOCATION_SERVICE);

        boolean isGPSEnabled = locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER);
        boolean isNetworkEnabled = locationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER);
        if (!isGPSEnabled && !isNetworkEnabled) {
            //Toast.makeText(mycontext, "No network provider is enabled for location access", Toast.LENGTH_LONG).show();
            android.app.AlertDialog.Builder alertdialog = new android.app.AlertDialog.Builder(this);

            alertdialog.setTitle("Access Location");
            alertdialog.setIcon(R.drawable.ic_action_location);
            alertdialog.setMessage("No network provider is enabled for location access!!");
            alertdialog.setPositiveButton("Turn On",
                    new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int whichButton) {
                            startActivity(new Intent(Settings.ACTION_LOCATION_SOURCE_SETTINGS));
                        }
                    });
            alertdialog.setNegativeButton("Cancel", new DialogInterface.OnClickListener() {

                @Override
                public void onClick(DialogInterface dialog, int which) {
                    // TODO Auto-generated method stub

                }
            }).create();
            alertdialog.show();
            return;
        }

        final LatLang latLang=Utility.getLocation(this);
        pDialog = new ProgressDialog(this);
        pDialog.setMessage("Loading...");
        pDialog.setIndeterminate(false);
        pDialog.setCancelable(false);
        pDialog.show();

        StringRequest postRequest = new StringRequest(Request.Method.POST, "http://fieldcloud.in/App/accept_task.php",
                new Response.Listener<String>()
                {
                    @Override
                    public void onResponse(String response) {
                        // response
                        Log.d("Response", response);
                        try {
                            JSONObject json=new JSONObject(response);

                            int success = json.getInt("success");
                            if (success == 1) {
                                sqldatabase.updateTaskAccepted(taskEncap.getTaskid());
                                finish();
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                        pDialog.dismiss();
                    }
                },
                new Response.ErrorListener()
                {
                    @Override
                    public void onErrorResponse(VolleyError error) {
                        // error
                        pDialog.dismiss();
                        Log.d("Error.Response", error.toString());
                    }
                }
        ) {
            @Override
            protected Map<String, String> getParams()
            {
                Map<String, String>  params = new HashMap<String, String>();

                params.put("assign_id", taskEncap.getAssignid());
                params.put("datetime", Utility.getCurrentDateTime());
                params.put("latitude", latLang.getLatitude());
                params.put("longtitude",latLang.getLongitude());
                return params;
            }
        };

        requestQueue.add(postRequest);

    }

    private void getTaskDetails(){
        taskList=sqldatabase.getSingleTask(taskid);
        if(taskList.size()!=0){
            taskEncap=taskList.get(0);
            cardView.setVisibility(View.VISIBLE);
            getSharedPreferences("projectid", MODE_PRIVATE).edit().putString("tasklistid", taskEncap.getListtaskid()).apply();
            setValues();
        }else{
            snackbar= Snackbar.make(coordinatorLayout, "Details not found", Snackbar.LENGTH_INDEFINITE) .setAction("Close", new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    snackbar.dismiss();
                }
            });
            snackbar.show();

        }
    }

    private void getTasksOnline(final String taskid){

        cardView.setVisibility(View.GONE);
        progressBar.setVisibility(View.VISIBLE);

        StringRequest postRequest = new StringRequest(Request.Method.POST, "http://fieldcloud.in/App/getSingleTask.php",
                new Response.Listener<String>()
                {
                    @Override
                    public void onResponse(String response) {
                        // response
                        Log.d("Response", response);
                        try {
                            JSONObject json=new JSONObject(response);

                            int success = json.getInt("success");
                            if (success == 1) {
                                JSONArray jsonArray=json.getJSONArray("tasks");
                                JSONArray projectArray=json.getJSONArray("project");
                                JSONArray milestoneArray=json.getJSONArray("milestone");
                                JSONArray listtaskArray=json.getJSONArray("listtask");
                                JSONArray progresslsitArray=json.getJSONArray("progresslist");

                                for(int i=0; i<jsonArray.length(); i++){
                                    JSONObject jsonObject=jsonArray.getJSONObject(i);
                                    taskEncap=new TaskEncap(jsonObject);
                                    sqldatabase.insert_task(taskEncap);
                                }
                                for(int i=0; i<milestoneArray.length(); i++){
                                    JSONObject jsonObject=milestoneArray.getJSONObject(i);
                                    sqldatabase.updateMilestoneDatails(jsonObject);
                                }
                                for(int i=0; i<listtaskArray.length(); i++){
                                    JSONObject jsonObject=listtaskArray.getJSONObject(i);
                                    sqldatabase.updateListtask(jsonObject);
                                }
                                for(int i=0; i<projectArray.length(); i++){
                                    JSONObject jsonObject=projectArray.getJSONObject(i);
                                    sqldatabase.updateProjectDetails(jsonObject);
                                }
                                for(int i=0; i<progresslsitArray.length(); i++){
                                    JSONObject jsonObject=progresslsitArray.getJSONObject(i);
                                    sqldatabase.insertTaskProgress(jsonObject);
                                }
                                getTaskDetails();
                                progressBar.setVisibility(View.GONE);
                            }

                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                        progressBar.setVisibility(View.GONE);
                    }
                },
                new Response.ErrorListener()
                {
                    @Override
                    public void onErrorResponse(VolleyError error) {
                        // error
                        start.setVisible(false);
                        stop.setVisible(false);
                        Log.d("Error.Response", error.toString());
                        snackbar= Snackbar.make(coordinatorLayout, "Internet connectivity problem", Snackbar.LENGTH_INDEFINITE) .setAction("close", new View.OnClickListener() {
                            @Override
                            public void onClick(View view) {
                                snackbar.dismiss();
                            }
                        });
                        snackbar.show();
                        progressBar.setVisibility(View.GONE);
                    }
                }
        ) {
            @Override
            protected Map<String, String> getParams()
            {
                Map<String, String>  params = new HashMap<String, String>();
                params.put("taskid", taskid);
                return params;
            }
        };

        requestQueue.add(postRequest);

    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        Intent intent=new Intent(this, RejectForm.class);
        intent.putParcelableArrayListExtra("arrayList",taskList);

        switch (item.getItemId()){

            case R.id.reject:
                if(progressBar.getVisibility()==View.GONE) {
                    intent.putExtra("request", "reject");
                    startActivity(intent);
                }
                break;
            case R.id.accept:
                if(progressBar.getVisibility()==View.GONE) {
                    acceptTask();
                }
                break;
            case android.R.id.home:
                onBackPressed();
                break;

        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) this.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();

        return networkInfo != null && networkInfo.isConnected();
    }

}
