package com.b2lmobitech.fieldcloudplus.task.old;

import android.content.Context;
import android.content.Intent;
import androidx.cardview.widget.CardView;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.encap.TaskEncap;
import java.util.ArrayList;
import java.util.Date;

/**
 * Created by home on 10/31/2017.
 */

public class UpcomingListAdapter extends RecyclerView.Adapter<UpcomingListAdapter.viewHolder> {

    Context context;
    ArrayList<TaskEncap> arrayList;

    public UpcomingListAdapter(Context context, ArrayList<TaskEncap> arrayList){
        this.context=context;
        this.arrayList=arrayList;
    }

    @Override
    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.list_task_active, parent, false);
        return new viewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(viewHolder holder, int position) {

        final TaskEncap taskEncap=arrayList.get(position);

        holder.taskname.setText(taskEncap.getTaskname());

        int daysbetween=(int) (taskEncap.getD_startdate().getTime()-new Date().getTime())/ (1000*60*60*24);

        daysbetween=daysbetween+1;

        if(daysbetween==1){
            holder.remaining_days.setText("Starting Tommorrow");

        }else{
            holder.remaining_days.setText("Starting in "+daysbetween + " Days");
        }

        final ArrayList<TaskEncap> parcellist=new ArrayList<>();
        parcellist.add(taskEncap);

        holder.cardView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent intent=new Intent(context, TaskDetails.class);
                intent.putParcelableArrayListExtra("arrayList",parcellist);
                intent.putExtra("taskid",taskEncap.getTaskid());
                context.startActivity(intent);
            }
        });

    }

    @Override
    public int getItemCount() {
        return arrayList.size();
    }

    public class viewHolder extends RecyclerView.ViewHolder{

        TextView taskname,progress,remaining_days;
        RelativeLayout relativeLayout;
        CardView cardView;

        public viewHolder(View itemView) {
            super(itemView);
            taskname=itemView.findViewById(R.id.task_name);
            progress=itemView.findViewById(R.id.progress_text);
            remaining_days=itemView.findViewById(R.id.due_date);
            relativeLayout=itemView.findViewById(R.id.progresslayout);
            relativeLayout.setVisibility(View.GONE);
            cardView=itemView.findViewById(R.id.cardView);

        }
    }


}
