package com.b2lmobitech.fieldcloudplus.task.others;

/**
 * Created by home on 2/10/2018.
 */
import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.IntentSender;
import android.content.pm.PackageManager;
import android.location.LocationManager;
import android.os.Looper;
import android.provider.Settings;
import androidx.core.app.ActivityCompat;
import androidx.appcompat.app.AlertDialog;
import android.widget.Toast;


import com.b2lmobitech.fieldcloudplus.BuildConfig;
import com.b2lmobitech.fieldcloudplus.task.listener.LocationUpdateListener;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.ResolvableApiException;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResponse;
import com.google.android.gms.location.LocationSettingsStatusCodes;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;


public class LocationUpdate {
    private static LocationUpdate mInstance;
    private static Context mContext;
    public static final int REQUEST_CHECK_SETTINGS = 1;
    private LocationUpdate(Context context){
        // Specify the application context
        mContext = context;
    }

    public static synchronized LocationUpdate getInstance(Context context){
        // If Instance is null then initialize new Instance
        if(mInstance == null){
            mInstance = new LocationUpdate(context);
        }
        // Return MySingleton new Instance
        return mInstance;
    }

    private void getLcoation(final LocationUpdateListener locationUpdateListener) {

        if (ActivityCompat.checkSelfPermission(mContext, android.Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED && ActivityCompat.checkSelfPermission(mContext, android.Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
            return;
        }
        LocationManager locationManager=(LocationManager)mContext.getSystemService(Context.LOCATION_SERVICE);
        final LocationRequest locationRequest = LocationRequest.create();
        locationRequest.setPriority(LocationRequest.PRIORITY_HIGH_ACCURACY);
        locationRequest.setInterval(10000);
        locationRequest.setFastestInterval(10000 / 2);
        locationRequest.setNumUpdates(1);
        LocationServices.getFusedLocationProviderClient(mContext).requestLocationUpdates(locationRequest, new LocationCallback() {
                    @Override
                    public void onLocationResult(LocationResult locationResult) {
                        // do work here
                        android.location.Location location=locationResult.getLastLocation();

                        if (location != null) {

                            boolean isMock;
                            if (android.os.Build.VERSION.SDK_INT >= 18) {
                                isMock = location.isFromMockProvider();
                            } else {
                                isMock = !Settings.Secure.getString(mContext.getContentResolver(), Settings.Secure.ALLOW_MOCK_LOCATION).equals("0");
                            }
                            ;
                            if (isMock && !BuildConfig.DEBUG) {
                              showFakelOcationAlert();
                            } else {
                                locationUpdateListener.onLocationReceived(location.getLatitude()+"",location.getLongitude()+"");
                            }
                        } else {
                            Toast.makeText(mContext, "Unable to find lcoation", Toast.LENGTH_SHORT).show();
                        }
                    }
                },
                Looper.myLooper());
    }

    public void connectLocation(final LocationUpdateListener locationUpdateListener) {

        final LocationRequest locationRequest = LocationRequest.create();
        locationRequest.setPriority(LocationRequest.PRIORITY_HIGH_ACCURACY);
        locationRequest.setInterval(10000);
        locationRequest.setFastestInterval(10000 / 2);
        locationRequest.setNumUpdates(1);
        LocationSettingsRequest.Builder builder = new LocationSettingsRequest.Builder().addLocationRequest(locationRequest);
        builder.setAlwaysShow(true);


        Task<LocationSettingsResponse> task =
                LocationServices.getSettingsClient(mContext).checkLocationSettings(builder.build());
        task.addOnCompleteListener(new OnCompleteListener<LocationSettingsResponse>() {
            @Override
            public void onComplete(Task<LocationSettingsResponse> task) {
                try {
                    task.getResult(ApiException.class);
                    // All location settings are satisfied. The client can initialize location
                    getLcoation(locationUpdateListener);
                } catch (ApiException exception) {
                    switch (exception.getStatusCode()) {
                        case LocationSettingsStatusCodes.RESOLUTION_REQUIRED:
                            try {
                                ResolvableApiException resolvable = (ResolvableApiException) exception;
                                resolvable.startResolutionForResult(
                                        (Activity) mContext,
                                        REQUEST_CHECK_SETTINGS);
                            } catch (IntentSender.SendIntentException e) {
                                // Ignore the error.
                            } catch (ClassCastException e) {
                                // Ignore, should be an impossible error.
                            }
                            break;
                    }
                }
            }
        });
    }

    private  void showFakelOcationAlert() {
        AlertDialog.Builder builder = new AlertDialog.Builder(mContext);

// Add the buttons
        builder.setPositiveButton("CLOSE", new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int id) {

            }
        });

        builder.setTitle("FAKE LOCATION DETECTED");
        builder.setMessage("Turn off fake location and retry");
        AlertDialog dialog = builder.create();
        dialog.show();
    }

}
