package com.b2lmobitech.fieldcloudplus.task.others;

import android.content.Context;
import android.content.SharedPreferences;

import com.b2lmobitech.fieldcloudplus.task.sql.Database;

import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;

/**
 * Created by home on 3/24/2018.
 */

public class Preference {
    private static Preference mInstance;
    private static SharedPreferences sharedPreferences;
    Context context;

    private Preference(Context context){
        // Get the request queue
        sharedPreferences=context.getSharedPreferences(globalvariables.LOGOUT_CHECKING,Context.MODE_PRIVATE);
        this.context=context;
    }

    public static synchronized Preference getInstance(Context context){
        // If Instance is null then initialize new Instance
            mInstance = new Preference(context);
        // Return MySingleton new Instance
        return mInstance;
    }

    public String getString(String str){
        return  sharedPreferences.getString(str,"");
    }

    public void putString(String key,String pair){
        sharedPreferences.edit().putString(key,pair).apply();
    }

    public void putProjectId(String id){
        sharedPreferences.edit().putString("projectId",id).apply();
    }

    public String getProjectId(){
        return  sharedPreferences.getString("projectId","");
    }

    public void putTaskListId(String id){
        sharedPreferences.edit().putString("tasklistId",id).apply();
    }

    public String getTaskListId(){
        return  sharedPreferences.getString("tasklistId","");
    }

    public String getCompanyName(){
        return  sharedPreferences.getString(globalvariables.logout_companyname,"");
    }

    public String getEmailId(){
        return  sharedPreferences.getString(globalvariables.logout_emailid,"").toLowerCase();
    }

    public String getDesignation(){
        return  sharedPreferences.getString(globalvariables.logout_designation,"");
    }

    public boolean isAdmin(){
        return  sharedPreferences.getString(globalvariables.logout_designation,"").equalsIgnoreCase("admin");
    }

    public boolean isResponsible(String projectId){
        return  isAdmin() || Database.getInstance(context).isResponsibleForThisProject(projectId,getEmailId());
    }

    public String getCompnayType(){
        return  sharedPreferences.getString(globalvariables.logout_companytype,"");
    }

}
