package com.b2lmobitech.fieldcloudplus.task.others;


import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Environment;
import android.util.Base64;
import android.util.Log;


import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * Created by home on 2/12/2018.
 */

public class Utility {

    public static String imgToString(Bitmap bitmap){
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, stream);
        byte[] byteArray = stream.toByteArray();
        return Base64.encodeToString(byteArray, Base64.DEFAULT);
    }

    public static String imgToString(Drawable drawable){
        return imgToString(drawableToBitmap(drawable));
    }

    public static String imgToString(Drawable drawable,Bitmap bitmap){
        return imgToString(overlay(drawableToBitmap(drawable),bitmap));
    }

    public static String imgToString(Bitmap bitmap1,Bitmap bitmap2){
        return imgToString(overlay(bitmap1,bitmap2));
    }

    public static Bitmap bitmap(String str){
        byte[] decodedBytes = Base64.decode(str, 0);
        return BitmapFactory.decodeByteArray(decodedBytes, 0, decodedBytes.length);
    }

    public static Bitmap overlay(Bitmap bmp1, Bitmap bmp2) {
        Bitmap bmOverlay = Bitmap.createBitmap(bmp1.getWidth(), bmp1.getHeight(), bmp1.getConfig());
        Canvas canvas = new Canvas(bmOverlay);
        canvas.drawBitmap(bmp1, new Matrix(), null);
        canvas.drawBitmap(bmp2, 0, 0, null);
        return bmOverlay;
    }


    public static Bitmap drawableToBitmap (Drawable drawable) {
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }

        int width = drawable.getIntrinsicWidth();
        width = width > 0 ? width : 1;
        int height = drawable.getIntrinsicHeight();
        height = height > 0 ? height : 1;

        Bitmap bitmap = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);

        return bitmap;
    }

    public static File getCapturedImageFile(Context context) throws IOException {


        File mediaStorageDir = context.getCacheDir();

        File mediaFile = new File(mediaStorageDir.getPath() + File.separator
                + "IMG_" + System.currentTimeMillis() + ".jpg");
        try {
            mediaFile.createNewFile();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return mediaFile;
    }

    public static File getSignFile(Context context) throws IOException {

        File mediaStorageDir = context.getCacheDir();
        if (!mediaStorageDir.exists()) {
            if (!mediaStorageDir.mkdirs()) {
                return null;
            }
        }

        File mediaFile = new File(mediaStorageDir.getPath() + File.separator + "SIGN_" + System.currentTimeMillis() + ".jpg");
        try {
            mediaFile.createNewFile();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return mediaFile;
    }



    public static String getCurrentDateTime() {
        Calendar c1 = Calendar.getInstance();
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df1.format(c1.getTime());
    }

    public static String getCurrentDate() {
        Calendar c1 = Calendar.getInstance();
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
        return df1.format(c1.getTime());
    }

    public static  String getNormalDatetime(String str) throws ParseException {
       Date date=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(str);
        return new SimpleDateFormat("dd-MM-yyyy hh:mm a").format(date);
    }

    public static Bitmap processImage(Bitmap bitmap){




        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        float  x= (float) bitmap.getHeight()/ (float) bitmap.getWidth();

        float s43= (float) 4/3;
        if(x==s43) {
            bitmap = Bitmap.createScaledBitmap(bitmap, 360, 480, true);
        }else {
            bitmap = Bitmap.createScaledBitmap(bitmap, 360, 640, true);
        }
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, stream);

        byte[] byteArray = stream.toByteArray();


        if(byteArray.length>160000) { //200KB

            bitmap.compress(Bitmap.CompressFormat.JPEG, 90, stream);
        }

        Log.e("IamgeSize",byteArray.length+" b");
        return bitmap;

    }

    public static String bitmap2string(Bitmap bm) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bm.compress(Bitmap.CompressFormat.JPEG, 100, stream);
        byte[] byteArray = stream.toByteArray();
        return Base64.encodeToString(byteArray, Base64.DEFAULT);
    }

    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager cm = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();

        return networkInfo != null && networkInfo.isConnected();
    }



}

