package com.b2lmobitech.fieldcloudplus.task.service;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.old.TaskDetails;

import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.media.AudioManager;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import androidx.core.app.NotificationCompat;
import androidx.legacy.content.WakefulBroadcastReceiver;

public class AlarmReceiver extends WakefulBroadcastReceiver {

    @Override
    public void onReceive(final Context context, Intent intent) {
    	
    	 String taskname = intent.getStringExtra ("task");
         String taskid = intent.getStringExtra ("taskid");
         //String user = intent.getStringExtra ("user");
         int request=intent.getIntExtra ("request",0);
         
         //Log.e("request receive ", String.valueOf(request));
 	
    	 Uri alarmUri = RingtoneManager.getDefaultUri(RingtoneManager.TYPE_NOTIFICATION);
        Ringtone ringtone = RingtoneManager.getRingtone(context, alarmUri);
        if(ringtone!=null){
    	    ringtone.setStreamType(AudioManager.STREAM_ALARM);
    	    ringtone.play();
    	
    	}
        
        
        
        Intent intent1 = new Intent(context,TaskDetails.class);
		// Send data to NotificationView Class
		intent1.putExtra("taskid", taskid);
	//	intent.putExtra("text", message);
		// Open NotificationView.java Activity
		PendingIntent pIntent = PendingIntent.getActivity(context, request, intent1,
				PendingIntent.FLAG_UPDATE_CURRENT);
 
		// Create Notification using NotificationCompat.Builder
		NotificationCompat.Builder builder = new NotificationCompat.Builder(
				context)
				// Set Icon
				.setSmallIcon(R.drawable.task_ongoing)
				// Set Ticker Message
				.setTicker("REMINDER!!")
				// Set Title
				.setContentTitle("TASK REMINDER ")
				// Set Text
				.setContentText(taskname)
				// Add an Action Button below Notification
				.addAction(R.drawable.next, "Action Button", pIntent)
				// Set PendingIntent into Notification
				.setContentIntent(pIntent)
				// Dismiss Notification
				.setAutoCancel(true);
 
		// Create Notification Manager
		NotificationManager notificationmanager = (NotificationManager) context
				.getSystemService(Context.NOTIFICATION_SERVICE);
		// Build Notification with Notification Manager
		notificationmanager.notify(request, builder.build());
        
        //this will send a notification message
      /*  ComponentName comp = new ComponentName(context.getPackageName(),
                AlarmService.class.getName());
        startWakefulService(context, (intent.setComponent(comp)));
        setResultCode(Activity.RESULT_OK);*/
    }
}

