package com.b2lmobitech.fieldcloudplus.task.service;

import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;

import androidx.annotation.NonNull;
import androidx.core.app.NotificationCompat;
import androidx.work.Data;
import androidx.work.ListenableWorker;
import androidx.work.WorkerParameters;

import android.util.Log;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.activities.Dashboard;
import com.b2lmobitech.fieldcloudplus.task.encap.TaskEncap;
import com.b2lmobitech.fieldcloudplus.task.enums.TaskEnum;
import com.b2lmobitech.fieldcloudplus.task.sql.Sqlite;
//import com.firebase.jobdispatcher.JobParameters;
//import com.firebase.jobdispatcher.JobService;

import java.util.ArrayList;

import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import com.google.common.util.concurrent.ListenableFuture;

/**
 * Created by home on 12/16/2017.
 */

public class DailyNotification extends ListenableWorker {
//    Context mycontext;
    Sqlite sqldatabase;
    public DailyNotification(@NonNull Context appContext, @NonNull WorkerParameters params) {
        super(appContext, params);
//        mycontext = appContext;
    }

    @Override
    public ListenableFuture<Result> startWork() {
        // Do your work here.
        sqldatabase = new Sqlite(getApplicationContext());
        int late = 0;
        int active = 0;

        try {
            String emailid = getApplicationContext().getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0).getString(globalvariables.logout_emailid, "");

            Log.e("user",emailid);
            ArrayList<TaskEncap> arrayList = sqldatabase.getAllTasks(emailid);

            for (TaskEncap taskEncap : arrayList) {
                if(taskEncap.getEmail_id().equalsIgnoreCase(emailid)) {
                    if (taskEncap.getCategory().equals(TaskEnum.ACTIVE)) {
                        Log.e("active",taskEncap.getTaskname());
                        active++;
                    } else if (taskEncap.getCategory().equals(TaskEnum.LATE)) {
                        Log.e("LATE",taskEncap.getTaskname());
                        late++;
                    }
                }
            }

            int total = late + active;
            if (total != 0) {
                Intent intent1 = new Intent(getApplicationContext(), Dashboard.class);
                PendingIntent pIntent = PendingIntent.getActivity(getApplicationContext(), 1, intent1,
                        PendingIntent.FLAG_UPDATE_CURRENT);

                // Create Notification using NotificationCompat.Builder
                NotificationCompat.Builder builder = new NotificationCompat.Builder(
                        getApplicationContext(), "daily")
                        .setSmallIcon(R.mipmap.ic_launcher)
                        .setBadgeIconType(NotificationCompat.BADGE_ICON_NONE)
                        .setTicker("REMINDER!!")
                        .setContentTitle("Today Tasks")
                        .setContentIntent(pIntent)
                        .setAutoCancel(true);
                if (late == 0) {
                    builder.setContentText("Total : " + total);
                } else {
                    builder.setContentText("Total : " + total + "(" + late + " late)");

                }

                NotificationManager notificationmanager = (NotificationManager) getApplicationContext()
                        .getSystemService(Context.NOTIFICATION_SERVICE);
                notificationmanager.notify(1, builder.build());
            }
        }catch (Exception e){
            e.printStackTrace();
        }

        // Return a ListenableFuture<>
        return null;
    }

    @Override
    public void onStopped() {
        // Cleanup because you are being stopped.
    }
//    @Override
//    public boolean onStartJob(JobParameters job) {
//        sqldatabase = new Sqlite(this);
//        int late = 0;
//        int active = 0;
//
//        try {
//            String emailid = this.getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0).getString(globalvariables.logout_emailid, "");
//
//            Log.e("user",emailid);
//            ArrayList<TaskEncap> arrayList = sqldatabase.getAllTasks(emailid);
//
//            for (TaskEncap taskEncap : arrayList) {
//                if(taskEncap.getEmail_id().equalsIgnoreCase(emailid)) {
//                    if (taskEncap.getCategory().equals(TaskEnum.ACTIVE)) {
//                        Log.e("active",taskEncap.getTaskname());
//                        active++;
//                    } else if (taskEncap.getCategory().equals(TaskEnum.LATE)) {
//                        Log.e("LATE",taskEncap.getTaskname());
//                        late++;
//                    }
//                }
//            }
//
//            int total = late + active;
//            if (total != 0) {
//                Intent intent1 = new Intent(this, Dashboard.class);
//                PendingIntent pIntent = PendingIntent.getActivity(this, 1, intent1,
//                        PendingIntent.FLAG_UPDATE_CURRENT);
//
//                // Create Notification using NotificationCompat.Builder
//                NotificationCompat.Builder builder = new NotificationCompat.Builder(
//                        this, "daily")
//                        .setSmallIcon(R.mipmap.ic_launcher)
//                        .setBadgeIconType(R.mipmap.ic_launcher)
//                        .setTicker("REMINDER!!")
//                        .setContentTitle("Today Tasks")
//                        .setContentIntent(pIntent)
//                        .setAutoCancel(true);
//                if (late == 0) {
//                    builder.setContentText("Total : " + total);
//                } else {
//                    builder.setContentText("Total : " + total + "(" + late + " late)");
//
//                }
//
//                NotificationManager notificationmanager = (NotificationManager) this
//                        .getSystemService(Context.NOTIFICATION_SERVICE);
//                notificationmanager.notify(1, builder.build());
//            }
//        }catch (Exception e){
//            e.printStackTrace();
//        }
//
//
//        return false;
//    }
//
//
//    @Override
//    public boolean onStopJob(JobParameters job) {
//        return false;
//    }


}
