package com.b2lmobitech.fieldcloudplus.task.service;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;

import androidx.annotation.NonNull;
import androidx.work.Data;
import androidx.work.ListenableWorker;
import androidx.work.WorkerParameters;

import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import com.b2lmobitech.fieldcloudplus.task.encap.RequestEncap;
import com.b2lmobitech.fieldcloudplus.task.sql.Sqlite;
//import com.firebase.jobdispatcher.FirebaseJobDispatcher;
//import com.firebase.jobdispatcher.JobParameters;
//import com.firebase.jobdispatcher.JobService;
import com.google.common.util.concurrent.ListenableFuture;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by home on 11/21/2017.
 */

public class GetRequestDetails extends ListenableWorker {

    RequestQueue requestQueue;
    private Sqlite sqldatabase;
    JSONArray jsonArray=new JSONArray();
    JSONObject jsonObject;
    String tag;
//    FirebaseJobDispatcher dispatcher;
    public GetRequestDetails(@NonNull Context appContext, @NonNull WorkerParameters params) {
        super(appContext, params);
//        mycontext = appContext;
    }

    @Override
    public ListenableFuture<Result> startWork() {
        // Do your work here.
        requestQueue= Volley.newRequestQueue(getApplicationContext());
        sqldatabase=new Sqlite(getApplicationContext());
//        Bundle bundle=job.getExtras();
        Data bundle = getInputData();
        getRequestDetails(bundle.getString("assignid"),bundle.getString("datetime"));

        // Return a ListenableFuture<>
        return null;
    }

    @Override
    public void onStopped() {
        // Cleanup because you are being stopped.
    }
//    @Override
//    public boolean onStartJob(JobParameters job) {
//        requestQueue= Volley.newRequestQueue(this);
//        sqldatabase=new Sqlite(this);
//        Bundle bundle=job.getExtras();
//        getRequestDetails(bundle.getString("assignid"),bundle.getString("datetime"));
//        return false;
//    }
//
//    @Override
//    public boolean onStopJob(JobParameters job) {
//
//        return false;
//    }

    private void getRequestDetails(final String assignid, final String requestdatetime){
        StringRequest postRequest = new StringRequest(Request.Method.POST, "http://fieldcloud.in/App/getRequestDetails.php",
                new Response.Listener<String>()
                {
                    @Override
                    public void onResponse(String response) {
                        // response
                        Log.d("Response", response);
                        try {
                            JSONObject json=new JSONObject(response);

                            int success = json.getInt("success");
                            if (success == 1) {
                                JSONArray jsonArray=json.getJSONArray("requests");

                                for(int i=0; i<jsonArray.length(); i++){
                                    JSONObject jsonObject=jsonArray.getJSONObject(i);
                                    RequestEncap requestEncap=new RequestEncap();

                                    requestEncap.setTaskName(jsonObject.getString("task_name"));
                                    requestEncap.setTaskId(jsonObject.getString("task_id"));
                                    requestEncap.setAssignid(jsonObject.getString("assign_id"));
                                    requestEncap.setEmployeeid(jsonObject.getString("employeeid"));
                                    requestEncap.setStatus(jsonObject.getString("status"));
                                    requestEncap.setReason(jsonObject.getString("reason"));
                                    requestEncap.setRequestdatetime(jsonObject.getString("r_datetime"));
                                    requestEncap.setResponse(jsonObject.getString("response"));
                                    requestEncap.setIncreasedays(jsonObject.getString("increasedays"));
                                    requestEncap.setUpdateddatetime(jsonObject.getString("updatetime"));
                                    sqldatabase.insertOrUpdateTaskRequest(requestEncap);
                                }
                            }

                        } catch (Exception e) {
                            e.printStackTrace();
                        }

                    }
                },
                new Response.ErrorListener()
                {
                    @Override
                    public void onErrorResponse(VolleyError error) {
                        // error
                        Log.d("Error.Response", error.toString());

                    }
                }
        ) {
            @Override
            protected Map<String, String> getParams()
            {
                Map<String, String>  params = new HashMap<String, String>();
                params.put("assign_id", assignid);
                params.put("datetime", requestdatetime);
                return params;
            }
        };

        requestQueue.add(postRequest);
    }
}
