package com.b2lmobitech.fieldcloudplus.task.service;

import android.content.Context;
import android.util.Log;

import androidx.annotation.NonNull;
import androidx.work.Data;
import androidx.work.ListenableWorker;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkInfo;
import androidx.work.WorkManager;
import androidx.work.WorkerParameters;

import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import com.b2lmobitech.fieldcloudplus.task.encap.TaskEncap;
import com.b2lmobitech.fieldcloudplus.task.sql.Sqlite;
import com.google.common.util.concurrent.ListenableFuture;
//import com.firebase.jobdispatcher.FirebaseJobDispatcher;
//import com.firebase.jobdispatcher.GooglePlayDriver;
//import com.firebase.jobdispatcher.JobParameters;
//import com.firebase.jobdispatcher.JobService;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by home on 11/20/2017.
 */

public class GetTaskDetails extends ListenableWorker  {
    RequestQueue requestQueue;
    private Sqlite sqldatabase;
    JSONArray jsonArray=new JSONArray();
    JSONObject jsonObject;
    String tag;
     WorkManager workmanager;
//    FirebaseJobDispatcher dispatcher;
    public GetTaskDetails(@NonNull Context appContext, @NonNull WorkerParameters params) {
        super(appContext, params);
    }
    @Override
    public ListenableFuture<ListenableWorker.Result> startWork() {
        // Do your work here.
        Data input = getInputData();
        requestQueue= Volley.newRequestQueue(getApplicationContext());
        sqldatabase=new Sqlite(getApplicationContext());
        workmanager = WorkManager.getInstance(getApplicationContext());
        getTasksOnline(input.getString("taskid"));
        tag=input.getString("taskid");
        //tag=job.getTag(); //check this if not works
        // Return a ListenableFuture<>
        return null;
    }
    @Override
    public void onStopped() {
        // Cleanup because you are being stopped.
    }
//    public boolean onStartJob(JobParameters job) {
//        requestQueue= Volley.newRequestQueue(this);
//        sqldatabase=new Sqlite(this);
//        getTasksOnline(job.getExtras().getString("taskid"));
//        tag=job.getTag();
//        dispatcher = new FirebaseJobDispatcher(new GooglePlayDriver(this));
//        return false;
//    }

//    @Override
//    public boolean onStopJob(JobParameters job) {
//        return false;
//    }

    private void getTasksOnline(final String taskid){

        StringRequest postRequest = new StringRequest(Request.Method.POST, "http://fieldcloud.in/App/getSingleTask.php",
                new Response.Listener<String>()
                {
                    @Override
                    public void onResponse(String response) {
                        // response
                        Log.d("Response", response);
                        try {
                            JSONObject json=new JSONObject(response);

                            int success = json.getInt("success");
                            if (success == 1) {
                                workmanager.cancelUniqueWork(tag);
                                JSONArray jsonArray=json.getJSONArray("tasks");
                                JSONArray projectArray=json.getJSONArray("project");
                                JSONArray milestoneArray=json.getJSONArray("milestone");
                                JSONArray listtaskArray=json.getJSONArray("listtask");
                                JSONArray progresslsitArray=json.getJSONArray("progresslist");

                                for(int i=0; i<jsonArray.length(); i++){
                                    JSONObject jsonObject=jsonArray.getJSONObject(i);
                                    TaskEncap taskEncap=new TaskEncap(jsonObject);
                                    sqldatabase.insert_task(taskEncap);
                                }
                                for(int i=0; i<milestoneArray.length(); i++){
                                    JSONObject jsonObject=milestoneArray.getJSONObject(i);
                                    sqldatabase.updateMilestoneDatails(jsonObject);
                                }
                                for(int i=0; i<listtaskArray.length(); i++){
                                    JSONObject jsonObject=listtaskArray.getJSONObject(i);
                                    sqldatabase.updateListtask(jsonObject);
                                }
                                for(int i=0; i<projectArray.length(); i++){
                                    JSONObject jsonObject=projectArray.getJSONObject(i);
                                    sqldatabase.updateProjectDetails(jsonObject);
                                }
                                for(int i=0; i<progresslsitArray.length(); i++){
                                    JSONObject jsonObject=progresslsitArray.getJSONObject(i);
                                    sqldatabase.insertTaskProgress(jsonObject);
                                }
                            }

                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                },
                new Response.ErrorListener()
                {
                    @Override
                    public void onErrorResponse(VolleyError error) {
                        // error
                        Log.d("Error.Response", error.toString());
                    }
                }
        ) {
            @Override
            protected Map<String, String> getParams()
            {
                Map<String, String>  params = new HashMap<String, String>();
                params.put("taskid", taskid);
                return params;
            }
        };

        requestQueue.add(postRequest);

    }


}
