package com.b2lmobitech.fieldcloudplus.task.service

import android.app.Notification
import android.app.NotificationChannel
import android.app.NotificationManager
import android.app.PendingIntent
import android.content.ContentResolver
import android.content.Context
import android.content.Intent
import android.graphics.Color
import android.media.AudioAttributes
import android.media.RingtoneManager
import android.net.Uri
import android.os.Build
import android.util.Log
import androidx.core.app.NotificationCompat
import androidx.core.app.TaskStackBuilder
import androidx.work.Constraints
import androidx.work.Data
import androidx.work.NetworkType
import androidx.work.OneTimeWorkRequest
import com.android.volley.RequestQueue
import com.android.volley.toolbox.Volley
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.defect.DefectDetailsActivity
import com.b2lmobitech.fieldcloudplus.defect.DefectListActivity
import com.b2lmobitech.fieldcloudplus.defect.DefectStatus
import com.b2lmobitech.fieldcloudplus.defect.PettyCashActivity
import com.b2lmobitech.fieldcloudplus.kyc.KycActivity
import com.b2lmobitech.fieldcloudplus.task.Utility
import com.b2lmobitech.fieldcloudplus.task.activities.RequestDetails
import com.b2lmobitech.fieldcloudplus.task.activities.TaskInfoActivity
import com.b2lmobitech.fieldcloudplus.task.encap.NotificationEncap
import com.b2lmobitech.fieldcloudplus.task.encap.TaskEncap
import com.b2lmobitech.fieldcloudplus.task.sql.Sqlite
import com.google.firebase.messaging.FirebaseMessagingService
import com.google.firebase.messaging.RemoteMessage
import java.util.Date
import java.util.Locale
import java.util.concurrent.TimeUnit

//import com.firebase.jobdispatcher.Constraint;
//import com.firebase.jobdispatcher.FirebaseJobDispatcher;
//import com.firebase.jobdispatcher.GooglePlayDriver;
//import com.firebase.jobdispatcher.Job;
//import com.firebase.jobdispatcher.Lifetime;
//import com.firebase.jobdispatcher.Trigger;
/**
 * Created by home on 11/14/2017.
 */
class MyFirebaseMessagingService : FirebaseMessagingService() {
    //For fieldcloud Firebase console
    //email id:b2ldemo123@gmail.com
    //go to tools->firebase-> check is connect your appto firebase(connected)
    //Add FCM to your app (Dependencies set up correctly)
    private var sqldatabase: Sqlite? = null
    var requestQueue: RequestQueue? = null
    var intent: Intent? = null
    var taskEncap: TaskEncap? = null
    var notificationEncap: NotificationEncap? = null
    var context: Context? = null
    var notificationEncaps: ArrayList<NotificationEncap> = ArrayList()
    private var SOUND_URI: Uri? = null

    override fun onMessageReceived(remoteMessage: RemoteMessage) {
        super.onMessageReceived(remoteMessage)
        //Displaying data in log
        //It is optional
        Log.d("MyFirebaseMessagingService", "From: " + remoteMessage.from)
        Log.d("MyFirebaseMessagingService", "Notification Message Body: " + remoteMessage.data)
        //Calling method to generate notification
        SOUND_URI =
            RingtoneManager.getDefaultUri(RingtoneManager.TYPE_ALARM) //Uri.parse(URL.notification_sound);
        context = this
        sqldatabase = Sqlite(this)

        val data = remoteMessage.data
        requestQueue = Volley.newRequestQueue(this)

        //{id=DR_329, type=defect}
        if (data["type"] == "defect") {
            val message = remoteMessage.notification?.body?: data["body"] ?:data["message"]?:""
            if(message.contains("new",true) || message.contains("assigned",true) || message.contains("approved",true)){
                NotificationUtils.showDefectNotificationWithAlarm(data.getOrDefault("id",""),data.getOrDefault("title","FieldCloud Plus"),message,applicationContext)
            }else {
                showDefectNotification("Defect Report", message, data["id"])
            }
        }else if (data["type"] == "petty") {
            showPettyCashNotification("Petty Cash", data["body"])
        }else if (data["type"] == "kyc") {
            showKycNotification("KYC Update", data["body"])
        } else {
            notificationEncap = NotificationEncap()
            notificationEncap!!.assignId = data["assignid"]
            notificationEncap!!.taskId = data["taskid"]
            notificationEncap!!.message = data["body"]
            notificationEncap!!.datetime = data["dateandtime"]
            notificationEncap!!.type = data["type"]
            //getTasksOnline(notificationEncap.getTaskId());
            scheduleJob(notificationEncap!!.taskId)

            var intent = Intent(this, TaskInfoActivity::class.java)
            intent.putExtra("id", data["taskid"])
            intent.putExtra("fromNotification", true)

            when (notificationEncap!!.type.lowercase(Locale.getDefault())) {
                "new" -> show(intent, "Task", notificationEncap!!.message)
                "request" -> {
                    intent = Intent(this, RequestDetails::class.java)
                    intent.putExtra("id", data["taskid"])
                    intent.putExtra("fromNotification", true)
                    show(intent, "Request", notificationEncap!!.message)
                }

                "completed" -> show(intent, "Task", notificationEncap!!.message)
                "task" -> show(intent, "Task", notificationEncap!!.message)
                else -> {}
            }
            sqldatabase!!.insertNotifications(notificationEncap)
        }
    }


    private fun showKycNotification(title: String, message: String?) {
//        Uri defaultSoundUri= RingtoneManager.getDefaultUri(RingtoneManager.TYPE_ALARM);
//        Ringtone ringtone = RingtoneManager.getRingtone(context, defaultSoundUri);
//        if(ringtone!=null){
//            ringtone.setStreamType(AudioManager.STREAM_ALARM);
//            ringtone.play();
//
//        }
        val intent = Intent(this, KycActivity::class.java)
        val pendingIntent =
            TaskStackBuilder.create(this) // add all of DetailsActivity's parents to the stack,
                // followed by DetailsActivity itself
                .addNextIntentWithParentStack(intent)
                .getPendingIntent(0, PendingIntent.FLAG_UPDATE_CURRENT)
        notficationwithsound("kyc", "KYC Updates", "Desc", title, message, pendingIntent)
        //        NotificationManager notificationManager =(NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
//        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O)
//        {
//            // Creating an Audio Attribute
//            AudioAttributes audioAttributes = new AudioAttributes.Builder()
//                    .setContentType(AudioAttributes.CONTENT_TYPE_SONIFICATION)
//                    .setUsage(AudioAttributes.USAGE_NOTIFICATION)
//                    .build();
//            String channelId = "kyc";
//            NotificationChannel channel = new NotificationChannel(
//                    channelId,
//                    "KYC Updates",
//                    NotificationManager.IMPORTANCE_HIGH);
//            channel.setLightColor( Color.GRAY);
//            channel.enableLights(true);
//            channel.setDescription("Desc");
//            channel.setSound(SOUND_URI, audioAttributes);
//            notificationManager.createNotificationChannel(channel);
//        }
//
//        Builder notificationBuilder= new Builder(this,"kyc").setSmallIcon(R.mipmap.ic_launcher)
//                .setContentTitle(title)
//                .setContentText(message)
//                .setAutoCancel(true)
//                .setDefaults(Notification.DEFAULT_LIGHTS)
//                .setSound(SOUND_URI)
//                .setContentIntent(pendingIntent);
//
//
//        if (notificationManager != null) {
//            notificationManager.notify((int) new Date().getTime(), notificationBuilder.build());
//        }
    }

    private fun showPettyCashNotification(title: String, message: String?) {
//        Uri defaultSoundUri= RingtoneManager.getDefaultUri(RingtoneManager.TYPE_ALARM);
//        Ringtone ringtone = RingtoneManager.getRingtone(context, defaultSoundUri);
//        if(ringtone!=null){
//            ringtone.setStreamType(AudioManager.STREAM_ALARM);
//            ringtone.play();
//
//        }
        val intent = Intent(this, PettyCashActivity::class.java)
        val pendingIntent =
            TaskStackBuilder.create(this) // add all of DetailsActivity's parents to the stack,
                // followed by DetailsActivity itself
                .addNextIntentWithParentStack(intent)
                .getPendingIntent(0, PendingIntent.FLAG_UPDATE_CURRENT)
        notficationwithsound(
            "defect",
            "Defect Notificaitons",
            "Desc",
            title,
            message,
            pendingIntent
        )
        //        NotificationManager notificationManager =(NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
//        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O)
//        {
//            String channelId = "defect";
//            AudioAttributes audioAttributes = new AudioAttributes.Builder()
//                    .setContentType(AudioAttributes.CONTENT_TYPE_SONIFICATION)
//                    .setUsage(AudioAttributes.USAGE_NOTIFICATION)
//                    .build();
//            NotificationChannel channel = new NotificationChannel(
//                    channelId,
//                    "Defect Notificaitons",
//                    NotificationManager.IMPORTANCE_HIGH);
//            channel.setLightColor( Color.GRAY);
//            channel.enableLights(true);
//            channel.setDescription("Desc");
//            channel.setSound(SOUND_URI, audioAttributes);
//            notificationManager.createNotificationChannel(channel);
//        }
//
//        Builder notificationBuilder= new Builder(this,"defect").setSmallIcon(R.mipmap.ic_launcher)
//                .setContentTitle(title)
//                .setContentText(message)
//                .setAutoCancel(true)
//                .setDefaults(Notification.DEFAULT_LIGHTS)
//                .setSound(SOUND_URI)
//                .setContentIntent(pendingIntent);
//
//
//        if (notificationManager != null) {
//            notificationManager.notify((int) new Date().getTime(), notificationBuilder.build());
//        }
    }

    private fun showDefectNotification(title: String, message: String?, id: String?) {
//            Uri defaultSoundUri= RingtoneManager.getDefaultUri(RingtoneManager.TYPE_ALARM);
//        Ringtone ringtone = RingtoneManager.getRingtone(context, defaultSoundUri);
//        if(ringtone!=null){
//            ringtone.setStreamType(AudioManager.STREAM_ALARM);
//            ringtone.play();
//
//        }

        val intent: Intent
        if (message!!.lowercase(Locale.getDefault()).contains("new")) {
            intent = Intent(this, DefectListActivity::class.java)
            intent.putExtra("status", DefectStatus.OPEN)
        } else {
            intent = Intent(this, DefectDetailsActivity::class.java)
        }
        intent.putExtra("id", id)
        var flags = PendingIntent.FLAG_UPDATE_CURRENT
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
            flags =
                flags or PendingIntent.FLAG_MUTABLE // or FLAG_IMMUTABLE if the intent does not need to be modified
        }
        val pendingIntent =
            TaskStackBuilder.create(this) // add all of DetailsActivity's parents to the stack,
                // followed by DetailsActivity itself
                .addNextIntentWithParentStack(intent)
                .getPendingIntent(0, flags)

        notficationwithsound(
            "defect_others",
            "Defect Notificaitons",
            "Desc",
            title,
            message,
            pendingIntent
        )

        //        NotificationManager notificationManager =(NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
//        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O)
//        {
//            String channelId = "defect";
//            AudioAttributes audioAttributes = new AudioAttributes.Builder()
//                    .setContentType(AudioAttributes.CONTENT_TYPE_SONIFICATION)
//                    .setUsage(AudioAttributes.USAGE_NOTIFICATION)
//                    .build();
//            NotificationChannel channel = new NotificationChannel(
//                    channelId,
//                    "Defect Notificaitons",
//                    NotificationManager.IMPORTANCE_HIGH);
//            channel.setLightColor( Color.GRAY);
//            channel.enableLights(true);
//            channel.setDescription("Desc");
//            channel.setSound(SOUND_URI, audioAttributes);
//            notificationManager.createNotificationChannel(channel);
//        }
//
//
//            Builder notificationBuilder= new Builder(this,"defect").setSmallIcon(R.mipmap.ic_launcher)
//                    .setContentTitle(title)
//                    .setContentText(message)
//                    .setAutoCancel(true)
//                    .setDefaults(Notification.DEFAULT_LIGHTS)
//                    .setSound(SOUND_URI)
//                    .setContentIntent(pendingIntent);
//
//
//        if (notificationManager != null) {
//            notificationManager.notify((int) new Date().getTime(), notificationBuilder.build());
//        }
    }

    private fun show(intent: Intent, title: String, message: String) {
//        Uri defaultSoundUri= RingtoneManager.getDefaultUri(RingtoneManager.TYPE_ALARM);
//        Ringtone ringtone = RingtoneManager.getRingtone(context, defaultSoundUri);
//        if(ringtone!=null){
//            ringtone.setStreamType(AudioManager.STREAM_ALARM);
//            ringtone.play();
//
//        }
        val pendingIntent =
            TaskStackBuilder.create(this) // add all of DetailsActivity's parents to the stack,
                // followed by DetailsActivity itself
                .addNextIntentWithParentStack(intent)
                .getPendingIntent(0, PendingIntent.FLAG_UPDATE_CURRENT)

        val notificationBuilder =
            NotificationCompat.Builder(this, "b2l").setSmallIcon(R.mipmap.ic_launcher)
                .setContentTitle(title)
                .setContentText(message)
                .setAutoCancel(true)
                .setDefaults(Notification.DEFAULT_LIGHTS)
                .setSound(SOUND_URI)
                .setContentIntent(pendingIntent)

        val notificationManager = getSystemService(NOTIFICATION_SERVICE) as NotificationManager

        notificationManager?.notify(Date().time.toInt(), notificationBuilder.build())
    }

    override fun onSendError(s: String, e: Exception) {
        super.onSendError(s, e)
    }

    private fun scheduleJob(taskid: String) {
        val input = Data.Builder()
            .putString("taskid", taskid)
            .build()
        val constraints = Constraints.Builder() // The Worker needs Network connectivity
            .setRequiredNetworkType(NetworkType.CONNECTED) // Needs the device to be charging
            //                .setRequiresCharging(true)
            .build()
        val request =  // Tell which work to execute
            OneTimeWorkRequest.Builder(GetTaskDetails::class.java)
                .setInputData(input) // Sets the input data for the ListenableWorker
                .addTag(Utility.getCurrentDateTime()) // If you want to delay the start of work by 60 seconds
                .setInitialDelay(
                    1,
                    TimeUnit.SECONDS
                ) // Set a backoff criteria to be used when retry-ing
                //                        .setBackoffCriteria(BackoffCriteria.EXPONENTIAL, 30000, TimeUnit.MILLISECONDS)
                // Set additional constraints
                .setConstraints(constraints)
                .build()
        //        FirebaseJobDispatcher dispatcher = new FirebaseJobDispatcher(new GooglePlayDriver(this));
//        Bundle bundle=new Bundle();
//        bundle.putString("taskid",taskid);
//        Job job = dispatcher.newJobBuilder()
//                .setLifetime(Lifetime.FOREVER)
//                .setService(GetTaskDetails.class)
//                .setTag(Utility.getCurrentDateTime())
//                .setExtras(bundle)
//                .setTrigger(Trigger.executionWindow(0, 1))
//                .setConstraints(Constraint.ON_ANY_NETWORK)
//                .build();
//        dispatcher.schedule(job);
    }

    private fun scheduleJob(assignid: String, datetime: String) {
        val input = Data.Builder()
            .putString("assignid", assignid)
            .putString("datetime", datetime)
            .build()
        val constraints = Constraints.Builder() // The Worker needs Network connectivity
            .setRequiredNetworkType(NetworkType.CONNECTED) // Needs the device to be charging
            //                .setRequiresCharging(true)
            .build()
        val request =  // Tell which work to execute
            OneTimeWorkRequest.Builder(GetRequestDetails::class.java)
                .setInputData(input) // Sets the input data for the ListenableWorker
                .addTag(Utility.getCurrentDateTime()) // If you want to delay the start of work by 60 seconds
                .setInitialDelay(
                    1,
                    TimeUnit.SECONDS
                ) // Set a backoff criteria to be used when retry-ing
                //                        .setBackoffCriteria(BackoffCriteria.EXPONENTIAL, 30000, TimeUnit.MILLISECONDS)
                // Set additional constraints
                .setConstraints(constraints)
                .build()
        //        FirebaseJobDispatcher dispatcher = new FirebaseJobDispatcher(new GooglePlayDriver(this));
//        Bundle bundle=new Bundle();
//        bundle.putString("assignid",assignid);
//        bundle.putString("datetime",datetime);
//
//        Job job = dispatcher.newJobBuilder()
//                .setLifetime(Lifetime.FOREVER)
//                .setService(GetRequestDetails.class)
//                .setTag(Utility.getCurrentDateTime())
//                .setExtras(bundle)
//                .setTrigger(Trigger.executionWindow(0, 1))
//                .setConstraints(Constraint.ON_ANY_NETWORK)
//                .build();
//        dispatcher.schedule(job);
    }

    private fun notficationwithsound(
        channelid: String,
        channelname: String,
        channeldescription: String,
        title: String,
        message: String?,
        pendingIntent: PendingIntent?
    ) {
       /* val customSoundUri = Uri.parse(
            ContentResolver.SCHEME_ANDROID_RESOURCE
                    + "://" + packageName + "/" + R.raw.sound2
        )
        val ringtone = RingtoneManager.getRingtone(context, customSoundUri)
        ringtone?.play()*/
        val notificationId = Date().time.toInt()
        val soundUri = RingtoneManager.getDefaultUri(RingtoneManager.TYPE_NOTIFICATION)
        //For API 26+ you need to put some additional code like below:
        val mChannel: NotificationChannel
        val mNotificationManager = getSystemService(NOTIFICATION_SERVICE) as NotificationManager

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            mChannel =
                NotificationChannel(channelid, channelname, NotificationManager.IMPORTANCE_HIGH)
            mChannel.lightColor = Color.GRAY
            mChannel.enableLights(true)
            mChannel.description = channeldescription
            val audioAttributes = AudioAttributes.Builder()
                .setContentType(AudioAttributes.CONTENT_TYPE_SONIFICATION)
                .setUsage(AudioAttributes.USAGE_NOTIFICATION)
                .build()
            mChannel.setSound(soundUri, audioAttributes)

            mNotificationManager?.createNotificationChannel(mChannel)
        }

        var flags = PendingIntent.FLAG_UPDATE_CURRENT
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
            flags =
                flags or PendingIntent.FLAG_MUTABLE // or FLAG_IMMUTABLE if the intent does not need to be modified
        }
        //General code:
        val status = NotificationCompat.Builder(applicationContext, channelid)
        status.setAutoCancel(true)
            .setWhen(System.currentTimeMillis())
            .setSmallIcon(R.mipmap.ic_launcher) //.setOnlyAlertOnce(true)
            .setContentTitle(title)
            .setContentText(message)
            .setVibrate(longArrayOf(0, 500, 1000))
            .setDefaults(Notification.DEFAULT_LIGHTS)
            .setSound(soundUri)
            .setContentIntent(pendingIntent)
        //             .setContent(views);
        mNotificationManager.notify(notificationId, status.build())
    }
}


