package com.b2lmobitech.fieldcloudplus.task.service

import android.app.Notification
import android.app.NotificationChannel
import android.app.NotificationManager
import android.app.PendingIntent
import android.content.Context
import android.content.Intent
import android.graphics.Color
import android.media.AudioAttributes
import android.media.RingtoneManager
import android.net.Uri
import android.os.Build
import androidx.core.app.NotificationCompat
import com.b2lmobitech.fieldcloudplus.R
import com.b2lmobitech.fieldcloudplus.defect.DefectDetailsActivity
import com.b2lmobitech.fieldcloudplus.defect.DefectListActivity
import com.b2lmobitech.fieldcloudplus.defect.DefectStatus
import com.google.firebase.messaging.FirebaseMessagingService.NOTIFICATION_SERVICE
import java.util.Date
import java.util.Locale

object NotificationUtils {

    private fun createDefectNotificationChannel(context: Context, soundUri: Uri) {
        val channelId = "defect"
        val channelName = "Defect Notification Channel"
        val channelDescription = "Defect Notification Channel"

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {

            val channel = NotificationChannel(
                channelId,
                channelName,
                NotificationManager.IMPORTANCE_DEFAULT
            )
            channel.setSound(
                soundUri,
                AudioAttributes.Builder().setUsage(AudioAttributes.USAGE_NOTIFICATION).build()
            )
            channel.enableLights(true)
            channel.description = channelDescription
            val notificationManager = context.getSystemService(NotificationManager::class.java)
            notificationManager.createNotificationChannel(channel)
            val mNotificationManager =
                context.getSystemService(NOTIFICATION_SERVICE) as NotificationManager
            mNotificationManager.createNotificationChannel(channel)
        }
    }

    fun showDefectNotificationWithAlarm(
        id:String,
        title: String,
        message: String?,
        context: Context,
        snoozeCount: Int = 0
    ) {
        /* val customSoundUri = Uri.parse(
             ContentResolver.SCHEME_ANDROID_RESOURCE
                     + "://" + packageName + "/" + R.raw.sound2
         )
         val ringtone = RingtoneManager.getRingtone(context, customSoundUri)
         ringtone?.play()*/


        val notificationId = Date().time.toInt()
        val soundUri = RingtoneManager.getDefaultUri(RingtoneManager.TYPE_ALARM)
        val mNotificationManager =
            context.getSystemService(NOTIFICATION_SERVICE) as NotificationManager
        createDefectNotificationChannel(context,soundUri)

        val acceptIntent = Intent(context, DefectDetailsActivity::class.java)
        acceptIntent.putExtra("notification_id", notificationId)
        acceptIntent.putExtra("status", DefectStatus.OPEN)
        acceptIntent.putExtra("id", id)
        acceptIntent.putExtra("accept", true)

        val snoozeIntent = Intent(context, SnoozeBroadcastReceiver::class.java)
        snoozeIntent.action = "SNOOZE_ACTION"
        snoozeIntent.putExtra("notification_id", notificationId)
        snoozeIntent.putExtra("id", id)
        snoozeIntent.putExtra("title", title)
        snoozeIntent.putExtra("message", message)
        snoozeIntent.putExtra("count", snoozeCount)

        var flags = PendingIntent.FLAG_UPDATE_CURRENT
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
            flags =
                flags or PendingIntent.FLAG_MUTABLE // or FLAG_IMMUTABLE if the intent does not need to be modified
        }
        val status = NotificationCompat.Builder(context, "defect")
        status.setAutoCancel(true)
            .setWhen(System.currentTimeMillis())
            .setSmallIcon(R.mipmap.ic_launcher) //.setOnlyAlertOnce(true)
            .setContentTitle(title)
            .setContentText(message)
            .setOngoing(true)
            .setVibrate(longArrayOf(0, 500, 1000))
            .setDefaults(Notification.DEFAULT_LIGHTS)
            .setSound(soundUri)


        if (snoozeCount < 3) {
            status.setDeleteIntent(PendingIntent.getBroadcast(context, 0, snoozeIntent, flags))
            status.addAction(
                R.drawable.accept,
                "Snooze",
                PendingIntent.getBroadcast(context, 0, snoozeIntent, flags)
            )
        }else{
            status.setDeleteIntent(PendingIntent.getActivity(context, 1, acceptIntent, flags))
        }
        status.addAction(
            R.drawable.decline,
            "Accept",
            PendingIntent.getActivity(context, 1, acceptIntent, flags)
        )
        mNotificationManager.notify(notificationId, status.build())
    }

    fun showSimpleNotification(context: Context,message:String){
        val mNotificationManager =
            context.getSystemService(NOTIFICATION_SERVICE) as NotificationManager
        val channelId = "GENERAL"
        val channelName = "GENERAL Notification Channel"
        val channelDescription = "GENERAL Notification Channel"

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {

            val channel = NotificationChannel(
                channelId,
                channelName,
                NotificationManager.IMPORTANCE_DEFAULT
            )
            channel.enableLights(true)
            channel.description = channelDescription
            val notificationManager = context.getSystemService(NotificationManager::class.java)
            notificationManager.createNotificationChannel(channel)
            mNotificationManager.createNotificationChannel(channel)
        }
        val status = NotificationCompat.Builder(context, "defect")
        status.setAutoCancel(true)
            .setWhen(System.currentTimeMillis())
            .setSmallIcon(R.mipmap.ic_launcher) //.setOnlyAlertOnce(true)
            .setContentTitle("GeoFence")
            .setContentText(message)
            .setVibrate(longArrayOf(0, 500, 1000))
            .setDefaults(Notification.DEFAULT_LIGHTS)
        mNotificationManager.notify(0, status.build())
    }

}