package com.b2lmobitech.fieldcloudplus.task.service;


import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import androidx.core.app.NotificationCompat;
import android.util.Log;

import com.b2lmobitech.fieldcloudplus.R;
import com.b2lmobitech.fieldcloudplus.task.activities.Dashboard;
import com.b2lmobitech.fieldcloudplus.task.encap.TaskEncap;
import com.b2lmobitech.fieldcloudplus.task.enums.TaskEnum;
import com.b2lmobitech.fieldcloudplus.task.sql.Sqlite;

import java.util.ArrayList;

import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;


public class ReminderReceiver extends BroadcastReceiver {

     Sqlite sqldatabase;

    @Override
    public void onReceive(Context context, Intent intent) {

        sqldatabase = new Sqlite(context);
        int late = 0;
        int active = 0;

        try {
            String emailid = context.getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0).getString(globalvariables.logout_emailid, "");

            Log.e("user",emailid);
            ArrayList<TaskEncap> arrayList = sqldatabase.getAllTasks(emailid);

            for (TaskEncap taskEncap : arrayList) {
                if(taskEncap.getEmail_id().equalsIgnoreCase(emailid)) {
                    if (taskEncap.getCategory().equals(TaskEnum.ACTIVE)) {
                        Log.e("active",taskEncap.getTaskname());
                        active++;
                    } else if (taskEncap.getCategory().equals(TaskEnum.LATE)) {
                        Log.e("LATE",taskEncap.getTaskname());
                        late++;
                    }
                }
            }

            int total = late + active;
            if (total != 0) {
                Intent intent1 = new Intent(context, Dashboard.class);
                PendingIntent pIntent = PendingIntent.getActivity(context, 1, intent1,
                        PendingIntent.FLAG_UPDATE_CURRENT);

                // Create Notification using NotificationCompat.Builder
                NotificationCompat.Builder builder = new NotificationCompat.Builder(
                        context, "daily")
                        .setSmallIcon(R.mipmap.ic_launcher)
//                        .setBadgeIconType(R.mipmap.ic_launcher)
                        .setTicker("REMINDER!!")
                        .setContentTitle("Today Tasks")
                        .setContentIntent(pIntent)
                        .setAutoCancel(true);
                if (late == 0) {
                    builder.setContentText("Total : " + total);
                } else {
                    builder.setContentText("Total : " + total + "(" + late + " late)");

                }

                NotificationManager notificationmanager = (NotificationManager) context
                        .getSystemService(Context.NOTIFICATION_SERVICE);
                notificationmanager.notify(1, builder.build());
            }
        }catch (Exception e){
            e.printStackTrace();
        }
        }



}
