package com.b2lmobitech.fieldcloudplus.task.service

import android.app.AlarmManager
import android.app.PendingIntent
import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.util.Log
import androidx.core.app.NotificationManagerCompat


class SnoozeBroadcastReceiver : BroadcastReceiver() {

    override fun onReceive(context: Context, intent: Intent) {
        Log.d("FieldCloud","SnoozeBroadcastReceiver onReceive")
        val notificationId = intent.getIntExtra("notification_id", 0)
        val title = intent.getStringExtra("title")?:""
        val message = intent.getStringExtra("message")?:""
        val id = intent.getStringExtra("id")?:""
        val snoozeCount = intent.getIntExtra("count",0)

        val notificationManager = NotificationManagerCompat.from(context)
        notificationManager.cancel(notificationId)
        // Schedule the same notification to appear after 5 minutes
        val alarmManager = context.getSystemService(Context.ALARM_SERVICE) as AlarmManager
        val triggerAtMillis = System.currentTimeMillis() + ( 1 * 60 * 1000 ) // 1 minutes from now

        val newIntent = Intent(context, NotificationPublisher::class.java).apply {
            putExtra("title", title)
            putExtra("id", id)
            putExtra("message", message)
            putExtra("count", snoozeCount+1)
        }
        val pendingIntent = PendingIntent.getBroadcast(context, notificationId, newIntent, PendingIntent.FLAG_UPDATE_CURRENT or PendingIntent.FLAG_IMMUTABLE)
        alarmManager.set(AlarmManager.RTC_WAKEUP, triggerAtMillis, pendingIntent)
    }
}

class NotificationPublisher : BroadcastReceiver() {

    override fun onReceive(context: Context, intent: Intent) {
        Log.d("FieldCloud","NotificationPublisher onReceive")
        val notificationId = intent.getIntExtra("notification_id", 0)
        val title = intent.getStringExtra("title")?:""
        val id = intent.getStringExtra("id")?:""
        val message = intent.getStringExtra("message")
        val snoozeCount = intent.getIntExtra("count",0)

        // Here you call your method to show the notification again
        if (message != null) {
            NotificationUtils.showDefectNotificationWithAlarm(id,title,message,context,snoozeCount)
        }
    }
}