package com.b2lmobitech.fieldcloudplus.task.service;


import android.content.Context;
import android.database.Cursor;
import android.util.Log;

import androidx.annotation.NonNull;
import androidx.work.Worker;
import androidx.work.WorkerParameters;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import com.b2lmobitech.fieldcloudplus.task.sql.Sqlite;
//import com.firebase.jobdispatcher.JobParameters;
//import com.firebase.jobdispatcher.JobService;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

import com.b2lmobitech.fieldcloudplus.others.sql.Tables.TaskProgress;

/**
 * Created by home on 11/3/2017.
 */

public class UpdateTaskService extends Worker {

    RequestQueue requestQueue;
    private Sqlite sqldatabase;
    JSONArray jsonArray=new JSONArray();
    JSONObject jsonObject;
    public UpdateTaskService(@NonNull Context appContext, @NonNull WorkerParameters params) {
        super(appContext, params);
    }

    @Override
    public Result doWork() {
        // Do your work here.
        requestQueue= Volley.newRequestQueue(getApplicationContext());
        sqldatabase=new Sqlite(getApplicationContext());
        getNonSyncedTasks();

        return null;
    }

    @Override
    public void onStopped() {
        // Cleanup because you are being stopped.
    }
//    @Override
//    public boolean onStartJob(JobParameters job) {
//        requestQueue= Volley.newRequestQueue(this);
//        sqldatabase=new Sqlite(this);
//        getNonSyncedTasks();
//        return true;
//    }

//    @Override
//    public boolean onStopJob(com.firebase.jobdispatcher.JobParameters job) {
//        return false;
//    }

    private void getNonSyncedTasks(){
        Cursor cursor=sqldatabase.getTaskProgress();

        if(cursor!=null){
            cursor.moveToFirst();

            jsonArray=new JSONArray();
            do{
                jsonObject=new JSONObject();

                try {
                    jsonObject.put("local_id", cursor.getString(cursor.getColumnIndexOrThrow(TaskProgress._ID)));
                    jsonObject.put("task_id", cursor.getString(cursor.getColumnIndexOrThrow(TaskProgress.TASKID)));
                    jsonObject.put("employee_id", cursor.getString(cursor.getColumnIndexOrThrow(TaskProgress.EMPLOYEEID)));
                    jsonObject.put("progress_date", cursor.getString(cursor.getColumnIndexOrThrow(TaskProgress.PROGRESSDATE)));
                    jsonObject.put("progress", cursor.getString(cursor.getColumnIndexOrThrow(TaskProgress.PROGRESS)));
                    jsonObject.put("completed_datetime", cursor.getString(cursor.getColumnIndexOrThrow(TaskProgress.COMPLETEDDATETIME)));
                    jsonObject.put("completed_activities", cursor.getString(cursor.getColumnIndexOrThrow(TaskProgress.COMPLETEDACTIVITIES)));
                    jsonObject.put("latitude", cursor.getString(cursor.getColumnIndexOrThrow(TaskProgress.LATITUDE)));
                    jsonObject.put("longitude", cursor.getString(cursor.getColumnIndexOrThrow(TaskProgress.LONGITUDE)));
                    jsonObject.put("camera", cursor.getString(cursor.getColumnIndexOrThrow(TaskProgress.IMAGE)));

                } catch (JSONException e) {
                    e.printStackTrace();
                }
                jsonArray.put(jsonObject);
                syncProgress(jsonArray);

            }while (cursor.moveToNext());
        }


    }

    private void syncProgress(final JSONArray jsonArray){

        StringRequest postRequest = new StringRequest(Request.Method.POST, "http://fieldcloud.in/App/insert_progress.php",
                new Response.Listener<String>()
                {
                    @Override
                    public void onResponse(String response) {
                        // response
                        Log.d("Response", response);
                        try {
                            JSONObject json=new JSONObject(response);

                            int success = json.getInt("success");
                            if (success == 1) {
                                JSONArray jsonArray1=json.getJSONArray("ineserted");
                                for(int i=0; i<jsonArray1.length(); i++){
                                    sqldatabase.updateProgressCompleted(jsonArray1.getString(i));
                                }
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                },
                new Response.ErrorListener()
                {
                    @Override
                    public void onErrorResponse(VolleyError error) {
                        // error
                        Log.d("Error.Response", error.toString());
                    }
                }
        ) {
            @Override
            protected Map<String, String> getParams()
            {
                Map<String, String>  params = new HashMap<String, String>();
                params.put("json", jsonArray.toString());
                return params;
            }
        };

        postRequest.setRetryPolicy(new DefaultRetryPolicy(120 * 1000, 1, 1.0f));
        requestQueue.add(postRequest);

    }


}
