package com.b2lmobitech.fieldcloudplus.task.sql;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;

import com.android.volley.RequestQueue;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.AssignTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.CategoryTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.ClientTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.EmployeeTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.MilestoneTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.ProgressTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.ProjectTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.TagTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.TaskTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.TasklistTable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by home on 3/24/2018.
 */

public class Database {
    private static Database mInstance;
    private RequestQueue mRequestQueue;
    private static Context mContext;
    private static SqliteHelper sqliteHelper;

    private Database(Context context){
        // Specify the application context
        mContext = context;
        // Get the request queue
        sqliteHelper=new SqliteHelper(context);
    }

    public static synchronized Database getInstance(Context context){
        // If Instance is null then initialize new Instance
        if(mInstance == null){
            mInstance = new Database(context);
        }
        // Return MySingleton new Instance
        return mInstance;
    }

    public void insertProjects(JSONArray jsonArray) throws Exception {

        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();

        for(int i=0; i<jsonArray.length(); i++){
            JSONObject jsonObject=jsonArray.getJSONObject(i);
            ContentValues cv = new ContentValues();
            cv.put(ProjectTable.PROJECTID,jsonObject.getString("projectid"));
            cv.put(ProjectTable.PROJECTNAME,jsonObject.getString("projectname"));
            cv.put(ProjectTable.DESCRIPTION,jsonObject.getString("description"));
            cv.put(ProjectTable.STARTDATE,jsonObject.getString("startdate"));
            cv.put(ProjectTable.ENDDATE,jsonObject.getString("enddate"));
            cv.put(ProjectTable.STATUS,jsonObject.getString("status"));
            cv.put(ProjectTable.RESPONSIBLEPERSON,jsonObject.getString("presponsible").toLowerCase());
            cv.put(ProjectTable.CREATEDBY,jsonObject.getString("pcreatedby").toLowerCase());
            cv.put(ProjectTable.CREATEDBYTYPE,jsonObject.getString("createdbytype"));
            cv.put(ProjectTable.CREATEDDATETIME,jsonObject.getString("createdatetime"));
            cv.put(ProjectTable.TAGID,jsonObject.getString("tagid"));
            cv.put(ProjectTable.CATID,jsonObject.getString("catid"));
            cv.put(ProjectTable.CLIENT,jsonObject.getString("client"));
            cv.put(ProjectTable.CLIENTCOMPANYID,jsonObject.getString("clientcompany"));
            cv.put(ProjectTable.UPDATEDATETIME,jsonObject.getString("updateddatetime"));
            cv.put(ProjectTable.DELETED,jsonObject.getString(ProjectTable.DELETED));
            sdb.insertWithOnConflict(ProjectTable.TABLENAME,null, cv,SQLiteDatabase.CONFLICT_REPLACE);
        }
        sdb.close();
    }

    public void insertMilestones(JSONArray jsonArray) throws Exception {

        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();

        for(int i=0; i<jsonArray.length(); i++){
            JSONObject jsonObject=jsonArray.getJSONObject(i);
            ContentValues cv = new ContentValues();
            cv.put(MilestoneTable.PROJECTID,jsonObject.getString("projectid"));
            cv.put(MilestoneTable.MILESTONEID,jsonObject.getString("milestoneid"));
            cv.put(MilestoneTable.DESCRIPTION,jsonObject.getString("description"));
            cv.put(MilestoneTable.NAME,jsonObject.getString("milestonename"));
            cv.put(MilestoneTable.TAG,jsonObject.getString("tag_id"));;
            cv.put(MilestoneTable.STARTDATE,jsonObject.getString("startdate"));
            cv.put(MilestoneTable.ENDDATE,jsonObject.getString("enddate"));
            cv.put(MilestoneTable.RESPONSIBLEPERSON,jsonObject.getString("mresponsible").toLowerCase());
            cv.put(MilestoneTable.CREATEDBY,jsonObject.getString("createdby").toLowerCase());
            cv.put(MilestoneTable.CREATEDBYTYPE,jsonObject.getString("createdbytype"));
            cv.put(MilestoneTable.CREATEDDATETIME,jsonObject.getString("createdatetime"));
            cv.put(MilestoneTable.UPDATEDATETIME,jsonObject.getString("updateddatetime"));
            cv.put(MilestoneTable.DELETED,jsonObject.getString(MilestoneTable.DELETED));
            sdb.insertWithOnConflict(MilestoneTable.TABLENAME,null, cv,SQLiteDatabase.CONFLICT_REPLACE);
        }
        sdb.close();
    }

    public void insertTaskLists(JSONArray jsonArray) throws Exception {

        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();

        for(int i=0; i<jsonArray.length(); i++){
            JSONObject jsonObject=jsonArray.getJSONObject(i);
            ContentValues cv = new ContentValues();
            cv.put(TasklistTable.PROJECTID,jsonObject.getString("projectid"));
            cv.put(TasklistTable.MILESTONEID,jsonObject.getString("milestoneid"));
            cv.put(TasklistTable.TASKLISTID,jsonObject.getString("tasklistid"));
            cv.put(TasklistTable.DESCRIPTION,jsonObject.getString("description"));
            cv.put(TasklistTable.NAME,jsonObject.getString("tasklistname"));
            cv.put(TasklistTable.RESPONSIBLEPERSON,jsonObject.getString("lresponsible").toLowerCase());
            cv.put(TasklistTable.CREATEDBY,jsonObject.getString("createdby").toLowerCase());
            cv.put(TasklistTable.CREATEDBYTYPE,jsonObject.getString("createdbytype"));
            cv.put(TasklistTable.CREATEDDATETIME,jsonObject.getString("createdatetime"));
            cv.put(TasklistTable.UPDATEDATETIME,jsonObject.getString("updateddatetime"));
            cv.put(TasklistTable.DELETED,jsonObject.getString(TasklistTable.DELETED));
            sdb.insertWithOnConflict(TasklistTable.TABLENAME,null, cv,SQLiteDatabase.CONFLICT_REPLACE);
        }
        sdb.close();
    }

    public void insertClients(JSONArray jsonArray) throws Exception {

        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();

        for(int i=0; i<jsonArray.length(); i++){
            JSONObject jsonObject=jsonArray.getJSONObject(i);
            ContentValues cv = new ContentValues();
            cv.put(ClientTable.COMPANYID,jsonObject.getString(ClientTable.COMPANYID));
            cv.put(ClientTable.COMPANYNAME,jsonObject.getString(ClientTable.COMPANYNAME));
            cv.put(ClientTable.ADDRESS,jsonObject.getString(ClientTable.ADDRESS));
            cv.put(ClientTable.WEBADDRESS,jsonObject.getString(ClientTable.WEBADDRESS));
            cv.put(ClientTable.CREATEDBY,jsonObject.getString(ClientTable.CREATEDBY));
            cv.put(ClientTable.RESPONSIBLEPERSON,jsonObject.getString(ClientTable.RESPONSIBLEPERSON));
            cv.put(ClientTable.CREATEDBYTYPE,jsonObject.getString(ClientTable.CREATEDBYTYPE));
            cv.put(ClientTable.CREATEDDATETIME,jsonObject.getString(ClientTable.CREATEDDATETIME));
            cv.put(ClientTable.RESPONSIBLEPERSOSMOBILE,jsonObject.getString(ClientTable.RESPONSIBLEPERSOSMOBILE));
            cv.put(ClientTable.RESPONSIBLEMAIL,jsonObject.getString(ClientTable.RESPONSIBLEMAIL));
            cv.put(ClientTable.CEMAIL,jsonObject.getString(ClientTable.CEMAIL));
            cv.put(ClientTable.CMOBILE,jsonObject.getString(ClientTable.CMOBILE));
            cv.put(ClientTable.CPHONE,jsonObject.getString(ClientTable.CPHONE));
            sdb.insertWithOnConflict(ClientTable.TABLENAME,null, cv,SQLiteDatabase.CONFLICT_REPLACE);
        }
        sdb.close();
    }

    public void insertCategories(JSONArray jsonArray) throws Exception {

        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();

        for(int i=0; i<jsonArray.length(); i++){
            JSONObject jsonObject=jsonArray.getJSONObject(i);
            ContentValues cv = new ContentValues();
            cv.put(CategoryTable.CATID,jsonObject.getString(CategoryTable.CATID));
            cv.put(CategoryTable.CATNAME,jsonObject.getString(CategoryTable.CATNAME));
            cv.put(CategoryTable.CATDESCRIPTION,jsonObject.getString(CategoryTable.CATDESCRIPTION));
            cv.put(CategoryTable.CREATEDBY,jsonObject.getString(CategoryTable.CREATEDBY));
            cv.put(CategoryTable.CREATEDBY,jsonObject.getString(CategoryTable.CREATEDBY));
            cv.put(CategoryTable.CREATEDBYTYPE,jsonObject.getString(CategoryTable.CREATEDBYTYPE));
            cv.put(CategoryTable.CREATEDBY,jsonObject.getString(CategoryTable.CREATEDBY));
            cv.put(CategoryTable.CREATEDDATETIME,jsonObject.getString(CategoryTable.CREATEDDATETIME));
            sdb.insertWithOnConflict(CategoryTable.TABLENAME,null, cv,SQLiteDatabase.CONFLICT_REPLACE);
        }
        sdb.close();
    }

    public void insertTasks(JSONArray jsonArray) throws Exception {

        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();

        for(int i=0; i<jsonArray.length(); i++){
            JSONObject jsonObject=jsonArray.getJSONObject(i);
            ContentValues cv = new ContentValues();
            cv.put(TaskTable.TASKID,jsonObject.getString(TaskTable.TASKID));
            cv.put(TaskTable.NAME,jsonObject.getString(TaskTable.NAME));
            cv.put(TaskTable.DESCRIPTION,jsonObject.getString(TaskTable.DESCRIPTION));
            cv.put(TaskTable.PROJECTID,jsonObject.getString(TaskTable.PROJECTID));
            cv.put(TaskTable.MILESTONEID,jsonObject.getString(TaskTable.MILESTONEID));
            cv.put(TaskTable.LISTTASKID,jsonObject.getString(TaskTable.LISTTASKID));
            cv.put(TaskTable.PROGRESS,jsonObject.getString(TaskTable.PROGRESS));
            cv.put(TaskTable.STARTDATE,jsonObject.getString(TaskTable.STARTDATE));
            cv.put(TaskTable.ENDDATE,jsonObject.getString(TaskTable.ENDDATE));
            cv.put(TaskTable.PRIORITY,jsonObject.getString(TaskTable.PRIORITY));
            cv.put(TaskTable.SEQUENCE,jsonObject.getString(TaskTable.SEQUENCE));
            cv.put(TaskTable.STATUS,jsonObject.getString(TaskTable.STATUS));
            cv.put(TaskTable.TAG,jsonObject.getString(TaskTable.TAG));
            cv.put(TaskTable.CREATEDBY,jsonObject.getString(TaskTable.CREATEDBY).toLowerCase());
            cv.put(TaskTable.CREATEDBYTYPE,jsonObject.getString(TaskTable.CREATEDBYTYPE));
            cv.put(TaskTable.COMPLETEDBY,jsonObject.getString(TaskTable.COMPLETEDBY));
            cv.put(TaskTable.COMPLETEDBYTYPE,jsonObject.getString(TaskTable.COMPLETEDBYTYPE));
            cv.put(TaskTable.COMPLETEDDATETIME,jsonObject.getString(TaskTable.COMPLETEDDATETIME));
            cv.put(TaskTable.STALLEDBY,jsonObject.getString(TaskTable.STALLEDBY));
            cv.put(TaskTable.STALLEDBYTYPE,jsonObject.getString(TaskTable.STALLEDBYTYPE));
            cv.put(TaskTable.STALLEDDATETIME,jsonObject.getString(TaskTable.STALLEDDATETIME));
            cv.put(TaskTable.STALLEDREASON,jsonObject.getString(TaskTable.STALLEDREASON));
            cv.put(TaskTable.TPSTATUS,jsonObject.getString(TaskTable.TPSTATUS));
            cv.put(TaskTable.STOPPEDDATETIME,jsonObject.getString(TaskTable.STOPPEDDATETIME));
            cv.put(TaskTable.ASSIGNEDDATETIME,jsonObject.getString(TaskTable.ASSIGNEDDATETIME));
            cv.put(TaskTable.UPDATEDATETIME,jsonObject.getString(TaskTable.UPDATEDATETIME));
            cv.put(TaskTable.UNDERPTOGRESSDATETIME,jsonObject.getString(TaskTable.UNDERPTOGRESSDATETIME));
            cv.put(TaskTable.CREATEDDATETIME,jsonObject.getString(TaskTable.CREATEDDATETIME));
            cv.put(TaskTable.DELETED,jsonObject.getString(TaskTable.DELETED));
            sdb.insertWithOnConflict(TaskTable.TABLENAME,null, cv,SQLiteDatabase.CONFLICT_REPLACE);
        }
        sdb.close();
    }

    public void insertTags(JSONArray jsonArray) throws Exception {

        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();

        for(int i=0; i<jsonArray.length(); i++){
            JSONObject jsonObject=jsonArray.getJSONObject(i);
            ContentValues cv = new ContentValues();
            cv.put(TagTable.TAGID,jsonObject.getString(TagTable.TAGID));
            cv.put(TagTable.TAGNAME,jsonObject.getString(TagTable.TAGNAME));
            cv.put(TagTable.WEIGHTAGE,jsonObject.getString(TagTable.WEIGHTAGE));
            cv.put(TagTable.CREATEDBY,jsonObject.getString(TagTable.CREATEDBY));
            cv.put(TagTable.CREATEDBYTYPE,jsonObject.getString(TagTable.CREATEDBYTYPE));
            cv.put(TagTable.CREATEDBY,jsonObject.getString(TagTable.CREATEDBY));
            cv.put(TagTable.CREATEDDATETIME,jsonObject.getString(TagTable.CREATEDDATETIME));
            sdb.insertWithOnConflict(TagTable.TABLENAME,null, cv,SQLiteDatabase.CONFLICT_REPLACE);
        }
        sdb.close();
    }

    public void insertEmplyoees(JSONArray jsonArray) throws Exception {

        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();

        for(int i=0; i<jsonArray.length(); i++){
            JSONObject jsonObject=jsonArray.getJSONObject(i);
            ContentValues cv = new ContentValues();
            cv.put(EmployeeTable.NAME,jsonObject.getString("employeename"));
            cv.put(EmployeeTable.EMAILID,jsonObject.getString("emailid").toLowerCase());
            sdb.insertWithOnConflict(EmployeeTable.TABLENAME,null, cv,SQLiteDatabase.CONFLICT_REPLACE);
        }
        sdb.close();
    }

    public void insertAssigns(JSONArray jsonArray) throws Exception {

        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();

        for(int i=0; i<jsonArray.length(); i++){
            JSONObject jsonObject=jsonArray.getJSONObject(i);
            ContentValues cv = new ContentValues();
            cv.put(AssignTable.ASSIGNID,jsonObject.getString(AssignTable.ASSIGNID));
            cv.put(AssignTable.TASKID,jsonObject.getString(AssignTable.TASKID));
            cv.put(AssignTable.EMPLYOEEID,jsonObject.getString(AssignTable.EMPLYOEEID).toLowerCase());
            cv.put(AssignTable.STATUS,jsonObject.getString(AssignTable.STATUS));
            cv.put(AssignTable.ASSIGNEDDATETIME,jsonObject.getString(AssignTable.ASSIGNEDDATETIME));
            cv.put(AssignTable.ARDT,jsonObject.getString(AssignTable.ARDT));
            cv.put(AssignTable.ARLAT,jsonObject.getString(AssignTable.ARLAT));
            cv.put(AssignTable.ARLON,jsonObject.getString(AssignTable.ARLON));
            cv.put(AssignTable.UNDERPTOGRESSDATETIME,jsonObject.getString(AssignTable.UNDERPTOGRESSDATETIME));
            cv.put(AssignTable.ULAT,jsonObject.getString(AssignTable.ULAT));
            cv.put(AssignTable.ULON,jsonObject.getString(AssignTable.ULON));
            cv.put(AssignTable.RSDATETIME,jsonObject.getString(AssignTable.RSDATETIME));
            cv.put(AssignTable.RSREASON,jsonObject.getString(AssignTable.RSREASON));
            cv.put(AssignTable.RSLAT,jsonObject.getString(AssignTable.RSLAT));
            cv.put(AssignTable.RSLON,jsonObject.getString(AssignTable.RSLON));
            cv.put(AssignTable.UPDATEDDATETIME,jsonObject.getString(AssignTable.UPDATEDDATETIME));
            cv.put(AssignTable.DELETED,jsonObject.getString(AssignTable.DELETED));
            sdb.insertWithOnConflict(AssignTable.TABLENAME,null, cv,SQLiteDatabase.CONFLICT_REPLACE);
        }
        sdb.close();
    }

    public void insertProgress(JSONArray jsonArray) throws Exception {

        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();

        for(int i=0; i<jsonArray.length(); i++){
            JSONObject jsonObject=jsonArray.getJSONObject(i);
            ContentValues cv = new ContentValues();
            cv.put(ProgressTable.TASKID,jsonObject.getString(ProgressTable.TASKID));
            cv.put(ProgressTable.BYTYPE,jsonObject.getString(ProgressTable.BYTYPE));
            cv.put(ProgressTable.BY,jsonObject.getString(ProgressTable.BY));
            cv.put(ProgressTable.EMPLOYEE,jsonObject.getString(ProgressTable.EMPLOYEE));
            cv.put(ProgressTable.DATE,jsonObject.getString(ProgressTable.DATE));
            cv.put(ProgressTable.PROGRESS,jsonObject.getString(ProgressTable.PROGRESS));
            cv.put(ProgressTable.ACTIVITIES,jsonObject.getString(ProgressTable.ACTIVITIES));
            cv.put(ProgressTable.IMAGE,jsonObject.getString(ProgressTable.IMAGE));
            cv.put(ProgressTable.DATETIME,jsonObject.getString(ProgressTable.DATETIME));
            sdb.insertWithOnConflict(ProgressTable.TABLENAME,null, cv,SQLiteDatabase.CONFLICT_REPLACE);
        }
        sdb.close();
    }

    public void deleteAllProjects(){
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        sdb.delete(ProjectTable.TABLENAME, "1", null);
        sdb.close();
    }

    public void deleteMilestones(String projectId){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="DELETE FROM "+ MilestoneTable.TABLENAME
                +" WHERE "+ MilestoneTable.PROJECTID+"='"+projectId+"'";
        sdb.rawQuery(query,null);
        sdb.close();
    }

    public void deleteTask(String id){
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        String query="UPDATE "+ TaskTable.TABLENAME +" SET "+TaskTable.DELETED+"='yes'"
                +" WHERE "+ TaskTable.TASKID+"='"+id+"'";
        sdb.rawQuery(query,null);
        sdb.close();
    }

    public void deleteTasklist(String id){
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        String query="UPDATE "+ TasklistTable.TABLENAME +" SET "+TasklistTable.DELETED+"='yes'"
                +" WHERE "+ TasklistTable.TASKLISTID+"='"+id+"'";
        sdb.rawQuery(query,null);
        sdb.close();
    }

    public void deleteMilestone(String id){
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        String query="UPDATE "+ MilestoneTable.TABLENAME +" SET "+MilestoneTable.DELETED+"='yes'"
                +" WHERE "+ MilestoneTable.MILESTONEID+"='"+id+"'";
        sdb.rawQuery(query,null);
        sdb.close();
    }

    public void deleteProject(String id){
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        String query="UPDATE "+ ProjectTable.TABLENAME +" SET "+ProjectTable.DELETED+"='yes'"
                +" WHERE "+ ProjectTable.PROJECTID+"='"+id+"'";
        sdb.rawQuery(query,null);
        sdb.close();
    }

    public void deleteTasklists(String projectId){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="DELETE FROM "+ TasklistTable.TABLENAME
                +" WHERE "+ TasklistTable.PROJECTID+"='"+projectId+"'";
        sdb.rawQuery(query,null);
        sdb.close();
    }

    public JSONArray getProjectsList(){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        JSONArray jsonArray=new JSONArray();
        String query="SELECT * FROM "+ ProjectTable.TABLENAME;
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {

            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                do{
                    try {
                        JSONObject jsonObject=new JSONObject();
                        jsonObject.put("projectid",cursor.getString(cursor.getColumnIndex(ProjectTable.PROJECTID)));
                        jsonObject.put("udatetime",cursor.getString(cursor.getColumnIndex(ProjectTable.UPDATEDATETIME)));
                        jsonArray.put(jsonObject);
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }while (cursor.moveToNext());
            }
            cursor.close();
        }
        return jsonArray;
    }

    public JSONArray getTasksList(String id,boolean byProject){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        JSONArray jsonArray=new JSONArray();

        String query;
        if(byProject){
            query="SELECT * FROM "+ TaskTable.TABLENAME +" WHERE "+TaskTable.PROJECTID+"='"+id+"'";
        }else{
            query="SELECT * FROM "+ TaskTable.TABLENAME +" WHERE "+TaskTable.LISTTASKID+"='"+id+"'";
        }
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {

            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                do{
                    try {
                        JSONObject jsonObject=new JSONObject();
                        jsonObject.put("id",cursor.getString(cursor.getColumnIndex(TaskTable.TASKID)));
                        jsonObject.put("dt",cursor.getString(cursor.getColumnIndex(TaskTable.UPDATEDATETIME)));
                        jsonArray.put(jsonObject);
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }while (cursor.moveToNext());
            }
            cursor.close();
        }
        return jsonArray;
    }

    public JSONArray getTasksListBystatus(String id,String status){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        JSONArray jsonArray=new JSONArray();

        String query="SELECT * FROM "+ TaskTable.TABLENAME +" WHERE "+TaskTable.PROJECTID+"='"+id+"' AND "+TaskTable.STATUS+"='"+status+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {

            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                do{
                    try {
                        JSONObject jsonObject=new JSONObject();
                        jsonObject.put("id",cursor.getString(cursor.getColumnIndex(TaskTable.TASKID)));
                        jsonObject.put("dt",cursor.getString(cursor.getColumnIndex(TaskTable.UPDATEDATETIME)));
                        jsonArray.put(jsonObject);
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }while (cursor.moveToNext());
            }
            cursor.close();
        }
        return jsonArray;
    }

    public JSONArray getTasksByStatus(String id,String status,String employee){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ TaskTable.TABLENAME
                +" LEFT JOIN "+AssignTable.TABLENAME +" ON "+AssignTable.TASKID+"="+TaskTable.TASKID +" AND "+AssignTable.STATUS+"!=('declined' AND 'stalled' AND 'stopped') AND "+AssignTable.DELETED+"='no'"
                +" INNER JOIN "+TasklistTable.TABLENAME + " ON "+TasklistTable.TASKLISTID+"="+TaskTable.LISTTASKID +" AND "+ TasklistTable.DELETED+"='no'"
                +" INNER JOIN "+MilestoneTable.TABLENAME + " ON "+MilestoneTable.MILESTONEID+"="+TasklistTable.MILESTONEID +" AND "+MilestoneTable.DELETED+"='no'"
                +" INNER JOIN "+ProjectTable.TABLENAME + " ON "+ProjectTable.PROJECTID+"="+MilestoneTable.PROJECTID +" AND "+ProjectTable.DELETED+"='no'"
                +" WHERE "+TaskTable.PROJECTID+"='"+id+"' AND "+TaskTable.DELETED+"='no' AND ";
        if(employee!=null){
            query=query+AssignTable.EMPLYOEEID+"='"+employee+"' AND (";
        }else{
            query=query+" ( ";
        }
        if(status.equalsIgnoreCase("underprogress")){
            query=query+TaskTable.STATUS+"='underprogress' AND "+TaskTable.ENDDATE+">='"+DateUtils.getCurrentDate()+"' )";
        }else if(status.equalsIgnoreCase("late")){
            query=query+TaskTable.STATUS+"='underprogress' AND "+TaskTable.ENDDATE+"<'"+DateUtils.getCurrentDate()+"' )";
        }else if(status.equalsIgnoreCase("completed")){
            query=query+TaskTable.STATUS+"='"+status+"' OR ("+TaskTable.STATUS+"='underprogress' AND "+TaskTable.PROGRESS+">89)) ORDER BY "+TaskTable.PROGRESS +" DESC";
        }else{
            query=query+TaskTable.STATUS+"='"+status+"')";
        }
        Cursor cursor = sdb.rawQuery(query,null);
        return cursorToArray(cursor);
    }

    public JSONArray getProjects(){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        JSONArray jsonArray=new JSONArray();
        String query="SELECT * FROM "+ ProjectTable.TABLENAME +" WHERE "+ProjectTable.DELETED+"='no'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                do{
                    try {
                        jsonArray.put(cursorToJson(cursor));
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }while (cursor.moveToNext());
            }
            cursor.close();
        }
        return jsonArray;
    }

    public JSONArray getProjects(String id){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        JSONArray jsonArray=new JSONArray();
        String  query="SELECT * FROM "+ TaskTable.TABLENAME
                +" LEFT JOIN "+ProjectTable.TABLENAME +" ON " +TaskTable.PROJECTID+"="+ProjectTable.PROJECTID
                +" LEFT JOIN "+AssignTable.TABLENAME +" ON " +AssignTable.TASKID+"="+TaskTable.TASKID +" AND "+AssignTable.DELETED+"='no' "
                +" WHERE ("+ProjectTable.RESPONSIBLEPERSON+"='"+id+"' OR " +AssignTable.EMPLYOEEID+"='"+id+"') "
                +" AND "+AssignTable.STATUS+"!=('declined' AND 'stalled' AND 'stopped') AND "+ TaskTable.STATUS+"!=('stopped' AND 'stalled')"
                +" GROUP BY "+ProjectTable.PROJECTID;

        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                do{
                    try {
                        jsonArray.put(cursorToJson(cursor));
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }while (cursor.moveToNext());
            }
            cursor.close();
        }
        return jsonArray;
    }

    public String getProjectResponsible(String projectId){
        return getProjectColumn(projectId,ProjectTable.RESPONSIBLEPERSON);
    }

    public String getProjectName(String projectId){
        return getProjectColumn(projectId,ProjectTable.PROJECTNAME);
    }

    public String getMilestoneName(String id){
        return getMilestoneColumn(id,MilestoneTable.NAME);
    }

    public String getMilestoneColumn(String id,String column){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ MilestoneTable.TABLENAME
                +" WHERE "+MilestoneTable.MILESTONEID+"='"+id+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                return cursor.getString(cursor.getColumnIndex(column));
            }
            cursor.close();
        }
        return "";
    }

    public String getTasklistColumn(String id,String column){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ TasklistTable.TABLENAME
                +" WHERE "+TasklistTable.TASKLISTID+"='"+id+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                return cursor.getString(cursor.getColumnIndex(column));
            }
            cursor.close();
        }
        return "";
    }

    public String getProjectColumn(String id,String column){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ ProjectTable.TABLENAME
                +" WHERE "+ProjectTable.PROJECTID+"='"+id+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                return cursor.getString(cursor.getColumnIndex(column));
            }
            cursor.close();
        }
        return "";
    }

    public String getTaskListName(String id){
        return getTasklistColumn(id,TasklistTable.NAME);
    }

    public String getTaskName(String id){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        JSONArray jsonArray=new JSONArray();
        String query="SELECT * FROM "+ TaskTable.TABLENAME +" WHERE "+TaskTable.TASKID+"='"+id+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                return cursor.getString(cursor.getColumnIndex(TaskTable.NAME));
            }
            cursor.close();
        }
        return "";
    }

    public String getTagName(String id){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ TagTable.TABLENAME +" WHERE "+TagTable.TAGID+"='"+id+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                return cursor.getString(cursor.getColumnIndex(TagTable.TAGNAME));
            }
            cursor.close();
        }
        return "";
    }

    public String getCategoryName(String id){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        JSONArray jsonArray=new JSONArray();
        String query="SELECT * FROM "+ CategoryTable.TABLENAME +" WHERE "+CategoryTable.CATID+"='"+id+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                return cursor.getString(cursor.getColumnIndex(CategoryTable.CATNAME));
            }
            cursor.close();
        }
        return "";
    }

    public String getClientName(String id){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        JSONArray jsonArray=new JSONArray();
        String query="SELECT * FROM "+ ClientTable.TABLENAME +" WHERE "+ClientTable.COMPANYID+"='"+id+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                return cursor.getString(cursor.getColumnIndex(ClientTable.COMPANYNAME));
            }
            cursor.close();
        }
        return "";
    }

    public String getEmployeeName(String id){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ EmployeeTable.TABLENAME +" WHERE "+EmployeeTable.EMAILID+"='"+id+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                if(cursor.getString(cursor.getColumnIndex(EmployeeTable.NAME)).equalsIgnoreCase(Preference.getInstance(mContext).getEmailId())){
                    return "Me";
                }
                return cursor.getString(cursor.getColumnIndex(EmployeeTable.NAME));
            }
            cursor.close();
        }
        return "";
    }

    public JSONArray getUnnasiignedTasks(String id){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        JSONArray jsonArray=new JSONArray();
        String query="SELECT * FROM "+ TaskTable.TABLENAME +" WHERE "+TaskTable.PROJECTID+"='"+id+"' AND "+TaskTable.STATUS+"='unassigned'";
        Cursor cursor = sdb.rawQuery(query,null);
        return cursorToArray(cursor);
    }

    public JSONArray getMilestones(String projectid){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        JSONArray jsonArray=new JSONArray();
        String query="SELECT * FROM "+ MilestoneTable.TABLENAME
                + " LEFT JOIN "+EmployeeTable.TABLENAME+" ON "+EmployeeTable.EMAILID+"="+MilestoneTable.RESPONSIBLEPERSON
                + " WHERE "+MilestoneTable.PROJECTID+"='"+projectid+"' AND "+ MilestoneTable.DELETED+"='no'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                do{
                    try {
                        jsonArray.put(cursorToJson(cursor));
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }while (cursor.moveToNext());
            }
            cursor.close();
        }
        return jsonArray;
    }

    public JSONArray getTaskLists(String projectid){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        JSONArray jsonArray=new JSONArray();
        String query="SELECT * FROM "+ TasklistTable.TABLENAME
                +" INNER JOIN "+EmployeeTable.TABLENAME+" ON "+EmployeeTable.EMAILID+"="+TasklistTable.RESPONSIBLEPERSON
                +" INNER JOIN "+MilestoneTable.TABLENAME+" ON "+MilestoneTable.MILESTONEID+"="+TasklistTable.MILESTONEID
                +" WHERE "+TasklistTable.PROJECTID+"='"+projectid+"'"
                +" AND "+MilestoneTable.DELETED+"='no' AND "+ TasklistTable.DELETED+"='no'"
                +" ORDER BY "+TasklistTable.MILESTONEID+" ASC";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                do{
                    try {
                        jsonArray.put(cursorToJson(cursor));
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }while (cursor.moveToNext());
            }
            cursor.close();
        }
        return jsonArray;
    }

    public JSONArray getProgressList(String id){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        JSONArray jsonArray=new JSONArray();
        String query="SELECT * FROM "+ ProgressTable.TABLENAME
                + " WHERE "+ProgressTable.TASKID+"='"+id+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        return cursorToArray(cursor);
    }

    public JSONArray getMilestonesList(String projectid){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        JSONArray jsonArray=new JSONArray();
        String query="SELECT * FROM "+ MilestoneTable.TABLENAME +" WHERE "+MilestoneTable.PROJECTID+"='"+projectid+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                do{
                    try {
                        JSONObject jsonObject=new JSONObject();
                        jsonObject.put("id",cursor.getString(cursor.getColumnIndex(MilestoneTable.MILESTONEID)));
                        jsonObject.put("dt",cursor.getString(cursor.getColumnIndex(MilestoneTable.UPDATEDATETIME)));
                        jsonArray.put(jsonObject);
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }while (cursor.moveToNext());
            }
            cursor.close();
        }
        return jsonArray;
    }

    public JSONArray getTaskListLists(String projectid){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        JSONArray jsonArray=new JSONArray();
        String query="SELECT * FROM "+ TasklistTable.TABLENAME +" WHERE "+TasklistTable.PROJECTID+"='"+projectid+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                do{
                    jsonArray.put(cursor.getString(cursor.getColumnIndex(TasklistTable.TASKLISTID)));
                }while (cursor.moveToNext());
            }
            cursor.close();
        }
        return jsonArray;
    }

    public JSONArray getAssignedTasks(String tasklist){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ TaskTable.TABLENAME
                + " WHERE "+TaskTable.LISTTASKID+"='"+tasklist+"' AND "+TaskTable.STATUS+"='assigned' ";
        Cursor cursor = sdb.rawQuery(query,null);
        return cursorToArray(cursor);
    }

    //////////////////////////////////////////////////

    public JSONArray getNewTasks(String tasklist,String email){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ TaskTable.TABLENAME
                +" INNER JOIN "+ AssignTable.TABLENAME +" ON "+TaskTable.TASKID+"="+AssignTable.TASKID
                +" WHERE "+TaskTable.LISTTASKID+"='"+tasklist+"' AND "+AssignTable.STATUS+"='YetToAccept' AND " + AssignTable.DELETED+"='no'"
                +" AND "+AssignTable.DELETED+"='no' AND "+TaskTable.DELETED+"='no'";
        if(!email.isEmpty()){
            query=query+" AND "+AssignTable.EMPLYOEEID +"='"+email+"'";
        }
        query=query+" ORDER BY "+AssignTable.ASSIGNEDDATETIME +" ASC";
        Cursor cursor = sdb.rawQuery(query,null);
        return cursorToArray(cursor);
    }

    public JSONArray getPendingTasks(String tasklist,String email){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ TaskTable.TABLENAME
                +" INNER JOIN "+ AssignTable.TABLENAME +" ON "+TaskTable.TASKID+"="+AssignTable.TASKID
                + " WHERE "+TaskTable.LISTTASKID+"='"+tasklist+"' AND (("+TaskTable.STATUS+"='underprogress' AND "+TaskTable.ENDDATE +">='"+ DateUtils.getCurrentDate()+"') "
                + "OR (" +TaskTable.STARTDATE +"<='"+ DateUtils.getCurrentDate()+"' AND "+TaskTable.ENDDATE +">='"+ DateUtils.getCurrentDate()+"' AND " +AssignTable.STATUS+"='accepted' ))"
                +" AND "+AssignTable.DELETED+"='no' AND "+AssignTable.STATUS+"!='YetToAccept' AND "+TaskTable.DELETED+"='no'";
        if(!email.isEmpty()){
            query=query+" AND "+AssignTable.EMPLYOEEID +"='"+email+"'";
        }
        query=query+" ORDER BY "+TaskTable.ENDDATE+","+AssignTable.ASSIGNEDDATETIME+" ASC";

        Cursor cursor = sdb.rawQuery(query,null);
        return cursorToArray(cursor);
    }

    public JSONArray getUpcomingTasks(String tasklist,String email){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ TaskTable.TABLENAME
                +" LEFT JOIN "+ AssignTable.TABLENAME +" ON "+TaskTable.TASKID+"="+AssignTable.TASKID
                +" WHERE "+TaskTable.LISTTASKID+"='"+tasklist+"' AND "+AssignTable.STATUS+"='accepted' AND "
                +TaskTable.STARTDATE +">'"+ DateUtils.getCurrentDate()+"' AND "+TaskTable.PROGRESS+"='0' AND "
                +AssignTable.DELETED+"='no' AND "+TaskTable.DELETED+"='no'";
        if(!email.isEmpty()){
            query=query+" AND "+AssignTable.EMPLYOEEID +"='"+email+"'";
        }
        query=query+" ORDER BY "+TaskTable.STARTDATE+","+AssignTable.ASSIGNEDDATETIME+" ASC";

        Cursor cursor = sdb.rawQuery(query,null);

        return cursorToArray(cursor);
    }

    public JSONArray getCompletedTasks(String tasklist,String email){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ TaskTable.TABLENAME
                +" LEFT JOIN "+ AssignTable.TABLENAME +" ON "+TaskTable.TASKID+"="+AssignTable.TASKID
                + " WHERE "+TaskTable.LISTTASKID+"='"+tasklist+"' AND "+TaskTable.STATUS+"='completed'"
                +" AND "+AssignTable.DELETED+"='no' AND "+TaskTable.DELETED+"='no'";
        if(!email.isEmpty()){
            query=query+" AND "+AssignTable.EMPLYOEEID +"='"+email+"'";
        }
        query=query+" ORDER BY "+TaskTable.COMPLETEDDATETIME +" DESC";

        Cursor cursor = sdb.rawQuery(query,null);
        return cursorToArray(cursor);
    }

    public JSONArray getLateTasks(String tasklist,String email){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        JSONArray jsonArray=new JSONArray();
        String query="SELECT * FROM "+ TaskTable.TABLENAME
                +" INNER JOIN "+ AssignTable.TABLENAME +" ON "+TaskTable.TASKID+"="+AssignTable.TASKID
                + " WHERE "+TaskTable.LISTTASKID+"='"+tasklist+"' AND (("+TaskTable.STATUS+"='underprogress' AND "+TaskTable.ENDDATE +"<'"+ DateUtils.getCurrentDate()+"') "
                +  "OR (" +TaskTable.ENDDATE +"<'"+ DateUtils.getCurrentDate()+"' AND " +AssignTable.STATUS+"='accepted'  ))"
                +" AND "+AssignTable.DELETED+"='no' AND "+TaskTable.DELETED+"='no'";
        if(!email.isEmpty()){
            query=query+" AND "+AssignTable.EMPLYOEEID +"='"+email+"'";
        }
        query=query+" ORDER BY "+TaskTable.ENDDATE+","+AssignTable.ASSIGNEDDATETIME+" ASC";
        Cursor cursor = sdb.rawQuery(query,null);
        return cursorToArray(cursor);
    }

    public JSONArray getTodayTasks(String tasklist,String email){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ TaskTable.TABLENAME
                +" INNER JOIN "+ AssignTable.TABLENAME +" ON "+TaskTable.TASKID+"="+AssignTable.TASKID
                + " WHERE "+TaskTable.LISTTASKID+"='"+tasklist+"' AND (("+TaskTable.STATUS+"='underprogress' AND "+TaskTable.ENDDATE +"='"+ DateUtils.getCurrentDate()+"') "
                +  "OR (" +TaskTable.ENDDATE +"='"+ DateUtils.getCurrentDate()+"' AND " +AssignTable.STATUS+"='accepted'  ))"
                +" AND "+AssignTable.DELETED+"='no' AND "+TaskTable.DELETED+"='no'";
        if(!email.isEmpty()){
            query=query+" AND "+AssignTable.EMPLYOEEID +"='"+email+"'";
        }
        query=query+" ORDER BY "+TaskTable.ENDDATE+","+AssignTable.ASSIGNEDDATETIME +" ASC";
        Cursor cursor = sdb.rawQuery(query,null);
        return cursorToArray(cursor);
    }

    ////////////////////////////////////////////////////

    public JSONObject getTaskDetails(String taskId) throws JSONException {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ TaskTable.TABLENAME
                +" LEFT JOIN "+ AssignTable.TABLENAME +" ON "+TaskTable.TASKID+"="+AssignTable.TASKID+" AND "
                + AssignTable.STATUS +"!=('stopped' AND 'rejected') AND "+AssignTable.DELETED+"='no' "
                +" WHERE "+TaskTable.TASKID+"='"+taskId+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                return cursorToJson(cursor);
            }
            cursor.close();
        }
        return null;
    }

    public JSONObject getAssignDetails(String id) throws JSONException {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ TaskTable.TABLENAME
                +" INNER JOIN "+ AssignTable.TABLENAME +" ON "+TaskTable.TASKID+"="+AssignTable.TASKID
                +" WHERE "+AssignTable.ASSIGNID+"='"+id+"' AND "+AssignTable.STATUS +"!='stopped' AND "+AssignTable.STATUS +"!='rejected'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                return cursorToJson(cursor);
            }
            cursor.close();
        }
        return null;
    }

    public JSONObject getWorkingPerson(String id) throws JSONException {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ TaskTable.TABLENAME
                +" INNER JOIN "+ AssignTable.TABLENAME +" ON "+TaskTable.TASKID+"="+AssignTable.TASKID
                +" WHERE "+TaskTable.TASKID+"='"+id+"' AND "+AssignTable.STATUS +"!='stopped' AND "+AssignTable.STATUS +"!='rejected'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                return cursorToJson(cursor);
            }
            cursor.close();
        }
        return null;
    }

    public JSONObject getMilestoneDetails(String id) throws JSONException {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ MilestoneTable.TABLENAME
                +" WHERE "+MilestoneTable.MILESTONEID+"='"+id+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                return cursorToJson(cursor);
            }
            cursor.close();
        }
        return null;
    }

    public JSONObject getTasklsitDetails(String id) throws JSONException {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ TasklistTable.TABLENAME
                +" WHERE "+TasklistTable.TASKLISTID+"='"+id+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                return cursorToJson(cursor);
            }
            cursor.close();
        }
        return null;
    }

    public JSONObject getTagDetails(String id) throws JSONException {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ TagTable.TABLENAME
                +" WHERE "+TagTable.TAGID+"='"+id+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                return cursorToJson(cursor);
            }
            cursor.close();
        }
        return null;
    }

    public JSONObject getClientDetails(String id) throws JSONException {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ ClientTable.TABLENAME
                +" WHERE "+ClientTable.COMPANYID+"='"+id+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                return cursorToJson(cursor);
            }
            cursor.close();
        }
        return null;
    }

    public JSONObject getCategoryDetails(String id) throws JSONException {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ CategoryTable.TABLENAME
                +" WHERE "+CategoryTable.CATID+"='"+id+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                return cursorToJson(cursor);
            }
            cursor.close();
        }
        return null;
    }

    public JSONObject getProjectDetails(String id) throws JSONException {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ ProjectTable.TABLENAME
                +" WHERE "+ProjectTable.PROJECTID+"='"+id+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                return cursorToJson(cursor);
            }
            cursor.close();
        }
        return null;
    }


  /*  public void deleteFromCart(String productid){
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        String where = CartTable.PRODUCTID+"= ?";
        sdb.delete(CartTable.TABLENAME, where, new String[] { productid });
        if(cartListChanged !=null){
            cartListChanged.listChanged();
        }
    }*/

    public boolean isMilestoneCompleted(String milestoneid){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        boolean isMilestoneCompleted=true;
        String query="SELECT * FROM "+ MilestoneTable.TABLENAME
                + " LEFT JOIN "+TaskTable.TABLENAME+" ON "+TaskTable.MILESTONEID+"="+MilestoneTable.MILESTONEID
                + " WHERE "+TaskTable.MILESTONEID+"='"+milestoneid+"' AND "+TaskTable.STATUS+"!='completed'";

        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null && cursor.getCount() > 0 ) {
            isMilestoneCompleted=false;
            cursor.close();
        }
        return isMilestoneCompleted;
    }

    public boolean isResponsibleForAnyProject(String id){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        boolean isResponsibleForAnyProject=false;
        String query="SELECT * FROM "+ ProjectTable.TABLENAME + " WHERE "+ProjectTable.RESPONSIBLEPERSON+"='"+id+"' ";

        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null && cursor.getCount() > 0 ) {
            isResponsibleForAnyProject=true;
            cursor.close();
        }
        return isResponsibleForAnyProject;
    }

    public boolean isResponsibleForThisProject(String projectid,String emailid){
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query="SELECT * FROM "+ ProjectTable.TABLENAME + " WHERE "+ProjectTable.RESPONSIBLEPERSON+"='"+emailid+"' AND "
                +ProjectTable.PROJECTID+"='"+projectid+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null && cursor.getCount() > 0 ) {
            cursor.close();
            return true;
        }
        return false;
    }

    private static JSONObject cursorToJson(Cursor c) throws JSONException {

        JSONObject retVal = new JSONObject();
        for(int i=0; i<c.getColumnCount(); i++) {
            String cName = c.getColumnName(i);

                switch (c.getType(i)) {
                    case Cursor.FIELD_TYPE_INTEGER:
                        retVal.put(cName, c.getInt(i));
                        break;
                    case Cursor.FIELD_TYPE_FLOAT:
                        retVal.put(cName, c.getFloat(i));
                        break;
                    case Cursor.FIELD_TYPE_STRING:
                        retVal.put(cName, c.getString(i));
                        break;
                    case Cursor.FIELD_TYPE_BLOB:
                        retVal.put(cName, Utility.getString(c.getBlob(i)));
                        break;
                }
        }
        return retVal;
    }

    private static JSONArray cursorToArray(Cursor c) {

        JSONArray jsonArray=new JSONArray();

        if (c != null) {
            if(c.getCount() > 0)
            {
                c.moveToFirst();
                do{
                    try {
                        jsonArray.put(cursorToJson(c));
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }while (c.moveToNext());
            }
            c.close();
        }
        return jsonArray;
    }

}
