package com.b2lmobitech.fieldcloudplus.task.sql;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;

import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.task.encap.Notes;
import com.b2lmobitech.fieldcloudplus.task.encap.NotificationEncap;
import com.b2lmobitech.fieldcloudplus.task.encap.RequestEncap;
import com.b2lmobitech.fieldcloudplus.task.encap.TaskEncap;
import com.b2lmobitech.fieldcloudplus.task.enums.TaskEnum;
import com.b2lmobitech.fieldcloudplus.task.enums.YesNo;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.NotesTable;

import org.json.JSONException;
import org.json.JSONObject;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;

import com.b2lmobitech.fieldcloudplus.others.sql.Tables.TaskNotification;
import com.b2lmobitech.fieldcloudplus.others.sql.Tables.TaskProgress;
import com.b2lmobitech.fieldcloudplus.others.sql.Tables.TaskRequestTable;
import com.b2lmobitech.fieldcloudplus.others.sql.Tables.TaskTable;
import com.b2lmobitech.fieldcloudplus.others.sql.Tables.leavetable;

import static android.content.Context.MODE_PRIVATE;

/**
 * Created by home on 11/21/2017.
 */

public class Sqlite extends SQLiteOpenHelper {

    public static final int DATABASE_VERSION = 3;
    public static final String DATABASE_NAME = "FieldCloudDesk.db3";
    Context context;

    public Sqlite(Context context) {
        super(context, DATABASE_NAME, null, DATABASE_VERSION);
        this.context=context;
    }

    @Override
    public void onCreate(SQLiteDatabase sqLiteDatabase) {

        sqLiteDatabase.execSQL("CREATE TABLE IF NOT EXISTS " + NotesTable.TABLE_NAME + " ("
                + NotesTable._ID + " INTEGER PRIMARY KEY ,"
                + NotesTable.DATETIME + " TEXT,"
                + NotesTable.TITLE + " TEXT,"
                + NotesTable.DESCRIPTION + " TEXT,"
                + "CONSTRAINT request_unique UNIQUE ("+NotesTable.DATETIME+"));");


        // new SqliteHelper(context).onCreate(sqLiteDatabase);
    }

    @Override
    public void onUpgrade(SQLiteDatabase sqLiteDatabase, int i, int i1) {
       // new SqliteHelper(context).onUpgrade(sqLiteDatabase,i,i1);
        sqLiteDatabase.execSQL("CREATE TABLE IF NOT EXISTS " + NotesTable.TABLE_NAME + " ("
                + NotesTable._ID + " INTEGER PRIMARY KEY ,"
                + NotesTable.DATETIME + " TEXT,"
                + NotesTable.TITLE + " TEXT,"
                + NotesTable.DESCRIPTION + " TEXT,"
                + "CONSTRAINT request_unique UNIQUE ("+NotesTable.DATETIME+"));");
    }

    public void insert_task(TaskEncap taskEncap) {
        SQLiteDatabase sdb = getWritableDatabase();
        Log.e("Table","newly inserted");
        try {
            ContentValues cv = new ContentValues();
            cv.put(TaskTable.TASKID, taskEncap.getTaskid());
            cv.put(TaskTable.TASKANME, taskEncap.getTaskname());
            cv.put(TaskTable.LISTTASKID, taskEncap.getListtaskid());
            cv.put(TaskTable.MILESTONEID, taskEncap.getMilestoneid());
            cv.put(TaskTable.PROJECTID, taskEncap.getProjctid());
            cv.put(TaskTable.PROJECTNAME, taskEncap.getProjectname());
            cv.put(TaskTable.STARTDATE,taskEncap.getStartdate());
            cv.put(TaskTable.ENDDATE,taskEncap.getEnddatte());
            cv.put(TaskTable.PROGRESS, taskEncap.getProgress());
            cv.put(TaskTable.DESCRIPTION, taskEncap.getDescription());
            cv.put(TaskTable.PRIORITY, taskEncap.getPriotity());
            cv.put(TaskTable.UPDATEDATETIME, taskEncap.getUpdateddatetime());
            cv.put(TaskTable.DELETED, taskEncap.getPriotity());
            cv.put(TaskTable.ASSIGNID, taskEncap.getAssignid());
            cv.put(TaskTable.T_STATUS, taskEncap.getStatus());
            cv.put(TaskTable.A_STATUS, taskEncap.getAssign_status());
            cv.put(TaskTable.UNDERPTOGRESSDATETIME,taskEncap.getUnderprogressdatetime());
            cv.put(TaskTable.EMAILID,taskEncap.getEmail_id().toLowerCase());
            cv.put(TaskTable.ASSIGNEDDATETIME,taskEncap.getAssigneddatetime());
            cv.put(TaskTable.ONLINESYNC,taskEncap.getOnline_sync());
            cv.put(TaskTable.SEQUENCE,taskEncap.getSequence());
            cv.put(TaskTable.LOCALSYNC, String.valueOf(YesNo.NO));
            sdb.insertWithOnConflict(TaskTable.TABLE_NAME, null, cv, SQLiteDatabase.CONFLICT_REPLACE);

        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        //}


    }

    public boolean taskTableHaveData() throws SQLException {
        SQLiteDatabase sdb = getWritableDatabase();
        Cursor mCursor = sdb.rawQuery("SELECT * FROM "+ TaskTable.TABLE_NAME,null);
        if (mCursor != null) {
            if(mCursor.getCount() > 0)
            {
                return true;
            }
        }
        return false;
    }

    public Cursor get_tasks() throws SQLException {
        SQLiteDatabase sdb = getWritableDatabase();
        Cursor mCursor = sdb.rawQuery("SELECT * FROM "+ TaskTable.TABLE_NAME +" ORDER BY "+TaskTable.PROJECTENDDATE +" DESC",null);

        if (mCursor != null) {
            if(mCursor.getCount() > 0)
            {
                return mCursor;
            }
        }
        return null;
    }

    public ArrayList<TaskEncap> getAllTasks(String emaild){
        ArrayList<TaskEncap> arrayList=new ArrayList<>();

        SQLiteDatabase sdb = getWritableDatabase();
        Cursor cursor = sdb.rawQuery("SELECT * FROM "+ TaskTable.TABLE_NAME,null);

       try {
           if (cursor != null) {
                arrayList=cursor2array(cursor);
               cursor.close();
           }
       }catch (Exception e){
           e.printStackTrace();
       }

        return arrayList;
    }

    public Cursor get_tasks(String projectid,String emailid) throws SQLException {
        SQLiteDatabase sdb = getWritableDatabase();
        Cursor mCursor = sdb.rawQuery("SELECT * FROM "+ TaskTable.TABLE_NAME +" WHERE "+ TaskTable.PROJECTID+"='"+projectid+"' AND "+TaskTable.EMAILID+"='"+emailid+"' ORDER BY assigneddatetime DESC",null);
        if (mCursor != null) {
            if(mCursor.getCount() > 0)
            {
                return mCursor;
            }
        }
        return null;
    }

    public ArrayList<TaskEncap> get_tasks_byproject(String projectid,String emailid) throws SQLException {
        SQLiteDatabase sdb = getWritableDatabase();
        Cursor mCursor = sdb.rawQuery("SELECT * FROM "+ TaskTable.TABLE_NAME +" WHERE "+ TaskTable.PROJECTID+"='"+projectid+"' AND "+TaskTable.EMAILID+"='"+emailid+"' ORDER BY assigneddatetime DESC",null);
        ArrayList<TaskEncap> arrayList=new ArrayList<>();
        if (mCursor != null) {
            try {
                arrayList=cursor2array(mCursor);

            } catch (ParseException e) {
                e.printStackTrace();
            }
            mCursor.close();
        }
        return arrayList;
    }

    public ArrayList<TaskEncap> get_tasks_bylsit(String projectid,String emailid) throws SQLException {
        SQLiteDatabase sdb = getWritableDatabase();
        Cursor mCursor = sdb.rawQuery("SELECT * FROM "+ TaskTable.TABLE_NAME +" WHERE "+ TaskTable.LISTTASKID+"='"+projectid+"' AND "+TaskTable.EMAILID+"='"+emailid+"' ORDER BY assigneddatetime DESC",null);
        ArrayList<TaskEncap> arrayList=new ArrayList<>();
        if (mCursor != null) {
            try {
                arrayList=cursor2array(mCursor);

            } catch (ParseException e) {
                e.printStackTrace();
            }
            mCursor.close();
        }
        return arrayList;
    }



    public Cursor getTask(String taskid) throws SQLException{
        SQLiteDatabase sdb = getWritableDatabase();
        Cursor mCursor = sdb.rawQuery("SELECT * FROM "+ TaskTable.TABLE_NAME+" WHERE "+ TaskTable.TASKID+"='"+taskid+"'",null);
        if (mCursor != null) {
            if(mCursor.getCount() > 0)
            {
                return mCursor;
            }
        }
        return null;
    }

    public ArrayList<TaskEncap> getTaskList(String projectid,String emailid){
        ArrayList<TaskEncap> arrayList=new ArrayList<>();
        SQLiteDatabase sdb = getWritableDatabase();


        return arrayList;
    }

    public ArrayList<TaskEncap> getSingleTask(String taskid){
        ArrayList<TaskEncap> arrayList=new ArrayList<>();
        SQLiteDatabase sdb = getWritableDatabase();
        Cursor cursor = sdb.rawQuery("SELECT * FROM "+ TaskTable.TABLE_NAME+" WHERE "+ TaskTable.TASKID+"='"+taskid+"'",null);
        if (cursor != null) {
            try {
                arrayList=cursor2array(cursor);
            } catch (ParseException e) {
                e.printStackTrace();
            }
            cursor.close();
        }
        return arrayList;
    }


    public void updateTaskProgress(String taskid,String progress,String datetime) {

        SQLiteDatabase sdb = getReadableDatabase();
        ContentValues cv = new ContentValues();
        cv.put(TaskTable.PROGRESS, progress);
        cv.put(TaskTable.UPDATEDATETIME, datetime);
        cv.put(TaskTable.LOCALSYNC,"YES");
        sdb.update(TaskTable.TABLE_NAME, cv , TaskTable.TASKID+ "= ? ", new String[]{taskid});

    }

    public void updateTaskAccepted(String taskid) {

        SQLiteDatabase sdb = getReadableDatabase();
        ContentValues cv = new ContentValues();
        cv.put(TaskTable.T_STATUS, "accepted");
        cv.put(TaskTable.A_STATUS, "accepted");
        sdb.update(TaskTable.TABLE_NAME, cv , TaskTable.TASKID+ "= ? ", new String[]{taskid});

    }

    public void updateProjectDetails(JSONObject jsonObject) throws JSONException {
        SQLiteDatabase sdb = getReadableDatabase();
        ContentValues cv = new ContentValues();
        cv.put(TaskTable.PROJECTDESCRIPTION, jsonObject.getString("p_description"));
        cv.put(TaskTable.PROJECTSTARTDATE, jsonObject.getString("p_start_date"));
        cv.put(TaskTable.PROJECTENDDATE, jsonObject.getString("p_end_date"));
        cv.put(TaskTable.PROJECTNAME, jsonObject.getString("project_name"));

        sdb.update(TaskTable.TABLE_NAME, cv , TaskTable.PROJECTID+ "= ? ", new String[]{jsonObject.getString("project_id")});

    }

    public void updateMilestoneDatails(JSONObject jsonObject) throws JSONException{
        SQLiteDatabase sdb = getReadableDatabase();
        ContentValues cv = new ContentValues();
        cv.put(TaskTable.MILESTONENAME, jsonObject.getString("milestone_name"));
        cv.put(TaskTable.MILESTONEDESCRIPTION, jsonObject.getString("m_description"));
        cv.put(TaskTable.MILESTONEENDDATE, jsonObject.getString("m_end_date"));
        sdb.update(TaskTable.TABLE_NAME, cv , TaskTable.MILESTONEID+ "= ? ", new String[]{jsonObject.getString("milestone_id")});

    }

    public void  updateListtask(JSONObject jsonObject) throws JSONException{
        SQLiteDatabase sdb = getReadableDatabase();
        ContentValues cv = new ContentValues();
        cv.put(TaskTable.LISTTASKNAME, jsonObject.getString("listtask_name"));
        sdb.update(TaskTable.TABLE_NAME, cv , TaskTable.LISTTASKID+ "= ? ", new String[]{jsonObject.getString("listtask_id")});

    }

    public Cursor getTasksNotUpdated() throws SQLException {
        SQLiteDatabase sdb = getWritableDatabase();
        Cursor mCursor = sdb.rawQuery("SELECT * FROM "+ TaskTable.TABLE_NAME+" WHERE "+ TaskTable.LOCALSYNC+"='YES'",null);
        if (mCursor != null) {
            if(mCursor.getCount() > 0)
            {
                return mCursor;
            }
        }
        return null;
    }

    public void updateTaskSynced(String taskid) {
        SQLiteDatabase sdb = getReadableDatabase();
        ContentValues cv = new ContentValues();
        cv.put(TaskTable.LOCALSYNC,"NO");
        sdb.update(leavetable.TABLE_NAME, cv , TaskTable.TASKID+ " = ? ", new String[]{taskid});

    }

    public void deleteAllTasks(){
        SQLiteDatabase db = getWritableDatabase();
        db.execSQL("DROP TABLE IF EXISTS " + TaskTable.TABLE_NAME);
        db.execSQL("CREATE TABLE IF NOT EXISTS " + TaskTable.TABLE_NAME + " ("
                + TaskTable._ID + " INTEGER PRIMARY KEY ,"
                + TaskTable.TASKID + " TEXT,"
                + TaskTable.TASKANME + " TEXT,"
                + TaskTable.LISTTASKID + " TEXT,"
                + TaskTable.LISTTASKNAME + " TEXT,"
                + TaskTable.MILESTONEID + " TEXT,"
                + TaskTable.MILESTONENAME + " TEXT,"
                + TaskTable.MILESTONEENDDATE + " TEXT,"
                + TaskTable.MILESTONEDESCRIPTION + " TEXT,"
                + TaskTable.PROJECTID + " TEXT,"
                + TaskTable.PROJECTNAME + " TEXT,"
                + TaskTable.PROJECTSTARTDATE + " TEXT,"
                + TaskTable.PROJECTENDDATE + " TEXT,"
                + TaskTable.PROJECTDESCRIPTION + " TEXT,"
                + TaskTable.EMAILID + " TEXT,"
                + TaskTable.STARTDATE + " TEXT DEFAULT '0000-00-00',"
                + TaskTable.ENDDATE + " TEXT DEFAULT '0000-00-00',"
                + TaskTable.PROGRESS + " TEXT,"
                + TaskTable.DESCRIPTION + " TEXT,"
                + TaskTable.PRIORITY + " TEXT,"
                + TaskTable.ASSIGNID + " TEXT,"
                + TaskTable.A_STATUS + " TEXT,"
                + TaskTable.T_STATUS + " TEXT,"
                + TaskTable.UNDERPTOGRESSDATETIME + " TEXT DEFAULT '0000-00-00 00:00:00',"
                + TaskTable.ASSIGNEDDATETIME + " TEXT DEFAULT '0000-00-00 00:00:00',"
                + TaskTable.UPDATEDATETIME + " TEXT DEFAULT '0000-00-00 00:00:00',"
                + TaskTable.DELETED + " TEXT,"
                + TaskTable.LOCALSYNC + " TEXT DEFAULT '"+ YesNo.NO+"',"
                + TaskTable.ONLINESYNC + " TEXT,"
                + TaskTable.FAV + " TEXT DEFAULT '"+ YesNo.NO+"',"
                + TaskTable.SEQUENCE + " TEXT,"
                + "CONSTRAINT task_unique UNIQUE ("+TaskTable.ASSIGNID+","+TaskTable.TASKID +"));");
    }

    public void insertTaskProgress(String taskid,String emailid,String progressdate,String progress,String completedactivities,String datetime,String sync,String latitude,String longitude){
        SQLiteDatabase sdb = getWritableDatabase();
        ContentValues cv = new ContentValues();
        cv.put(TaskProgress.TASKID, taskid);
        cv.put(TaskProgress.EMPLOYEEID,emailid);
        cv.put(TaskProgress.PROGRESSDATE,progressdate);
        cv.put(TaskProgress.PROGRESS, progress);
        cv.put(TaskProgress.COMPLETEDACTIVITIES, completedactivities);
        cv.put(TaskProgress.COMPLETEDDATETIME,datetime);
        cv.put(TaskProgress.PROGRESSEDBYTYPE,"user");
        cv.put(TaskProgress.PROGRESSEDBY,"no data available");
        cv.put(TaskProgress.LATITUDE,latitude);
        cv.put(TaskProgress.LONGITUDE,longitude);
        cv.put(TaskProgress.SYNC,sync);
        sdb.insert(TaskProgress.TABLE_NAME,null, cv);
    }

    public void insertTaskProgressWithImage(String taskid,String emailid,String progressdate,String progress,String completedactivities,String datetime,String sync,String latitude,String longitude,String image){
        SQLiteDatabase sdb = getWritableDatabase();
        ContentValues cv = new ContentValues();
        cv.put(TaskProgress.TASKID, taskid);
        cv.put(TaskProgress.EMPLOYEEID,emailid);
        cv.put(TaskProgress.PROGRESSDATE,progressdate);
        cv.put(TaskProgress.PROGRESS, progress);
        cv.put(TaskProgress.COMPLETEDACTIVITIES, completedactivities);
        cv.put(TaskProgress.COMPLETEDDATETIME,datetime);
        cv.put(TaskProgress.IMAGE,image);
        cv.put(TaskProgress.PROGRESSEDBYTYPE,"user");
        cv.put(TaskProgress.PROGRESSEDBY,"no data available");
        cv.put(TaskProgress.LATITUDE,latitude);
        cv.put(TaskProgress.LONGITUDE,longitude);
        cv.put(TaskProgress.SYNC,sync);
        sdb.insert(TaskProgress.TABLE_NAME,null, cv);
    }

    public void insertTaskProgress(JSONObject jsonObject) throws JSONException {
        SQLiteDatabase sdb = getWritableDatabase();

        Cursor isTaskAlreadyInserted = sdb.rawQuery("SELECT * FROM "+ TaskProgress.TABLE_NAME+" WHERE "+ TaskProgress.TASKID+"='"+jsonObject.getString("task_id")+"' AND "+TaskProgress.PROGRESS+"='"+jsonObject.getString("progress")+"' AND "+TaskProgress.COMPLETEDDATETIME+"='"+jsonObject.getString("completed_datetime")+"'",null);
        if (!(isTaskAlreadyInserted != null && isTaskAlreadyInserted.getCount() > 0)) {

            ContentValues cv = new ContentValues();
            cv.put(TaskProgress.TASKID, jsonObject.getString("task_id"));
            cv.put(TaskProgress.EMPLOYEEID, jsonObject.getString("employee_id"));
            cv.put(TaskProgress.PROGRESSDATE, jsonObject.getString("progress_date"));
            cv.put(TaskProgress.PROGRESS, jsonObject.getString("progress"));
            cv.put(TaskProgress.COMPLETEDACTIVITIES, jsonObject.getString("completed_activities"));
            cv.put(TaskProgress.COMPLETEDDATETIME, jsonObject.getString("completed_datetime"));
            cv.put(TaskProgress.PROGRESSEDBY, jsonObject.getString("progress_by"));
            cv.put(TaskProgress.PROGRESSEDBYTYPE, jsonObject.getString("progress_by_type"));
            cv.put(TaskProgress.SYNC, "no");
            sdb.insert(TaskProgress.TABLE_NAME, null, cv);
        }
    }

    public void deleteTask(String assignid){
        SQLiteDatabase sdb = getWritableDatabase();
        sdb.delete(TaskTable.TABLE_NAME , TaskTable.ASSIGNID+ " = ? ", new String[]{assignid});
    }

    public Cursor getTaskProgress(){
        SQLiteDatabase sdb = getWritableDatabase();
        Cursor mCursor = sdb.rawQuery("SELECT * FROM "+ TaskProgress.TABLE_NAME+" WHERE "+ TaskProgress.SYNC+"='yes'",null);
        if (mCursor != null) {
            if(mCursor.getCount() > 0)
            {
                return mCursor;
            }
        }
        return null;
    }

    public Cursor getTaskProgress(String taskid){
        SQLiteDatabase sdb = getWritableDatabase();
        Cursor mCursor = sdb.rawQuery("SELECT * FROM "+ TaskProgress.TABLE_NAME+" WHERE "+ TaskProgress.TASKID+"='"+taskid+"'",null);
        if (mCursor != null) {
            if(mCursor.getCount() > 0)
            {
                return mCursor;
            }
        }
        return null;
    }

    public void updateProgressCompleted(String index){
        SQLiteDatabase sdb = getWritableDatabase();
        ContentValues cv = new ContentValues();
        cv.put(TaskProgress.SYNC,"no");
        cv.put(TaskProgress.IMAGE,"null");
        sdb.update(TaskProgress.TABLE_NAME, cv , TaskProgress._ID+ " = ? ", new String[]{index});
    }

    public void insertTaskRequest(String assignid,String employeeid,String status,String reason,String increasedays,String requestFor,String datetime){

        SQLiteDatabase sdb = getWritableDatabase();
        ContentValues cv = new ContentValues();

        cv.put(TaskRequestTable.ASSIGNID, assignid);
        cv.put(TaskRequestTable.EMPLOYEEID, employeeid);
        cv.put(TaskRequestTable.STATUS, status);
        cv.put(TaskRequestTable.REASON, reason);
        cv.put(TaskRequestTable.INCREASEDAYS, increasedays);
        cv.put(TaskRequestTable.REQUESTDATETIME,datetime);
        sdb.insert(TaskRequestTable.TABLE_NAME,null, cv);
        sdb.insertWithOnConflict(TaskRequestTable.TABLE_NAME, null, cv, SQLiteDatabase.CONFLICT_REPLACE);
    }


    public void insertOrUpdateTaskRequest(RequestEncap requestEncap){
        SQLiteDatabase sdb = getWritableDatabase();
        ContentValues cv = new ContentValues();

            cv.put(TaskRequestTable.ASSIGNID, requestEncap.getAssignid());
            cv.put(TaskRequestTable.EMPLOYEEID, requestEncap.getEmployeeid());
            cv.put(TaskRequestTable.STATUS, requestEncap.getStatus());
            cv.put(TaskRequestTable.REASON, requestEncap.getReason());
            cv.put(TaskRequestTable.INCREASEDAYS, requestEncap.getIncreasedays());
            cv.put(TaskRequestTable.REQUESTDATETIME, requestEncap.getRequestdatetime());
            cv.put(TaskRequestTable.RESPONSE, requestEncap.getResponse());
            cv.put(TaskRequestTable.UPDATEDDATETIME, requestEncap.getUpdateddatetime());
            long l = sdb.insertWithOnConflict(TaskRequestTable.TABLE_NAME, null, cv, SQLiteDatabase.CONFLICT_REPLACE);
    }

    public void insertNotifications(NotificationEncap notificationEncap){
        SQLiteDatabase sdb = getWritableDatabase();
        ContentValues cv = new ContentValues();

        cv.put(TaskNotification.ASSIGNID, notificationEncap.getAssignId());
        cv.put(TaskNotification.TASKID, notificationEncap.getTaskId());
        cv.put(TaskNotification.DATETIME,notificationEncap.getDatetime() );
        cv.put(TaskNotification.TYPE, notificationEncap.getType());
        cv.put(TaskNotification.MESSAGE, notificationEncap.getMessage());

        sdb.insert(TaskNotification.TABLE_NAME, null, cv);
    }

    public void updateNotificationOpened(NotificationEncap notificationEncap){
        SQLiteDatabase sdb = getWritableDatabase();
        ContentValues cv = new ContentValues();
        cv.put(TaskNotification.OPENED,"yes");
        sdb.update(TaskNotification.TABLE_NAME, cv , TaskNotification.TASKID+ " = ? AND " +TaskNotification.ASSIGNID+ " = ? AND "+TaskNotification.DATETIME+ " = ? ", new String[]{notificationEncap.getTaskId(),notificationEncap.getAssignId(),notificationEncap.getDatetime()});
    }

    public void updateRequest(JSONObject jsonObject) throws JSONException {

        SQLiteDatabase sdb = getWritableDatabase();
        ContentValues cv = new ContentValues();

        cv.put(TaskRequestTable.ASSIGNID, jsonObject.getString(""));
        cv.put(TaskRequestTable.STATUS, jsonObject.getString(""));
        cv.put(TaskRequestTable.RESPONSE, jsonObject.getString(""));
        cv.put(TaskRequestTable.INCREASEDAYS, jsonObject.getString(""));
        cv.put(TaskRequestTable.REQUESTFOR,jsonObject.getString(""));
        cv.put(TaskRequestTable.REQUESTDATETIME,jsonObject.getString(""));
        cv.put(TaskRequestTable.REQUESTDATETIME,jsonObject.getString(""));
        sdb.insert(TaskRequestTable.TABLE_NAME,null, cv);

    }

    public Cursor getTaskRequestsList(String projectid){
        SQLiteDatabase sdb = getWritableDatabase();
        String query="SELECT * FROM task_request INNER JOIN task_task ON task_task.assignid=task_request.assignid WHERE projectid='"+projectid+"'";
        Cursor mCursor = sdb.rawQuery(query,null);
        if (mCursor != null) {
            if(mCursor.getCount() > 0)
            {
                return mCursor;
            }
        }
        return null;
    }

    public RequestEncap getTaskRequestDetails(String assignid,String datetime){
        RequestEncap requestEncap=new RequestEncap();
        SQLiteDatabase sdb = getWritableDatabase();
        String query="SELECT * FROM task_request INNER JOIN task_task ON task_task.assignid=task_request.assignid WHERE task_task.assignid='"+assignid+"' AND requestdatetime='"+datetime+"'";
        Cursor cursor = sdb.rawQuery(query,null);
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                requestEncap.setTaskName(cursor.getString(cursor.getColumnIndex(TaskTable.TASKANME)));
                requestEncap.setTaskId(cursor.getString(cursor.getColumnIndex(TaskTable.TASKID)));
                requestEncap.setAssignid(cursor.getString(cursor.getColumnIndex(TaskRequestTable.ASSIGNID)));
                requestEncap.setEmployeeid(cursor.getString(cursor.getColumnIndex(TaskRequestTable.EMPLOYEEID)));
                requestEncap.setStatus(cursor.getString(cursor.getColumnIndex(TaskRequestTable.STATUS)));
                requestEncap.setReason(cursor.getString(cursor.getColumnIndex(TaskRequestTable.REASON)));
                requestEncap.setRequestfor(cursor.getString(cursor.getColumnIndex(TaskRequestTable.REQUESTFOR)));
                requestEncap.setRequestdatetime(cursor.getString(cursor.getColumnIndex(TaskRequestTable.REQUESTDATETIME)));
                requestEncap.setResponse(cursor.getString(cursor.getColumnIndex(TaskRequestTable.RESPONSE)));
                requestEncap.setProjectId(cursor.getString(cursor.getColumnIndex(TaskTable.LISTTASKID)));
                requestEncap.setIncreasedays(cursor.getString(cursor.getColumnIndex(TaskRequestTable.INCREASEDAYS)));
                requestEncap.setUpdateddatetime(cursor.getString(cursor.getColumnIndex(TaskRequestTable.UPDATEDDATETIME)));
                context.getSharedPreferences("projectid", MODE_PRIVATE).edit().putString("projectid", cursor.getString(cursor.getColumnIndex(TaskTable.PROJECTID))).apply();

                return requestEncap;
            }
            cursor.close();
        }
        return null;
    }

    public ArrayList<RequestEncap> getRequestList(String projectid){

        SQLiteDatabase sdb = getWritableDatabase();
        ArrayList<RequestEncap> requestEncaps=new ArrayList<>();
        String query="SELECT * FROM task_request INNER JOIN task_task ON task_task.assignid=task_request.assignid WHERE listtaskid='"+projectid+"' ORDER BY "+TaskRequestTable.REQUESTDATETIME +" DESC";
        Cursor cursor = sdb.rawQuery(query,null);

        int i=0;
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();
                do{
                    i++;
                    RequestEncap requestEncap=new RequestEncap();
                    requestEncap.setTaskName(cursor.getString(cursor.getColumnIndex(TaskTable.TASKANME)));
                    requestEncap.setTaskId(cursor.getString(cursor.getColumnIndex(TaskTable.TASKID)));
                    requestEncap.setAssignid(cursor.getString(cursor.getColumnIndex(TaskRequestTable.ASSIGNID)));
                    requestEncap.setEmployeeid(cursor.getString(cursor.getColumnIndex(TaskRequestTable.EMPLOYEEID)));
                    requestEncap.setStatus(cursor.getString(cursor.getColumnIndex(TaskRequestTable.STATUS)));
                    requestEncap.setReason(cursor.getString(cursor.getColumnIndex(TaskRequestTable.REASON)));
                    //requestEncap.setRequestfor(cursor.getString(cursor.getColumnIndex(TaskRequestTable.REQUESTFOR)));
                    requestEncap.setRequestdatetime(cursor.getString(cursor.getColumnIndex(TaskRequestTable.REQUESTDATETIME)));
                    requestEncap.setResponse(cursor.getString(cursor.getColumnIndex(TaskRequestTable.RESPONSE)));
                    requestEncap.setIncreasedays(cursor.getString(cursor.getColumnIndex(TaskRequestTable.INCREASEDAYS)));
                    requestEncap.setUpdateddatetime(cursor.getString(cursor.getColumnIndex(TaskRequestTable.UPDATEDDATETIME)));
                    try {
                        requestEncaps.add(requestEncap);
                    }catch (Exception e){
                        e.printStackTrace();
                    }
                }while (cursor.moveToNext());
            }
            cursor.close();
        }
        return requestEncaps;
    }

    public Cursor getRequestStatus(String taskid){
        SQLiteDatabase sdb = getWritableDatabase();
        String query="SELECT * FROM task_request INNER JOIN task_task ON task_task.assignid=task_request.assignid WHERE taskid='" +
                taskid+"' and status='pending'";
        Cursor mCursor = sdb.rawQuery(query,null);
        if (mCursor != null) {
            if(mCursor.getCount() > 0)
            {
                return mCursor;
            }
        }
        return null;
    }

    public void deleteTaskRequest(String assign_id,String datetime){
        SQLiteDatabase sdb = getWritableDatabase();
        String where = TaskRequestTable.ASSIGNID+"=? AND "+ TaskRequestTable.REQUESTDATETIME+"=?";
        sdb.delete(TaskRequestTable.TABLE_NAME, where,
                new String[] { assign_id,datetime });
    }

    public void insert_Notes(String title, String Description,String datetime){
        SQLiteDatabase sdb = getWritableDatabase();
        ContentValues cv = new ContentValues();

        cv.put(NotesTable.TITLE,title);
        if(datetime.isEmpty()) {
            cv.put(NotesTable.DATETIME, Utility.getCurrentDateTime());
        }else{
            cv.put(NotesTable.DATETIME, datetime);
        }
        cv.put(NotesTable.DESCRIPTION, Description);
        sdb.insertWithOnConflict(NotesTable.TABLE_NAME, null, cv, SQLiteDatabase.CONFLICT_REPLACE);
    }

    public  ArrayList<Notes> getNotes(){
        ArrayList<Notes> arrayList=new ArrayList<>();
        SQLiteDatabase sdb = getWritableDatabase();
        String query="SELECT * FROM "+NotesTable.TABLE_NAME+" ORDER BY "+NotesTable.DATETIME +" DESC";
        Cursor cursor = sdb.rawQuery(query,null);
        int i=0;
        if (cursor != null) {
            if(cursor.getCount() > 0)
            {
                cursor.moveToFirst();

                do{
                    i++;
                    Notes notes=new Notes();
                    notes.setDatetime(cursor.getString(cursor.getColumnIndex(NotesTable.DATETIME)));
                    notes.setTitle(cursor.getString(cursor.getColumnIndex(NotesTable.TITLE)));
                    notes.setDescription(cursor.getString(cursor.getColumnIndex(NotesTable.DESCRIPTION)));
                    arrayList.add(notes);

                }while (cursor.moveToNext());
            }
            cursor.close();
        }
        return arrayList;
    }

    public void deleteNotes(String datetime){
        SQLiteDatabase sdb = getWritableDatabase();
        sdb.delete(NotesTable.TABLE_NAME , NotesTable.DATETIME+ " = ? ", new String[]{datetime});
    }

    private ArrayList<TaskEncap> cursor2array(Cursor cursor) throws ParseException {
        ArrayList<TaskEncap> arrayList=new ArrayList<>();
        cursor.moveToFirst();
        if(cursor.getCount()==0){
            return arrayList;
        }
        do{
            TaskEncap taskEncap=new TaskEncap();
            taskEncap.setProjctid(cursor.getString(cursor.getColumnIndex(TaskTable.PROJECTID)));
            taskEncap.setTaskid(cursor.getString(cursor.getColumnIndex(TaskTable.TASKID)));
            taskEncap.setTaskname(cursor.getString(cursor.getColumnIndex(TaskTable.TASKANME)));
            taskEncap.setAssignid(cursor.getString(cursor.getColumnIndex(TaskTable.ASSIGNID)));
            taskEncap.setEmail_id(cursor.getString(cursor.getColumnIndex(TaskTable.EMAILID)));
            taskEncap.setProjectname(cursor.getString(cursor.getColumnIndex(TaskTable.PROJECTNAME)));
            taskEncap.setMilestoneid(cursor.getString(cursor.getColumnIndex(TaskTable.MILESTONEID)));
            taskEncap.setMilestonename(cursor.getString(cursor.getColumnIndex(TaskTable.MILESTONENAME)));
            taskEncap.setListtaskid(cursor.getString(cursor.getColumnIndex(TaskTable.LISTTASKID)));
            taskEncap.setListtaskname(cursor.getString(cursor.getColumnIndex(TaskTable.LISTTASKNAME)));
            taskEncap.setAssigneddatetime(cursor.getString(cursor.getColumnIndex(TaskTable.ASSIGNEDDATETIME)));
            taskEncap.setDescription(cursor.getString(cursor.getColumnIndex(TaskTable.DESCRIPTION)));
            taskEncap.setStatus(cursor.getString(cursor.getColumnIndex(TaskTable.T_STATUS)));
            taskEncap.setAssign_status(cursor.getString(cursor.getColumnIndex(TaskTable.A_STATUS)));
            taskEncap.setPriotity(cursor.getString(cursor.getColumnIndex(TaskTable.PRIORITY)));
            taskEncap.setStartdate(cursor.getString(cursor.getColumnIndex(TaskTable.STARTDATE)));
            taskEncap.setEnddatte(cursor.getString(cursor.getColumnIndex(TaskTable.ENDDATE)));
            taskEncap.setUpdateddatetime(cursor.getString(cursor.getColumnIndex(TaskTable.UPDATEDATETIME)));
            taskEncap.setSequence(cursor.getString(cursor.getColumnIndex(TaskTable.SEQUENCE)));
            taskEncap.setOnline_sync(cursor.getString(cursor.getColumnIndex(TaskTable.ONLINESYNC)));
            taskEncap.setProgress(cursor.getString(cursor.getColumnIndex(TaskTable.PROGRESS)));
            taskEncap.setI_progress(Integer.parseInt(taskEncap.getProgress()));
            taskEncap.setD_assigneddatetime(Utility.getDateTime(taskEncap.getAssigneddatetime()));
            taskEncap.setD_startdate(Utility.getDateTime(taskEncap.getStartdate()));
            taskEncap.setD_enddatte(Utility.getDateTime(taskEncap.getEnddatte()));
            taskEncap.setUnderprogressdatetime(cursor.getString(cursor.getColumnIndex(TaskTable.UNDERPTOGRESSDATETIME)));
            taskEncap.setD_updateddatetime(Utility.getDateTime(taskEncap.getUpdateddatetime()));
            taskEncap.setProjectstartdate(cursor.getString(cursor.getColumnIndex(TaskTable.PROJECTSTARTDATE)));
            taskEncap.setProjectenddate(cursor.getString(cursor.getColumnIndex(TaskTable.PROJECTENDDATE)));
            taskEncap.setProjectdescription(cursor.getString(cursor.getColumnIndex(TaskTable.PROJECTDESCRIPTION)));
            taskEncap.setMilestonedescription(cursor.getString(cursor.getColumnIndex(TaskTable.MILESTONEDESCRIPTION)));
            taskEncap.setMilestoneenddate(cursor.getString(cursor.getColumnIndex(TaskTable.MILESTONEENDDATE)));
            int dayend=Utility.daysbetween(taskEncap.getD_enddatte());

            if(taskEncap.getI_progress()==100 && taskEncap.getStatus().equalsIgnoreCase("completed"))
            {
                taskEncap.setCategory(TaskEnum.COMPLETED);
            }else if(taskEncap.getAssign_status().trim().equalsIgnoreCase("yetToAccept")) {
                taskEncap.setCategory(TaskEnum.NEW);
            }else{
                if (dayend!=0 && taskEncap.getD_enddatte().before(new Date())){
                    taskEncap.setCategory(TaskEnum.LATE);
                } else if(taskEncap.getD_startdate().after(new Date()) && taskEncap.getAssign_status().equalsIgnoreCase("accepted")){
                    taskEncap.setCategory(TaskEnum.UPCOMING);
                }else {
                    taskEncap.setCategory(TaskEnum.ACTIVE);
                }
            }

            arrayList.add(taskEncap);
        }while(cursor.moveToNext());

        return arrayList;
    }


}
