package com.b2lmobitech.fieldcloudplus.task.sql;

/**
 * Created by home on 2/8/2018.
 */

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;


import com.b2lmobitech.fieldcloudplus.task.sql.tables.AssignTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.CategoryTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.ClientTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.EmployeeTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.MilestoneTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.ProgressTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.ProjectTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.TagTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.TaskTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.TasklistTable;


public class SqliteHelper extends SQLiteOpenHelper {

    private static final String DATABASE_NAME = "task.db3";
    private static final int DATABASE_VERSION = 2;

    // Variable to hold the database instance
    public SQLiteDatabase db;
    // Context of the application using the database.
    private final Context context;
    // Database open/upgrade helper
    private SqliteHelper dbHelper;

    public SqliteHelper(Context context) {
        super(context, DATABASE_NAME, null, DATABASE_VERSION);
        this.context=context;
    }

    // Called when no database exists in disk and the helper class needs
    // to create a new one.
    @Override
    public void onCreate(SQLiteDatabase _db) {
       createTables(_db);
    }


    // Called when there is a database version mismatch meaning that the version
    // of the database on disk needs to be upgraded to the current version.
    @Override
    public void onUpgrade(SQLiteDatabase _db, int _oldVersion, int _newVersion) {
        dropTables(_db);
        createTables(_db);
    }

    private void createTables(SQLiteDatabase _db){
        try {
            _db.execSQL(ProjectTable.CREATE_TABLE);
            _db.execSQL(ClientTable.CREATE_TABLE);
            _db.execSQL(CategoryTable.CREATE_TABLE);
            _db.execSQL(TagTable.CREATE_TABLE);
            _db.execSQL(MilestoneTable.CREATE_TABLE);
            _db.execSQL(TasklistTable.CREATE_TABLE);
            _db.execSQL(EmployeeTable.CREATE_TABLE);
            _db.execSQL(TaskTable.CREATE_TABLE);
            _db.execSQL(AssignTable.CREATE_TABLE);
            _db.execSQL(ProgressTable.CREATE_TABLE);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    private void dropTables(SQLiteDatabase _db){
        try {
            _db.execSQL("DROP TABLE IF EXISTS "+ProjectTable.TABLENAME);
            _db.execSQL("DROP TABLE IF EXISTS "+ClientTable.TABLENAME);
            _db.execSQL("DROP TABLE IF EXISTS "+CategoryTable.TABLENAME);
            _db.execSQL("DROP TABLE IF EXISTS "+TagTable.TABLENAME);
            _db.execSQL("DROP TABLE IF EXISTS "+MilestoneTable.TABLENAME);
            _db.execSQL("DROP TABLE IF EXISTS "+TasklistTable.TABLENAME);
            _db.execSQL("DROP TABLE IF EXISTS "+EmployeeTable.TABLENAME);
            _db.execSQL("DROP TABLE IF EXISTS "+TaskTable.TABLENAME);
            _db.execSQL("DROP TABLE IF EXISTS "+AssignTable.TABLENAME);
            _db.execSQL("DROP TABLE IF EXISTS "+ProgressTable.TABLENAME);
        }catch (Exception e){
            e.printStackTrace();
        }
    }






}
