package com.b2lmobitech.fieldcloudplus.utils

import java.text.ParseException
import java.text.SimpleDateFormat
import java.util.*






fun getCurrentDateTimeInString():String{
    val date = Calendar.getInstance().time
    return date.toString("yyyy-MM-dd HH:mm:ss")
}

fun getCurrentDateTime():Date{
    return Calendar.getInstance().time
}

fun getTimeBefore(seconds:Int=120):String{
    val date = Date(Calendar.getInstance().timeInMillis - seconds*100)
    return date.toString("yyyy-MM-dd HH:mm:ss")
}

fun String.toDate(format:String=DateConstant.SERVER_DATE_TIME):Date{
    val sdf = SimpleDateFormat(format,Locale.getDefault())
    return  sdf.parse(this)
}




fun String.getTimeOnly():String{

    var date=this.toDate("MM/dd/yyyy HH:mm:ss")

    return date!!.toString("hh:mm a")
}

fun String.getDate():String{

    var date=this.toDate("MM/dd/yyyy HH:mm:ss")

    return date!!.toString(DateConstant.DATE_FORMAT)
}

fun String.getInFormat(format: String):String{

    var date=this.toDate()

    return date!!.toString(format)
}





fun Date.toString(format: String="yyyy-MM-dd HH:mm:ss", locale: Locale = Locale.getDefault()): String {
    val formatter = SimpleDateFormat(format, locale)
    return formatter.format(this)
}

fun Date.string(format: String="dd/MM/yyyy HH:mm:ss", locale: Locale = Locale.getDefault()): String {
    val formatter = SimpleDateFormat(format, locale)
    return formatter.format(this)
}

fun Date.inRequestFormat(): String {
    return this.toString(format = "MM/dd/yyyy HH:mm:ss")
}

fun Date.tomorrow6AM():Date{
    val c = Calendar.getInstance()
    c.time = Date()
    c.add(Calendar.DATE, 1)
    c.set(Calendar.HOUR,6)
    c.set(Calendar.MINUTE,0)
    c.set(Calendar.SECOND,0)
    return c.time
}

fun Calendar.inRequestFormat():String{
    return this.time.toString("MM/dd/yyyy HH:mm:ss")
}

fun Date.diffInSeconds(date:Date): Long {
    val diff=this.time-date.time
    return diff/1000
}


fun Date.diffInReadbleFormat(date:Date): String {
    val diff= date.time-this.time


    val diffSeconds = diff / 1000 % 60
    val diffMinutes = diff / (60 * 1000) % 60
    val diffHours = diff / (60 * 60 * 1000) % 24
    val diffDays = diff / (24 * 60 * 60 * 1000)

    if (diffDays > 0) {
        return "$diffDays day"
    }else if (diffHours >= 1) {
        return "$diffHours hr ${if(diffMinutes != 0L) diffMinutes else ""} "
    }else if (diffMinutes >= 1) {
        return "$diffMinutes min"
    }else {
        return "$diffSeconds sec"
    }
}

fun Date.diffInMinitues(date:Date): Long {
    val diff= date.time-this.time
    return diff / (60 * 1000) % 60
}

fun Date.diffInSeconds(date:String): Long {
    val sdf = SimpleDateFormat(DateConstant.DATE_TIME_FORMAT,Locale.getDefault())
    try {
        return this.diffInSeconds(sdf.parse(date))
    } catch (e: ParseException) {
        return this.diffInSeconds(Calendar.getInstance().time)
    }
}



fun Calendar.format(sdf:String):String{
    return this.time.toString(sdf)
}

fun Calendar.getDateString(df:String="MM/dd/yyyy"):String{

    return this.format(df)
}

fun Calendar.getTimeString():String{
    return this.format("HH:mm:ss")
}