package com.b2lmobitech.fieldcloudplus.utils

import android.app.Activity
import android.content.Context
import android.util.TypedValue
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.inputmethod.InputMethodManager
import android.widget.Toast
import java.text.DecimalFormat
import java.text.ParseException
import java.text.SimpleDateFormat
import java.util.*
import android.opengl.ETC1.getHeight
import android.opengl.ETC1.getWidth
import android.os.Build
import android.graphics.drawable.Drawable
import android.R.attr.fragment
import android.content.res.Configuration
import android.graphics.*
import androidx.annotation.DrawableRes
import androidx.annotation.LayoutRes
import com.google.android.material.snackbar.Snackbar
import androidx.fragment.app.Fragment
import androidx.fragment.app.FragmentManager
import androidx.fragment.app.FragmentTransaction
import androidx.core.content.ContextCompat
import androidx.core.graphics.drawable.DrawableCompat
import androidx.recyclerview.widget.DividerItemDecoration
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import android.util.Base64
import android.util.Log
import java.io.*
import java.lang.reflect.Method
import java.nio.ByteBuffer


fun ViewGroup.inflate(@LayoutRes layout: Int, attachToRoot: Boolean = false): View {
    return LayoutInflater.from(context).inflate(layout, this, attachToRoot)
}

fun View.visible(visible:Boolean=true) {
    if(visible) {
        this.visibility = View.VISIBLE
    }else {
        this.visibility=View.GONE
    }
}

fun View.invisible(invisible:Boolean=true) {
    if(invisible) {
        this.visibility = View.INVISIBLE
    }else{
        this.visibility = View.VISIBLE
    }
}

fun View.hidden() {
    this.visibility = View.GONE
}



fun View.addRipple() = with(TypedValue()) {
    context.theme.resolveAttribute(android.R.attr.selectableItemBackground, this, true)
    setBackgroundResource(resourceId)
}

fun View.hideKeyboard() {
    val manager = context.getSystemService(Context.INPUT_METHOD_SERVICE) as InputMethodManager
    manager.hideSoftInputFromWindow(windowToken, 0)
}


fun Any.toast(context: Context) {
    Toast.makeText(context, this.toString(), Toast.LENGTH_SHORT).show()
}

fun Any.toast(context: Context,vararg args: String) {
    String.format(Locale.getDefault(),this.toString(), args.joinToString(",")).toast(context)
}

fun Any.toast(fragment: androidx.fragment.app.Fragment, vararg args: String) {
    String.format(Locale.getDefault(),this.toString(), args.joinToString(",")).toast(fragment.requireContext())
}

fun Any.toast(fragment: androidx.fragment.app.Fragment) {
    String.format(Locale.getDefault(),this.toString()).toast(fragment.requireContext())
}

fun String.snack(view: View) {
    Snackbar.make(view, this.toString(), Snackbar.LENGTH_SHORT).show()
}

fun Any.snack(activity: Activity) {
    Snackbar.make(activity.window.decorView.rootView, this.toString(), Snackbar.LENGTH_SHORT).show()
}

fun String.welcome(context: Context) {
    ("Welcome, " + this).toast(context)
}

fun String?.orNa(): String {
    return if (this == null || this.isEmpty()) "-NA-" else this
}

fun String.float():String{
    val format = DecimalFormat()
    format.setDecimalSeparatorAlwaysShown(false)
    return format.format(this)
}

fun Float.string():String{
    val format = DecimalFormat("#.##")
    format.setDecimalSeparatorAlwaysShown(false)
    return format.format(this)
}

fun Double.string():String{
    val format = DecimalFormat("#.##")
    format.setDecimalSeparatorAlwaysShown(false)
    return format.format(this)
}



fun androidx.recyclerview.widget.RecyclerView.setManager(context: Context, horizontal:Boolean=false, reverse:Boolean=false){
    if(horizontal){
        this.layoutManager= androidx.recyclerview.widget.LinearLayoutManager(context, androidx.recyclerview.widget.LinearLayoutManager.HORIZONTAL, reverse)
    }else{
        this.layoutManager= androidx.recyclerview.widget.LinearLayoutManager(context)
    }
}

fun Calendar.getPreviousDate():Calendar{
        val temp:Calendar = Calendar.getInstance()
        temp.time = this.time
        temp.set(Calendar.DAY_OF_MONTH,temp.get(Calendar.DAY_OF_MONTH) - 1)
        return temp
}

fun Calendar.getPreviousMonth():Calendar{
    val temp:Calendar = Calendar.getInstance()
    temp.time = this.time
    temp.set(Calendar.MONTH,temp.get(Calendar.MONTH) - 1)
    return temp
}

fun Calendar.getPreviousYear():Calendar{
    val temp:Calendar = Calendar.getInstance()
    temp.time = this.time
    temp.set(Calendar.YEAR,temp.get(Calendar.YEAR) - 1)
    return temp
}

fun Calendar.getTempInstance():Calendar{
    val temp:Calendar = Calendar.getInstance()
    temp.time = this.time
    return temp
}



fun androidx.recyclerview.widget.RecyclerView.addDivider(context: Context, horizontal:Boolean=false, reverse:Boolean=false){

    if(!horizontal){
        this.addItemDecoration(androidx.recyclerview.widget.DividerItemDecoration(context, androidx.recyclerview.widget.DividerItemDecoration.VERTICAL))
    }else{
        this.addItemDecoration(androidx.recyclerview.widget.DividerItemDecoration(context, androidx.recyclerview.widget.DividerItemDecoration.HORIZONTAL))
    }
}

fun Int.getBitmap(context: Context): Bitmap {
    var drawable = ContextCompat.getDrawable(context, this)
    if (Build.VERSION.SDK_INT < Build.VERSION_CODES.LOLLIPOP) {
        drawable = DrawableCompat.wrap(drawable!!).mutate()
    }

    val bitmap = Bitmap.createBitmap(drawable!!.intrinsicWidth,
            drawable.intrinsicHeight, Bitmap.Config.ARGB_8888)
    val canvas = Canvas(bitmap)
    drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight())
    drawable.draw(canvas)

    return bitmap
}

fun Bitmap.updateColor(color:Int):Bitmap{
    var bitmap = this.copy(this.config ?: Bitmap.Config.ARGB_8888,true);
    val paint = Paint()
    val filter = LightingColorFilter(color, 1)
    paint.setColorFilter(filter)
    val canvas = Canvas(bitmap)
    canvas.drawBitmap(bitmap, 0f, 0f, paint)
    return bitmap
}

fun Context.isTablet():Boolean{
   return (this.getResources().getConfiguration().screenLayout + Configuration.SCREENLAYOUT_SIZE_MASK ) >= Configuration.SCREENLAYOUT_SIZE_XLARGE
}

fun Bitmap.toByteArray(): ByteArray {
    val size = this.getRowBytes() * this.getHeight()
    val byteBuffer = ByteBuffer.allocate(size)
    this.copyPixelsToBuffer(byteBuffer)
    return byteBuffer.array()
}

fun File.toBitmap():Bitmap?{
    try { // Decode image size
        val o = BitmapFactory.Options()
        o.inJustDecodeBounds = true
        BitmapFactory.decodeStream(FileInputStream(this), null, o)
        o.inSampleSize = 4
        o.inJustDecodeBounds = false
        //---
        val imgbmp = BitmapFactory.decodeStream(FileInputStream(this), null, o)
        return imgbmp
    } catch (e: Exception) {
        return null
    }
}

fun File.toBase64String():String?{
    if (this.exists() && this.length() > 0) {
        val o = BitmapFactory.Options()
        o.inJustDecodeBounds = true
        BitmapFactory.decodeStream(FileInputStream(this), null, o)
        o.inSampleSize = 3
        o.inJustDecodeBounds = false
        val bm = BitmapFactory.decodeStream(FileInputStream(this), null, o) //o2

        val bOut = ByteArrayOutputStream()
        bm!!.compress(Bitmap.CompressFormat.JPEG, 90, bOut)
        return  Base64.encodeToString(bOut.toByteArray(), Base64.DEFAULT)
    }else{
        return null
    }
}

private fun decodemyFile(f: File?): Bitmap? {
    try { // Decode image size
        val o = BitmapFactory.Options()
        o.inJustDecodeBounds = true
        BitmapFactory.decodeStream(FileInputStream(f), null, o)
        o.inSampleSize = 4
        o.inJustDecodeBounds = false
        //---
        val imgbmp = BitmapFactory.decodeStream(FileInputStream(f), null, o) //o2
        val stream = ByteArrayOutputStream()
        //bmp.creates
        imgbmp?.compress(Bitmap.CompressFormat.JPEG, 80, stream)
        val byteArray = stream.toByteArray()
        try { //convert file into array of bytes
            val fileOuputStream = FileOutputStream(f) //outputfile
            fileOuputStream.write(byteArray)
            fileOuputStream.flush()
            fileOuputStream.close()
        } catch (e: Exception) {
            e.printStackTrace()
            Log.e("result erroe", e.toString())
        }
        return imgbmp
    } catch (e: FileNotFoundException) {
        return null
    }
    // return null;
}








