<?php
    include('session_timeout.php');
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <link rel="shortcut icon" href="../img/icon.png" type="image/x-icon">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Tundra Play</title>

    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
    <link rel="stylesheet" href="/tundra_play/assets/plugins/fontawesome-free/css/all.min.css">
    <link rel="stylesheet" href="/tundra_play/assets/plugins/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="/tundra_play/assets/custom_css/root_styles.css">
    <link rel="stylesheet" href="/tundra_play/assets/custom_css/home_styles.css">
</head>
<body class="hold-transition sidebar-collapse">

    <div class="wrapper">
        
        <nav class="main-header navbar navbar-expand navbar-light p-0">
            <ul class="navbar-nav">
                <li class="nav-item ml-2">
                    <a class="nav-link" id="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
                </li>
                <li class="nav-item mobile-responsive">
                    <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
                </li>
                <li class="nav-item d-none d-sm-inline-block">
                    <a onclick="SideMenuFunction(0)" class="nav-link">Home</a>
                </li>
            </ul>
            <ul class="navbar-nav ml-auto align-items-center profiledetails">
                <li class="nav-item d-flex flex-column align-items-end mr-2 text-right" style="color: #707478;">
                    <span class="font-weight-bold" style="font-size: 0.9rem; line-height: 1;">admin@gmail.com</span>
                    <!-- <small class="text-muted" style="font-size: 0.75rem; line-height: 1;margin-top:4%">admin@gmail.com</small> -->
                </li>
                <li class="nav-item dropdown">
                    <a class="nav-link d-flex align-items-center" href="#" id="profileDropdown" data-toggle="dropdown" aria-expanded="false">
                        <img src="/tundra_play/assets/images/user-icon.png" alt="User" class="rounded-circle" width="30" height="30">
                        <i class="fas fa-chevron-down ml-2 mr-2 text-muted" style="font-size: 0.7rem;"></i> 
                    </a>

                    <div class="dropdown-menu dropdown-menu-right border-0 mr-2" aria-labelledby="profileDropdown" style="min-width: 230px; border-radius: 10px;">
                        <a href="#" class="dropdown-item">
                            <i class="fas fa-user mr-2 text-primary"></i> My Profile
                        </a>
                        <div class="dropdown-divider"></div>
                        <a href="logout.php" class="dropdown-item text-danger">
                            <i class="fas fa-sign-out-alt mr-2"></i> Logout
                        </a>
                    </div>
                </li>
            </ul>
        </nav>
        
        <div class="b2l-menu">
            <div class="logo-item">
                <a class="brandlogo" href="/Project_Mgt/index_main.php">
                    <img src="/tundra_play/assets/images/b2lmobitech_logo.png">
                </a>
            </div>

            <!-- Dashboard -->
            <div class="menu-item">
                <a class="nav-link" data-toggle="collapse" onclick="SideMenuFunction(0)">
                    <img src="/tundra_play/assets/images/icons/icon_dashboard.png" class="sidemenu-img">
                    <span>Dashboard</span>
                </a>
            </div>

            <!-- Library -->
            <div class="menu-item">
                <a class="nav-link" data-toggle="collapse">
                    <i class="fa fa-angle-right"></i>
                    <img src="/tundra_play/assets/images/icons/icon_projects.png" class="sidemenu-img">
                    <span>Library</span>
                </a>
                <div class="collapse submenu">
                    <ul>
                        <li><a onclick="SideMenuFunction(0)">Content</a></li>
                    </ul>
                </div>
            </div>

            <!-- Monetization -->
            <div class="menu-item">
                <a class="nav-link" data-toggle="collapse">
                    <i class="fa fa-angle-right"></i>
                    <img src="/tundra_play/assets/images/icons/icon_monetization.png" class="sidemenu-img">
                    <span>Monetization</span>
                </a>
                <div class="collapse submenu">
                    <ul>
                        <li><a onclick="SideMenuFunction(0)">Advertisements</a></li>
                        <li><a onclick="SideMenuFunction(13)">Subscriptions</a></li>
                    </ul>
                </div>
            </div>

            <!-- Users -->
            <div class="menu-item">
                <a class="nav-link" data-toggle="collapse" onclick="SideMenuFunction(1)">
                    <img src="/tundra_play/assets/images/icons/icon_users.png" class="sidemenu-img">
                    <span>Users</span>
                </a>
            </div>

            <!-- Settings -->
            <div class="menu-item">
                <a class="nav-link" data-toggle="collapse">
                    <i class="fa fa-angle-right"></i>
                    <img src="/tundra_play/assets/images/icons/icon_settings.png" class="sidemenu-img">
                    <span>Settings</span>
                </a>
                <div class="collapse submenu">
                    <ul>
                        <li>
                            <a class="sub-toggle">Content <i class="fa fa-angle-right"></i></a>
                            <div class="collapse sub-submenu">
                                <ul>
                                    <li><a onclick="SideMenuFunction(3)">Content Types</a></li>
                                    <li><a onclick="SideMenuFunction(4)">Genres</a></li>
                                    <li><a onclick="SideMenuFunction(5)">Certificates</a></li>
                                    <li><a onclick="SideMenuFunction(6)">Moods</a></li>
                                    <li><a onclick="SideMenuFunction(7)">Pace</a></li>
                                    <li><a onclick="SideMenuFunction(8)">Target Audience</a></li>
                                    <li><a onclick="SideMenuFunction(9)">Violence Level</a></li> 
                                    <li><a onclick="SideMenuFunction(10)">Resolutions</a></li> 
                                    <li><a onclick="SideMenuFunction(11)">Devices</a></li> 
                                    <li><a onclick="SideMenuFunction(12)">Age Ratings</a></li> 
                                </ul>
                            </div>
                        </li>
                        <li><a onclick="SideMenuFunction(14)">Encoding</a></li>
                    </ul>
                </div>
            </div>
        </div>
        
        <div class="content-wrapper">
            <?php
                $page = (isset($_GET['page'])) ? $_GET['page'] : "0"; 
                if ($page == "0") {
                    $srcurl="dashboard.php";
                } else if ($page == "1") {
                    $srcurl="users/user_list.php";
                } else if ($page == "2") {
                    $srcurl="settings/subscription_list.php";
                } else if ($page == "3") {
                    $srcurl="settings/contenttype_list.php";
                } else if ($page == "4") {
                    $srcurl="settings/genre_list.php";
                } else if ($page == "5") {
                    $srcurl="settings/certificate_list.php";
                } else if ($page == "6") {
                    $srcurl="settings/mood_list.php";
                } else if ($page == "7") {
                    $srcurl="settings/pace_list.php";
                } else if ($page == "8") {
                    $srcurl="settings/target_list.php";
                } else if ($page == "9") {
                    $srcurl="settings/violence_list.php";
                } else if ($page == "10") {
                    $srcurl="settings/resolution_list.php";
                } else if ($page == "11") {
                    $srcurl="settings/device_list.php";
                } else if ($page == "12") {
                    $srcurl="settings/agerating_list.php";
                } else if ($page == "13") {
                    $srcurl="settings/subscription_list.php";
                } else if ($page == "14") {
                    $srcurl="settings/encoding_list.php";
                } else {
                    $srcurl="dashboard.php";
                }
            ?>
            <iframe src="<?php echo $srcurl; ?>" name="iframe_a" id="iframe_id"></iframe>
        </div>

    </div>

    <script src="/tundra_play/assets/plugins/jquery/jquery.min.js"></script>
    <script src="/tundra_play/assets/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>

    <script>	

        function SideMenuFunction(url) {
            var check = url;
            if (check == "0") {
                $("#iframe_id").attr("src", "dashboard.php");
            } else if (check == "1") {
                $("#iframe_id").attr("src", "users/user_list.php");
            } else if (check == "2") {
                $("#iframe_id").attr("src", "settings/subscription_list.php");
            } else if (check == "3") {
                $("#iframe_id").attr("src", "settings/contenttype_list.php");
            } else if (check == "4") {
                $("#iframe_id").attr("src", "settings/genre_list.php");
            } else if (check == "5") {
                $("#iframe_id").attr("src", "settings/certificate_list.php");
            } else if (check == "6") {
                $("#iframe_id").attr("src", "settings/mood_list.php");
            } else if (check == "7") {
                $("#iframe_id").attr("src", "settings/pace_list.php");
            } else if (check == "8") {
                $("#iframe_id").attr("src", "settings/target_list.php");
            } else if (check == "9") {
                $("#iframe_id").attr("src", "settings/violence_list.php");
            } else if (check == "10") {
                $("#iframe_id").attr("src", "settings/resolution_list.php");
            } else if (check == "11") {
                $("#iframe_id").attr("src", "settings/device_list.php");
            } else if (check == "12") {
                $("#iframe_id").attr("src", "settings/agerating_list.php");
            } else if (check == "13") {
                $("#iframe_id").attr("src", "settings/subscription_list.php");
            } else if (check == "14") {
                $("#iframe_id").attr("src", "settings/encoding_list.php");
            } else {
                $("#iframe_id").attr("src", "dashboard.php");
            }
            var queryParams = new URLSearchParams(window.location.search);
            queryParams.set("page", check);
            history.replaceState(null, null, "?"+queryParams.toString());
            
            $("body").toggleClass('sidebar-collapse');

            updateSidebarState();
        }

        function updateSidebarState_old() {
            if ($('body').hasClass('sidebar-collapse')) {
                $('.b2l-menu').css('width', '0');
                $(".profiledetails")
                    .removeClass('profiledetails-normal')
                    .addClass('profiledetails-collapsed');
                $('.content-wrapper, .main-footer, .main-header').css('margin-left', '0');
            } else {
                $('.b2l-menu').css('width', '200px');
                $(".profiledetails")
                    .removeClass('profiledetails-collapsed')
                    .addClass('profiledetails-normal');
                $('.content-wrapper, .main-footer, .main-header').css('margin-left', '200px');
            }
        }

        function updateSidebarState() {
            if ($('body').hasClass('sidebar-collapse')) {
                $('.b2l-menu').css('width', '90px');
                $('.b2l-menu .nav-link').css('flex-direction', 'column');
                $('.b2l-menu .nav-link span, .b2l-menu .nav-link .sidemenu-img').addClass('active');
                $('.b2l-menu .fa-angle-right').hide();
                $('.content-wrapper, .main-footer, .main-header').css('margin-left', '90px');
                $(".profiledetails").removeClass('profiledetails-normal').addClass('profiledetails-collapsed');
                $('.b2l-menu .submenu').collapse('hide');
                $('.b2l-menu .sub-submenu').collapse('hide');
                $('.b2l-menu .nav-link').removeClass('active-mainmenu');
                $('.b2l-menu .sub-toggle').removeClass('active-submenu'); 
            } else {
                $('.b2l-menu').css('width', '200px');
                $('.b2l-menu .nav-link').css('flex-direction', 'row');
                $('.b2l-menu .nav-link span, .b2l-menu .nav-link .sidemenu-img').removeClass('active');
                $('.b2l-menu .fa-angle-right').show();
                $('.content-wrapper, .main-footer, .main-header').css('margin-left', '200px');
                $(".profiledetails").removeClass('profiledetails-collapsed').addClass('profiledetails-normal');
            }
        }

        $(document).ready(function() {

            $('#pushmenu').on('click', function(e) {
                e.preventDefault();
                $("body").toggleClass('sidebar-collapse');
                updateSidebarState();
            });

            updateSidebarState();
            
        });

    </script>

    <script>

        $('.b2l-menu').on('click', '.nav-link', function(e) {
            $('.b2l-menu .nav-link').removeClass('active');
            const $this = $(this);
            const $mainmenu = $this.next('.submenu');
            if ($mainmenu.length === 0) {
                return true;
            }
            e.preventDefault();
            const isActive = $this.hasClass('active-mainmenu');
            if ($('body').hasClass('sidebar-collapse')) {
                $('body').removeClass('sidebar-collapse');
                updateSidebarState();
            }
            $('.b2l-menu .nav-link').removeClass('active-mainmenu');
            $('.b2l-menu > .menu-item .submenu').not($mainmenu).collapse('hide');
            if (!isActive) {
                $this.addClass('active-mainmenu');
                $mainmenu.collapse('show');
                $this.addClass('active');
            } else {
                $mainmenu.collapse('hide');
            }
        });

        // Sub-submenu toggle + highlight parent
        $('.b2l-menu').on('click', '.sub-toggle', function (e) {
            e.preventDefault();
            e.stopPropagation(); 
            const $submenu = $(this).next('.sub-submenu'); 
            $('.b2l-menu .submenu ul li .sub-toggle').not(this).removeClass('active-submenu');
            $('.b2l-menu .sub-submenu').not($submenu).collapse('hide');
            $(this).toggleClass('active-submenu');
            $submenu.collapse('toggle');
        });

        // When any sub-submenu link is clicked, close others
        $('.b2l-menu').on('click', '.sub-submenu ul li a', function () {
            $('.sub-submenu').collapse('hide');
            $('.submenu ul li .sub-toggle').removeClass('active-submenu');
        });

    </script>

</body>
</html>