<?php
    session_start(); 
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <link rel="shortcut icon" href="../img/icon.png" type="image/x-icon">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Tundra Play</title>

    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
    <link rel="stylesheet" href="/tundra_play/assets/plugins/fontawesome-free/css/all.min.css">
    <link rel="stylesheet" href="/tundra_play/assets/plugins/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="/tundra_play/assets/custom_css/root_styles.css">

    <style>
        body {
            background: #f2f2f2;
            font-family: var(--regular-font);
        }
    </style>
    <style>
        .signup-container {
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            position: relative;
            overflow: hidden;
            background: linear-gradient(135deg, #323236ff, #878787ff, #cececeff);
        }
        .form-section {
            background: #f2f2f2;
            padding: 2rem;
            width: 100%;
        }
        @media (max-width: 768px) {
            .form-section {
                position: fixed;
                z-index: 10;
                top: 0;
                left: 0;
                max-width: 100%;
                margin: auto;
                border-radius: 0px;
                min-height: 100vh;
                display: flex;
                justify-content: center;
                flex-direction: column;
            }
        }
        @media (min-width: 769px) {
            .form-section {
                position: relative;
                width: 100%;
                margin: auto;
                border-radius: 0px;
                height: 100%;
            }
        }
        .btn-outline-secondary {
            border-radius: 8px;
            border: 1px solid rgb(196, 196, 197);
            color: rgb(113, 113, 114);
        }
        .divider {
            text-align: center;
            position: relative;
            margin: 20px 0;
        }
        .divider::before, .divider::after {
            content: '';
            position: absolute;
            top: 50%;
            width: 32%;
            height: 1px;
            background: #ccc;
        }
        .divider::before {
            left: 0;
        }
        .divider::after {
            right: 0;
        }
        .divider span {
            padding: 0 10px;
            background: #fff;
            color: #888;
        }
        .temp-ad h2 {
            font-size: 2rem;
            color: #383744ff;
            font-weight: 600;
        }
        .slider-box {
            flex: 1;
            background: transparent;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 10px;
            width:80%;
            margin:auto;
        }
        .carousel-item {
            text-align: center;
            border-radius:8px;
            box-shadow: 0 0 20px rgba(0,0,0,0.05);
        }
        .carousel-item img {
            max-width: 100%;
            height: auto;
            margin: auto;
        }
        .carousel-indicators [data-bs-target] {
            background-color: #3e3d47ff;
        }
        .carousel-indicators {
            bottom:-58px;
        }
        .carousel-indicators li {
            background-color: #040404;
        }
        .btn-get-started {
            background: black;
            color:white!important;
            font-weight:600;
        }
        input:-webkit-autofill,
        input:-webkit-autofill:hover, 
        input:-webkit-autofill:focus, 
        textarea:-webkit-autofill,
        select:-webkit-autofill {
            box-shadow: 0 0 0px 1000px white inset !important; /* or your background color */
            -webkit-text-fill-color: #000 !important;
            background-color: white !important;
        }
        .btn-icon {
            float:left;
        }
        .btn-icon i {
            color: #3e3d47ff;
        }
        .bi-google {
            background: conic-gradient(from -45deg, #ea4335 110deg, #4285f4 90deg 180deg, #34a853 180deg 270deg, #fbbc05 270deg) 73% 55%/150% 150% no-repeat;
            -webkit-background-clip: text;
            background-clip: text;
            color: transparent;
            -webkit-text-fill-color: transparent;
        }
        .bi-phone {
            color:#1446fa;
        }
        .fa-mobile,.fa-envelope {
            color:black;
        }
        .bi-box {
            color:chocolate;
        }
        .btn-outline-secondary:hover,.btn-outline-secondary:focus {
            background:transparent;   
            color:#6c757d;
        }
        .btn-text {
            font-size:14px;    
        }
        .input-group-prepend .input-group-text {
            background-color: rgb(212, 212, 213);
            border: 2px solid rgb(212, 212, 213);
            border-top-left-radius: 8px;
            border-bottom-left-radius: 8px;
        }
        .input-group-prepend .input-group-text i {
            color: #3e3d47ff;
        }
        .form-label {
            font-size:13px;
            color: #6c68a0;
        }
        .form-control {
            font-size:14px;
            border-radius: 8px;
            border: 2px solid rgb(212, 212, 213);
        }
        .form-control:focus {
            border: 2px solid rgb(212, 212, 213);
            box-shadow: none;
            outline: none;
        }
        .develop {
            font-size: 11px;
            text-align: center;
            color: gray;
            margin-bottom: 0;
        }
        .email-container,.phone-container,.success-otp,.OTP-detail,.phoneOTP-detail {
            display:none;
        }
        .OTP-detail input[type="tel"],.phoneOTP-detail input[type="tel"] {
            height: 40px !important;
            line-height: 51px;
            border-radius: 8px;
            box-shadow: none;
            font-weight: 400;
            font-size: 14px;
            background: #f2f3f7;
            text-shadow: 0 0 0 #24272c;
            padding: 7px 7px 7px 7px;
            border: solid 1px #f2f3f7;
            width: 13%;
            text-align: center;
        }
        #resendotp_btn,#phoneresendotp_btn {
            color: blue;
            font-size: 14px;
            margin-left: 2%;
            cursor: pointer;
        }
        #resendotp_btn, .verification-alert, .success-otp,#phoneresendotp_btn, .phoneverification-alert, .phonesuccess-otp {
            display: none;
        }
        #logtimer_div,#phonelogtimer_div {
            padding-left: 5%;
        }
        .verification-alert,.phoneverification-alert {
            color: red;
            font-size: 14px;
            margin-top: 2%;
        }
        #resendotp_btn, .verification-alert, .success-otp,#phoneresendotp_btn, .phoneverification-alert, .phonesuccess-otp {
            display: none;
        }
        .verifyotpbtn,.phoneverifyotpbtn {
            display: block;
            margin-top: 4%;   
        }
        .otp_alert,.phoneotp_alert {
            font-size: 14px;
            margin-bottom: 5%;
            margin-top: 5%;
            color: darkred;
        }
        .reset-password {
            float: right;
            font-size: 14px;
            color: #626263ff;
            text-decoration: underline; 
        }
        @media (max-width: 768px) {
            .container-box {
                flex-direction: column;
            }
            .slider-box {
                border-left: none;
                border-top: 1px solid #ddd;
            }
        }

        .signup-link {
            text-decoration: none;
            color: #007bff; /* keep Bootstrap link blue */
        }

        .signup-link:hover {
            text-decoration: none; /* prevent underline on hover */
            color: #0056b3;        /* optional darker blue on hover */
        }
        .logo-cls {
            width: 50px;
        }
    </style>
</head>
<body>

    <div class="container-fluid signup-container">
        <div class="row w-100" style="margin: auto 10rem; box-shadow: 3px 2px 10px 0px gray; border-radius: 20px; overflow: hidden;">
            <div class="col-lg-5 d-flex align-items-center justify-content-center p-0">
                <div class="form-section">
                    <div class="text-center mb-4">
                        <div class="row m-auto">
                            <div class="col-12">
                                <a href="login.php" style="display: flex; align-items: center; justify-content: center;">
                                    <img class="logo-cls" src="/tundra_play/assets/images/b2lmobitech_logo.png" alt="Logo">
                                    <span style="font-weight: 700; font-size: 1.75rem; color:black; padding-left:0.5rem;">Tundra Play</span>
                                </a>
                            </div>
                        </div>
                    </div>
                    <h5 class="text-center mb-4">Signin to your account</h5>
                    <div class="login-container">
                        <form id="loginForm" autocomplete="off" method="post">
                            <div class="mb-3">
                                <label for="email" class="form-label">Email</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas fa-envelope"></i>
                                        </span>
                                    </div>
                                    <input type="email" class="form-control" id="email" placeholder="Enter your email">
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="password" class="form-label">Password</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                    <span class="input-group-text">
                                        <i class="fas fa-key"></i>
                                    </span>
                                    </div>
                                    <input type="password" class="form-control" id="password" placeholder="Enter your password">
                                </div>
                            </div>

                            <!-- <p class="reset-password"><a href="reset_password.php" style="color: inherit;">Reset Password?</a></p> -->
                            
                            <input type="hidden" name="csrf_token" value="<?php 
                                if (empty($_SESSION['csrf_token'])) {
                                    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
                                }
                                    echo $_SESSION['csrf_token'];
                                
                                ?>">
                            
                            <button type="submit" class="btn btn-get-started w-100 mt-3">Log In</button>
                        </form>
                    </div>
                    <div class="email-container">
                        <form id="emailloginForm" autocomplete="off" method="post">
                            <div class="mb-3">
                                <label for="emailotp" class="form-label">Email</label>
                                <input type="email" class="form-control" id="emailotp" placeholder="Enter your email">
                            </div>
                            <button onclick="return openemailotp()" class="btn btn-get-started sendotpbtn w-100 mt-3">Send OTP</button>
                        </form>
                    </div>
                    <div class="phone-container">
                        <form id="phoneloginForm" autocomplete="off" method="post">
                            <div class="mb-3">
                                <label for="phoneotp" class="form-label">Phone</label>
                                <input type="tel" pattern="[0-9]{10}" class="form-control" id="phoneotp" placeholder="Enter your Phone">
                            </div>
                            <button onclick="return openphoneotp()" class="btn btn-get-started phonesendotpbtn w-100 mt-3">Send OTP</button>
                        </form>
                    </div>
                    <div class="OTP-detail">
                        <p class="otp_alert"></p>
                        <div class="mb-1 otpautocls" style="position:relative">
                            <input maxlength="1" name="otpField" id="digit-1" data-next="digit-2" type="tel" value="" placeholder="-">
                            <input maxlength="1" name="otpField" id="digit-2" data-next="digit-3" data-previous="digit-1" type="tel" value="" placeholder="-">
                            <input maxlength="1" name="otpField" id="digit-3" data-next="digit-4" data-previous="digit-2" type="tel" value="" placeholder="-">
                            <input maxlength="1" name="otpField" id="digit-4" data-previous="digit-3" type="tel" value="" placeholder="-">
                            <input type="hidden" id="validation" value="0">
                            <span id="logtimer_div"></span>
                            <span id="resendotp_btn" onclick="resendotpbtn()">Resend OTP</span>
                            <p class="verification-alert">Incorrect OTP</p>
                            <span><button type="button" onclick="verifyotp()" class="btn btn-get-started verifyotpbtn">Verify</button></span>
                        </div>
                        <div class="success-otp">You Mail is verified. Please click on Signin button to login</div>
                    </div>
                    <div class="phoneOTP-detail">
                        <p class="phoneotp_alert"></p>
                        <div class="mb-1" style="position:relative">
                            <input maxlength="1" name="phoneotpField" id="phonedigit-1" data-next="phonedigit-2" type="tel" value="" placeholder="-">
                            <input maxlength="1" name="phoneotpField" id="phonedigit-2" data-next="phonedigit-3" data-previous="phonedigit-1" type="tel" value="" placeholder="-">
                            <input maxlength="1" name="phoneotpField" id="phonedigit-3" data-next="phonedigit-4" data-previous="phonedigit-2" type="tel" value="" placeholder="-">
                            <input maxlength="1" name="phoneotpField" id="phonedigit-4" data-previous="phonedigit-3" type="tel" value="" placeholder="-">
                            <input type="hidden" id="phonevalidation" value="0">
                            <span id="phonelogtimer_div"></span>
                            <span id="phoneresendotp_btn" onclick="phoneresendotpbtn()">Resend OTP</span>
                            <p class="phoneverification-alert">Incorrect OTP</p>
                            <span><button type="button" onclick="phoneverifyotp()" class="btn btn-get-started phoneverifyotpbtn">Verify</button></span>
                        </div>
                        <div class="success-otp">You Mobile is verified. Please click on Signin button to login</div>
                    </div>
                    <div class="otp-section">
                        <div class="divider p-1"><span style="background-color: transparent; font-size: 0.9rem;">or sign in using</span></div>

                        <button onclick="return getemailoptcontainer()" class="btn btn-outline-secondary w-100 mb-2">
                            <span class="btn-icon"><i class="fas fa-envelope"></i></span> <span class="btn-text">Continue with Email OTP</span>
                        </button>
                        <button onclick="return getphoneoptcontainer()" class="btn btn-outline-secondary w-100 mb-2">
                            <span class="btn-icon"><i class="fas fa-phone"></i></span> <span class="btn-text">Continue with Phone OTP</span>
                        </button>
                    </div>  
                    <p class="develop mt-2">Designed and Developed by B2L Mobitech Pvt. Ltd.</p>
                </div>
            </div>
            <div class="col-lg-7 temp-ad d-none d-lg-flex justify-content-center p-0">
                <div class="text-center p-5" style="background: linear-gradient(120deg, #b3b3b4ff, #e0e0e1ff, #f3f3f3ff); width: 100%;">
                    <h2 class="mb-1">Tundra Play</h2>
                    <p class="mb-4" style="color: #75757eff; font-weight: 550; font-size: 1rem;">Watch Videos Seamlessly</p>
                    <div class="slider-box">
                        <div id="carouselExampleIndicators" class="carousel slide" data-ride="carousel">
                        <ol class="carousel-indicators">
                            <li data-target="#carouselExampleIndicators" data-slide-to="0" class="active"></li>
                            <li data-target="#carouselExampleIndicators" data-slide-to="1"></li>
                            <li data-target="#carouselExampleIndicators" data-slide-to="2"></li>
                        </ol>
                        <div class="carousel-inner">
                            <div class="carousel-item active">
                            <img class="d-block w-100" src="/tundra_play/assets/images/login_image1.png" alt="First slide">
                            </div>
                            <div class="carousel-item">
                            <img class="d-block w-100" src="/tundra_play/assets/images/login_image2.png" alt="Second slide">
                            </div>
                            <div class="carousel-item">
                            <img class="d-block w-100" src="/tundra_play/assets/images/login_image3.png" alt="Third slide">
                            </div>
                        </div>
                        <a class="carousel-control-prev" href="#carouselExampleIndicators" role="button" data-slide="prev">
                            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                            <span class="sr-only">Previous</span>
                        </a>
                        <a class="carousel-control-next" href="#carouselExampleIndicators" role="button" data-slide="next">
                            <span class="carousel-control-next-icon" aria-hidden="true"></span>
                            <span class="sr-only">Next</span>
                        </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="/tundra_play/assets/plugins/jquery/jquery.min.js"></script>
    <script src="/tundra_play/assets/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>

    <script>
        function setGoogleButtonWidth() {
            const screenWidth = window.innerWidth;
            const targetWidth = screenWidth - 112; // reduce 112px
            const googleBtn = document.getElementById("g_id_signin");

            if (googleBtn) {
            googleBtn.setAttribute("data-width", targetWidth);
            }
        }

        setGoogleButtonWidth();

        window.addEventListener("resize", () => {
            setGoogleButtonWidth();
            google.accounts.id.renderButton(
            document.getElementById("g_id_signin"),
            { theme: "outline", size: "large", width: window.innerWidth - 112 }
            );
        });
        
        $(document).ready(function(){

            // ===== Check Email Availability =====
            $("#email").on("blur", function(){
                var email = $(this).val().trim();
                if(email.length > 0){
                    $.post("check_email.php", { email: email }, function(response){
                        if(response === "not_found"){
                            $("#emailStatus").text("Email not registered!");
                        } else {
                            $("#emailStatus").text("");
                        }
                    });
                }
            });

            // ===== Submit Login =====
            $("#loginForm").on('submit', function(e){
                e.preventDefault();

                var email = $("#email").val().trim();
                var password = $("#password").val().trim();
                var csrf_token = $("input[name='csrf_token']").val();

                var emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                if(!emailPattern.test(email)) { alert("Enter a valid email"); return false; }
                if(password.length < 8){ alert("Password must be at least 8 characters long"); return false; }


            
                $.ajax({
                    type: "POST",
                    url: "submitlogin.php",
                    data: { email: email, password: password, csrf_token: csrf_token
                    },
                    success: function(response){
                        // alert(response);
                        
                        if(response.trim()=="true_login"){
                                window.top.location.replace("home.php");
                                }
                                else if(response.trim()=="false_login"){
                                alert("You Do Not Have Access to Web");
                                }
                                else if(response.trim()=="verification_progress"){
                                alert("Your Account Verification is in Progress.");
                                }
                                else{
                                //swal("","please Enter Correct Mail id and password","error");
                            alert("Invalid Email or Password!");
                        }
                    },
                    error: function(){ alert("Something went wrong!"); }
                });
            });

        });

        function getDeviceType() {
            return /Mobi|Android|iPhone|iPad|iPod/i.test(navigator.userAgent) ? "Mobile" : "Desktop";
        }

        function getemailoptcontainer()
        {
            $(".email-container").show();
            $(".phone-container").hide();
            $(".login-container").hide();
        }
        
        function getphoneoptcontainer()
        {
            $(".email-container").hide();
            $(".phone-container").show();
            $(".login-container").hide();   
        }

        function openemailotp()
            {
                var email=$("#emailotp").val();
                $.ajax({
                    type: "POST",
                    url: "storeloginemailotp.php",
                    data: {email:email},
                    cache: false,
                    success: function(response)
                    {
                        if(response=="00")
                        {
                            alert("OTP not sent");
                        }
                        else if(response=="33")
                        {
                            alert("You are not registered with CRF!");
                        }
                        else
                        {						
                            $.ajax({
                                type: "POST",
                                url: "sendloginemailotp.php",
                                data: {email:email,otp:response},
                                cache: false,
                                success: function(response)
                                {
                                    if(response==11)
                                    {
                                        $(".email-container").hide();
                                        $(".OTP-detail").show();
                                        $(".otp_alert").html("We've sent a 4-digit code to your entered email-id. The code expires shortly, so please enter it soon.");
                                        var timer2="00:05:00";
                                        var interval = setInterval(function() {
                                        var timer = timer2.split(':');
                                        //by parsing integer, I avoid all extra string processing
                                        var hour = parseInt(timer[0], 10);
                                        var minutes = parseInt(timer[1], 10);
                                        var seconds = parseInt(timer[2], 10);
                                        --seconds;
                                        hour = (minutes < 0) ? --hour : hour;
                                        minutes = (seconds < 0) ? --minutes : minutes;
                                        if (minutes < 0 || hour < 0) 
                                        {
                                            clearInterval(interval);
                                            $('#logtimer_div').hide();
                                            $("#resendotp_btn").show();
                                            $("#validation").val("0");
                                        }
                                        else
                                            {
                                            seconds = (seconds < 0) ? 59 : seconds;
                                            seconds = (seconds < 10) ? '0' + seconds : seconds;
                                            //minutes = (minutes < 10) ?  minutes : minutes;
                                            minutes = (minutes < 0) ? 59 : minutes;
                                            minutes = (minutes < 10) ? '0' + minutes : minutes;
                                            hour = (hour < 0) ? 59 : hour;
                                            hour = (hour < 10) ? '0' + hour : hour;
                                            $('#logtimer_div').html(minutes + ':' + seconds);
                                            timer2 = hour + ':' + minutes + ':' + seconds;
                                            }
                                    }, 1000);
                                    }
                                    else
                                    {
                                        
                                    }
                                }
                            });

                        }
                    }
                });
                return false;
            }
            
        function verifyotp()
        {
            var digit1=$("#digit-1").val();
            var digit2=$("#digit-2").val();
            var digit3=$("#digit-3").val();
            var digit4=$("#digit-4").val();
            
            var otp=digit1+digit2+digit3+digit4;
            var email=$("#emailotp").val();
            if(otp.length!=4)
            {
                alert("Please Enter 4 Digit OTP");
            }
            else
            {
                        $.ajax({
                            type: "POST",
                            url: "verifyloginemailotp.php",
                            data: {email:email,otp:otp},
                            async: false,
                            success: function(responses)
                            {
                                response=responses;
                                callback.call(responses);
                            }
                        });
                        
                        
                    

    response = response.trim(); // always clean whitespace
    //	alert(response);

    if(response=="true_login"){
        $(".verification-alert").hide();
                            $('#submitbtn').removeAttr('disabled');
                            $("#validation").val("1");
                            $(".OTP-detail").hide();
                            //$(".success-otp").show();
                            window.top.location.replace("index_main.php");
                            }
    else if(response === "false_login"){
        alert("You Do Not Have Access to Web");
    }
    else if(response === "11"){
        // just OTP verified, no routing
        $(".verification-alert").hide();
        $('#submitbtn').removeAttr('disabled');
        $("#validation").val("1");
        $(".OTP-detail").hide();
    }
    else{
        $("#submitbtn").prop("disabled","true");
        $(".verification-alert").show();
        alert("Invalid Email or Password!");
    }

                    
            }
        }
        
        function verifyotp_new() {
        var otp = $("#digit-1").val() + $("#digit-2").val() + $("#digit-3").val() + $("#digit-4").val();
        var email = $("#emailotp").val();

        if (otp.length !== 4) {
            alert("Please Enter 4 Digit OTP");
            return;
        }

        $.ajax({
            type: "POST",
            url: "verifyloginemailotp.php",
            data: { email: email, otp: otp },
            success: function(response) {
                response = response.trim(); // always clean whitespace
            // console.log("OTP Response:", response);

                if (response === "false_login") {
                    alert("You Do Not Have Access to Web");
                    return;
                }

                if (response === "11") {
                    // OTP just verified, no redirect
                    $(".verification-alert").hide();
                    $("#submitbtn").removeAttr("disabled");
                    $("#validation").val("1");
                    $(".OTP-detail").hide();
                    return;
                }

                if (response === "invalid" || response === "33") {
                    $("#submitbtn").prop("disabled", true);
                    $(".verification-alert").show();
                    alert("Invalid Email or Password!"+response);
                    return;
                }

                // common success actions
                $(".verification-alert").hide();
                $("#submitbtn").removeAttr("disabled");
                $("#validation").val("1");
                $(".OTP-detail").hide();

                // Routing
                const routes = {
                    "true_login": "index_main.php"
                };

                if (routes[response]) {
                    window.top.location.replace(routes[response]);
                } else {
                    alert("Unknown response: " + response);
                }
            },
            error: function(xhr, status, error) {
                console.error("Ajax error:", error);
                alert("Something went wrong. Please try again.");
            }
        });
    }

        function openphoneotp()
        {
            var phone=$("#phoneotp").val();
            $.ajax({
                type: "POST",
                url: "storeloginphoneotp.php",
                data: {phone:phone},
                cache: false,
                success: function(response)
                {
                //   alert(response);
                    if(response=="00")
                    {
                        alert("OTP not sent");
                    }
                    else if(response=="33")
                    {
                        alert("You are not registered with CRF!");
                    }
                    else
                    {						
                        $.ajax({
                            type: "POST",
                            url: "sendloginphoneotp.php",
                            data: {phone:phone,otp:response},
                            cache: false,
                            success: function(responsee)
                            {
                            //  alert(responsee);
                                if(responsee==11)
                                {
                                    $(".phone-container").hide();
                                    $(".phoneOTP-detail").show();
                                    $(".phoneotp_alert").html("We've sent a 4-digit code to your entered mobile number. The code expires shortly, so please enter it soon.");
                                    var timer2="00:05:00";
                                    var interval = setInterval(function() {
                                    var timer = timer2.split(':');
                                    //by parsing integer, I avoid all extra string processing
                                    var hour = parseInt(timer[0], 10);
                                    var minutes = parseInt(timer[1], 10);
                                    var seconds = parseInt(timer[2], 10);
                                    --seconds;
                                    hour = (minutes < 0) ? --hour : hour;
                                    minutes = (seconds < 0) ? --minutes : minutes;
                                    if (minutes < 0 || hour < 0) 
                                    {
                                        clearInterval(interval);
                                        $('#phonelogtimer_div').hide();
                                        $("#phoneresendotp_btn").show();
                                        $("#phonevalidation").val("0");
                                    }
                                    else
                                        {
                                        seconds = (seconds < 0) ? 59 : seconds;
                                        seconds = (seconds < 10) ? '0' + seconds : seconds;
                                        //minutes = (minutes < 10) ?  minutes : minutes;
                                        minutes = (minutes < 0) ? 59 : minutes;
                                        minutes = (minutes < 10) ? '0' + minutes : minutes;
                                        hour = (hour < 0) ? 59 : hour;
                                        hour = (hour < 10) ? '0' + hour : hour;
                                        $('#phonelogtimer_div').html(minutes + ':' + seconds);
                                        timer2 = hour + ':' + minutes + ':' + seconds;
                                        }
                                }, 1000);
                                }
                                else
                                {
                                    alert("OTP not sent!");
                                }
                            }
                        });

                    }
                }
            });
            return false;
        }
        
        function phoneverifyotp()
        {
            var digit1=$("#phonedigit-1").val();
            var digit2=$("#phonedigit-2").val();
            var digit3=$("#phonedigit-3").val();
            var digit4=$("#phonedigit-4").val();
            
            var otp=digit1+digit2+digit3+digit4;
            var phone=$("#phoneotp").val();
            
            
            if(otp.length!=4)
            {
                alert("Please Enter 4 Digit OTP");
            }
            else
            {
                        $.ajax({
                            type: "POST",
                            url: "verifyloginphoneotp.php",
                            data: {phone:phone,otp:otp},
                            async: false,
                            success: function(responses)
                            {
                                response=responses;
                                callback.call(responses);
                            }
                        });
                        
                        //alert(response);
    response = response.trim(); // clean spaces

    if(response === "true_login"){
        // OTP verification success
        $(".phoneverification-alert").hide();
        $("#phonevalidation").val("1");
        $(".phoneOTP-detail").hide();
        window.top.location.replace("hcm_dashboard.php");
    }
    else if(response === "false_login"){
        alert("You Do Not Have Access to Web");
    }
                        else
                        {
                            //$("#submitbtn").prop("disabled","true");
                            $(".phoneverification-alert").show();
                            alert("Invalid Email or Password!");
                            return false;
                        }
            }
        }
        
        function resendotpbtn()
        {
            var email=$("#emailotp").val();
            if(email=='')
            {
                alert("Please Enter emailid");
            }
            else
            {
                $('#logtimer_div').show();
                $("#resendotp_btn").hide();
                openemailotp();
            }
        }
        
        function phoneresendotpbtn()
        {
            var phone=$("#phoneotp").val();
            if(phone=='')
            {
                alert("Please Enter phone number");
            }
            else
            {
                $('#phonelogtimer_div').show();
                $("#phoneresendotp_btn").hide();
                openemailotp();
            }
        }

    </script>

</body>
</html>