<?php
    session_start(); 
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>FITT | Reset Password</title>
    <meta name="google-signin-client_id" content="1098090927549-0g3l0l703516akr3s9h21vap96cm9etf.apps.googleusercontent.com">
    <script src="https://accounts.google.com/gsi/client" async defer></script>

    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
    <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css">
    <link rel="stylesheet" href="plugins/icheck-bootstrap/icheck-bootstrap.min.css">
    <link rel="stylesheet" href="dist/css/adminlte.min.css">
    
    <style>
        @font-face {
            font-family: 'Varela Round';
            src: url('VarelaRound-Regular.ttf') format('truetype');
            font-weight: normal;
            font-style: normal;
        }
        @font-face {
            font-family: 'Graphik Web Regular';
            src: url('Graphik Web Regular Regular.ttf');
        }
        body {
            /* font-family: "Graphik Web Regular",-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif!important; */
            /* font-family: 'Varela Round', sans-serif; */
            font-family: "Montserrat", sans-serif;
        } 
        body {
            background-color:#bed9da;
        }
        .signup-container {
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            position: relative;
            overflow: hidden;
            background: linear-gradient(135deg, #1f1a6d, #3f3ba8, #b3b8ff);
        }
        .form-section {
            background: #efeef5;
            padding: 2rem;
            width: 100%;
        }
        @media (max-width: 768px) {
            .form-section {
                position: fixed;
                z-index: 10;
                top: 0;
                left: 0;
                max-width: 100%;
                margin: auto;
                border-radius: 0px;
                min-height: 100vh;
                display: flex;
                justify-content: center;
                flex-direction: column;
            }
        }
        @media (min-width: 769px) {
            .form-section {
                position: relative;
                width: 100%;
                margin: auto;
                border-radius: 0px;
                height: 100%;
            }
        }
        .btn-primary {
            border-radius: 8px;
            background-color: #0070d2;
            border: none;
        }
        .btn-outline-secondary {
            border-radius: 8px;
            border: 1px solid #a9a5e5;
            color: #7d79b7;
        }
        .divider {
            text-align: center;
            position: relative;
            margin: 20px 0;
        }
        .divider::before, .divider::after {
            content: '';
            position: absolute;
            top: 50%;
            width: 32%;
            height: 1px;
            background: #ccc;
        }
        .divider::before {
            left: 0;
        }
        .divider::after {
            right: 0;
        }
        .divider span {
            padding: 0 10px;
            background: #fff;
            color: #888;
        }
        .temp-ad h2 {
            font-size: 2rem;
            color: #1f1a6d;
        }
        .slider-box {
            flex: 1;
            background: transparent;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 10px;
            width:80%;
            margin:auto;
        }
        .carousel-item {
            text-align: center;
            border-radius:8px;
            box-shadow: 0 0 20px rgba(0,0,0,0.05);
        }
        .carousel-item img {
            max-width: 100%;
            height: auto;
            margin: auto;
        }
        .carousel-indicators [data-bs-target] {
            background-color: #257c88;
        }
        .carousel-indicators {
            bottom:-58px;
        }
        .carousel-indicators li {
            background-color: #040404;
        }
        .btn-get-started {
            background: #1f1a6d;
            color:white!important;
            font-weight:600;
        }
        input:-webkit-autofill,
        input:-webkit-autofill:hover, 
        input:-webkit-autofill:focus, 
        textarea:-webkit-autofill,
        select:-webkit-autofill {
            box-shadow: 0 0 0px 1000px white inset !important; /* or your background color */
            -webkit-text-fill-color: #000 !important;
            background-color: white !important;
        }
        .btn-icon {
            float:left;
        }
        .btn-icon i {
            color: #7d79b7;
        }
        .bi-google {
            background: conic-gradient(from -45deg, #ea4335 110deg, #4285f4 90deg 180deg, #34a853 180deg 270deg, #fbbc05 270deg) 73% 55%/150% 150% no-repeat;
            -webkit-background-clip: text;
            background-clip: text;
            color: transparent;
            -webkit-text-fill-color: transparent;
        }
        .bi-phone {
            color:#1446fa;
        }
        .fa-mobile,.fa-envelope {
            color:black;
        }
        .bi-box {
            color:chocolate;
        }
        .btn-outline-secondary:hover,.btn-outline-secondary:focus {
            background:transparent;   
            color:#6c757d;
        }
        .btn-text {
            font-size:14px;    
        }
        .input-group-prepend .input-group-text {
            background-color: #cfc9ef;
            border: 2px solid #cfc9ef;
            border-top-left-radius: 8px;
            border-bottom-left-radius: 8px;
        }
        .input-group-prepend .input-group-text i {
            color: #1f1a6d;
        }
        .form-label {
            font-size:13px;
            color: #6c68a0;
        }
        .form-control {
            font-size:14px;
            border-radius: 8px;
            border: 2px solid #cfc9ef;
        }
        .form-control:focus {
            border: 2px solid #cfc9ef;
        }
        .develop {
            font-size: 11px;
            text-align: center;
            color: gray;
            margin-bottom: 0;
        }
        .email-container,.phone-container,.success-otp,.OTP-detail,.phoneOTP-detail {
            display:none;
        }
        .OTP-detail input[type="tel"],.phoneOTP-detail input[type="tel"] {
            height: 40px !important;
            line-height: 51px;
            border-radius: 8px;
            box-shadow: none;
            font-weight: 400;
            font-size: 14px;
            background: #f2f3f7;
            text-shadow: 0 0 0 #24272c;
            padding: 7px 7px 7px 7px;
            border: solid 1px #f2f3f7;
            width: 13%;
            text-align: center;
        }
        #resendotp_btn,#phoneresendotp_btn {
            color: blue;
            font-size: 14px;
            margin-left: 2%;
            cursor: pointer;
        }
        #resendotp_btn, .verification-alert, .success-otp,#phoneresendotp_btn, .phoneverification-alert, .phonesuccess-otp {
            display: none;
        }
        #logtimer_div,#phonelogtimer_div {
            padding-left: 5%;
        }
        .verification-alert,.phoneverification-alert {
            color: red;
            font-size: 14px;
            margin-top: 2%;
        }
        #resendotp_btn, .verification-alert, .success-otp,#phoneresendotp_btn, .phoneverification-alert, .phonesuccess-otp {
            display: none;
        }
        .verifyotpbtn,.phoneverifyotpbtn {
            display: block;
            margin-top: 4%;   
        }
        .otp_alert,.phoneotp_alert {
            font-size: 14px;
            margin-bottom: 5%;
            margin-top: 5%;
            color: darkred;
        }
        .reset-password {
            float: right;
            font-size: 14px;
            color: #443f98;
            text-decoration: underline; 
        }
        @media (max-width: 768px) {
            .container-box {
                flex-direction: column;
            }
            .slider-box {
                border-left: none;
                border-top: 1px solid #ddd;
            }
        }

        .signup-link {
            text-decoration: none;
            color: #007bff; /* keep Bootstrap link blue */
        }

        .signup-link:hover {
            text-decoration: none; /* prevent underline on hover */
            color: #0056b3;        /* optional darker blue on hover */
        }
        .logo-cls {
            width: 80%;
        }
        .logocls p {
            font-size: 18px!important;
            font-weight: 400!important;
            color:black!important;
        }
        .logocls .para-cls {
            margin-top:1%;
        }
    </style>
</head>
<body>

<div class="container-fluid signup-container">
  <div class="row w-100" style="margin: auto 10rem; box-shadow: 0px 0px 10px 0px white; border-radius: 20px; overflow: hidden;">
    <div class="col-lg-5 d-flex align-items-center justify-content-center p-0">
      <div class="form-section">
        <div class="text-center mb-2">
            <div class="row w-75 m-auto logocls" style='font-family:"Graphik Web Regular",-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif'>
                <div class="col-md-3 p-0"><a href="index_main.php"><img class="logo-cls" src="dist/img/b2lmobitech_logo.png"
               alt=" Logo" width="120"></a></div>
                <div class="col-md-9 p-0 text-left para-cls"><a href="index_main.php"><p class="mb-0">PMS</p>
            <p>Project Management System</p></a></div>
            </div>
        </div>
        <h4 class="text-center mb-4" style='font-family:"Graphik Web Regular",-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif'>Forgot Password</h4>
        <div class="login-container">
            <form id="loginForm" autocomplete="off" method="post">
                <div class="mb-3">
                    <label for="emailotp" class="form-label">Email</label>
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text">
                                <i class="fas fa-envelope"></i>
                            </span>
                        </div>
                        <input type="email" class="form-control" id="emailotp" placeholder="Enter your email">
                    </div>
                </div>
                <input type="hidden" name="csrf_token" value = "<?php 
                                                                    if (empty($_SESSION['csrf_token'])) {
                                                                        $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
                                                                    }
                                                                    echo $_SESSION['csrf_token'];
                                                                ?>">
                <button type="button" onclick="return openemailotp()" class="btn btn-get-started w-100 mt-3">Send OTP</button>
            </form>
        </div>
        
        <div class="OTP-detail">
            <p class="otp_alert"></p>
            <div class="mb-1 otpautocls" style="position:relative">
				    <!--<input maxlength="4" name="otpField" class="sellevverifyinput" id="enquiryotp" type="tel" value="" placeholder="-">-->
				    <input maxlength="1" name="otpField" id="digit-1" data-next="digit-2" type="tel" value="" placeholder="-">
				    <input maxlength="1" name="otpField" id="digit-2" data-next="digit-3" data-previous="digit-1" type="tel" value="" placeholder="-">
				    <input maxlength="1" name="otpField" id="digit-3" data-next="digit-4" data-previous="digit-2" type="tel" value="" placeholder="-">
				    <input maxlength="1" name="otpField" id="digit-4" data-previous="digit-3" type="tel" value="" placeholder="-">
				    <input type="hidden" id="validation" value="0">
				    <span id="logtimer_div"></span>
				    <span id="resendotp_btn" onclick="resendotpbtn()">Resend OTP</span>
				    <p class="verification-alert">Incorrect OTP</p>
				    <span><button type="button" onclick="verifyotp()" class="btn btn-danger verifyotpbtn">Verify</button></span>
				  </div>
		<div class="success-otp">You Mail is verified. Please click on Signin button to login</div>
        </div>
        
        <p class="text-center mt-4 small">Already have an account? <a href="pms_login.php">Log in</a></p>
      </div>
    </div>
    <div class="col-lg-7 temp-ad d-none d-lg-flex justify-content-center p-0">
      <div class="text-center p-5" style="background: linear-gradient(120deg, #a9a5e5, #cfc9ef, #f2edf9); width: 100%;">
        <h2 class="mb-1">Project Management System</h2>
        <p class="mb-4" style="color: #6c68a0; font-weight: 550; font-size: 1rem;">Manage Projects Effortlessly</p>
        <div class="slider-box">
            <div id="carouselExampleIndicators" class="carousel slide" data-ride="carousel">
              <ol class="carousel-indicators">
                <li data-target="#carouselExampleIndicators" data-slide-to="0" class="active"></li>
                <li data-target="#carouselExampleIndicators" data-slide-to="1"></li>
                <li data-target="#carouselExampleIndicators" data-slide-to="2"></li>
              </ol>
              <div class="carousel-inner">
                <div class="carousel-item active">
                  <img class="d-block w-100" src="dist/img/slider1-rbg.png" alt="First slide">
                </div>
                <div class="carousel-item">
                  <img class="d-block w-100" src="dist/img/slider2-rbg.png" alt="Second slide">
                </div>
                <div class="carousel-item">
                  <img class="d-block w-100" src="dist/img/slider3-rbg.png" alt="Third slide">
                </div>
              </div>
              <a class="carousel-control-prev" href="#carouselExampleIndicators" role="button" data-slide="prev">
                <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                <span class="sr-only">Previous</span>
              </a>
              <a class="carousel-control-next" href="#carouselExampleIndicators" role="button" data-slide="next">
                <span class="carousel-control-next-icon" aria-hidden="true"></span>
                <span class="sr-only">Next</span>
              </a>
            </div>
          </div>
      </div>
    </div>
  </div>
</div>

<!-- jQuery -->
<script src="plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/adminlte.min.js"></script>
<script>

//to focus on next otp field
document.addEventListener("DOMContentLoaded", function () {
    const inputs = document.querySelectorAll("input[name='otpField']");

    inputs.forEach((input, index) => {
        input.addEventListener("input", function () {
            if (this.value.length === 1) {
                let nextId = this.dataset.next;
                if (nextId) {
                    document.getElementById(nextId).focus();
                }
            }
        });

        input.addEventListener("keydown", function (e) {
            if (e.key === "Backspace" && this.value === "") {
                let prevId = this.dataset.previous;
                if (prevId) {
                    document.getElementById(prevId).focus();
                }
            }
        });
    });
});



function openemailotp()
	{
	    
		var email=$("#emailotp").val();
		if(email=="")
		{
		    alert("Please enter Email id");
		}
		else
		{
		    
    		$.ajax({
    			type: "POST",
    			url: "sendresetemailotp.php",
    			data: {email:email},
    			cache: false,
    			success: function(response)
    			{
    			    //alert(response);
    				if(response=="00")
    				{
    					alert("OTP not sent");
    				}
    				else if(response=="33")
    				{
    					alert("You are not registered with mPragati Booking System!");
    				}
    				else if(response==11)
    				{				
    							    //$(".email-container").hide();
    							    $(".OTP-detail").show();
    							    $(".otp_alert").html("We've sent a 4-digit code to your entered email-id. The code expires shortly, so please enter it soon.");
    							    var timer2="00:05:00";
            						var interval = setInterval(function() {
                                      var timer = timer2.split(':');
                                      //by parsing integer, I avoid all extra string processing
                                      var hour = parseInt(timer[0], 10);
                                      var minutes = parseInt(timer[1], 10);
                                      var seconds = parseInt(timer[2], 10);
                                      --seconds;
                                      hour = (minutes < 0) ? --hour : hour;
                                      minutes = (seconds < 0) ? --minutes : minutes;
                                      if (minutes < 0 || hour < 0) 
                                      {
                                        clearInterval(interval);
                                        $('#logtimer_div').hide();
                                        $("#resendotp_btn").show();
                                        $("#validation").val("0");
                                      }
                                      else
                                        {
                                          seconds = (seconds < 0) ? 59 : seconds;
                                          seconds = (seconds < 10) ? '0' + seconds : seconds;
                                          //minutes = (minutes < 10) ?  minutes : minutes;
                                          minutes = (minutes < 0) ? 59 : minutes;
                                          minutes = (minutes < 10) ? '0' + minutes : minutes;
                                           hour = (hour < 0) ? 59 : hour;
                                          hour = (hour < 10) ? '0' + hour : hour;
                                          $('#logtimer_div').html(minutes + ':' + seconds);
                                          timer2 = hour + ':' + minutes + ':' + seconds;
                                        }
                                }, 1000);
    							
    						}
    						else
    						{
    						    alert("Something Wrong!");
    						}
    				}
    		});
    	}
		return false;
	}
	
	function verifyotp()
    {
        var digit1=$("#digit-1").val();
          var digit2=$("#digit-2").val();
          var digit3=$("#digit-3").val();
          var digit4=$("#digit-4").val();
          
          var otp=digit1+digit2+digit3+digit4;
          var email=$("#emailotp").val();
          if(otp.length!=4)
          {
              alert("Please Enter 4 Digit OTP");
          }
          else
          {
        			$.ajax({
        				type: "POST",
        				url: "verifyresetemailotp.php",
        				data: {email:email,otp:otp},
        				async: false,
        				success: function(response)
        				{
        					res=response;
        					callback.call(response);
        				}
        			});
        			//alert(res);
        			if(res=="00")
        			{
        			   alert("Something Wrong!");
        				return false; 
        			}
        			else if(res=="33")
        			{
        			   $(".verification-alert").show();
        			    return false; 
        			}
        			else
        			{
        			     $(".verification-alert").hide();
        				$('#submitbtn').removeAttr('disabled');
        				$("#validation").val("1");
        				$(".OTP-detail").hide();
        				//$(".success-otp").show();
        				//window.location.href="../Proxpert/dist/pages/index.php";
        				window.location.href="set_password.php?mail="+email+"&key="+res+"&action=reset";
        			}
          }
    }
    
    function resendotpbtn()
	{
		var email=$("#emailotp").val();
		if(email=='')
		{
			alert("Please Enter emailid");
		}
		else
		{
    		$('#logtimer_div').show();
            $("#resendotp_btn").hide();
            openemailotp();
		}
	}
</script>
</body>
</html>