<?php 
$session_lifetime = 1800; // 30 minutes

session_set_cookie_params([
    'lifetime' => $session_lifetime,                  // Session ends when browser closes
    'path' => '/',
    'domain' => '',                   // Use current domain
    'secure' => isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on', // Only HTTPS
    'httponly' => true,               // JS cannot access session cookie
    'samesite' => 'Strict'            // Protect against CSRF
]);


session_start();


if (
    $_SESSION['user_agent'] !== $_SERVER['HTTP_USER_AGENT'] ||
    $_SESSION['ip'] !== $_SERVER['REMOTE_ADDR'] // optional
) {
    session_unset();
    session_destroy();
   
    header("Location: /tundra_play/erp/login.php");
    exit;
}
$url_link=$_SERVER['SERVER_NAME'];
if(!isset($_SESSION['tundra_user_id']))
{
    ?>
     <script>
     var fullurl="<?php echo '/tundra_play/erp/login.php'; ?>";
     window.top.location.href = fullurl;
     </script>
     <?php 
}
// Check if the session has expired
else if (isset($_SESSION['tundrastarttimeout']) && (time() - $_SESSION['tundrastarttimeout'] > $session_lifetime)) {
    
    //echo $_SESSION['crfstarttimeout'];
    
    // Session expired, destroy it
   session_unset();
    session_destroy();
    ?>
     <script>
     var fullurl="<?php echo '/tundra_play/erp/login.php'; ?>";
     window.top.location.href = fullurl;
     </script>
     <?php 
    exit();
}
?>