<?php
    session_start(); 
    include('model/config.php');
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>PMS | Set Password</title>
    <meta name="google-signin-client_id" content="1098090927549-0g3l0l703516akr3s9h21vap96cm9etf.apps.googleusercontent.com">
    <script src="https://accounts.google.com/gsi/client" async defer></script>

    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
    <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css">
    <link rel="stylesheet" href="plugins/icheck-bootstrap/icheck-bootstrap.min.css">
    <link rel="stylesheet" href="dist/css/adminlte.min.css">
  
    <style>
        @font-face {
            font-family: 'Varela Round';
            src: url('VarelaRound-Regular.ttf') format('truetype');
            font-weight: normal;
            font-style: normal;
        }
        @font-face {
            font-family: 'Graphik Web Regular';
            src: url('Graphik Web Regular Regular.ttf');
        }
        body {
            /* font-family: "Graphik Web Regular",-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif!important; */
            /* font-family: 'Varela Round', sans-serif; */
            font-family: "Montserrat", sans-serif;
        } 
        body {
            background-color:#bed9da;
        }
        .signup-container {
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            position: relative;
            overflow: hidden;
            background: linear-gradient(135deg, #1f1a6d, #3f3ba8, #b3b8ff);
        }
        .form-section {
            background: #efeef5;
            padding: 2rem;
            width: 100%;
        }
        @media (max-width: 768px) {
            .form-section {
                position: fixed;
                z-index: 10;
                top: 0;
                left: 0;
                max-width: 100%;
                margin: auto;
                border-radius: 0px;
                min-height: 100vh;
                display: flex;
                justify-content: center;
                flex-direction: column;
            }
        }
        @media (min-width: 769px) {
            .form-section {
                position: relative;
                width: 100%;
                margin: auto;
                border-radius: 0px;
                height: 100%;
            }
        }
        .btn-primary {
            border-radius: 8px;
            background-color: #0070d2;
            border: none;
        }
        .btn-outline-secondary {
            border-radius: 8px;
            border: 1px solid #a9a5e5;
            color: #7d79b7;
        }
        .divider {
            text-align: center;
            position: relative;
            margin: 20px 0;
        }
        .divider::before, .divider::after {
            content: '';
            position: absolute;
            top: 50%;
            width: 32%;
            height: 1px;
            background: #ccc;
        }
        .divider::before {
            left: 0;
        }
        .divider::after {
            right: 0;
        }
        .divider span {
            padding: 0 10px;
            background: #fff;
            color: #888;
        }
        .temp-ad h2 {
            font-size: 2rem;
            color: #1f1a6d;
        }
        .slider-box {
            flex: 1;
            background: transparent;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 10px;
            width:80%;
            margin:auto;
        }
        .carousel-item {
            text-align: center;
            border-radius:8px;
            box-shadow: 0 0 20px rgba(0,0,0,0.05);
        }
        .carousel-item img {
            max-width: 100%;
            height: auto;
            margin: auto;
        }
        .carousel-indicators [data-bs-target] {
            background-color: #257c88;
        }
        .carousel-indicators {
            bottom:-58px;
        }
        .carousel-indicators li {
            background-color: #040404;
        }
        .btn-get-started {
            background: #1f1a6d;
            color:white!important;
            font-weight:600;
        }
        input:-webkit-autofill,
        input:-webkit-autofill:hover, 
        input:-webkit-autofill:focus, 
        textarea:-webkit-autofill,
        select:-webkit-autofill {
            box-shadow: 0 0 0px 1000px white inset !important; /* or your background color */
            -webkit-text-fill-color: #000 !important;
            background-color: white !important;
        }
        .btn-icon {
            float:left;
        }
        .btn-icon i {
            color: #7d79b7;
        }
        .bi-google {
            background: conic-gradient(from -45deg, #ea4335 110deg, #4285f4 90deg 180deg, #34a853 180deg 270deg, #fbbc05 270deg) 73% 55%/150% 150% no-repeat;
            -webkit-background-clip: text;
            background-clip: text;
            color: transparent;
            -webkit-text-fill-color: transparent;
        }
        .bi-phone {
            color:#1446fa;
        }
        .fa-mobile,.fa-envelope {
            color:black;
        }
        .bi-box {
            color:chocolate;
        }
        .btn-outline-secondary:hover,.btn-outline-secondary:focus {
            background:transparent;   
            color:#6c757d;
        }
        .btn-text {
            font-size:14px;    
        }
        .input-group-prepend .input-group-text {
            background-color: #cfc9ef;
            border: 2px solid #cfc9ef;
            border-top-left-radius: 8px;
            border-bottom-left-radius: 8px;
        }
        .input-group-prepend .input-group-text i {
            color: #1f1a6d;
        }
        .form-label {
            font-size:13px;
            color: #6c68a0;
        }
        .form-control {
            font-size:14px;
            border-radius: 8px;
            border: 2px solid #cfc9ef;
        }
        .form-control:focus {
            border: 2px solid #cfc9ef;
        }
        .develop {
            font-size: 11px;
            text-align: center;
            color: gray;
            margin-bottom: 0;
        }
        .email-container,.phone-container,.success-otp,.OTP-detail,.phoneOTP-detail {
            display:none;
        }
        .OTP-detail input[type="tel"],.phoneOTP-detail input[type="tel"] {
            height: 40px !important;
            line-height: 51px;
            border-radius: 8px;
            box-shadow: none;
            font-weight: 400;
            font-size: 14px;
            background: #f2f3f7;
            text-shadow: 0 0 0 #24272c;
            padding: 7px 7px 7px 7px;
            border: solid 1px #f2f3f7;
            width: 13%;
            text-align: center;
        }
        #resendotp_btn,#phoneresendotp_btn {
            color: blue;
            font-size: 14px;
            margin-left: 2%;
            cursor: pointer;
        }
        #resendotp_btn, .verification-alert, .success-otp,#phoneresendotp_btn, .phoneverification-alert, .phonesuccess-otp {
            display: none;
        }
        #logtimer_div,#phonelogtimer_div {
            padding-left: 5%;
        }
        .verification-alert,.phoneverification-alert {
            color: red;
            font-size: 14px;
            margin-top: 2%;
        }
        #resendotp_btn, .verification-alert, .success-otp,#phoneresendotp_btn, .phoneverification-alert, .phonesuccess-otp {
            display: none;
        }
        .verifyotpbtn,.phoneverifyotpbtn {
            display: block;
            margin-top: 4%;   
        }
        .otp_alert,.phoneotp_alert {
            font-size: 14px;
            margin-bottom: 5%;
            margin-top: 5%;
            color: darkred;
        }
        .reset-password {
            float: right;
            font-size: 14px;
            color: #443f98;
            text-decoration: underline; 
            font-family: "Graphik Web Regular",-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif!important;
        }
        @media (max-width: 768px) {
            .container-box {
                flex-direction: column;
            }
            .slider-box {
                border-left: none;
                border-top: 1px solid #ddd;
            }
        }

        .signup-link {
            text-decoration: none;
            color: #007bff; /* keep Bootstrap link blue */
        }

        .signup-link:hover {
            text-decoration: none; /* prevent underline on hover */
            color: #0056b3;        /* optional darker blue on hover */
        }
        .logo-cls {
            width: 80%;
        }
        .logocls p {
            font-size: 18px!important;
            font-weight: 400!important;
            color:black!important;
        }
        .logocls .para-cls {
            margin-top:1%;
        }
    </style>
    <style>
        .pwd_error,.somethingerr,.already {
            display:none;
            color:red;
            font-size:15px;
        }
        .password-validation {
            color:red;
            display:none;
        }
        .successmsg {
            display:none;
            font-size:14px;
        }
        #togglePassword,#toggleREPassword {
            cursor:pointer;
            position: absolute;
            right: 3%;
            top: 26%;
            z-index:999999;
        }
    </style>
</head>
<body>

<div class="container-fluid signup-container">
  <div class="row w-100" style="margin: auto 10rem; box-shadow: 0px 0px 10px 0px white; border-radius: 20px; overflow: hidden;">
    <div class="col-lg-5 d-flex align-items-center justify-content-center p-0">
      <div class="form-section">
        <div class="text-center mb-2">
            <div class="row w-75 m-auto logocls" style='font-family:"Graphik Web Regular",-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif'>
                <div class="col-md-3 p-0"><a href="index_main.php"><img class="logo-cls" src="dist/img/b2lmobitech_logo.png"
               alt=" Logo" width="120"></a></div>
                <div class="col-md-9 p-0 text-left para-cls"><a href="index_main.php"><p class="mb-0">PMS</p>
            <p>Project Management System</p></a></div>
            </div>
        </div>
        <h4 class="text-center mb-4" style='font-family:"Graphik Web Regular",-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif'>Set Password</h4>
        <div class="login-container">
        <?php
          if (isset($_GET["key"]) && isset($_GET["mail"]) && isset($_GET["action"]) && ($_GET["action"]=="reset") && !isset($_POST["action"]))
            {
                $key = htmlspecialchars($_GET["key"]);
              $email = htmlspecialchars($_GET["mail"]);
              $curDate = date("Y-m-d H:i:s");
              $query = "SELECT * FROM `password_reset_temp` WHERE token_key='".$key."' and email='".$email."' and deletion=0 order by id desc limit 1";
              //echo $query;
              $query_row=mysqli_query($conn,$query);
              $row = mysqli_fetch_assoc($query_row);
              if ($row==false){
              $error .= '<h2>Invalid Link</h2>
            <p>The link is invalid/expired. Either you did not copy the correct link
            from the email, or you have already used the key in which case it is 
            deactivated.</p>';
            	}
            	else{
              $expDate = $row['expDate'];
              if ($expDate >= $curDate)
              { ?>
                    <div class="row d-block">
                <form autocomplete="off" onsubmit="return resetpassword()" method="post">
            <div class="col-lg-12 col-md-12 pl-0">
            </div>
             <input type="hidden" id="token" value="<?php echo $row['token_key']; ?>">
             <input type="hidden" id="tokenemail" value="<?php echo $row['email']; ?>">
             <input type="hidden" id="email" value="<?php echo $email;?>"/>
             <input type="hidden" id="main_organisation_id" value="<?php echo $row['main_organisation_id']; ?>">
             <input type="hidden" id="csrf_token" value="<?php 
            if (empty($_SESSION['csrf_token'])) {
                $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
            }
                echo $_SESSION['csrf_token'];
            
            ?>">
             
            <div class="col-lg-12 col-md-12 pl-0 pr-0">
                <div class="login-detail">
                    <div class="mb-3">
                        <label for="emailotp" class="form-label">Password</label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text">
                                    <i class="fas fa-key"></i>
                                </span>
                            </div>
                            <input type="password" class="form-control" id="newpwd" pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).{8,}" placeholder="New Password" title="Must contain at least one number and one uppercase and lowercase letter, and at least 8 or more characters" required>
                        </div>
                    </div>
          
                    <div class="mb-3">
                        <label for="emailotp" class="form-label">Confirm Password</label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text">
                                    <i class="fas fa-key"></i>
                                </span>
                            </div>
                            <input type="password" class="form-control" id="cfmpwd" pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).{8,}" placeholder="Confirm Password" title="Must contain at least one number and one uppercase and lowercase letter, and at least 8 or more characters" required>
                        </div>
                    </div>
                </div>
                
                <p class="somethingerr">Something went wrong!</p>
                <p class="password-validation">Password Not Match</p>
                          <div class="">
                              <span class="successmsg">Password Successfully Reset.</span>
                          </div>
            </div>
            <button type="submit" id="submitbtn" name="submit" class="btn btn-get-started btn-block">Reset Password</button>
            </form>
     </div>
            <?php  } 
                else
              {
                  $error .= "<h2>Link Expired</h2>
            <p>The link is expired. You are trying to use the expired link which 
            as valid only 24 hours (1 days after request).<br /><br /></p>";
              }
            }
            } 
            
            
         if($error!='')
          { ?>
          <div class="alert alert-danger" role="alert"><?php echo $error; ?></div>
          <?php } ?>
        </div>
        
        <p class="text-center mt-4 small">Already have an account? <a href="pms_login.php">Log in</a></p>
      </div>
    </div>
    <div class="col-lg-7 temp-ad d-none d-lg-flex justify-content-center p-0">
      <div class="text-center p-5" style="background: linear-gradient(120deg, #a9a5e5, #cfc9ef, #f2edf9); width: 100%;">
        <h2 class="mb-1">Project Management System</h2>
        <p class="mb-4" style="color: #6c68a0; font-weight: 550; font-size: 1rem;">Manage Projects Effortlessly</p>
        <div class="slider-box">
            <div id="carouselExampleIndicators" class="carousel slide" data-ride="carousel">
              <ol class="carousel-indicators">
                <li data-target="#carouselExampleIndicators" data-slide-to="0" class="active"></li>
                <li data-target="#carouselExampleIndicators" data-slide-to="1"></li>
                <li data-target="#carouselExampleIndicators" data-slide-to="2"></li>
              </ol>
              <div class="carousel-inner">
                <div class="carousel-item active">
                  <img class="d-block w-100" src="dist/img/slider1-rbg.png" alt="First slide">
                </div>
                <div class="carousel-item">
                  <img class="d-block w-100" src="dist/img/slider2-rbg.png" alt="Second slide">
                </div>
                <div class="carousel-item">
                  <img class="d-block w-100" src="dist/img/slider3-rbg.png" alt="Third slide">
                </div>
              </div>
              <a class="carousel-control-prev" href="#carouselExampleIndicators" role="button" data-slide="prev">
                <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                <span class="sr-only">Previous</span>
              </a>
              <a class="carousel-control-next" href="#carouselExampleIndicators" role="button" data-slide="next">
                <span class="carousel-control-next-icon" aria-hidden="true"></span>
                <span class="sr-only">Next</span>
              </a>
            </div>
          </div>
      </div>
    </div>
  </div>
</div>


<script src="plugins/jquery/jquery.min.js"></script>
<script src="plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="dist/js/adminlte.min.js"></script>
<script>
      function resetpassword()
      {
          
          var pass=document.getElementById("newpwd").value;
          var repass=document.getElementById("cfmpwd").value;
           var email=document.getElementById("email").value;
          var tokenemail=document.getElementById("tokenemail").value;
          var token=document.getElementById("token").value;
          var main_organisation_id=document.getElementById("main_organisation_id").value;
          var csrf_token=document.getElementById("csrf_token").value;
          
          
          if(pass!=repass)
          {
              
              $(".password-validation").show();
          }
          else if(email=='')
          {
              alert("Emailid Not Found");
          }
          else
          {
            $(".password-validation").hide();
            
          $.ajax({
        	  type: "POST",
        	  url: "resetpassword.php",
        	  data:{pass:pass,repass:repass,email:email,tokenemail:tokenemail,token:token,main_organisation_id:main_organisation_id,csrf_token:csrf_token},
        	   success: function(respond){
        	       //alert(respond);
        		if(respond==11)
        		{
        		    $(".already").hide();
        		    $(".somethingerr").hide();
        		    $(".successmsg").show();
                    $("#newpwd").val("");
                    $("#cfmpwd").val("");
        		    $(".successmsg").css("color","green");
        		    $(".resetbtn").hide();
        		    $("#submitbtn").hide();
        		    $("#loginbtn").show();
        		}
        		else if(respond==33)
        		{
        		    $(".somethingerr").show();
        		}
        		else if(respond==22)
        		{
        		    $(".already").show();
        		}
        	  }
        	});
          }
        	
        	return false;
      }
  </script>
  
  <script>
     
        const togglePassword = document.querySelector("#togglePassword");
        const password = document.querySelector("#newpwd");
        
        togglePassword.addEventListener("click", function () {
           
          // toggle the type attribute
          const type = password.getAttribute("type") === "password" ? "text" : "password";
          password.setAttribute("type", type);
          // toggle the eye icon
          this.classList.toggle('fa-eye');
          this.classList.toggle('fa-eye-slash');
        });
    </script>
    
    <script>
        const toggleREPassword = document.querySelector("#toggleREPassword");
        const passwordRE = document.querySelector("#cfmpwd");
        
        toggleREPassword.addEventListener("click", function () {
           
          // toggle the type attribute
          const type = passwordRE.getAttribute("type") === "password" ? "text" : "password";
          passwordRE.setAttribute("type", type);
          // toggle the eye icon
          this.classList.toggle('fa-eye');
          this.classList.toggle('fa-eye-slash');
        });
    </script>
</body>
</html>