<?php
    include "../../db/connection.php";
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tundra Play</title>

    <?php include "../support_header.php"; ?>
    <link rel="stylesheet" href="../../assets/custom_css/other_styles.css">
</head>
<body>
    <div class="wrapper">
        <div class="app-content-header">
            <div class="row">
                <div class="col-6"><div class="heading">Content Types</div></div>
                <div class="col-6 text-right">
                    <a href="contenttype_save.php" class="btn btn-primary mr-2">+ Content Type</a>
                    <a class="btn btn-secondary" href="../dashboard.php">Back</a>
                </div>
            </div>
        </div>
        <div class="app-content">
            <div class="card">
                <div class="datatableContainer">
                    <table id="datatable-response" class="dataTable">
                        <thead>
                            <tr>
                                <th>S.No</th>
                                <th>Content Types</th>
                                <th>Added Time</th>
                                <th class="text-center">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                $sql = "SELECT id, contenttype_id, contenttype_type, added_time  
                                        FROM contenttype 
                                        WHERE deletion = 0";
                                $res = mysqli_query($conn, $sql);
                                if ($res && mysqli_num_rows($res) > 0) {
                                    $sno = 1;
                                    while ($row = mysqli_fetch_assoc($res)) {
                            ?>
                                        <tr>
                                            <td><?php echo $sno; ?></td>
                                            <td><?php echo $row['contenttype_type']; ?></td>
                                            <td><?php echo $row['added_time']; ?></td>
                                            <td>
                                                <div class="action-dot"><i class="fa fa-ellipsis-v"></i>
                                                    <div class="menu-box">
                                                        <ul class="p-0 m-0">
                                                            <li class="menu-item"><a href="contenttype_save.php?contenttype_id=<?php echo $row['contenttype_id']; ?>">Edit</a></li>
                                                            <li class="menu-item"><a href="javascript:void(0)" data-id="<?php echo $row['contenttype_id']; ?>" id="deletemenu">Delete</a></li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                            <?php
                                        $sno++;
                                    }
                                }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <?php include "../support_footer.php"; ?>

    <script>
        $('#datatable-response').DataTable({
            responsive: true,
            autoWidth: false,
            scrollX: false,
            dom: '<"top d-flex justify-content-between"lBf>rt<"bottom d-flex justify-content-between"ip><"clear">',
            buttons: ['copy', 'csv', 'excel', 'pdf', 'print', 'colvis'],
            columnDefs: [
                { responsivePriority: 1, targets: -1 }
            ]
        });        
    </script>
    <script>
        $(document).on("click","#deletemenu",function(){
            var id=$(this).data("id");
            $("#staticBackdrop").modal("show");
            document.getElementById('okbutton').setAttribute('onclick','delbtn("'+id+'")');
            $("#staticBackdrop .confirmation p").html("Are you sure to Delete?");
        });
        
        function delbtn(id) {
            var type="delete_contenttype";
            $.ajax({
                type: "POST",
                url: "setting_function.php",
                data: {type:type,id:id},
                async: false,
                success: function(response) {
                    //alert(response);
                    if(response==11) {
                        $("#staticBackdrop").modal("hide");
                        $("#successalertmodal").modal("show");
                        $("#successalertmodal .confirmation p").html("Successfully Deleted!");
                        $("#successok").attr("href",url);
                    } else {
                        $("#staticBackdrop").modal("hide");
                        $("#erroralertmodal").modal("show");
                        $("#erroralertmodal .confirmation p").html("Not Deleted!");
                    }
                }
            });
            return false;
        }
    </script>

</body>
</html>