<?php
    include "../../db/connection.php";

    $device_id = isset($_GET['device_id']) ? $_GET['device_id'] : '';
    $back_url = 'device_list.php';
    
    $row1 = [];
    $query1 = "SELECT id, device_id, device_type FROM device WHERE device_id = '$device_id'";
    $result1 = mysqli_query($conn, $query1);
    if ($result1 && mysqli_num_rows($result1) > 0) {
        $row1 = mysqli_fetch_assoc($result1);
    } 
    
    if (empty($row1)) {
        $savetype = "add_device";
    } else {
        $savetype = "edit_device";
    }
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tundra Play</title>

    <?php include "../support_header.php"; ?>
    <link rel="stylesheet" href="../../assets/custom_css/other_styles.css">
</head>
<body>
    <div class="wrapper">
        <form id="saveForm" onsubmit="return add_form()" method="post" enctype="multipart/form-data">
            <div class="app-content-header">
                <div class="row">
                    <div class="col-6"><div class="heading">Save Device</div></div>
                    <div class="col-6 text-right">
                        <button type="submit" class="btn btn-primary mr-2" name="submit">Save</button>
                        <a class="btn btn-secondary" href="<?php echo $back_url; ?>">Back</a>
                    </div>
                </div>
            </div>
            <div class="app-content">
                <div class="card">

                    <input type="hidden" id="save_type" name="save_type" class="form-control" value="<?php echo $savetype; ?>" />
                    <input type="hidden" id="device_id" name="device_id" class="form-control" value="<?php echo $row1['device_id'] ?? ''; ?>" />

                    <div class="row">
                        <div class="col-12">
                            <div class="form-group">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">Device</span>
                                    </div>
                                    <input type="text" class="form-control" name="device_type" id="device_type" value="<?php echo $row1['device_type'] ?? ''; ?>">
                                </div>
                                <div class="error" id="device_type_error"></div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </form>
    </div>

    <?php include "../support_footer.php"; ?>

    <script> 
        function add_form() {
            
            $('.error').html('');
            var url = "<?php echo $back_url;?>";
            var save_type = $("#save_type").val().trim();
            var device_id = $("#device_id").val().trim();
            var device_type = $("#device_type").val().trim();
            
            var count = 0;

            if (device_type == '') { $('#device_type_error').html('*Required'); count++; }
            
            if (count > 0) return false;

            var formData = new FormData();
            formData.append("type", save_type); 
            formData.append("device_id", device_id); 
            formData.append("device_type", device_type);  
            
            // for (var pair of formData.entries()) {
            //     console.log(pair[0] + ': ' + pair[1]);
            // }
            
            $.ajax({
                type: "POST",
                url: "setting_function.php",
                data: formData,
                processData: false, 
                contentType: false, 
                dataType: "json",
                success: function (response) {
                    // console.log("Server response:", response);
                    // alert(JSON.stringify(response));

                    if (response.status === 'success' && response.code === 11) {
                        alert("Successfully Saved!");
                    } else if (response.status === 'exists' || response.status === 'extension_error') {
                        alert(response.message);
                    } else if (response.status === 'error') {
                        $('.error').html(''); 
                        if (response.errors && response.errors.length > 0) {
                            response.errors.forEach(function(field) {
                                $('#' + field + '_error').html('*Required');
                            });
                        }
                    } else {
                        alert(response.message || "Not Added!");
                    }
                },
                error: function (xhr, status, error) {
                    console.error("AJAX Error:", status, error);
                    alert("Server Error: " + error);
                }
            });

            return false;
        }
    </script>

</body>
</html>