<?php
    include "../../db/connection.php";

    $resolution_id = isset($_GET['resolution_id']) ? $_GET['resolution_id'] : '';
    $back_url = 'resolution_list.php';
    
    $row1 = [];
    $query1 = "SELECT id, resolution_id, resolution_type FROM resolution WHERE resolution_id = '$resolution_id'";
    $result1 = mysqli_query($conn, $query1);
    if ($result1 && mysqli_num_rows($result1) > 0) {
        $row1 = mysqli_fetch_assoc($result1);
    } 
    
    if (empty($row1)) {
        $savetype = "add_resolution";
    } else {
        $savetype = "edit_resolution";
    }
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tundra Play</title>

    <?php include "../support_header.php"; ?>
    <link rel="stylesheet" href="../../assets/custom_css/other_styles.css">
</head>
<body>
    <div class="wrapper">
        <form id="saveForm" onsubmit="return add_form()" method="post" enctype="multipart/form-data">
            <div class="app-content-header">
                <div class="row">
                    <div class="col-6"><div class="heading">Save Resolution</div></div>
                    <div class="col-6 text-right">
                        <button type="submit" class="btn btn-primary mr-2" name="submit">Save</button>
                        <a class="btn btn-secondary" href="<?php echo $back_url; ?>">Back</a>
                    </div>
                </div>
            </div>
            <div class="app-content">
                <div class="card">

                    <input type="hidden" id="save_type" name="save_type" class="form-control" value="<?php echo $savetype; ?>" />
                    <input type="hidden" id="resolution_id" name="resolution_id" class="form-control" value="<?php echo $row1['resolution_id'] ?? ''; ?>" />

                    <div class="row">
                        <div class="col-12">
                            <div class="form-group">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">Resolution</span>
                                    </div>
                                    <input type="text" class="form-control" name="resolution_type" id="resolution_type" value="<?php echo $row1['resolution_type'] ?? ''; ?>">
                                </div>
                                <div class="error" id="resolution_type_error"></div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </form>
    </div>

    <?php include "../support_footer.php"; ?>

    <script> 
        function add_form() {
            
            $('.error').html('');
            var url = "<?php echo $back_url;?>";
            var save_type = $("#save_type").val().trim();
            var resolution_id = $("#resolution_id").val().trim();
            var resolution_type = $("#resolution_type").val().trim();
            
            var count = 0;

            if (resolution_type == '') { $('#resolution_type_error').html('*Required'); count++; }
            
            if (count > 0) return false;

            var formData = new FormData();
            formData.append("type", save_type); 
            formData.append("resolution_id", resolution_id); 
            formData.append("resolution_type", resolution_type);  
            
            // for (var pair of formData.entries()) {
            //     console.log(pair[0] + ': ' + pair[1]);
            // }
            
            $.ajax({
                type: "POST",
                url: "setting_function.php",
                data: formData,
                processData: false, 
                contentType: false, 
                dataType: "json",
                success: function (response) {
                    // console.log("Server response:", response);
                    // alert(JSON.stringify(response));

                    if (response.status === 'success' && response.code === 11) {
                        alert("Successfully Saved!");
                    } else if (response.status === 'exists' || response.status === 'extension_error') {
                        alert(response.message);
                    } else if (response.status === 'error') {
                        $('.error').html(''); 
                        if (response.errors && response.errors.length > 0) {
                            response.errors.forEach(function(field) {
                                $('#' + field + '_error').html('*Required');
                            });
                        }
                    } else {
                        alert(response.message || "Not Added!");
                    }
                },
                error: function (xhr, status, error) {
                    console.error("AJAX Error:", status, error);
                    alert("Server Error: " + error);
                }
            });

            return false;
        }
    </script>

</body>
</html>