<?php
    include "../../db/connection.php";

    // $login_user_id = $_SESSION['tundra_user_id'];
    // $login_role = $_SESSION['tundra_role'];

    $login_user_id = "USER_1";
    $login_role = "admin";

    $type = $_POST['type'];

    date_default_timezone_set("Asia/Kolkata");
    $currentdatetime = date("Y-m-d H:i:s");
    $currentdate = date("Y-m-d");
    $currenttime = date("H-i-s");

    if ($type == 'add_genre') {
        $errors = [];

        $genre_id       = trim($_POST['genre_id'] ?? '');
        $genre_type       = trim($_POST['genre_type'] ?? '');

        if ($genre_type === '') { $errors[] = 'genre_type'; }

        if (!empty($errors)) {
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            exit;
        }

        // --- Check duplicate ---
        $check_sql = "SELECT id 
                        FROM genre 
                        WHERE deletion = 0 
                            AND genre_type = ?";
        $stmt_check = $conn->prepare($check_sql);
        $stmt_check->bind_param("s", $genre_type);
        $stmt_check->execute();
        $result_check = $stmt_check->get_result();

        if ($result_check->num_rows > 0) {
            echo json_encode(['status' => 'exists', 'message' => 'Already Available..!']);
            exit;
        }

        // --- Insert new record ---
        $insert_sql = "INSERT INTO genre (genre_id, genre_type, added_by, added_time)
                        VALUES ('NA', ?, ?, ?)";
        $stmt_insert = $conn->prepare($insert_sql);
        $stmt_insert->bind_param(
            "sss",
            $genre_type,
            $login_user_id,
            $currentdatetime
        );

        if ($stmt_insert->execute()) {
            $last_id = $conn->insert_id;
            $genre_id = 'GENRE_' . $last_id;
            
            $update_sql = "UPDATE genre 
                        SET genre_id = ? 
                        WHERE id = ?";
            $stmt_update = $conn->prepare($update_sql);
            $stmt_update->bind_param("si",$genre_id, $last_id);
            $stmt_update->execute();

            echo json_encode(['status' => 'success', 'code' => 11]);
        } else {
            echo json_encode(['status' => 'error', 'message' => $conn->error, 'code' => 00]);
        }

        $stmt_insert->close();
        $stmt_check->close();
    }
    else if ($type == 'edit_genre') {
        $errors = [];

        $genre_id       = trim($_POST['genre_id'] ?? '');
        $genre_type       = trim($_POST['genre_type'] ?? '');
        
        if ($genre_type === '') { $errors[] = 'genre_type'; }

        if (!empty($errors)) {
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            exit;
        }
            
        $update_sql = "UPDATE genre 
                    SET genre_type = ? 
                    WHERE genre_id = ?";
        $stmt_update = $conn->prepare($update_sql);
        $stmt_update->bind_param("ss",$genre_type, $genre_id);
        if ($stmt_update->execute()) {
            echo json_encode(['status' => 'success', 'code' => 11]);
        } else {
            echo json_encode(['status' => 'error', 'message' => $conn->error, 'code' => 00]);
        }
        
    }
    else if ($type == 'delete_genre') {
        $id = $_POST['id'];
        $sql = "UPDATE genre SET deleted_by = '$login_user_id', deleted_time = '$currentdatetime', deletion = 1 WHERE genre_id = '$id'";
        if ($conn->query($sql) === TRUE) {
            echo "11";
        } else {
            echo $conn->error;
        }
    } 
    else if ($type == 'add_contenttype') {
        $errors = [];

        $contenttype_id       = trim($_POST['contenttype_id'] ?? '');
        $contenttype_type       = trim($_POST['contenttype_type'] ?? '');

        if ($contenttype_type === '') { $errors[] = 'contenttype_type'; }

        if (!empty($errors)) {
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            exit;
        }

        // --- Check duplicate ---
        $check_sql = "SELECT id 
                        FROM contenttype 
                        WHERE deletion = 0 
                            AND contenttype_type = ?";
        $stmt_check = $conn->prepare($check_sql);
        $stmt_check->bind_param("s", $contenttype);
        $stmt_check->execute();
        $result_check = $stmt_check->get_result();

        if ($result_check->num_rows > 0) {
            echo json_encode(['status' => 'exists', 'message' => 'Already Available..!']);
            exit;
        }

        // --- Insert new record ---
        $insert_sql = "INSERT INTO contenttype (contenttype_id, contenttype_type, added_by, added_time)
                        VALUES ('NA', ?, ?, ?)";
        $stmt_insert = $conn->prepare($insert_sql);
        $stmt_insert->bind_param(
            "sss",
            $contenttype_type,
            $login_user_id,
            $currentdatetime
        );

        if ($stmt_insert->execute()) {
            $last_id = $conn->insert_id;
            $contenttype_id = 'CONTENTTYPE_' . $last_id;
            
            $update_sql = "UPDATE contenttype 
                        SET contenttype_id = ? 
                        WHERE id = ?";
            $stmt_update = $conn->prepare($update_sql);
            $stmt_update->bind_param("si",$contenttype_id, $last_id);
            $stmt_update->execute();

            echo json_encode(['status' => 'success', 'code' => 11]);
        } else {
            echo json_encode(['status' => 'error', 'message' => $conn->error, 'code' => 00]);
        }

        $stmt_insert->close();
        $stmt_check->close();
    }
    else if ($type == 'edit_contenttype') {
        $errors = [];

        $contenttype_id       = trim($_POST['contenttype_id'] ?? '');
        $contenttype_type       = trim($_POST['contenttype_type'] ?? '');
        
        if ($contenttype_type === '') { $errors[] = 'contenttype_type'; }

        if (!empty($errors)) {
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            exit;
        }
            
        $update_sql = "UPDATE contenttype 
                    SET contenttype_type = ? 
                    WHERE contenttype_id = ?";
        $stmt_update = $conn->prepare($update_sql);
        $stmt_update->bind_param("ss",$contenttype_type, $contenttype_id);
        if ($stmt_update->execute()) {
            echo json_encode(['status' => 'success', 'code' => 11]);
        } else {
            echo json_encode(['status' => 'error', 'message' => $conn->error, 'code' => 00]);
        }
        
    }
    else if ($type == 'delete_contenttype') {
        $id = $_POST['id'];
        $sql = "UPDATE contenttype SET deleted_by = '$login_user_id', deleted_time = '$currentdatetime', deletion = 1 WHERE contenttype_id = '$id'";
        if ($conn->query($sql) === TRUE) {
            echo "11";
        } else {
            echo $conn->error;
        }
    } 
    else if ($type == 'add_certificate') {
        $errors = [];

        $certificate_id       = trim($_POST['certificate_id'] ?? '');
        $certificate_type       = trim($_POST['certificate_type'] ?? '');

        if ($certificate_type === '') { $errors[] = 'certificate_type'; }

        if (!empty($errors)) {
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            exit;
        }

        // --- Check duplicate ---
        $check_sql = "SELECT id 
                        FROM certificate 
                        WHERE deletion = 0 
                            AND certificate_type = ?";
        $stmt_check = $conn->prepare($check_sql);
        $stmt_check->bind_param("s", $certificate_type);
        $stmt_check->execute();
        $result_check = $stmt_check->get_result();

        if ($result_check->num_rows > 0) {
            echo json_encode(['status' => 'exists', 'message' => 'Already Available..!']);
            exit;
        }

        // --- Insert new record ---
        $insert_sql = "INSERT INTO certificate (certificate_id, certificate_type, added_by, added_time)
                        VALUES ('NA', ?, ?, ?)";
        $stmt_insert = $conn->prepare($insert_sql);
        $stmt_insert->bind_param(
            "sss",
            $certificate_type,
            $login_user_id,
            $currentdatetime
        );

        if ($stmt_insert->execute()) {
            $last_id = $conn->insert_id;
            $certificate_id = 'CERTIFICATE_' . $last_id;
            
            $update_sql = "UPDATE certificate 
                        SET certificate_id = ? 
                        WHERE id = ?";
            $stmt_update = $conn->prepare($update_sql);
            $stmt_update->bind_param("si",$certificate_id, $last_id);
            $stmt_update->execute();

            echo json_encode(['status' => 'success', 'code' => 11]);
        } else {
            echo json_encode(['status' => 'error', 'message' => $conn->error, 'code' => 00]);
        }

        $stmt_insert->close();
        $stmt_check->close();
    }
    else if ($type == 'edit_certificate') {
        $errors = [];

        $certificate_id       = trim($_POST['certificate_id'] ?? '');
        $certificate_type       = trim($_POST['certificate_type'] ?? '');
        
        if ($certificate_type === '') { $errors[] = 'certificate_type'; }

        if (!empty($errors)) {
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            exit;
        }
            
        $update_sql = "UPDATE certificate 
                    SET certificate_type = ? 
                    WHERE certificate_id = ?";
        $stmt_update = $conn->prepare($update_sql);
        $stmt_update->bind_param("ss",$certificate_type, $certificate_id);
        if ($stmt_update->execute()) {
            echo json_encode(['status' => 'success', 'code' => 11]);
        } else {
            echo json_encode(['status' => 'error', 'message' => $conn->error, 'code' => 00]);
        }
        
    }
    else if ($type == 'delete_certificate') {
        $id = $_POST['id'];
        $sql = "UPDATE certificate SET deleted_by = '$login_user_id', deleted_time = '$currentdatetime', deletion = 1 WHERE certificate_id = '$id'";
        if ($conn->query($sql) === TRUE) {
            echo "11";
        } else {
            echo $conn->error;
        }
    } 
    else if ($type == 'add_device') {
        $errors = [];

        $device_id       = trim($_POST['device_id'] ?? '');
        $device_type       = trim($_POST['device_type'] ?? '');

        if ($device_type === '') { $errors[] = 'device_type'; }

        if (!empty($errors)) {
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            exit;
        }

        // --- Check duplicate ---
        $check_sql = "SELECT id 
                        FROM device 
                        WHERE deletion = 0 
                            AND device_type = ?";
        $stmt_check = $conn->prepare($check_sql);
        $stmt_check->bind_param("s", $device_type);
        $stmt_check->execute();
        $result_check = $stmt_check->get_result();

        if ($result_check->num_rows > 0) {
            echo json_encode(['status' => 'exists', 'message' => 'Already Available..!']);
            exit;
        }

        // --- Insert new record ---
        $insert_sql = "INSERT INTO device (device_id, device_type, added_by, added_time)
                        VALUES ('NA', ?, ?, ?)";
        $stmt_insert = $conn->prepare($insert_sql);
        $stmt_insert->bind_param(
            "sss",
            $device_type,
            $login_user_id,
            $currentdatetime
        );

        if ($stmt_insert->execute()) {
            $last_id = $conn->insert_id;
            $device_id = 'DEVICE_' . $last_id;
            
            $update_sql = "UPDATE device 
                        SET device_id = ? 
                        WHERE id = ?";
            $stmt_update = $conn->prepare($update_sql);
            $stmt_update->bind_param("si",$device_id, $last_id);
            $stmt_update->execute();

            echo json_encode(['status' => 'success', 'code' => 11]);
        } else {
            echo json_encode(['status' => 'error', 'message' => $conn->error, 'code' => 00]);
        }

        $stmt_insert->close();
        $stmt_check->close();
    }
    else if ($type == 'edit_device') {
        $errors = [];

        $device_id       = trim($_POST['device_id'] ?? '');
        $device_type       = trim($_POST['device_type'] ?? '');
        
        if ($device_type === '') { $errors[] = 'device_type'; }

        if (!empty($errors)) {
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            exit;
        }
            
        $update_sql = "UPDATE device 
                    SET device_type = ? 
                    WHERE device_id = ?";
        $stmt_update = $conn->prepare($update_sql);
        $stmt_update->bind_param("ss",$device_type, $device_id);
        if ($stmt_update->execute()) {
            echo json_encode(['status' => 'success', 'code' => 11]);
        } else {
            echo json_encode(['status' => 'error', 'message' => $conn->error, 'code' => 00]);
        }
        
    }
    else if ($type == 'delete_device') {
        $id = $_POST['id'];
        $sql = "UPDATE device SET deleted_by = '$login_user_id', deleted_time = '$currentdatetime', deletion = 1 WHERE device_id = '$id'";
        if ($conn->query($sql) === TRUE) {
            echo "11";
        } else {
            echo $conn->error;
        }
    } 
    else if ($type == 'add_mood') {
        $errors = [];

        $mood_id       = trim($_POST['mood_id'] ?? '');
        $mood_type       = trim($_POST['mood_type'] ?? '');

        if ($mood_type === '') { $errors[] = 'mood_type'; }

        if (!empty($errors)) {
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            exit;
        }

        // --- Check duplicate ---
        $check_sql = "SELECT id 
                        FROM mood 
                        WHERE deletion = 0 
                            AND mood_type = ?";
        $stmt_check = $conn->prepare($check_sql);
        $stmt_check->bind_param("s", $mood_type);
        $stmt_check->execute();
        $result_check = $stmt_check->get_result();

        if ($result_check->num_rows > 0) {
            echo json_encode(['status' => 'exists', 'message' => 'Already Available..!']);
            exit;
        }

        // --- Insert new record ---
        $insert_sql = "INSERT INTO mood (mood_id, mood_type, added_by, added_time)
                        VALUES ('NA', ?, ?, ?)";
        $stmt_insert = $conn->prepare($insert_sql);
        $stmt_insert->bind_param(
            "sss",
            $mood_type,
            $login_user_id,
            $currentdatetime
        );

        if ($stmt_insert->execute()) {
            $last_id = $conn->insert_id;
            $mood_id = 'MOOD_' . $last_id;
            
            $update_sql = "UPDATE mood 
                        SET mood_id = ? 
                        WHERE id = ?";
            $stmt_update = $conn->prepare($update_sql);
            $stmt_update->bind_param("si",$mood_id, $last_id);
            $stmt_update->execute();

            echo json_encode(['status' => 'success', 'code' => 11]);
        } else {
            echo json_encode(['status' => 'error', 'message' => $conn->error, 'code' => 00]);
        }

        $stmt_insert->close();
        $stmt_check->close();
    }
    else if ($type == 'edit_mood') {
        $errors = [];

        $mood_id       = trim($_POST['mood_id'] ?? '');
        $mood_type       = trim($_POST['mood_type'] ?? '');
        
        if ($mood_type === '') { $errors[] = 'mood_type'; }

        if (!empty($errors)) {
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            exit;
        }
            
        $update_sql = "UPDATE mood 
                    SET mood_type = ? 
                    WHERE mood_id = ?";
        $stmt_update = $conn->prepare($update_sql);
        $stmt_update->bind_param("ss",$mood_type, $mood_id);
        if ($stmt_update->execute()) {
            echo json_encode(['status' => 'success', 'code' => 11]);
        } else {
            echo json_encode(['status' => 'error', 'message' => $conn->error, 'code' => 00]);
        }
        
    }
    else if ($type == 'delete_mood') {
        $id = $_POST['id'];
        $sql = "UPDATE mood SET deleted_by = '$login_user_id', deleted_time = '$currentdatetime', deletion = 1 WHERE mood_id = '$id'";
        if ($conn->query($sql) === TRUE) {
            echo "11";
        } else {
            echo $conn->error;
        }
    } 
    else if ($type == 'add_pace') {
        $errors = [];

        $pace_id       = trim($_POST['pace_id'] ?? '');
        $pace_type       = trim($_POST['pace_type'] ?? '');

        if ($pace_type === '') { $errors[] = 'pace_type'; }

        if (!empty($errors)) {
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            exit;
        }

        // --- Check duplicate ---
        $check_sql = "SELECT id 
                        FROM pace 
                        WHERE deletion = 0 
                            AND pace_type = ?";
        $stmt_check = $conn->prepare($check_sql);
        $stmt_check->bind_param("s", $pace_type);
        $stmt_check->execute();
        $result_check = $stmt_check->get_result();

        if ($result_check->num_rows > 0) {
            echo json_encode(['status' => 'exists', 'message' => 'Already Available..!']);
            exit;
        }

        // --- Insert new record ---
        $insert_sql = "INSERT INTO pace (pace_id, pace_type, added_by, added_time)
                        VALUES ('NA', ?, ?, ?)";
        $stmt_insert = $conn->prepare($insert_sql);
        $stmt_insert->bind_param(
            "sss",
            $pace_type,
            $login_user_id,
            $currentdatetime
        );

        if ($stmt_insert->execute()) {
            $last_id = $conn->insert_id;
            $pace_id = 'PACE_' . $last_id;
            
            $update_sql = "UPDATE pace 
                        SET pace_id = ? 
                        WHERE id = ?";
            $stmt_update = $conn->prepare($update_sql);
            $stmt_update->bind_param("si",$pace_id, $last_id);
            $stmt_update->execute();

            echo json_encode(['status' => 'success', 'code' => 11]);
        } else {
            echo json_encode(['status' => 'error', 'message' => $conn->error, 'code' => 00]);
        }

        $stmt_insert->close();
        $stmt_check->close();
    }
    else if ($type == 'edit_pace') {
        $errors = [];

        $pace_id       = trim($_POST['pace_id'] ?? '');
        $pace_type       = trim($_POST['pace_type'] ?? '');
        
        if ($pace_type === '') { $errors[] = 'pace_type'; }

        if (!empty($errors)) {
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            exit;
        }
            
        $update_sql = "UPDATE pace 
                    SET pace_type = ? 
                    WHERE pace_id = ?";
        $stmt_update = $conn->prepare($update_sql);
        $stmt_update->bind_param("ss",$pace_type, $pace_id);
        if ($stmt_update->execute()) {
            echo json_encode(['status' => 'success', 'code' => 11]);
        } else {
            echo json_encode(['status' => 'error', 'message' => $conn->error, 'code' => 00]);
        }
        
    }
    else if ($type == 'delete_pace') {
        $id = $_POST['id'];
        $sql = "UPDATE pace SET deleted_by = '$login_user_id', deleted_time = '$currentdatetime', deletion = 1 WHERE pace_id = '$id'";
        if ($conn->query($sql) === TRUE) {
            echo "11";
        } else {
            echo $conn->error;
        }
    } 
    else if ($type == 'add_resolution') {
        $errors = [];

        $resolution_id       = trim($_POST['resolution_id'] ?? '');
        $resolution_type       = trim($_POST['resolution_type'] ?? '');

        if ($resolution_type === '') { $errors[] = 'resolution_type'; }

        if (!empty($errors)) {
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            exit;
        }

        // --- Check duplicate ---
        $check_sql = "SELECT id 
                        FROM resolution 
                        WHERE deletion = 0 
                            AND resolution_type = ?";
        $stmt_check = $conn->prepare($check_sql);
        $stmt_check->bind_param("s", $resolution_type);
        $stmt_check->execute();
        $result_check = $stmt_check->get_result();

        if ($result_check->num_rows > 0) {
            echo json_encode(['status' => 'exists', 'message' => 'Already Available..!']);
            exit;
        }

        // --- Insert new record ---
        $insert_sql = "INSERT INTO resolution (resolution_id, resolution_type, added_by, added_time)
                        VALUES ('NA', ?, ?, ?)";
        $stmt_insert = $conn->prepare($insert_sql);
        $stmt_insert->bind_param(
            "sss",
            $resolution_type,
            $login_user_id,
            $currentdatetime
        );

        if ($stmt_insert->execute()) {
            $last_id = $conn->insert_id;
            $resolution_id = 'RESOLUTION_' . $last_id;
            
            $update_sql = "UPDATE resolution 
                        SET resolution_id = ? 
                        WHERE id = ?";
            $stmt_update = $conn->prepare($update_sql);
            $stmt_update->bind_param("si",$resolution_id, $last_id);
            $stmt_update->execute();

            echo json_encode(['status' => 'success', 'code' => 11]);
        } else {
            echo json_encode(['status' => 'error', 'message' => $conn->error, 'code' => 00]);
        }

        $stmt_insert->close();
        $stmt_check->close();
    }
    else if ($type == 'edit_resolution') {
        $errors = [];

        $resolution_id       = trim($_POST['resolution_id'] ?? '');
        $resolution_type       = trim($_POST['resolution_type'] ?? '');
        
        if ($resolution_type === '') { $errors[] = 'resolution_type'; }

        if (!empty($errors)) {
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            exit;
        }
            
        $update_sql = "UPDATE resolution 
                    SET resolution_type = ? 
                    WHERE resolution_id = ?";
        $stmt_update = $conn->prepare($update_sql);
        $stmt_update->bind_param("ss",$resolution_type, $resolution_id);
        if ($stmt_update->execute()) {
            echo json_encode(['status' => 'success', 'code' => 11]);
        } else {
            echo json_encode(['status' => 'error', 'message' => $conn->error, 'code' => 00]);
        }
        
    }
    else if ($type == 'delete_resolution') {
        $id = $_POST['id'];
        $sql = "UPDATE resolution SET deleted_by = '$login_user_id', deleted_time = '$currentdatetime', deletion = 1 WHERE resolution_id = '$id'";
        if ($conn->query($sql) === TRUE) {
            echo "11";
        } else {
            echo $conn->error;
        }
    } 
    else if ($type == 'add_target') {
        $errors = [];

        $target_id       = trim($_POST['target_id'] ?? '');
        $target_type       = trim($_POST['target_type'] ?? '');

        if ($target_type === '') { $errors[] = 'target_type'; }

        if (!empty($errors)) {
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            exit;
        }

        // --- Check duplicate ---
        $check_sql = "SELECT id 
                        FROM target 
                        WHERE deletion = 0 
                            AND target_type = ?";
        $stmt_check = $conn->prepare($check_sql);
        $stmt_check->bind_param("s", $target_type);
        $stmt_check->execute();
        $result_check = $stmt_check->get_result();

        if ($result_check->num_rows > 0) {
            echo json_encode(['status' => 'exists', 'message' => 'Already Available..!']);
            exit;
        }

        // --- Insert new record ---
        $insert_sql = "INSERT INTO target (target_id, target_type, added_by, added_time)
                        VALUES ('NA', ?, ?, ?)";
        $stmt_insert = $conn->prepare($insert_sql);
        $stmt_insert->bind_param(
            "sss",
            $target_type,
            $login_user_id,
            $currentdatetime
        );

        if ($stmt_insert->execute()) {
            $last_id = $conn->insert_id;
            $target_id = 'TARGET_' . $last_id;
            
            $update_sql = "UPDATE target 
                        SET target_id = ? 
                        WHERE id = ?";
            $stmt_update = $conn->prepare($update_sql);
            $stmt_update->bind_param("si",$target_id, $last_id);
            $stmt_update->execute();

            echo json_encode(['status' => 'success', 'code' => 11]);
        } else {
            echo json_encode(['status' => 'error', 'message' => $conn->error, 'code' => 00]);
        }

        $stmt_insert->close();
        $stmt_check->close();
    }
    else if ($type == 'edit_target') {
        $errors = [];

        $target_id       = trim($_POST['target_id'] ?? '');
        $target_type       = trim($_POST['target_type'] ?? '');
        
        if ($target_type === '') { $errors[] = 'target_type'; }

        if (!empty($errors)) {
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            exit;
        }
            
        $update_sql = "UPDATE target 
                    SET target_type = ? 
                    WHERE target_id = ?";
        $stmt_update = $conn->prepare($update_sql);
        $stmt_update->bind_param("ss",$target_type, $target_id);
        if ($stmt_update->execute()) {
            echo json_encode(['status' => 'success', 'code' => 11]);
        } else {
            echo json_encode(['status' => 'error', 'message' => $conn->error, 'code' => 00]);
        }
        
    }
    else if ($type == 'delete_target') {
        $id = $_POST['id'];
        $sql = "UPDATE target SET deleted_by = '$login_user_id', deleted_time = '$currentdatetime', deletion = 1 WHERE target_id = '$id'";
        if ($conn->query($sql) === TRUE) {
            echo "11";
        } else {
            echo $conn->error;
        }
    } 
    else if ($type == 'add_violence') {
        $errors = [];

        $violence_id       = trim($_POST['violence_id'] ?? '');
        $violence_type       = trim($_POST['violence_type'] ?? '');

        if ($violence_type === '') { $errors[] = 'violence_type'; }

        if (!empty($errors)) {
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            exit;
        }

        // --- Check duplicate ---
        $check_sql = "SELECT id 
                        FROM violence 
                        WHERE deletion = 0 
                            AND violence_type = ?";
        $stmt_check = $conn->prepare($check_sql);
        $stmt_check->bind_param("s", $violence_type);
        $stmt_check->execute();
        $result_check = $stmt_check->get_result();

        if ($result_check->num_rows > 0) {
            echo json_encode(['status' => 'exists', 'message' => 'Already Available..!']);
            exit;
        }

        // --- Insert new record ---
        $insert_sql = "INSERT INTO violence (violence_id, violence_type, added_by, added_time)
                        VALUES ('NA', ?, ?, ?)";
        $stmt_insert = $conn->prepare($insert_sql);
        $stmt_insert->bind_param(
            "sss",
            $violence_type,
            $login_user_id,
            $currentdatetime
        );

        if ($stmt_insert->execute()) {
            $last_id = $conn->insert_id;
            $violence_id = 'VIOLENCE_' . $last_id;
            
            $update_sql = "UPDATE violence 
                        SET violence_id = ? 
                        WHERE id = ?";
            $stmt_update = $conn->prepare($update_sql);
            $stmt_update->bind_param("si",$violence_id, $last_id);
            $stmt_update->execute();

            echo json_encode(['status' => 'success', 'code' => 11]);
        } else {
            echo json_encode(['status' => 'error', 'message' => $conn->error, 'code' => 00]);
        }

        $stmt_insert->close();
        $stmt_check->close();
    }
    else if ($type == 'edit_violence') {
        $errors = [];

        $violence_id       = trim($_POST['violence_id'] ?? '');
        $violence_type       = trim($_POST['violence_type'] ?? '');
        
        if ($violence_type === '') { $errors[] = 'violence_type'; }

        if (!empty($errors)) {
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            exit;
        }
            
        $update_sql = "UPDATE violence 
                    SET violence_type = ? 
                    WHERE violence_id = ?";
        $stmt_update = $conn->prepare($update_sql);
        $stmt_update->bind_param("ss",$violence_type, $violence_id);
        if ($stmt_update->execute()) {
            echo json_encode(['status' => 'success', 'code' => 11]);
        } else {
            echo json_encode(['status' => 'error', 'message' => $conn->error, 'code' => 00]);
        }
        
    }
    else if ($type == 'delete_violence') {
        $id = $_POST['id'];
        $sql = "UPDATE violence SET deleted_by = '$login_user_id', deleted_time = '$currentdatetime', deletion = 1 WHERE violence_id = '$id'";
        if ($conn->query($sql) === TRUE) {
            echo "11";
        } else {
            echo $conn->error;
        }
    } 
    else if ($type == 'add_agerating') {
        $errors = [];

        $agerating_id       = trim($_POST['agerating_id'] ?? '');
        $agerating_type       = trim($_POST['agerating_type'] ?? '');

        if ($agerating_type === '') { $errors[] = 'agerating_type'; }

        if (!empty($errors)) {
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            exit;
        }

        // --- Check duplicate ---
        $check_sql = "SELECT id 
                        FROM agerating 
                        WHERE deletion = 0 
                            AND agerating_type = ?";
        $stmt_check = $conn->prepare($check_sql);
        $stmt_check->bind_param("s", $agerating_type);
        $stmt_check->execute();
        $result_check = $stmt_check->get_result();

        if ($result_check->num_rows > 0) {
            echo json_encode(['status' => 'exists', 'message' => 'Already Available..!']);
            exit;
        }

        // --- Insert new record ---
        $insert_sql = "INSERT INTO agerating (agerating_id, agerating_type, added_by, added_time)
                        VALUES ('NA', ?, ?, ?)";
        $stmt_insert = $conn->prepare($insert_sql);
        $stmt_insert->bind_param(
            "sss",
            $agerating_type,
            $login_user_id,
            $currentdatetime
        );

        if ($stmt_insert->execute()) {
            $last_id = $conn->insert_id;
            $agerating_id = 'agerating_' . $last_id;
            
            $update_sql = "UPDATE agerating 
                        SET agerating_id = ? 
                        WHERE id = ?";
            $stmt_update = $conn->prepare($update_sql);
            $stmt_update->bind_param("si",$agerating_id, $last_id);
            $stmt_update->execute();

            echo json_encode(['status' => 'success', 'code' => 11]);
        } else {
            echo json_encode(['status' => 'error', 'message' => $conn->error, 'code' => 00]);
        }

        $stmt_insert->close();
        $stmt_check->close();
    }
    else if ($type == 'edit_agerating') {
        $errors = [];

        $agerating_id       = trim($_POST['agerating_id'] ?? '');
        $agerating_type       = trim($_POST['agerating_type'] ?? '');
        
        if ($agerating_type === '') { $errors[] = 'agerating_type'; }

        if (!empty($errors)) {
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            exit;
        }
            
        $update_sql = "UPDATE agerating 
                    SET agerating_type = ? 
                    WHERE agerating_id = ?";
        $stmt_update = $conn->prepare($update_sql);
        $stmt_update->bind_param("ss",$agerating_type, $agerating_id);
        if ($stmt_update->execute()) {
            echo json_encode(['status' => 'success', 'code' => 11]);
        } else {
            echo json_encode(['status' => 'error', 'message' => $conn->error, 'code' => 00]);
        }
        
    }
    else if ($type == 'delete_agerating') {
        $id = $_POST['id'];
        $sql = "UPDATE agerating SET deleted_by = '$login_user_id', deleted_time = '$currentdatetime', deletion = 1 WHERE agerating_id = '$id'";
        if ($conn->query($sql) === TRUE) {
            echo "11";
        } else {
            echo $conn->error;
        }
    } 
    else if ($type == 'add_subscription') {
        $errors = [];

        $subscription_id       = trim($_POST['subscription_id'] ?? '');
        $subscription_type       = trim($_POST['subscription_type'] ?? '');
        $amount       = trim($_POST['amount'] ?? '');
        $ads       = trim($_POST['ads'] ?? '');
        $downloads       = trim($_POST['downloads'] ?? '');
        $no_devices       = trim($_POST['no_devices'] ?? '');
        $no_days       = trim($_POST['no_days'] ?? '');
        $device_ids = isset($_POST['device_ids']) ? $_POST['device_ids'] : [];
        $resolution_ids = isset($_POST['resolution_ids']) ? $_POST['resolution_ids'] : [];

        if ($subscription_type === '') { $errors[] = 'subscription_type'; }
        if ($amount === '') { $errors[] = 'amount'; }
        if ($ads === '') { $errors[] = 'ads'; }
        if ($downloads === '') { $errors[] = 'downloads'; }
        if ($no_devices === '') { $errors[] = 'no_devices'; }
        if ($no_days === '') { $errors[] = 'no_days'; }

        if (!empty($errors)) {
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            exit;
        }

        // --- Check duplicate ---
        $check_sql = "SELECT id 
                        FROM subscription 
                        WHERE deletion = 0 
                            AND subscription_type = ?";
        $stmt_check = $conn->prepare($check_sql);
        $stmt_check->bind_param("s", $subscription_type);
        $stmt_check->execute();
        $result_check = $stmt_check->get_result();

        if ($result_check->num_rows > 0) {
            echo json_encode(['status' => 'exists', 'message' => 'Already Available..!']);
            exit;
        }

        // --- Insert new record ---
        $insert_sql = "INSERT INTO subscription (subscription_id, subscription_type, amount, ads, downloads, no_devices, no_days, added_by, added_time)
                        VALUES ('NA', ?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt_insert = $conn->prepare($insert_sql);
        $stmt_insert->bind_param(
            "ssssssss",
            $subscription_type,
            $amount,
            $ads,
            $downloads,
            $no_devices,
            $no_days,
            $login_user_id,
            $currentdatetime
        );

        if ($stmt_insert->execute()) {
            $last_id = $conn->insert_id;
            $subscription_id = 'SUBSCRIPTION_' . $last_id;
            
            $update_sql = "UPDATE subscription 
                        SET subscription_id = ? 
                        WHERE id = ?";
            $stmt_update = $conn->prepare($update_sql);
            $stmt_update->bind_param("si",$subscription_id, $last_id);
            $stmt_update->execute();

            if (!empty($device_ids)) {
                foreach ($device_ids as $device_id) {
                    $insert_dt_sql = "INSERT INTO subscription_devices 
                        (subscription_id, device_id, added_by, added_time)
                        VALUES (?, ?, ?, ?)";
                    $stmt_dt = $conn->prepare($insert_dt_sql);
                    $stmt_dt->bind_param("ssss", $subscription_id, $device_id, $login_user_id, $currentdatetime);
                    $stmt_dt->execute();
                }
            }
            
            if (!empty($resolution_ids)) {
                foreach ($resolution_ids as $resolution_id) {
                    $insert_ct_sql = "INSERT INTO subscription_resolutions 
                        ( subscription_id, resolution_id, added_by, added_time)
                        VALUES (?, ?, ?, ?)";
                    $stmt_ct = $conn->prepare($insert_ct_sql);
                    $stmt_ct->bind_param("ssss", $subscription_id, $resolution_id, $login_user_id, $currentdatetime);
                    $stmt_ct->execute();
                }
            }

            echo json_encode(['status' => 'success', 'code' => 11]);
        } else {
            echo json_encode(['status' => 'error', 'message' => $conn->error, 'code' => 00]);
        }

        $stmt_insert->close();
        $stmt_check->close();
    }
    else if ($type == 'edit_subscription') {
        $errors = [];

        $subscription_id       = trim($_POST['subscription_id'] ?? '');
        $subscription_type       = trim($_POST['subscription_type'] ?? '');
        $amount       = trim($_POST['amount'] ?? '');
        $ads       = trim($_POST['ads'] ?? '');
        $downloads       = trim($_POST['downloads'] ?? '');
        $no_devices       = trim($_POST['no_devices'] ?? '');
        $no_days       = trim($_POST['no_days'] ?? '');
        $device_ids = isset($_POST['device_ids']) ? $_POST['device_ids'] : [];
        $resolution_ids = isset($_POST['resolution_ids']) ? $_POST['resolution_ids'] : [];

        if ($subscription_type === '') { $errors[] = 'subscription_type'; }
        if ($amount === '') { $errors[] = 'amount'; }
        if ($ads === '') { $errors[] = 'ads'; }
        if ($downloads === '') { $errors[] = 'downloads'; }
        if ($no_devices === '') { $errors[] = 'no_devices'; }
        if ($no_days === '') { $errors[] = 'no_days'; }

        if (!empty($errors)) {
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            exit;
        }
            
        $update_sql = "UPDATE subscription 
                    SET subscription_type = ?, amount = ?, ads = ?, downloads = ?, no_devices = ?, no_days = ? 
                    WHERE subscription_id = ?";
        $stmt_update = $conn->prepare($update_sql);
        $stmt_update->bind_param("sssssss",$subscription_type,$amount,$ads,$downloads,$no_devices,$no_days, $subscription_id);
        if ($stmt_update->execute()) {

            $existing_devices = [];

            $sql = "SELECT device_id, deletion 
                    FROM subscription_devices 
                    WHERE subscription_id = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("s", $subscription_id);
            $stmt->execute();
            $res = $stmt->get_result();

            while ($row = $res->fetch_assoc()) {
                $existing_devices[$row['device_id']] = $row['deletion'];
            }

            $new_devices = $device_ids; 
            
            foreach ($new_devices as $device_id) { 
                if (!isset($existing_devices[$device_id])) {
                    // Completely new → INSERT
                    $sql = "INSERT INTO subscription_devices 
                            (subscription_id, device_id, deletion, added_by, added_time)
                            VALUES (?, ?, 0, ?, ?)";
                    $stmt = $conn->prepare($sql);
                    $stmt->bind_param("ssss", $subscription_id, $device_id, $login_user_id, $currentdatetime);
                    $stmt->execute();

                } elseif ($existing_devices[$device_id] == 1) {
                    // Was deleted → RESTORE
                    $sql = "UPDATE subscription_devices 
                            SET deletion = 0 
                            WHERE subscription_id = ? AND device_id = ?";
                    $stmt = $conn->prepare($sql);
                    $stmt->bind_param("ss", $subscription_id, $device_id);
                    $stmt->execute();
                }
            }

            foreach ($existing_devices as $device_id => $del_status) { 
                if ($del_status == 0 && !in_array($device_id, $new_devices)) {
                    // Previously active, now removed
                    $sql = "UPDATE subscription_devices 
                            SET deletion = 1 
                            WHERE subscription_id = ? AND device_id = ?";
                    $stmt = $conn->prepare($sql);
                    $stmt->bind_param("ss", $subscription_id, $device_id);
                    $stmt->execute();
                }
            }

            $existing_resolutions = [];

            $sql = "SELECT resolution_id, deletion 
                    FROM subscription_resolutions 
                    WHERE subscription_id = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("s", $subscription_id);
            $stmt->execute();
            $res = $stmt->get_result();

            while ($row = $res->fetch_assoc()) {
                $existing_resolutions[$row['resolution_id']] = $row['deletion'];
            }

            $new_resolutions = $resolution_ids; 
            
            foreach ($new_resolutions as $resolution_id) { 
                if (!isset($existing_resolutions[$resolution_id])) {
                    // Completely new → INSERT
                    $sql = "INSERT INTO subscription_resolutions 
                            (subscription_id, resolution_id, deletion, added_by, added_time)
                            VALUES (?, ?, 0, ?, ?)";
                    $stmt = $conn->prepare($sql);
                    $stmt->bind_param("ssss", $subscription_id, $resolution_id, $login_user_id, $currentdatetime);
                    $stmt->execute();

                } elseif ($existing_resolutions[$resolution_id] == 1) {
                    // Was deleted → RESTORE
                    $sql = "UPDATE subscription_resolutions 
                            SET deletion = 0 
                            WHERE subscription_id = ? AND resolution_id = ?";
                    $stmt = $conn->prepare($sql);
                    $stmt->bind_param("ss", $subscription_id, $resolution_id);
                    $stmt->execute();
                }
            }

            foreach ($existing_resolutions as $resolution_id => $del_status) { 
                if ($del_status == 0 && !in_array($resolution_id, $new_resolutions)) {
                    // Previously active, now removed
                    $sql = "UPDATE subscription_resolutions 
                            SET deletion = 1 
                            WHERE subscription_id = ? AND resolution_id = ?";
                    $stmt = $conn->prepare($sql);
                    $stmt->bind_param("ss", $subscription_id, $resolution_id);
                    $stmt->execute();
                }
            }

            echo json_encode(['status' => 'success', 'code' => 11]);

        } else {
            echo json_encode(['status' => 'error', 'message' => $conn->error, 'code' => 00]);
        }
        
    }
    else if ($type == 'delete_subscription') {
        $id = $_POST['id'];
        $sql = "UPDATE subscription SET deleted_by = '$login_user_id', deleted_time = '$currentdatetime', deletion = 1 WHERE subscription_id = '$id'";
        if ($conn->query($sql) === TRUE) {
            echo "11";
        } else {
            echo $conn->error;
        }
    } 
?>